/*	-------------------------------------------------------------------------------------------------------
	 1991-2012 Take-Two Interactive Software and its subsidiaries.  Developed by Firaxis Games.  
	Sid Meier's Civilization V, Civ, Civilization, 2K Games, Firaxis Games, Take-Two Interactive Software 
	and their respective logos are all trademarks of Take-Two interactive Software, Inc.  
	All other marks and trademarks are the property of their respective owners.  
	All rights reserved. 
	------------------------------------------------------------------------------------------------------- */

// Author -	Mustafa Thamer
//			Jon Shafer - 03/2005

#include "CvGameCoreDLLPCH.h"
#include "CvGlobals.h"
#include "CvRandom.h"
#include "ICvDLLUserInterface.h"
#include "CvMap.h"
#include "CvPlayerAI.h"
#include "CvTeam.h"
#include "CvInfos.h"
#include "ICvDLLUtility.h"
#include "CvPlayerAI.h"
#include "CvGameTextMgr.h"
#include "CvDiplomacyAI.h"
#include "CvEconomicAI.h"
#include "CvMilitaryAI.h"
#include "CvCitySpecializationAI.h"
#include "CvGrandStrategyAI.h"
#include "CvMinorCivAI.h"
#include "CvImprovementClasses.h"
#include "CvAStar.h"
#include "cvStopWatch.h"
#include "CvReplayInfo.h"
#include "CvTypes.h"

#include "CvDllDatabaseUtility.h"
#include "CvDllScriptSystemUtility.h"

#include "CvDllCity.h"
#include "CvDllDeal.h"
#include "CvDllContext.h"
#include "CvDllPlayer.h"
#include "CvDllPlot.h"
#include "CvDllRandom.h"
#include "CvDllUnit.h"

// must be included after all other headers
#include "LintFree.h"

template <class T>
void deleteInfoArray(std::vector<T*>& array)
{
	for(std::vector<T*>::iterator it = array.begin(); it != array.end(); ++it)
	{
		SAFE_DELETE(*it);
	}

	array.clear();
}

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////

CvGlobals gGlobals;

//
// CONSTRUCTOR
//
CvGlobals::CvGlobals() :
	m_bGraphicsInitialized(false),
	m_bTutorialDisabled(false),
	m_bLogging(false),
	m_iRandLogging(0),
	m_bOverwriteLogs(false),
	m_bOutOfSyncDebuggingEnabled(false),
	m_bSynchLogging(false),
	m_bAILogging(false),
	m_bAIPerfLogging(false),
	m_bBuilderAILogging(false),
	m_bSerializationLogging(false),
	m_bPlayerAndCityAILogSplit(false),
	m_bTutorialLogging(false),
	m_bTutorialDebugging(false),
	m_bDLLProfiler(false),
	m_iNewPlayers(0),
	m_bZoomOut(false),
	m_bZoomIn(false),
	m_bLoadGameFromFile(false),
	m_bAllowRClickMovementWhileCameraScrolling(false),
	m_bPostTurnAutosaves(false),
	m_asyncRand(NULL),
	m_game(NULL),
	m_map(NULL),
	m_pathFinder(NULL),
	m_interfacePathFinder(NULL),
	m_ignoreUnitsPathFinder(NULL),
	m_stepFinder(NULL),
	m_routeFinder(NULL),
	m_waterRouteFinder(NULL),
	m_areaFinder(NULL),
	m_influenceFinder(NULL),
	m_buildRouteFinder(NULL),
	m_tacticalAnalysisMapFinder(NULL),
	m_pDLL(NULL),
	m_pEngineUI(NULL),

// -- ints --
	m_iAI_ATTEMPT_RUSH_OVER_X_TURNS_TO_BUILD(15),
	m_iINITIAL_AI_CITY_PRODUCTION(0),
	m_iAI_CAN_DISBAND_UNITS(1),
	m_iAI_SHOULDNT_MANAGE_PLOT_ASSIGNMENT(0),
	m_iPOLICY_WEIGHT_PROPAGATION_PERCENT(50),
	m_iPOLICY_WEIGHT_PROPAGATION_LEVELS(2),
	m_iPOLICY_WEIGHT_PERCENT_DROP_NEW_BRANCH(75),
	m_iTECH_WEIGHT_PROPAGATION_PERCENT(50),
	m_iTECH_WEIGHT_PROPAGATION_LEVELS(2),
	m_iTECH_PRIORITY_UNIQUE_ITEM(5),
	m_iTECH_PRIORITY_MAYA_CALENDAR_BONUS(50),
	m_iAI_VALUE_OF_YIELD_GOLD(7),
	m_iAI_VALUE_OF_YIELD_PRODUCTION(15),
	m_iAI_VALUE_OF_YIELD_SCIENCE(8),
	m_iDEFAULT_FLAVOR_VALUE(5),
	m_iPERSONALITY_FLAVOR_MAX_VALUE(20),
	m_iPERSONALITY_FLAVOR_MIN_VALUE(0),
	m_iFLAVOR_MIN_VALUE(-1000),
	m_iFLAVOR_MAX_VALUE(1000),
	m_iFLAVOR_RANDOMIZATION_RANGE(2),
	m_iFLAVOR_EXPANDGROW_COEFFICIENT(8),
	m_iAI_GRAND_STRATEGY_NUM_TURNS_STRATEGY_MUST_BE_ACTIVE(0),
	m_iAI_GS_RAND_ROLL(50),
	m_iAI_GRAND_STRATEGY_CURRENT_STRATEGY_WEIGHT(50),
	m_iAI_GRAND_STRATEGY_GUESS_NO_CLUE_WEIGHT(40),
	m_iAI_GRAND_STRATEGY_GUESS_POSITIVE_THRESHOLD(120),
	m_iAI_GRAND_STRATEGY_GUESS_LIKELY_THRESHOLD(70),
	m_iAI_GRAND_STRATEGY_OTHER_PLAYERS_GS_MULTIPLIER(40),
	m_iAI_GS_CONQUEST_NOBODY_MET_FIRST_TURN(20),
	m_iAI_GRAND_STRATEGY_CONQUEST_NOBODY_MET_WEIGHT(-50),
	m_iAI_GRAND_STRATEGY_CONQUEST_AT_WAR_WEIGHT(10),
	m_iAI_GS_CONQUEST_MILITARY_STRENGTH_FIRST_TURN(60),
	m_iAI_GRAND_STRATEGY_CONQUEST_POWER_RATIO_MULTIPLIER(100),
	m_iAI_GRAND_STRATEGY_CONQUEST_CRAMPED_WEIGHT(20),
	m_iAI_GRAND_STRATEGY_CONQUEST_WEIGHT_PER_MINOR_ATTACKED(5),
	m_iAI_GRAND_STRATEGY_CONQUEST_WEIGHT_PER_MINOR_CONQUERED(10),
	m_iAI_GRAND_STRATEGY_CONQUEST_WEIGHT_PER_MAJOR_ATTACKED(10),
	m_iAI_GRAND_STRATEGY_CONQUEST_WEIGHT_PER_MAJOR_CONQUERED(15),
	m_iAI_GS_CULTURE_RATIO_MULTIPLIER(150),
	m_iAI_GS_CULTURE_RATIO_EARLY_TURN_THRESHOLD(50),
	m_iAI_GS_CULTURE_RATIO_EARLY_DIVISOR(2),
	m_iAI_GS_CULTURE_MAX_CITIES(4),
	m_iAI_GS_CULTURE_MAX_CITIES_MODIFIER(10),
	m_iAI_GS_CULTURE_POLICY_BRANCH_MOD(10),
	m_iAI_GRAND_STRATEGY_UN_EACH_MINOR_ATTACKED_WEIGHT(-40),
	m_iAI_GS_UN_SECURED_VOTE_MOD(300),
	m_iAI_GS_SS_HAS_APOLLO_PROGRAM(150),
	m_iAI_GS_SS_TECH_PROGRESS_MOD(300),
	m_iAI_STRATEGY_EARLY_EXPLORATION_STARTING_WEIGHT(100),
	m_iAI_STRATEGY_EARLY_EXPLORATION_EXPLORERS_WEIGHT_DIVISOR(1),
	m_iAI_STRATEGY_EARLY_EXPLORATION_WEIGHT_PER_FLAVOR(10),
	m_iAI_STRATEGY_EARLY_EXPANSION_NUM_UNOWNED_TILES_REQUIRED(25),
	m_iAI_STRATEGY_EARLY_EXPANSION_NUM_CITIES_LIMIT(10),
	m_fAI_STRATEGY_NEED_IMPROVEMENT_CITY_RATIO(0.34f),
	m_iAI_STRATEGY_ISLAND_START_COAST_REVEAL_PERCENT(80),
	m_iAI_STRATEGY_AREA_IS_FULL_PERCENT(75),
	m_iAI_STRATEGY_MINIMUM_SETTLE_FERTILITY(20000),
	m_iAI_BUY_PLOT_TEST_PROBES(5),
	m_iAI_PLOT_VALUE_STRATEGIC_RESOURCE(50),
	m_iAI_PLOT_VALUE_LUXURY_RESOURCE(40),
	m_iAI_PLOT_VALUE_SPECIALIZATION_MULTIPLIER(20),
	m_iAI_PLOT_VALUE_YIELD_MULTIPLIER(10),
	m_iAI_PLOT_VALUE_DEFICIENT_YIELD_MULTIPLIER(5),
	m_iAI_PLOT_VALUE_FIERCE_DISPUTE(6),
	m_iAI_PLOT_VALUE_STRONG_DISPUTE(4),
	m_iAI_PLOT_VALUE_WEAK_DISPUTE(2),
	m_iAI_GOLD_PRIORITY_MINIMUM_PLOT_BUY_VALUE(150),
	m_iAI_GOLD_BALANCE_TO_HALVE_PLOT_BUY_MINIMUM(1000),
	m_iAI_GOLD_PRIORITY_UPGRADE_BASE(150),
	m_iAI_GOLD_PRIORITY_UPGRADE_PER_FLAVOR_POINT(25),
	m_iAI_GOLD_PRIORITY_DIPLOMACY_BASE(150),
	m_iAI_GOLD_PRIORITY_DIPLOMACY_PER_FLAVOR_POINT(25),
	m_iAI_GOLD_PRIORITY_UNIT(300),
	m_iAI_GOLD_PRIORITY_DEFENSIVE_BUILDING(400),
	m_iBUILDER_TASKING_PLOT_EVAL_MULTIPLIER_FOOD(2),
	m_iBUILDER_TASKING_PLOT_EVAL_MULTIPLIER_PRODUCTION(2),
	m_iBUILDER_TASKING_PLOT_EVAL_MULTIPLIER_GOLD(1),
	m_iBUILDER_TASKING_PLOT_EVAL_MULTIPLIER_SCIENCE(1),
	m_iBUILDER_TASKING_PLOT_EVAL_MULTIPLIER_CULTURE(1),
	m_iBUILDER_TASKING_PLOT_EVAL_MULTIPLIER_LUXURY_RESOURCE(50000),
	m_iBUILDER_TASKING_IMPROVE_RESOURCE_TENDENCY(15),
	m_iBUILDER_TASKING_BUILD_ROUTE_TENDENCY(100),
	m_iBUILDER_TASKING_DIRECTIVES_TO_EVALUATE(1),
	m_iBUILDER_TASKING_BASELINE_BUILD_IMPROVEMENTS(1),
	m_iBUILDER_TASKING_BASELINE_BUILD_RESOURCE_IMPROVEMENTS(100),
	m_iBUILDER_TASKING_BASELINE_BUILD_ROUTES(10),
	m_iBUILDER_TASKING_BASELINE_REPAIR(10),
	m_iBUILDER_TASKING_BASELINE_SCRUB_FALLOUT(1000),
	m_iAI_MILITARY_THREAT_WEIGHT_MINOR(1),
	m_iAI_MILITARY_THREAT_WEIGHT_MAJOR(3),
	m_iAI_MILITARY_THREAT_WEIGHT_SEVERE(6),
	m_iAI_MILITARY_THREAT_WEIGHT_CRITICAL(10),
	m_iAI_STRATEGY_DEFEND_MY_LANDS_BASE_UNITS(2),
	m_iAI_STRATEGY_MILITARY_RESERVE_PERCENTAGE(33),
	m_iAI_MILITARY_CITY_THREAT_WEIGHT_CAPITAL(125),
	m_iAI_MILITARY_BARBARIANS_FOR_MINOR_THREAT(2),
	m_iAI_MILITARY_IGNORE_BAD_ODDS(0),
	m_iAI_CITY_SPECIALIZATION_EARLIEST_TURN(25),
	m_iAI_CITY_SPECIALIZATION_REEVALUATION_INTERVAL(10000),
	m_iAI_CITY_SPECIALIZATION_GENERAL_ECONOMIC_WEIGHT(200),
	m_iAI_CITY_SPECIALIZATION_FOOD_WEIGHT_FLAVOR_EXPANSION(5),
	m_iAI_CITY_SPECIALIZATION_FOOD_WEIGHT_PERCENT_CONTINENT_UNOWNED(5),
	m_iAI_CITY_SPECIALIZATION_FOOD_WEIGHT_NUM_CITIES(-50),
	m_iAI_CITY_SPECIALIZATION_FOOD_WEIGHT_NUM_SETTLERS(-40),
	m_iAI_CITY_SPECIALIZATION_FOOD_WEIGHT_EARLY_EXPANSION(500),
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_OPERATIONAL_UNITS_REQUESTED(10),
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_CIVS_AT_WAR_WITH(100),
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_WAR_MOBILIZATION(300),
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_EMPIRE_DEFENSE(300),
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_EMPIRE_DEFENSE_CRITICAL(1000),
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_CAPITAL_THREAT(50),
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_NEED_NAVAL_UNITS(50),
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_NEED_NAVAL_UNITS_CRITICAL(250),
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_FLAVOR_WONDER(200),
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_FLAVOR_SPACESHIP(5),
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_TRAINING_PER_OFFENSE(10),
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_TRAINING_PER_PERSONALITY(10),
	m_iAI_CITY_SPECIALIZATION_GOLD_WEIGHT_FLAVOR_GOLD(20),
	m_iAI_CITY_SPECIALIZATION_GOLD_WEIGHT_LAND_DISPUTE(10),
	m_iAI_CITY_SPECIALIZATION_SCIENCE_WEIGHT_FLAVOR_SCIENCE(20),
	m_iAI_CITY_SPECIALIZATION_SCIENCE_WEIGHT_FLAVOR_SPACESHIP(10),
	m_iAI_CITY_SPECIALIZATION_YIELD_WEIGHT_FIRST_RING(8),
	m_iAI_CITY_SPECIALIZATION_YIELD_WEIGHT_SECOND_RING(5),
	m_iAI_CITY_SPECIALIZATION_YIELD_WEIGHT_THIRD_RING(2),
	m_iAI_CITY_SPECIALIZATION_YIELD_NUM_TILES_CONSIDERED(18),
	m_iAI_CITYSTRATEGY_SMALL_CITY_POP_THRESHOLD(2),
	m_iAI_CITYSTRATEGY_MEDIUM_CITY_POP_THRESHOLD(8),
	m_iAI_CITYSTRATEGY_LARGE_CITY_POP_THRESHOLD(15),
	m_iAI_CITYSTRATEGY_NEED_TILE_IMPROVERS_CITY_THRESHOLD(2),
	m_iAI_CITYSTRATEGY_NEED_TILE_IMPROVERS_WORKER_MOD(200),
	m_iAI_CITYSTRATEGY_NEED_TILE_IMPROVERS_DESPERATE_TURN(30),
	m_iAI_CITYSTRATEGY_WANT_TILE_IMPROVERS_MINIMUM_SIZE(2),
	m_fAI_CITYSTRATEGY_YIELD_DEFICIENT_FOOD(2.0f),
	m_fAI_CITYSTRATEGY_YIELD_DEFICIENT_PRODUCTION(0.8f),
	m_fAI_CITYSTRATEGY_YIELD_DEFICIENT_GOLD(0.0f),
	m_fAI_CITYSTRATEGY_YIELD_DEFICIENT_SCIENCE(0.0f),
	m_iAI_CITYSTRATEGY_OPERATION_UNIT_BASE_WEIGHT(900),
	m_iAI_CITYSTRATEGY_OPERATION_UNIT_FLAVOR_MULTIPLIER(100),
	m_iAI_CITYSTRATEGY_ARMY_UNIT_BASE_WEIGHT(700),
	m_iAI_CITIZEN_VALUE_FOOD(12),
	m_iAI_CITIZEN_VALUE_PRODUCTION(8),
	m_iAI_CITIZEN_VALUE_GOLD(6),
	m_iAI_CITIZEN_VALUE_SCIENCE(6),
	m_iAI_CITIZEN_VALUE_CULTURE(8),
	m_iAI_CITIZEN_VALUE_FAITH(6),
	m_iAI_CITIZEN_FOOD_MOD_SIZE_CUTOFF(6),
	m_iAI_CITIZEN_FOOD_MOD_SIZE_EXPONENT(5),
	m_iAI_CITIZEN_MOD_FOOD_DEFICIT(300),
	m_iAI_CITIZEN_MOD_PRODUCTION_DEFICIT(250),
	m_iAI_OPERATIONAL_BARBARIAN_CAMP_DEPLOY_RANGE(2),
	m_iAI_OPERATIONAL_CITY_ATTACK_DEPLOY_RANGE(5),
	m_iAI_OPERATIONAL_PILLAGE_ENEMY_DEPLOY_RANGE(4),
	m_iAI_OPERATIONAL_NAVAL_BOMBARDMENT_DEPLOY_RANGE(1),
	m_iAI_OPERATIONAL_PERCENT_DANGER_FOR_FORWARD_MUSTER(20),
	m_iAI_OPERATIONAL_PERCENT_HEALTH_FOR_OPERATION(80),
	m_iAI_TACTICAL_MAP_UNIT_STRENGTH_MULTIPLIER(10),
	m_iAI_TACTICAL_MAP_DOMINANCE_PERCENTAGE(25),
	m_iAI_TACTICAL_MAP_TEMP_ZONE_RADIUS(5),
	m_iAI_TACTICAL_MAP_TEMP_ZONE_TURNS(4),
	m_iAI_TACTICAL_MAP_BOMBARDMENT_ZONE_TURNS(1),
	m_iAI_TACTICAL_RECRUIT_RANGE(10),
	m_iAI_TACTICAL_REPOSITION_RANGE(10),
	m_iAI_TACTICAL_OVERKILL_PERCENT(50),
	m_iAI_TACTICAL_BARBARIAN_RELEASE_VARIATION(15),
	m_iAI_TACTICAL_MOVE_PRIORITY_RANDOMNESS(6),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_CAPTURE_CITY(9),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_DAMAGE_CITY(5),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_DESTROY_HIGH_UNIT(16),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_DESTROY_MEDIUM_UNIT(15),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_DESTROY_LOW_UNIT(14),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_TO_SAFETY(12),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_ATTRIT_HIGH_UNIT(10),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_ATTRIT_MEDIUM_UNIT(7),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_ATTRIT_LOW_UNIT(6),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_DESPERATE_ATTACK(0),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_PILLAGE(8),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_BLOCKADE_RESOURCE(10),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_CIVILIAN_ATTACK(13),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_PASSIVE_MOVE(-1),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_AGGRESSIVE_MOVE(3),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_CAMP_DEFENSE(13),
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_ESCORT_CIVILIAN(30),
	m_iAI_HOMELAND_MOVE_PRIORITY_RANDOMNESS(10),
	m_iAI_HOMELAND_MAX_UPGRADE_MOVE_TURNS(5),
	m_iAI_HOMELAND_MAX_DEFENSIVE_MOVE_TURNS(4),
	m_iAI_HOMELAND_ESTIMATE_TURNS_DISTANCE(10),
	m_iAI_HOMELAND_MOVE_PRIORITY_SETTLE(50),
	m_iAI_HOMELAND_MOVE_PRIORITY_HEAL(30),
	m_iAI_HOMELAND_MOVE_PRIORITY_TO_SAFETY(30),
	m_iAI_HOMELAND_MOVE_PRIORITY_WORKER(30),
	m_iAI_HOMELAND_MOVE_PRIORITY_WORKER_SEA(30),
	m_iAI_HOMELAND_MOVE_PRIORITY_EXPLORE(35),
	m_iAI_HOMELAND_MOVE_PRIORITY_EXPLORE_SEA(35),
	m_iAI_HOMELAND_MOVE_PRIORITY_SENTRY(20),
	m_iAI_HOMELAND_MOVE_PRIORITY_MOBILE_RESERVE(15),
	m_iAI_HOMELAND_MOVE_PRIORITY_GARRISON(10),
	m_iAI_HOMELAND_MOVE_PRIORITY_PATROL(0),
	m_iAI_HOMELAND_MOVE_PRIORITY_UPGRADE(25),
	m_iAI_HOMELAND_MOVE_PRIORITY_ANCIENT_RUINS(40),
	m_iAI_HOMELAND_MOVE_PRIORITY_GARRISON_CITY_STATE(40),
	m_iAI_HOMELAND_MOVE_PRIORITY_ARTIST_GOLDEN_AGE(50),
	m_iAI_HOMELAND_MOVE_PRIORITY_SCIENTIST_FREE_TECH(50),
	m_iAI_HOMELAND_MOVE_PRIORITY_ENGINEER_HURRY(50),
	m_iAI_HOMELAND_MOVE_PRIORITY_GENERAL_GARRISON(50),
	m_iAI_HOMELAND_MOVE_PRIORITY_ADMIRAL_GARRISON(50),
	m_iAI_HOMELAND_MOVE_PRIORITY_PROPHET_RELIGION(50),
	m_iAI_HOMELAND_MOVE_PRIORITY_MISSIONARY(40),
	m_iAI_HOMELAND_MOVE_PRIORITY_INQUISITOR(40),
	m_iAI_HOMELAND_MOVE_PRIORITY_SPACESHIP_PART(20),
	m_iAI_HOMELAND_MOVE_PRIORITY_AIRCRAFT_TO_THE_FRONT(50),
	m_iAI_HOMELAND_MOVE_PRIORITY_TREASURE(100),
	m_iAI_HOMELAND_GREAT_PERSON_TURNS_TO_WAIT(10),
	m_iAI_DIPLO_PLOT_RANGE_FROM_CITY_HOME_FRONT(5),
	m_iAI_DIPLO_LAND_DISPUTE_WEIGHT_WEAK(1),
	m_iAI_DIPLO_LAND_DISPUTE_WEIGHT_STRONG(3),
	m_iAI_DIPLO_LAND_DISPUTE_WEIGHT_FIERCE(5),
	m_iMINOR_BULLY_GOLD(100),
	m_iMINOR_FRIENDSHIP_RATE_MOD_MAXIMUM(150),
	m_iMINOR_FRIENDSHIP_RATE_MOD_SHARED_RELIGION(50),
	m_iMINOR_FRIENDSHIP_DROP_PER_TURN(-100),
	m_iMINOR_FRIENDSHIP_DROP_PER_TURN_HOSTILE(-150),
	m_iMINOR_FRIENDSHIP_DROP_PER_TURN_AGGRESSOR(-200),
	m_iMINOR_FRIENDSHIP_DROP_DISHONOR_PLEDGE_TO_PROTECT(-2000),
	m_iMINOR_FRIENDSHIP_DROP_BULLY_GOLD_SUCCESS(-1500),
	m_iMINOR_FRIENDSHIP_DROP_BULLY_GOLD_FAILURE(0),
	m_iMINOR_FRIENDSHIP_DROP_BULLY_WORKER_SUCCESS(-5000),
	m_iMINOR_FRIENDSHIP_DROP_BULLY_WORKER_FAILURE(0),
	m_iMINOR_FRIENDSHIP_NEGATIVE_INCREASE_PER_TURN(100),
	m_iMINOR_FRIENDSHIP_AT_WAR(-60),
	m_iMINOR_CIV_AGGRESSOR_THRESHOLD(2),
	m_iMINOR_CIV_WARMONGER_THRESHOLD(4),
	m_iPERMANENT_WAR_AGGRESSOR_CHANCE(50),
	m_iPERMANENT_WAR_OTHER_WARMONGER_CHANCE_DISTANT(25),
	m_iPERMANENT_WAR_OTHER_WARMONGER_CHANCE_FAR(50),
	m_iPERMANENT_WAR_OTHER_WARMONGER_CHANCE_CLOSE(75),
	m_iPERMANENT_WAR_OTHER_WARMONGER_CHANCE_NEIGHBORS(100),
	m_iPERMANENT_WAR_OTHER_CHANCE_DISTANT(0),
	m_iPERMANENT_WAR_OTHER_CHANCE_FAR(0),
	m_iPERMANENT_WAR_OTHER_CHANCE_CLOSE(20),
	m_iPERMANENT_WAR_OTHER_CHANCE_NEIGHBORS(50),
	m_iPERMANENT_WAR_OTHER_AT_WAR(50),
	m_iFRIENDSHIP_THRESHOLD_NEUTRAL(0),
	m_iFRIENDSHIP_THRESHOLD_FRIENDS(30),
	m_iFRIENDSHIP_THRESHOLD_ALLIES(60),
	m_iFRIENDSHIP_THRESHOLD_MAX(120),
	m_iFRIENDSHIP_THRESHOLD_CAN_BULLY(-30),
	m_iFRIENDSHIP_THRESHOLD_CAN_PLEDGE_TO_PROTECT(0),
	m_iMINOR_FRIENDSHIP_CLOSE_AMOUNT(8),
	m_iMINOR_CIV_SCIENCE_BONUS_MULTIPLIER(25),
	m_iFRIENDS_CULTURE_BONUS_AMOUNT_ANCIENT(4),
	m_iFRIENDS_CULTURE_BONUS_AMOUNT_MEDIEVAL(6),
	m_iFRIENDS_CULTURE_BONUS_AMOUNT_INDUSTRIAL(10),
	m_iALLIES_CULTURE_BONUS_AMOUNT_ANCIENT(4),
	m_iALLIES_CULTURE_BONUS_AMOUNT_MEDIEVAL(6),
	m_iALLIES_CULTURE_BONUS_AMOUNT_INDUSTRIAL(10),
	m_iFRIENDS_CAPITAL_FOOD_BONUS_AMOUNT_PRE_RENAISSANCE(1),
	m_iFRIENDS_CAPITAL_FOOD_BONUS_AMOUNT_POST_RENAISSANCE(1),
	m_iFRIENDS_OTHER_CITIES_FOOD_BONUS_AMOUNT_PRE_RENAISSANCE(1),
	m_iFRIENDS_OTHER_CITIES_FOOD_BONUS_AMOUNT_POST_RENAISSANCE(2),
	m_iALLIES_CAPITAL_FOOD_BONUS_AMOUNT(1),
	m_iALLIES_OTHER_CITIES_FOOD_BONUS_AMOUNT(1),
	m_iFRIENDS_BASE_TURNS_UNIT_SPAWN(15),
	m_iFRIENDS_RAND_TURNS_UNIT_SPAWN(3),
	m_iALLIES_EXTRA_TURNS_UNIT_SPAWN(-3),
	m_iUNIT_SPAWN_BIAS_MULTIPLIER(67),
	m_iUNIT_SPAWN_NUM_CHOICES(3),
	m_iFRIENDS_HAPPINESS_FLAT_BONUS_AMOUNT_ANCIENT(2),
	m_iFRIENDS_HAPPINESS_FLAT_BONUS_AMOUNT_MEDIEVAL(3),
	m_iFRIENDS_HAPPINESS_FLAT_BONUS_AMOUNT_INDUSTRIAL(4),
	m_iALLIES_HAPPINESS_FLAT_BONUS_AMOUNT_ANCIENT(2),
	m_iALLIES_HAPPINESS_FLAT_BONUS_AMOUNT_MEDIEVAL(2),
	m_iALLIES_HAPPINESS_FLAT_BONUS_AMOUNT_INDUSTRIAL(2),
	m_iFRIENDS_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_ANCIENT(1),
	m_iFRIENDS_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_MEDIEVAL(1),
	m_iFRIENDS_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_INDUSTRIAL(1),
	m_iALLIES_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_ANCIENT(1),
	m_iALLIES_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_MEDIEVAL(1),
	m_iALLIES_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_INDUSTRIAL(1),
	m_iFRIENDS_FAITH_FLAT_BONUS_AMOUNT_INDUSTRIAL(13),
	m_iFRIENDS_FAITH_FLAT_BONUS_AMOUNT_RENAISSANCE(12),
	m_iFRIENDS_FAITH_FLAT_BONUS_AMOUNT_MEDIEVAL(10),
	m_iFRIENDS_FAITH_FLAT_BONUS_AMOUNT_CLASSICAL(7),
	m_iFRIENDS_FAITH_FLAT_BONUS_AMOUNT_ANCIENT(2),
	m_iALLIES_FAITH_FLAT_BONUS_AMOUNT_INDUSTRIAL(13),
	m_iALLIES_FAITH_FLAT_BONUS_AMOUNT_RENAISSANCE(12),
	m_iALLIES_FAITH_FLAT_BONUS_AMOUNT_MEDIEVAL(10),
	m_iALLIES_FAITH_FLAT_BONUS_AMOUNT_CLASSICAL(7),
	m_iALLIES_FAITH_FLAT_BONUS_AMOUNT_ANCIENT(2),
	m_iMINOR_TURNS_GREAT_PEOPLE_SPAWN_BASE(37),
	m_iMINOR_TURNS_GREAT_PEOPLE_SPAWN_RAND(7),
	m_iMINOR_TURNS_GREAT_PEOPLE_SPAWN_BIAS_MULTIPLY(50),
	m_iMINOR_ADDITIONAL_ALLIES_GP_CHANGE(-1),
	m_iMAX_MINOR_ADDITIONAL_ALLIES_GP_CHANGE(-10),
	m_iMAX_DISTANCE_MINORS_BARB_QUEST(50),
	m_iTXT_KEY_MINOR_GIFT_UNITS_REMINDER(2),
	m_iWAR_QUEST_COMPLETE_FRIENDSHIP(100),
	m_iWAR_QUEST_UNITS_TO_KILL_DIVISOR(4),
	m_iWAR_QUEST_MIN_UNITS_TO_KILL(3),
	m_iMINOR_QUEST_FRIENDSHIP_ROUTE(50),
	m_iMINOR_QUEST_FRIENDSHIP_KILL_CAMP(50),
	m_iMINOR_QUEST_FRIENDSHIP_CONNECT_RESOURCE(40),
	m_iMINOR_QUEST_FRIENDSHIP_CONSTRUCT_WONDER(40),
	m_iMINOR_QUEST_FRIENDSHIP_GREAT_PERSON(40),
	m_iMINOR_QUEST_FRIENDSHIP_KILL_CITY_STATE(80),
	m_iMINOR_QUEST_FRIENDSHIP_FIND_PLAYER(35),
	m_iMINOR_QUEST_FRIENDSHIP_FIND_NATURAL_WONDER(40),
	m_iMINOR_QUEST_FRIENDSHIP_GIVE_GOLD(10),
	m_iMINOR_QUEST_FRIENDSHIP_PLEDGE_TO_PROTECT(20),
	m_iMINOR_QUEST_FRIENDSHIP_CONTEST_CULTURE(40),
	m_iMINOR_QUEST_FRIENDSHIP_CONTEST_FAITH(40),
	m_iMINOR_QUEST_FRIENDSHIP_CONTEST_TECHS(40),
	m_iMINOR_QUEST_FRIENDSHIP_INVEST(0),
	m_iMINOR_QUEST_FRIENDSHIP_BULLY_CITY_STATE(40),
	m_iMINOR_QUEST_FRIENDSHIP_DENOUNCE_MAJOR(40),
	m_iMINOR_QUEST_FRIENDSHIP_SPREAD_RELIGION(40),
	m_iMINOR_QUEST_STANDARD_CONTEST_LENGTH(30),
	m_iMINOR_CIV_GOLD_GIFT_GAME_MULTIPLIER(2),
	m_iMINOR_CIV_GOLD_GIFT_GAME_DIVISOR(3),
	m_iMINOR_CIV_GOLD_GIFT_VISIBLE_DIVISOR(5),
	m_iMINOR_CIV_GOLD_GIFT_MINIMUM_FRIENDSHIP_REWARD(5),
	m_iMINOR_CIV_BEST_RELATIONS_HAPPINESS_BONUS(2),
	m_iMINOR_CIV_RESOURCE_SEARCH_RADIUS(5),
	m_iFRIENDSHIP_PER_UNIT_INTRUDING(-6),
	m_iFRIENDSHIP_PER_BARB_KILLED(5),
	m_iFRIENDSHIP_PER_UNIT_GIFTED(2),
	m_iMAX_INFLUENCE_FROM_MINOR_GIFTS(3),
	m_iMINOR_LIBERATION_FRIENDSHIP(150),
	m_iRETURN_CIVILIAN_FRIENDSHIP(30),
	m_iMINOR_CIV_MAX_GLOBAL_QUESTS_FOR_PLAYER(1),
	m_iMINOR_CIV_MAX_PERSONAL_QUESTS_FOR_PLAYER(2),
	m_iMINOR_CIV_GLOBAL_QUEST_FIRST_POSSIBLE_TURN(30),
	m_iMINOR_CIV_GLOBAL_QUEST_FIRST_POSSIBLE_TURN_RAND(20),
	m_iMINOR_CIV_GLOBAL_QUEST_MIN_TURNS_BETWEEN(10),
	m_iMINOR_CIV_GLOBAL_QUEST_RAND_TURNS_BETWEEN(25),
	m_iMINOR_CIV_GLOBAL_QUEST_RAND_TURNS_BETWEEN_HOSTILE_MULTIPLIER(200),
	m_iMINOR_CIV_PERSONAL_QUEST_FIRST_POSSIBLE_TURN(30),
	m_iMINOR_CIV_PERSONAL_QUEST_FIRST_POSSIBLE_TURN_RAND(20),
	m_iMINOR_CIV_PERSONAL_QUEST_MIN_TURNS_BETWEEN(10),
	m_iMINOR_CIV_PERSONAL_QUEST_RAND_TURNS_BETWEEN(25),
	m_iMINOR_CIV_PERSONAL_QUEST_RAND_TURNS_BETWEEN_HOSTILE_MULTIPLIER(200),
	m_iMINOR_CIV_QUEST_KILL_CAMP_RANGE(8),
	m_iMINOR_CIV_QUEST_WONDER_COMPLETION_THRESHOLD(25),
	m_iMINOR_CIV_THREATENED_BY_BARBS_NOTIF_THRESHOLD(2),
	m_iMINOR_CIV_MERCANTILE_RESOURCES_QUANTITY(1),
	m_iMINOR_CIV_MERCANTILE_RESOURCES_KEEP_ON_CAPTURE_DISABLED(0),	
	m_iQUEST_DISABLED_ROUTE(0),
	m_iQUEST_DISABLED_KILL_CAMP(0),
	m_iQUEST_DISABLED_CONNECT_RESOURCE(0),
	m_iQUEST_DISABLED_CONSTRUCT_WONDER(0),
	m_iQUEST_DISABLED_GREAT_PERSON(0),
	m_iQUEST_DISABLED_KILL_CITY_STATE(0),
	m_iQUEST_DISABLED_FIND_PLAYER(0),
	m_iQUEST_DISABLED_NATURAL_WONDER(0),
	m_iQUEST_DISABLED_GIVE_GOLD(0),
	m_iQUEST_DISABLED_PLEDGE_TO_PROTECT(0),
	m_iQUEST_DISABLED_CONTEST_CULTURE(0),
	m_iQUEST_DISABLED_CONTEST_FAITH(0),
	m_iQUEST_DISABLED_CONTEST_TECHS(0),
	m_iQUEST_DISABLED_INVEST(0),
	m_iQUEST_DISABLED_BULLY_CITY_STATE(0),
	m_iQUEST_DISABLED_DENOUNCE_MAJOR(0),
	m_iQUEST_DISABLED_SPREAD_RELIGION(0),
	m_iMINOR_CIV_QUEST_WEIGHT_DEFAULT(10),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_FRIENDLY_ROUTE(200),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_HOSTILE_ROUTE(20),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MARITIME_ROUTE(120),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MERCANTILE_ROUTE(150),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MILITARISTIC_KILL_CAMP(300),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MARITIME_CONNECT_RESOURCE(200),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MERCANTILE_CONNECT_RESOURCE(300),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_CULTURED_CONSTRUCT_WONDER(300),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_CULTURED_GREAT_PERSON(300),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MILITARISTIC_KILL_CITY_STATE(200),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_HOSTILE_KILL_CITY_STATE(200),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_NEUTRAL_KILL_CITY_STATE(40),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MARITIME_FIND_PLAYER(300),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MERCANTILE_FIND_PLAYER(200),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MILITARISTIC_FIND_NATURAL_WONDER(50),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_HOSTILE_FIND_NATURAL_WONDER(30),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MILITARISTIC_GIVE_GOLD(200),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MERCANTILE_GIVE_GOLD(350),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_OTHER_GIVE_GOLD(300),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MILITARISTIC_PLEDGE_TO_PROTECT(200),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_CULTURED_PLEDGE_TO_PROTECT(350),
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_OTHER_PLEDGE_TO_PROTECT(300),
	m_iRELIGION_BELIEF_SCORE_CITY_MULTIPLIER(10),
	m_iRELIGION_BELIEF_SCORE_WORKED_PLOT_MULTIPLIER(8),
	m_iRELIGION_BELIEF_SCORE_OWNED_PLOT_MULTIPLIER(5),
	m_iRELIGION_BELIEF_SCORE_UNOWNED_PLOT_MULTIPLIER(3),
	m_iRELIGION_MISSIONARY_RANGE_IN_TURNS(10),
	m_iRELIGION_MAX_MISSIONARIES(4),
	m_iMC_GIFT_WEIGHT_THRESHOLD(100),
	m_iMC_ALWAYS_GIFT_DIPLO_THRESHOLD(4),
	m_iMC_SOMETIMES_GIFT_RAND_MULTIPLIER(5),
	m_iMC_SMALL_GIFT_WEIGHT_PASS_OTHER_PLAYER(30),
	m_iMC_GIFT_WEIGHT_PASS_OTHER_PLAYER(15),
	m_iMC_GIFT_WEIGHT_MARITIME_GROWTH(100),
	m_iMC_GIFT_WEIGHT_DIPLO_VICTORY(100),
	m_iMC_GIFT_WEIGHT_CULTURE_VICTORY(100),
	m_iMC_GIFT_WEIGHT_CONQUEST_VICTORY(100),
	m_iMC_GIFT_WEIGHT_MILITARISTIC(-50),
	m_iMC_GIFT_WEIGHT_RESOURCE_WE_NEED(80),
	m_iMC_GIFT_WEIGHT_NEUTRAL_VICTORY_ROLL(101),
	m_iMC_GIFT_WEIGHT_PROTECTIVE(10),
	m_iMC_GIFT_WEIGHT_HOSTILE(-20),
	m_iMC_GIFT_WEIGHT_NEIGHBORS(5),
	m_iMC_GIFT_WEIGHT_CLOSE(4),
	m_iMC_GIFT_WEIGHT_FAR(3),
	m_iMC_GIFT_WEIGHT_ALMOST_NOT_ALLIES(150),
	m_iMC_GIFT_WEIGHT_ALMOST_NOT_FRIENDS(125),
	m_iOPINION_WEIGHT_LAND_FIERCE(30),
	m_iOPINION_WEIGHT_LAND_STRONG(20),
	m_iOPINION_WEIGHT_LAND_WEAK(10),
	m_iOPINION_WEIGHT_LAND_NONE(-6),
	m_iOPINION_WEIGHT_VICTORY_FIERCE(30),
	m_iOPINION_WEIGHT_VICTORY_STRONG(20),
	m_iOPINION_WEIGHT_VICTORY_WEAK(10),
	m_iOPINION_WEIGHT_VICTORY_NONE(-6),
	m_iOPINION_WEIGHT_WONDER_FIERCE(20),
	m_iOPINION_WEIGHT_WONDER_STRONG(15),
	m_iOPINION_WEIGHT_WONDER_WEAK(10),
	m_iOPINION_WEIGHT_WONDER_NONE(0),
	m_iOPINION_WEIGHT_MINOR_CIV_FIERCE(30),
	m_iOPINION_WEIGHT_MINOR_CIV_STRONG(20),
	m_iOPINION_WEIGHT_MINOR_CIV_WEAK(10),
	m_iOPINION_WEIGHT_MINOR_CIV_NONE(0),
	m_iOPINION_WEIGHT_WARMONGER_CRITICAL(100),
	m_iOPINION_WEIGHT_WARMONGER_SEVERE(70),
	m_iOPINION_WEIGHT_WARMONGER_MAJOR(40),
	m_iOPINION_WEIGHT_WARMONGER_MINOR(15),
	m_iOPINION_WEIGHT_WARMONGER_NONE(0),
	m_iOPINION_WEIGHT_ASKED_NO_SETTLE(20),
	m_iOPINION_WEIGHT_ASKED_STOP_SPYING(20),
	m_iOPINION_WEIGHT_MADE_DEMAND_OF_US(20),
	m_iOPINION_WEIGHT_RETURNED_CIVILIAN(-20),
	m_iOPINION_WEIGHT_RESURRECTED(-200),
	m_iOPINION_WEIGHT_LIBERATED_ONE_CITY(-30),
	m_iOPINION_WEIGHT_LIBERATED_TWO_CITIES(-50),
	m_iOPINION_WEIGHT_LIBERATED_THREE_CITIES(-60),
	m_iOPINION_WEIGHT_EMBASSY(-1),
	m_iOPINION_WEIGHT_CULTURE_BOMBED(30),
	m_iOPINION_WEIGHT_PER_NEGATIVE_CONVERSION(2),
	m_iOPINION_WEIGHT_ADOPTING_HIS_RELIGION(-10),
	m_iOPINION_WEIGHT_ADOPTING_MY_RELIGION(-6),
	m_iOPINION_WEIGHT_SAME_LATE_POLICIES(-10),
	m_iOPINION_WEIGHT_DIFFERENT_LATE_POLICIES(10),
	m_iOPINION_WEIGHT_BROKEN_MILITARY_PROMISE(40),
	m_iOPINION_WEIGHT_BROKEN_MILITARY_PROMISE_WORLD(15),
	m_iOPINION_WEIGHT_IGNORED_MILITARY_PROMISE(15),
	m_iOPINION_WEIGHT_BROKEN_EXPANSION_PROMISE(20),
	m_iOPINION_WEIGHT_IGNORED_EXPANSION_PROMISE(15),
	m_iOPINION_WEIGHT_BROKEN_BORDER_PROMISE(20),
	m_iOPINION_WEIGHT_IGNORED_BORDER_PROMISE(15),
	m_iOPINION_WEIGHT_BROKEN_CITY_STATE_PROMISE(40),
	m_iOPINION_WEIGHT_BROKEN_CITY_STATE_PROMISE_WORLD(15),
	m_iOPINION_WEIGHT_IGNORED_CITY_STATE_PROMISE(15),
	m_iOPINION_WEIGHT_BROKEN_SPY_PROMISE(20),
	m_iOPINION_WEIGHT_IGNORED_SPY_PROMISE(10),
	m_iOPINION_WEIGHT_FORGAVE_FOR_SPYING(-10),
	m_iOPINION_WEIGHT_BROKEN_NO_CONVERT_PROMISE(8),
	m_iOPINION_WEIGHT_IGNORED_NO_CONVERT_PROMISE(4),
	m_iOPINION_WEIGHT_BROKEN_COOP_WAR_PROMISE(20),
	m_iOPINION_WEIGHT_KILLED_PROTECTED_MINOR_NUM_TURNS_UNTIL_FORGIVEN(125),
	m_iOPINION_WEIGHT_KILLED_PROTECTED_MINOR(40),
	m_iOPINION_WEIGHT_KILLED_MANY_PROTECTED_MINORS(10),
	m_iOPINION_WEIGHT_ATTACKED_PROTECTED_MINOR_NUM_TURNS_UNTIL_FORGIVEN(75),
	m_iOPINION_WEIGHT_ATTACKED_PROTECTED_MINOR_RECENTLY_NUM_TURNS(50),
	m_iOPINION_WEIGHT_ATTACKED_PROTECTED_MINOR_RECENTLY(20),
	m_iOPINION_WEIGHT_ATTACKED_PROTECTED_MINOR_WHILE_AGO(15),
	m_iOPINION_WEIGHT_ATTACKED_MANY_PROTECTED_MINORS(15),
	m_iOPINION_WEIGHT_BULLIED_PROTECTED_MINOR_NUM_TURNS_UNTIL_FORGIVEN(75),
	m_iOPINION_WEIGHT_BULLIED_PROTECTED_MINOR_RECENTLY_NUM_TURNS(50),
	m_iOPINION_WEIGHT_BULLIED_PROTECTED_MINOR_RECENTLY(15),
	m_iOPINION_WEIGHT_BULLIED_PROTECTED_MINOR_WHILE_AGO(10),
	m_iOPINION_WEIGHT_BULLIED_MANY_PROTECTED_MINORS(10),
	m_iOPINION_WEIGHT_SIDED_WITH_THEIR_MINOR_NUM_TURNS_UNTIL_FORGIVEN(25),
	m_iOPINION_WEIGHT_SIDED_WITH_THEIR_MINOR(5),
	m_iOPINION_WEIGHT_DOF(-35),
	m_iOPINION_WEIGHT_DOF_WITH_FRIEND(-15),
	m_iOPINION_WEIGHT_DOF_WITH_ENEMY(15),
	m_iOPINION_WEIGHT_DENOUNCED_BY_FRIEND_EACH(25),
	m_iOPINION_WEIGHT_DENOUNCED_BY_FRIEND_DONT_LIKE(-10),
	m_iOPINION_WEIGHT_DENOUNCED_FRIEND_EACH(15),
	m_iOPINION_WEIGHT_DENOUNCED_ME_FRIENDS(35),
	m_iOPINION_WEIGHT_WAR_FRIEND_EACH(40),
	m_iOPINION_WEIGHT_WAR_ME_FRIENDS(60),
	m_iOPINION_WEIGHT_REFUSED_REQUEST_EACH(15),
	m_iOPINION_WEIGHT_DENOUNCED_ME(35),
	m_iOPINION_WEIGHT_DENOUNCED_THEM(35),
	m_iOPINION_WEIGHT_DENOUNCED_FRIEND(15),
	m_iOPINION_WEIGHT_DENOUNCED_ENEMY(-15),
	m_iOPINION_WEIGHT_RECKLESS_EXPANDER(35),
	m_iOPINION_THRESHOLD_UNFORGIVABLE(50),
	m_iOPINION_THRESHOLD_ENEMY(30),
	m_iOPINION_THRESHOLD_COMPETITOR(10),
	m_iOPINION_THRESHOLD_FAVORABLE(-10),
	m_iOPINION_THRESHOLD_FRIEND(-30),
	m_iOPINION_THRESHOLD_ALLY(-50),
	m_iAPPROACH_NEUTRAL_DEFAULT(4),
	m_iAPPROACH_BIAS_FOR_CURRENT(3),
	m_iAPPROACH_WAR_CURRENTLY_DECEPTIVE(2),
	m_iAPPROACH_HOSTILE_CURRENTLY_HOSTILE(5),
	m_iAPPROACH_WAR_CURRENTLY_WAR(3),
	m_iAPPROACH_RANDOM_PERCENT(15),
	m_iAPPROACH_WAR_CONQUEST_GRAND_STRATEGY(5),
	m_iAPPROACH_OPINION_UNFORGIVABLE_WAR(10),
	m_iAPPROACH_OPINION_UNFORGIVABLE_HOSTILE(4),
	m_iAPPROACH_OPINION_UNFORGIVABLE_DECEPTIVE(0),
	m_iAPPROACH_OPINION_UNFORGIVABLE_GUARDED(4),
	m_iAPPROACH_OPINION_ENEMY_WAR(8),
	m_iAPPROACH_OPINION_ENEMY_HOSTILE(4),
	m_iAPPROACH_OPINION_ENEMY_DECEPTIVE(1),
	m_iAPPROACH_OPINION_ENEMY_GUARDED(4),
	m_iAPPROACH_OPINION_COMPETITOR_WAR(4),
	m_iAPPROACH_OPINION_COMPETITOR_HOSTILE(4),
	m_iAPPROACH_OPINION_COMPETITOR_DECEPTIVE(2),
	m_iAPPROACH_OPINION_COMPETITOR_GUARDED(2),
	m_iAPPROACH_OPINION_NEUTRAL_DECEPTIVE(0),
	m_iAPPROACH_OPINION_NEUTRAL_FRIENDLY(2),
	m_iAPPROACH_OPINION_FAVORABLE_HOSTILE(-5),
	m_iAPPROACH_OPINION_FAVORABLE_DECEPTIVE(0),
	m_iAPPROACH_OPINION_FAVORABLE_FRIENDLY(4),
	m_iAPPROACH_OPINION_FRIEND_HOSTILE(-5),
	m_iAPPROACH_OPINION_FRIEND_FRIENDLY(10),
	m_iAPPROACH_OPINION_ALLY_FRIENDLY(10),
	m_iAPPROACH_DECEPTIVE_WORKING_WITH_PLAYER(15),
	m_iAPPROACH_FRIENDLY_WORKING_WITH_PLAYER(15),
	m_iAPPROACH_HOSTILE_WORKING_WITH_PLAYER(-10),
	m_iAPPROACH_GUARDED_WORKING_WITH_PLAYER(-10),
	m_iAPPROACH_DECEPTIVE_WORKING_AGAINST_PLAYER(10),
	m_iAPPROACH_HOSTILE_WORKING_AGAINST_PLAYER(10),
	m_iAPPROACH_WAR_WORKING_AGAINST_PLAYER(10),
	m_iAPPROACH_WAR_DENOUNCED(10),
	m_iAPPROACH_HOSTILE_DENOUNCED(10),
	m_iAPPROACH_GUARDED_DENOUNCED(5),
	m_iAPPROACH_FRIENDLY_DENOUNCED(-15),
	m_iAPPROACH_DECEPTIVE_DENOUNCED(-15),
	m_iAPPROACH_ATTACKED_PROTECTED_MINOR_WAR(6),
	m_iAPPROACH_ATTACKED_PROTECTED_MINOR_HOSTILE(2),
	m_iAPPROACH_ATTACKED_PROTECTED_MINOR_GUARDED(1),
	m_iAPPROACH_ATTACKED_PROTECTED_MINOR_PAST_WAR(4),
	m_iAPPROACH_ATTACKED_PROTECTED_MINOR_PAST_HOSTILE(1),
	m_iAPPROACH_ATTACKED_PROTECTED_MINOR_PAST_GUARDED(1),
	m_iAPPROACH_DECEPTIVE_MILITARY_THREAT_CRITICAL(0),
	m_iAPPROACH_GUARDED_MILITARY_THREAT_CRITICAL(4),
	m_iAPPROACH_AFRAID_MILITARY_THREAT_CRITICAL(4),
	m_iAPPROACH_DECEPTIVE_DEMAND(-6),
	m_iAPPROACH_FRIENDLY_DEMAND(-6),
	m_iAPPROACH_WAR_BROKEN_MILITARY_PROMISE(4),
	m_iAPPROACH_DECEPTIVE_BROKEN_MILITARY_PROMISE(-10),
	m_iAPPROACH_FRIENDLY_BROKEN_MILITARY_PROMISE(-10),
	m_iAPPROACH_WAR_BROKEN_MILITARY_PROMISE_WORLD(5),
	m_iAPPROACH_DECEPTIVE_BROKEN_MILITARY_PROMISE_WORLD(-4),
	m_iAPPROACH_FRIENDLY_BROKEN_MILITARY_PROMISE_WORLD(-4),
	m_iAPPROACH_DECEPTIVE_IGNORED_MILITARY_PROMISE(-4),
	m_iAPPROACH_FRIENDLY_IGNORED_MILITARY_PROMISE(-4),
	m_iAPPROACH_WAR_BROKEN_EXPANSION_PROMISE(4),
	m_iAPPROACH_DECEPTIVE_BROKEN_EXPANSION_PROMISE(-6),
	m_iAPPROACH_FRIENDLY_BROKEN_EXPANSION_PROMISE(-6),
	m_iAPPROACH_WAR_IGNORED_EXPANSION_PROMISE(3),
	m_iAPPROACH_DECEPTIVE_IGNORED_EXPANSION_PROMISE(-4),
	m_iAPPROACH_FRIENDLY_IGNORED_EXPANSION_PROMISE(-4),
	m_iAPPROACH_WAR_BROKEN_BORDER_PROMISE(4),
	m_iAPPROACH_DECEPTIVE_BROKEN_BORDER_PROMISE(-6),
	m_iAPPROACH_FRIENDLY_BROKEN_BORDER_PROMISE(-6),
	m_iAPPROACH_WAR_IGNORED_BORDER_PROMISE(3),
	m_iAPPROACH_DECEPTIVE_IGNORED_BORDER_PROMISE(-4),
	m_iAPPROACH_FRIENDLY_IGNORED_BORDER_PROMISE(-4),
	m_iAPPROACH_WAR_BROKEN_CITY_STATE_PROMISE(4),
	m_iAPPROACH_DECEPTIVE_BROKEN_CITY_STATE_PROMISE(-10),
	m_iAPPROACH_FRIENDLY_BROKEN_CITY_STATE_PROMISE(-10),
	m_iAPPROACH_WAR_BROKEN_CITY_STATE_PROMISE_WORLD(3),
	m_iAPPROACH_DECEPTIVE_BROKEN_CITY_STATE_PROMISE_WORLD(-3),
	m_iAPPROACH_FRIENDLY_BROKEN_CITY_STATE_PROMISE_WORLD(-3),
	m_iAPPROACH_WAR_IGNORED_CITY_STATE_PROMISE(4),
	m_iAPPROACH_DECEPTIVE_IGNORED_CITY_STATE_PROMISE(-4),
	m_iAPPROACH_FRIENDLY_IGNORED_CITY_STATE_PROMISE(-4),
	m_iAPPROACH_FRIENDLY_MILITARY_THREAT_CRITICAL(0),
	m_iAPPROACH_DECEPTIVE_MILITARY_THREAT_SEVERE(0),
	m_iAPPROACH_GUARDED_MILITARY_THREAT_SEVERE(3),
	m_iAPPROACH_AFRAID_MILITARY_THREAT_SEVERE(2),
	m_iAPPROACH_FRIENDLY_MILITARY_THREAT_SEVERE(0),
	m_iAPPROACH_DECEPTIVE_MILITARY_THREAT_MAJOR(0),
	m_iAPPROACH_GUARDED_MILITARY_THREAT_MAJOR(2),
	m_iAPPROACH_AFRAID_MILITARY_THREAT_MAJOR(1),
	m_iAPPROACH_FRIENDLY_MILITARY_THREAT_MAJOR(0),
	m_iAPPROACH_DECEPTIVE_MILITARY_THREAT_MINOR(0),
	m_iAPPROACH_GUARDED_MILITARY_THREAT_MINOR(0),
	m_iAPPROACH_AFRAID_MILITARY_THREAT_MINOR(1),
	m_iAPPROACH_FRIENDLY_MILITARY_THREAT_MINOR(0),
	m_iAPPROACH_HOSTILE_MILITARY_THREAT_NONE(2),
	m_iAPPROACH_WAR_AT_WAR_WITH_PLAYER_WARS_NEUTRAL(-9),
	m_iAPPROACH_WAR_AT_WAR_WITH_PLAYER_WARS_WINNING(-3),
	m_iAPPROACH_WAR_AT_WAR_WITH_PLAYER_WARS_LOSING(-12),
	m_iAPPROACH_HOSTILE_AT_WAR_WITH_PLAYER(-2),
	m_iAPPROACH_DECEPTIVE_AT_WAR_WITH_PLAYER(2),
	m_iAPPROACH_GUARDED_AT_WAR_WITH_PLAYER(0),
	m_iAPPROACH_FRIENDLY_AT_WAR_WITH_PLAYER(2),
	m_iAPPROACH_WAR_PLANNING_WAR_WITH_ANOTHER_PLAYER(-12),
	m_iAPPROACH_HOSTILE_PLANNING_WAR_WITH_ANOTHER_PLAYER(-2),
	m_iAPPROACH_DECEPTIVE_PLANNING_WAR_WITH_ANOTHER_PLAYER(2),
	m_iAPPROACH_GUARDED_PLANNING_WAR_WITH_ANOTHER_PLAYER(0),
	m_iAPPROACH_FRIENDLY_PLANNING_WAR_WITH_ANOTHER_PLAYER(2),
	m_iAPPROACH_WAR_HOSTILE_WITH_ANOTHER_PLAYER(-2),
	m_iAPPROACH_HOSTILE_HOSTILE_WITH_ANOTHER_PLAYER(-2),
	m_iAPPROACH_DECEPTIVE_HOSTILE_WITH_ANOTHER_PLAYER(2),
	m_iAPPROACH_FRIENDLY_HOSTILE_WITH_ANOTHER_PLAYER(2),
	m_iAPPROACH_WAR_AFRAID_WITH_ANOTHER_PLAYER(-4),
	m_iAPPROACH_HOSTILE_AFRAID_WITH_ANOTHER_PLAYER(-4),
	m_iAPPROACH_DECEPTIVE_AFRAID_WITH_ANOTHER_PLAYER(2),
	m_iAPPROACH_FRIENDLY_AFRAID_WITH_ANOTHER_PLAYER(2),
	m_iAPPROACH_WAR_PROJECTION_DESTRUCTION_PERCENT(45),
	m_iAPPROACH_WAR_PROJECTION_DEFEAT_PERCENT(60),
	m_iAPPROACH_WAR_PROJECTION_STALEMATE_PERCENT(80),
	m_iAPPROACH_WAR_PROJECTION_UNKNOWN_PERCENT(100),
	m_iAPPROACH_WAR_PROJECTION_GOOD_PERCENT(150),
	m_iAPPROACH_WAR_PROJECTION_VERY_GOOD_PERCENT(180),
	m_iAPPROACH_GUARDED_PROJECTION_DESTRUCTION_PERCENT(125),
	m_iAPPROACH_GUARDED_PROJECTION_DEFEAT_PERCENT(115),
	m_iAPPROACH_GUARDED_PROJECTION_STALEMATE_PERCENT(105),
	m_iAPPROACH_GUARDED_PROJECTION_UNKNOWN_PERCENT(100),
	m_iAPPROACH_GUARDED_PROJECTION_GOOD_PERCENT(80),
	m_iAPPROACH_GUARDED_PROJECTION_VERY_GOOD_PERCENT(60),
	m_iTURNS_SINCE_PEACE_WEIGHT_DAMPENER(25),
	m_iAPPROACH_WAR_HAS_MADE_PEACE_BEFORE_PERCENT(65),
	m_iAPPROACH_WAR_RECKLESS_EXPANDER(160),
	m_iAPPROACH_WAR_PROXIMITY_NEIGHBORS(115),
	m_iAPPROACH_WAR_PROXIMITY_CLOSE(100),
	m_iAPPROACH_WAR_PROXIMITY_FAR(60),
	m_iAPPROACH_WAR_PROXIMITY_DISTANT(50),
	m_iMINOR_APPROACH_IGNORE_DEFAULT(1),
	m_iMINOR_APPROACH_BIAS_FOR_CURRENT(2),
	m_iMINOR_APPROACH_IGNORE_CURRENTLY_WAR(3),
	m_iMINOR_APPROACH_WAR_CONQUEST_GRAND_STRATEGY(10),
	m_iMINOR_APPROACH_PROTECTIVE_CONQUEST_GRAND_STRATEGY(-15),
	m_iMINOR_APPROACH_FRIENDLY_CONQUEST_GRAND_STRATEGY(-5),
	m_iMINOR_APPROACH_WAR_CONQUEST_GRAND_STRATEGY_NEIGHBORS(10),
	m_iMINOR_APPROACH_WAR_DIPLO_GRAND_STRATEGY(-20),
	m_iMINOR_APPROACH_IGNORE_DIPLO_GRAND_STRATEGY(-15),
	m_iMINOR_APPROACH_PROTECTIVE_DIPLO_GRAND_STRATEGY_NEIGHBORS(5),
	m_iMINOR_APPROACH_WAR_CULTURE_GRAND_STRATEGY(-20),
	m_iMINOR_APPROACH_IGNORE_CULTURE_GRAND_STRATEGY(-15),
	m_iMINOR_APPROACH_PROTECTIVE_CULTURE_GRAND_STRATEGY_CST(5),
	m_iMINOR_APPROACH_WAR_CURRENTLY_PROTECTIVE(-10),
	m_iMINOR_APPROACH_PROTECTIVE_CURRENTLY_PROTECTIVE(10),
	m_iMINOR_APPROACH_PROTECTIVE_CURRENTLY_WAR(-15),
	m_iMINOR_APPROACH_FRIENDLY_CURRENTLY_WAR(-6),
	m_iMINOR_APPROACH_FRIENDLY_RESOURCES(1),
	m_iMINOR_APPROACH_PROTECTIVE_RESOURCES(1),
	m_iMINOR_APPROACH_WAR_FRIENDS(-100),
	m_iMINOR_APPROACH_FRIENDLY_FRIENDS(4),
	m_iMINOR_APPROACH_PROTECTIVE_FRIENDS(2),
	m_iMINOR_APPROACH_IGNORE_PROXIMITY_NEIGHBORS(-2),
	m_iMINOR_APPROACH_FRIENDLY_PROXIMITY_NEIGHBORS(-1),
	m_iMINOR_APPROACH_PROTECTIVE_PROXIMITY_NEIGHBORS(1),
	m_iMINOR_APPROACH_CONQUEST_PROXIMITY_NEIGHBORS(1),
	m_iMINOR_APPROACH_IGNORE_PROXIMITY_CLOSE(-1),
	m_iMINOR_APPROACH_PROTECTIVE_PROXIMITY_CLOSE(1),
	m_iMINOR_APPROACH_CONQUEST_PROXIMITY_CLOSE(-2),
	m_iMINOR_APPROACH_FRIENDLY_PROXIMITY_FAR(2),
	m_iMINOR_APPROACH_CONQUEST_PROXIMITY_FAR(-4),
	m_iMINOR_APPROACH_FRIENDLY_PROXIMITY_DISTANT(2),
	m_iMINOR_APPROACH_CONQUEST_PROXIMITY_DISTANT(-10),
	m_iMINOR_APPROACH_FRIENDLY_PERSONALITY_FRIENDLY(0),
	m_iMINOR_APPROACH_PROTECTIVE_PERSONALITY_PROTECTIVE(0),
	m_iMINOR_APPROACH_FRIENDLY_PERSONALITY_NEUTRAL(0),
	m_iMINOR_APPROACH_PROTECTIVE_PERSONALITY_NEUTRAL(0),
	m_iMINOR_APPROACH_FRIENDLY_PERSONALITY_HOSTILE(-1),
	m_iMINOR_APPROACH_PROTECTIVE_PERSONALITY_HOSTILE(-2),
	m_iMINOR_APPROACH_CONQUEST_PERSONALITY_HOSTILE(1),
	m_iMINOR_APPROACH_FRIENDLY_PERSONALITY_IRRATIONAL(0),
	m_iMINOR_APPROACH_PROTECTIVE_PERSONALITY_IRRATIONAL(0),
	m_iMINOR_APPROACH_WAR_PLANNING_WAR_WITH_ANOTHER_PLAYER(-20),
	m_iMINOR_APPROACH_PROTECTIVE_WITH_ANOTHER_PLAYER(-2),
	m_iMINOR_APPROACH_WAR_TARGET_IMPOSSIBLE(10),
	m_iMINOR_APPROACH_WAR_TARGET_BAD(20),
	m_iMINOR_APPROACH_WAR_TARGET_AVERAGE(40),
	m_iMINOR_APPROACH_WAR_TARGET_FAVORABLE(110),
	m_iMINOR_APPROACH_WAR_TARGET_SOFT(130),
	m_iCOOPERATION_DESIRE_THRESHOLD_EAGER(200),
	m_iCOOPERATION_DESIRE_THRESHOLD_STRONG(150),
	m_iCOOPERATION_DESIRE_THRESHOLD_DECENT(100),
	m_iCOOPERATION_DESIRE_THRESHOLD_WEAK(50),
	m_iCOOPERATION_DESIRE_WAR_STATE_CALM(0),
	m_iCOOPERATION_DESIRE_WAR_STATE_NEARLY_WON(-100),
	m_iCOOPERATION_DESIRE_WAR_STATE_OFFENSIVE(-50),
	m_iCOOPERATION_DESIRE_WAR_STATE_STALEMATE(0),
	m_iCOOPERATION_DESIRE_WAR_STATE_DEFENSIVE(25),
	m_iCOOPERATION_DESIRE_WAR_STATE_NEARLY_DEFEATED(60),
	m_iCOOPERATION_DESIRE_MILITARY_STRENGTH_IMMENSE(50),
	m_iCOOPERATION_DESIRE_MILITARY_STRENGTH_POWERFUL(40),
	m_iCOOPERATION_DESIRE_MILITARY_STRENGTH_STRONG(25),
	m_iCOOPERATION_DESIRE_MILITARY_STRENGTH_AVERAGE(10),
	m_iCOOPERATION_DESIRE_MILITARY_STRENGTH_POOR(0),
	m_iCOOPERATION_DESIRE_MILITARY_STRENGTH_WEAK(0),
	m_iCOOPERATION_DESIRE_MILITARY_STRENGTH_PATHETIC(0),
	m_iCOOPERATION_DESIRE_OPINION_ALLY(150),
	m_iCOOPERATION_DESIRE_OPINION_FRIEND(100),
	m_iCOOPERATION_DESIRE_OPINION_NEUTRAL(50),
	m_iCOOPERATION_DESIRE_OPINION_COMPETITOR(25),
	m_iCOOPERATION_DESIRE_OPINION_ENEMY(0),
	m_iCOOPERATION_DESIRE_GAME_THREAT_CRITICAL(0),
	m_iCOOPERATION_DESIRE_GAME_THREAT_SEVERE(10),
	m_iCOOPERATION_DESIRE_GAME_THREAT_MAJOR(25),
	m_iCOOPERATION_DESIRE_GAME_THREAT_MINOR(35),
	m_iCOOPERATION_DESIRE_GAME_THREAT_NONE(50),
	m_iCOOPERATION_DESIRE_THEM_US_SAME_COMPETITOR(50),
	m_iCOOPERATION_DESIRE_THEM_US_COMPETITOR_ENEMY(75),
	m_iCOOPERATION_DESIRE_THEM_US_ENEMY_COMPETITOR(75),
	m_iCOOPERATION_DESIRE_THEM_US_SAME_ENEMY(100),
	m_iEVALUATE_WAR_PLAYER_THRESHOLD(400),
	m_iEVALUATE_WAR_WILLING_TO_DECLARE_THRESHOLD(50),
	m_iEVALUATE_WAR_CONQUEST_GRAND_STRATEGY(50),
	m_iEVALUATE_WAR_NOT_PREPARED(-100),
	m_iEVALUATE_WAR_ALREADY_FIGHTING(-150),
	m_iEVALUATE_WAR_GAME_THREAT_CRITICAL(150),
	m_iEVALUATE_WAR_GAME_THREAT_SEVERE(100),
	m_iEVALUATE_WAR_GAME_THREAT_MAJOR(50),
	m_iEVALUATE_WAR_GAME_THREAT_MINOR(20),
	m_iEVALUATE_WAR_GAME_THREAT_NONE(0),
	m_iEVALUATE_WAR_SOFT_TARGET(100),
	m_iEVALUATE_WAR_FAVORABLE_TARGET(50),
	m_iEVALUATE_WAR_AVERAGE_TARGET(-25),
	m_iEVALUATE_WAR_BAD_TARGET(-100),
	m_iEVALUATE_WAR_IMPOSSIBLE_TARGET(-200),
	m_iREQUEST_PEACE_TURN_THRESHOLD(4),
	m_iPEACE_WILLINGNESS_OFFER_PROJECTION_DESTRUCTION(100),
	m_iPEACE_WILLINGNESS_OFFER_PROJECTION_DEFEAT(60),
	m_iPEACE_WILLINGNESS_OFFER_PROJECTION_STALEMATE(20),
	m_iPEACE_WILLINGNESS_OFFER_PROJECTION_UNKNOWN(0),
	m_iPEACE_WILLINGNESS_OFFER_PROJECTION_GOOD(-20),
	m_iPEACE_WILLINGNESS_OFFER_PROJECTION_VERY_GOOD(-50),
	m_iPEACE_WILLINGNESS_OFFER_WAR_DAMAGE_NONE(0),
	m_iPEACE_WILLINGNESS_OFFER_WAR_DAMAGE_MINOR(10),
	m_iPEACE_WILLINGNESS_OFFER_WAR_DAMAGE_MAJOR(20),
	m_iPEACE_WILLINGNESS_OFFER_WAR_DAMAGE_SERIOUS(50),
	m_iPEACE_WILLINGNESS_OFFER_WAR_DAMAGE_CRIPPLED(80),
	m_iPEACE_WILLINGNESS_OFFER_THRESHOLD_UN_SURRENDER(180),
	m_iPEACE_WILLINGNESS_OFFER_THRESHOLD_CAPITULATION(150),
	m_iPEACE_WILLINGNESS_OFFER_THRESHOLD_CESSION(120),
	m_iPEACE_WILLINGNESS_OFFER_THRESHOLD_SURRENDER(95),
	m_iPEACE_WILLINGNESS_OFFER_THRESHOLD_SUBMISSION(70),
	m_iPEACE_WILLINGNESS_OFFER_THRESHOLD_BACKDOWN(55),
	m_iPEACE_WILLINGNESS_OFFER_THRESHOLD_SETTLEMENT(40),
	m_iPEACE_WILLINGNESS_OFFER_THRESHOLD_ARMISTICE(20),
	m_iPEACE_WILLINGNESS_ACCEPT_PROJECTION_DESTRUCTION(-50),
	m_iPEACE_WILLINGNESS_ACCEPT_PROJECTION_DEFEAT(-20),
	m_iPEACE_WILLINGNESS_ACCEPT_PROJECTION_STALEMATE(-10),
	m_iPEACE_WILLINGNESS_ACCEPT_PROJECTION_UNKNOWN(0),
	m_iPEACE_WILLINGNESS_ACCEPT_PROJECTION_GOOD(50),
	m_iPEACE_WILLINGNESS_ACCEPT_PROJECTION_VERY_GOOD(100),
	m_iPEACE_WILLINGNESS_ACCEPT_TARGET_IMPOSSIBLE(-50),
	m_iPEACE_WILLINGNESS_ACCEPT_TARGET_BAD(-20),
	m_iPEACE_WILLINGNESS_ACCEPT_TARGET_AVERAGE(0),
	m_iPEACE_WILLINGNESS_ACCEPT_TARGET_FAVORABLE(20),
	m_iPEACE_WILLINGNESS_ACCEPT_TARGET_SOFT(50),
	m_iPEACE_WILLINGNESS_ACCEPT_THRESHOLD_UN_SURRENDER(150),
	m_iPEACE_WILLINGNESS_ACCEPT_THRESHOLD_CAPITULATION(115),
	m_iPEACE_WILLINGNESS_ACCEPT_THRESHOLD_CESSION(80),
	m_iPEACE_WILLINGNESS_ACCEPT_THRESHOLD_SURRENDER(65),
	m_iPEACE_WILLINGNESS_ACCEPT_THRESHOLD_SUBMISSION(50),
	m_iPEACE_WILLINGNESS_ACCEPT_THRESHOLD_BACKDOWN(35),
	m_iPEACE_WILLINGNESS_ACCEPT_THRESHOLD_SETTLEMENT(20),
	m_iPEACE_WILLINGNESS_ACCEPT_THRESHOLD_ARMISTICE(10),
	m_iARMISTICE_GPT_DIVISOR(3),
	m_iARMISTICE_MIN_GOLD(100),
	m_iWAR_GOAL_THRESHOLD_CONQUEST(250),
	m_iWAR_GOAL_THRESHOLD_DAMAGE(130),
	m_iWAR_GOAL_THRESHOLD_PEACE(70),
	m_iWAR_GOAL_STATE_CALM(0),
	m_iWAR_GOAL_STATE_NEARLY_WON(300),
	m_iWAR_GOAL_STATE_OFFENSIVE(100),
	m_iWAR_GOAL_STATE_STALEMATE(-30),
	m_iWAR_GOAL_STATE_DEFENSIVE(-100),
	m_iWAR_GOAL_STATE_NEARLY_DEFEATED(-300),
	m_iWAR_GOAL_ANOTHER_PLAYER_STATE_CALM(-50),
	m_iWAR_GOAL_ANOTHER_PLAYER_STATE_NEARLY_WON(0),
	m_iWAR_GOAL_ANOTHER_PLAYER_STATE_OFFENSIVE(-20),
	m_iWAR_GOAL_ANOTHER_PLAYER_STATE_STALEMATE(-60),
	m_iWAR_GOAL_ANOTHER_PLAYER_STATE_DEFENSIVE(-100),
	m_iWAR_GOAL_ANOTHER_PLAYER_STATE_NEARLY_DEFEATED(-150),
	m_iWAR_GOAL_DAMAGE_CRIPPLED(-100),
	m_iWAR_GOAL_DAMAGE_SERIOUS(-50),
	m_iWAR_GOAL_DAMAGE_MAJOR(-25),
	m_iWAR_GOAL_DAMAGE_MINOR(-10),
	m_iWAR_GOAL_DAMAGE_NONE(0),
	m_iWAR_GOAL_GAME_THREAT_CRITICAL(200),
	m_iWAR_GOAL_GAME_THREAT_SEVERE(100),
	m_iWAR_GOAL_GAME_THREAT_MAJOR(50),
	m_iWAR_GOAL_GAME_THREAT_MINOR(20),
	m_iWAR_GOAL_GAME_THREAT_NONE(0),
	m_iWAR_GOAL_TARGET_SOFT(100),
	m_iWAR_GOAL_TARGET_FAVORABLE(50),
	m_iWAR_GOAL_TARGET_AVERAGE(0),
	m_iWAR_GOAL_TARGET_BAD(-50),
	m_iWAR_GOAL_TARGET_IMPOSSIBLE(-100),
	m_iWAR_PROJECTION_THRESHOLD_VERY_GOOD(100),
	m_iWAR_PROJECTION_THRESHOLD_GOOD(25),
	m_iWAR_PROJECTION_THRESHOLD_DESTRUCTION(-100),
	m_iWAR_PROJECTION_THRESHOLD_DEFEAT(-25),
	m_iWAR_PROJECTION_THRESHOLD_STALEMATE(0),
	m_iWAR_PROJECTION_THEIR_MILITARY_STRENGTH_PATHETIC(100),
	m_iWAR_PROJECTION_THEIR_MILITARY_STRENGTH_WEAK(60),
	m_iWAR_PROJECTION_RECKLESS_EXPANDER(25),
	m_iWAR_PROJECTION_THEIR_MILITARY_STRENGTH_POOR(25),
	m_iWAR_PROJECTION_THEIR_MILITARY_STRENGTH_AVERAGE(0),
	m_iWAR_PROJECTION_THEIR_MILITARY_STRENGTH_STRONG(-25),
	m_iWAR_PROJECTION_THEIR_MILITARY_STRENGTH_POWERFUL(-60),
	m_iWAR_PROJECTION_THEIR_MILITARY_STRENGTH_IMMENSE(-100),
	m_iWAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_PATHETIC(50),
	m_iWAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_WEAK(30),
	m_iWAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_POOR(12),
	m_iWAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_AVERAGE(0),
	m_iWAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_STRONG(-12),
	m_iWAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_POWERFUL(-30),
	m_iWAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_IMMENSE(-50),
	m_iWAR_PROJECTION_WAR_DAMAGE_US_NONE(0),
	m_iWAR_PROJECTION_WAR_DAMAGE_US_MINOR(-10),
	m_iWAR_PROJECTION_WAR_DAMAGE_US_MAJOR(-20),
	m_iWAR_PROJECTION_WAR_DAMAGE_US_SERIOUS(-30),
	m_iWAR_PROJECTION_WAR_DAMAGE_US_CRIPPLED(-40),
	m_iWAR_PROJECTION_WAR_DAMAGE_THEM_NONE(0),
	m_iWAR_PROJECTION_WAR_DAMAGE_THEM_MINOR(5),
	m_iWAR_PROJECTION_WAR_DAMAGE_THEM_MAJOR(10),
	m_iWAR_PROJECTION_WAR_DAMAGE_THEM_SERIOUS(15),
	m_iWAR_PROJECTION_WAR_DAMAGE_THEM_CRIPPLED(20),
	m_iWAR_PROJECTION_WAR_DURATION_SCORE_CAP(20),
	m_iWAR_STATE_CALM_THRESHOLD_FOREIGN_FORCES(25),
	m_iWAR_STATE_THRESHOLD_NEARLY_WON(75),
	m_iWAR_STATE_THRESHOLD_OFFENSIVE(57),
	m_iWAR_STATE_THRESHOLD_STALEMATE(42),
	m_iWAR_STATE_THRESHOLD_DEFENSIVE(25),
	m_iWAR_DAMAGE_LEVEL_THRESHOLD_CRIPPLED(67),
	m_iWAR_DAMAGE_LEVEL_THRESHOLD_SERIOUS(50),
	m_iWAR_DAMAGE_LEVEL_THRESHOLD_MAJOR(25),
	m_iWAR_DAMAGE_LEVEL_THRESHOLD_MINOR(10),
	m_iWAR_DAMAGE_LEVEL_CITY_WEIGHT(150),
	m_iWAR_DAMAGE_LEVEL_INVOLVED_CITY_POP_MULTIPLIER(100),
	m_iWAR_DAMAGE_LEVEL_UNINVOLVED_CITY_POP_MULTIPLIER(120),
	m_iMILITARY_AGGRESSIVE_POSTURE_THRESHOLD_INCREDIBLE(80),
	m_iMILITARY_AGGRESSIVE_POSTURE_THRESHOLD_HIGH(50),
	m_iMILITARY_AGGRESSIVE_POSTURE_THRESHOLD_MEDIUM(30),
	m_iMILITARY_AGGRESSIVE_POSTURE_THRESHOLD_LOW(10),
	m_iEXPANSION_CAPITAL_DISTANCE_AGGRESSIVE_POSTURE_HIGH(3),
	m_iEXPANSION_CAPITAL_DISTANCE_AGGRESSIVE_POSTURE_MEDIUM(5),
	m_iEXPANSION_CAPITAL_DISTANCE_AGGRESSIVE_POSTURE_LOW(9),
	m_iPLOT_BUYING_POSTURE_INCREDIBLE_THRESHOLD(10),
	m_iPLOT_BUYING_POSTURE_HIGH_THRESHOLD(7),
	m_iPLOT_BUYING_POSTURE_MEDIUM_THRESHOLD(4),
	m_iPLOT_BUYING_POSTURE_LOW_THRESHOLD(2),
	m_iMILITARY_STRENGTH_BASE(30),
	m_iMILITARY_STRENGTH_RATIO_MULTIPLIER(100),
	m_iMILITARY_STRENGTH_CITY_MOD(33),
	m_iMILITARY_STRENGTH_IMMENSE_THRESHOLD(250),
	m_iMILITARY_STRENGTH_POWERFUL_THRESHOLD(165),
	m_iMILITARY_STRENGTH_STRONG_THRESHOLD(115),
	m_iMILITARY_STRENGTH_AVERAGE_THRESHOLD(85),
	m_iMILITARY_STRENGTH_POOR_THRESHOLD(60),
	m_iMILITARY_STRENGTH_WEAK_THRESHOLD(40),
	m_iECONOMIC_STRENGTH_RATIO_MULTIPLIER(100),
	m_iECONOMIC_STRENGTH_IMMENSE_THRESHOLD(250),
	m_iECONOMIC_STRENGTH_POWERFUL_THRESHOLD(153),
	m_iECONOMIC_STRENGTH_STRONG_THRESHOLD(120),
	m_iECONOMIC_STRENGTH_AVERAGE_THRESHOLD(83),
	m_iECONOMIC_STRENGTH_POOR_THRESHOLD(65),
	m_iECONOMIC_STRENGTH_WEAK_THRESHOLD(40),
	m_iTARGET_IMPOSSIBLE_THRESHOLD(200),
	m_iTARGET_BAD_THRESHOLD(125),
	m_iTARGET_AVERAGE_THRESHOLD(80),
	m_iTARGET_FAVORABLE_THRESHOLD(50),
	m_iTARGET_INCREASE_WAR_TURNS(50),
	m_iTARGET_MILITARY_STRENGTH_IMMENSE(250),
	m_iTARGET_MILITARY_STRENGTH_POWERFUL(165),
	m_iTARGET_MILITARY_STRENGTH_STRONG(115),
	m_iTARGET_MILITARY_STRENGTH_AVERAGE(85),
	m_iTARGET_MILITARY_STRENGTH_POOR(60),
	m_iTARGET_MILITARY_STRENGTH_WEAK(40),
	m_iTARGET_MILITARY_STRENGTH_PATHETIC(0),
	m_iTARGET_ALREADY_WAR_EACH_PLAYER(30),
	m_iTARGET_NEIGHBORS(-10),
	m_iTARGET_CLOSE(0),
	m_iTARGET_FAR(30),
	m_iTARGET_DISTANT(80),
	m_iTARGET_MINOR_BACKUP_PATHETIC(0),
	m_iTARGET_MINOR_BACKUP_WEAK(0),
	m_iTARGET_MINOR_BACKUP_POOR(5),
	m_iTARGET_MINOR_BACKUP_AVERAGE(15),
	m_iTARGET_MINOR_BACKUP_STRONG(25),
	m_iTARGET_MINOR_BACKUP_POWERFUL(35),
	m_iTARGET_MINOR_BACKUP_IMMENSE(50),
	m_iTARGET_MINOR_BACKUP_DISTANT(100),
	m_iTARGET_MINOR_BACKUP_FAR(115),
	m_iTARGET_MINOR_BACKUP_CLOSE(150),
	m_iTARGET_MINOR_BACKUP_NEIGHBORS(200),
	m_iGAME_THREAT_CRITICAL_THRESHOLD(150),
	m_iGAME_THREAT_SEVERE_THRESHOLD(100),
	m_iGAME_THREAT_MAJOR_THRESHOLD(50),
	m_iGAME_THREAT_MINOR_THRESHOLD(10),
	m_iGAME_THREAT_AT_WAR_STALEMATE(10),
	m_iGAME_THREAT_AT_WAR_DEFENSIVE(40),
	m_iGAME_THREAT_AT_WAR_NEARLY_DEFEATED(100),
	m_iGAME_THREAT_AT_WAR_MILITARY_STRENGTH_IMMENSE(80),
	m_iGAME_THREAT_AT_WAR_MILITARY_STRENGTH_POWERFUL(50),
	m_iGAME_THREAT_AT_WAR_MILITARY_STRENGTH_STRONG(30),
	m_iGAME_THREAT_AT_WAR_MILITARY_STRENGTH_AVERAGE(10),
	m_iGAME_THREAT_GUESS_AT_WAR(50),
	m_iGAME_THREAT_GUESS_AT_WAR_MILITARY_STRENGTH_IMMENSE(100),
	m_iGAME_THREAT_GUESS_AT_WAR_MILITARY_STRENGTH_POWERFUL(60),
	m_iGAME_THREAT_GUESS_AT_WAR_MILITARY_STRENGTH_STRONG(40),
	m_iGAME_THREAT_GUESS_AT_WAR_MILITARY_STRENGTH_AVERAGE(20),
	m_iMILITARY_THREAT_CRITICAL_THRESHOLD(300),
	m_iMILITARY_THREAT_SEVERE_THRESHOLD(220),
	m_iMILITARY_THREAT_MAJOR_THRESHOLD(170),
	m_iMILITARY_THREAT_MINOR_THRESHOLD(100),
	m_iMILITARY_THREAT_STRENGTH_IMMENSE(300),
	m_iMILITARY_THREAT_STRENGTH_POWERFUL(200),
	m_iMILITARY_THREAT_STRENGTH_STRONG(135),
	m_iMILITARY_THREAT_STRENGTH_AVERAGE(100),
	m_iMILITARY_THREAT_STRENGTH_POOR(65),
	m_iMILITARY_THREAT_STRENGTH_WEAK(20),
	m_iMILITARY_THREAT_STRENGTH_PATHETIC(5),
	m_iMILITARY_THREAT_WAR_STATE_CALM(0),
	m_iMILITARY_THREAT_WAR_STATE_NEARLY_WON(-100),
	m_iMILITARY_THREAT_WAR_STATE_OFFENSIVE(-40),
	m_iMILITARY_THREAT_WAR_STATE_STALEMATE(30),
	m_iMILITARY_THREAT_WAR_STATE_DEFENSIVE(80),
	m_iMILITARY_THREAT_WAR_STATE_NEARLY_DEFEATED(150),
	m_iMILITARY_THREAT_NEIGHBORS(100),
	m_iMILITARY_THREAT_CLOSE(40),
	m_iMILITARY_THREAT_FAR(-40),
	m_iMILITARY_THREAT_DISTANT(-100),
	m_iMILITARY_THREAT_PER_MINOR_ATTACKED(20),
	m_iMILITARY_THREAT_PER_MINOR_CONQUERED(10),
	m_iMILITARY_THREAT_PER_MAJOR_ATTACKED(40),
	m_iMILITARY_THREAT_PER_MAJOR_CONQUERED(20),
	m_iMILITARY_THREAT_ALREADY_WAR_EACH_PLAYER_MULTIPLIER(-30),
	m_iWARMONGER_THREAT_CRITICAL_THRESHOLD(200),
	m_iWARMONGER_THREAT_SEVERE_THRESHOLD(150),
	m_iWARMONGER_THREAT_MAJOR_THRESHOLD(100),
	m_iWARMONGER_THREAT_MINOR_THRESHOLD(50),
	m_iWARMONGER_THREAT_MINOR_ATTACKED_WEIGHT(50),
	m_iWARMONGER_THREAT_MINOR_CONQUERED_WEIGHT(100),
	m_iWARMONGER_THREAT_MAJOR_ATTACKED_WEIGHT(50),
	m_iWARMONGER_THREAT_MAJOR_CONQUERED_WEIGHT(100),
	m_iWARMONGER_THREAT_PER_TURN_DECAY(5),
	m_iWARMONGER_THREAT_PERSONALITY_MOD(10),
	m_iWARMONGER_THREAT_CRITICAL_PERCENT_THRESHOLD(40),
	m_iWARMONGER_THREAT_SEVERE_PERCENT_THRESHOLD(25),
	m_iLAND_DISPUTE_FIERCE_THRESHOLD(400),
	m_iLAND_DISPUTE_STRONG_THRESHOLD(230),
	m_iLAND_DISPUTE_WEAK_THRESHOLD(100),
	m_iVICTORY_DISPUTE_FIERCE_THRESHOLD(80),
	m_iVICTORY_DISPUTE_STRONG_THRESHOLD(50),
	m_iVICTORY_DISPUTE_WEAK_THRESHOLD(30),
	m_iWONDER_DISPUTE_FIERCE_THRESHOLD(10),
	m_iWONDER_DISPUTE_STRONG_THRESHOLD(7),
	m_iWONDER_DISPUTE_WEAK_THRESHOLD(5),
	m_iMINOR_CIV_DISPUTE_FIERCE_THRESHOLD(700),
	m_iMINOR_CIV_DISPUTE_STRONG_THRESHOLD(400),
	m_iMINOR_CIV_DISPUTE_WEAK_THRESHOLD(200),
	m_iMINOR_CIV_DISPUTE_ALLIES_WEIGHT(10),
	m_iMINOR_CIV_DISPUTE_FRIENDS_WEIGHT(5),
	m_iLAND_DISPUTE_EXP_AGGRESSIVE_POSTURE_NONE(0),
	m_iLAND_DISPUTE_EXP_AGGRESSIVE_POSTURE_LOW(10),
	m_iLAND_DISPUTE_EXP_AGGRESSIVE_POSTURE_MEDIUM(32),
	m_iLAND_DISPUTE_EXP_AGGRESSIVE_POSTURE_HIGH(50),
	m_iLAND_DISPUTE_EXP_AGGRESSIVE_POSTURE_INCREDIBLE(60),
	m_iLAND_DISPUTE_PLOT_BUY_AGGRESSIVE_POSTURE_NONE(0),
	m_iLAND_DISPUTE_PLOT_BUY_AGGRESSIVE_POSTURE_LOW(5),
	m_iLAND_DISPUTE_PLOT_BUY_AGGRESSIVE_POSTURE_MEDIUM(12),
	m_iLAND_DISPUTE_PLOT_BUY_AGGRESSIVE_POSTURE_HIGH(20),
	m_iLAND_DISPUTE_PLOT_BUY_AGGRESSIVE_POSTURE_INCREDIBLE(30),
	m_iLAND_DISPUTE_DISTANT(0),
	m_iLAND_DISPUTE_FAR(10),
	m_iLAND_DISPUTE_CLOSE(18),
	m_iLAND_DISPUTE_NEIGHBORS(30),
	m_iLAND_DISPUTE_CRAMPED_MULTIPLIER(0),
	m_iLAND_DISPUTE_NO_EXPANSION_STRATEGY(0),
	m_iVICTORY_DISPUTE_GRAND_STRATEGY_MATCH_POSITIVE(14),
	m_iVICTORY_DISPUTE_GRAND_STRATEGY_MATCH_LIKELY(10),
	m_iVICTORY_DISPUTE_GRAND_STRATEGY_MATCH_UNSURE(6),
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_10(200),
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_9(180),
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_8(160),
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_7(130),
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_6(110),
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_5(90),
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_4(80),
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_3(55),
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_2(30),
	m_iVICTORY_DISPUTE_OTHER_PLAYER_FIERCE_THRESHOLD(70),
	m_iVICTORY_DISPUTE_OTHER_PLAYER_STRONG_THRESHOLD(50),
	m_iVICTORY_DISPUTE_OTHER_PLAYER_WEAK_THRESHOLD(30),
	m_iVICTORY_DISPUTE_OTHER_PLAYER_GRAND_STRATEGY_MATCH_POSITIVE(7),
	m_iVICTORY_DISPUTE_OTHER_PLAYER_GRAND_STRATEGY_MATCH_LIKELY(5),
	m_iVICTORY_DISPUTE_OTHER_PLAYER_GRAND_STRATEGY_MATCH_UNSURE(3),
	m_iIC_MEMORY_TURN_EXPIRATION(50),
	m_iSTOP_SPYING_MEMORY_TURN_EXPIRATION(50),
	m_iCOOP_WAR_SOON_COUNTER(10),
	m_iCOOP_WAR_LOCKED_TURNS(20),
	m_iCOOP_WAR_LOCKED_TURNS_WAR_WEIGHT(1000),
	m_iDEMAND_TURN_LIMIT_MIN(20),
	m_iDEMAND_TURN_LIMIT_RAND(10),
	m_iDONT_SETTLE_RAND(100),
	m_iDONT_SETTLE_FLAVOR_BASE(8),
	m_iDONT_SETTLE_FLAVOR_MULTIPLIER(5),
	m_iDONT_SETTLE_FRIENDLY(30),
	m_iDONT_SETTLE_STRENGTH_PATHETIC(-30),
	m_iDONT_SETTLE_STRENGTH_WEAK(-20),
	m_iDONT_SETTLE_STRENGTH_POOR(-10),
	m_iDONT_SETTLE_STRENGTH_AVERAGE(0),
	m_iDONT_SETTLE_STRENGTH_STRONG(25),
	m_iDONT_SETTLE_STRENGTH_POWERFUL(40),
	m_iDONT_SETTLE_STRENGTH_IMMENSE(60),
	m_iDONT_SETTLE_MOD_MILITARY_POSTURE_NONE(100),
	m_iDONT_SETTLE_MOD_MILITARY_POSTURE_LOW(100),
	m_iDONT_SETTLE_MOD_MILITARY_POSTURE_MEDIUM(150),
	m_iDONT_SETTLE_MOD_MILITARY_POSTURE_HIGH(200),
	m_iDONT_SETTLE_MOD_MILITARY_POSTURE_INCREDIBLE(300),
	m_iDOF_TURN_BUFFER(20),
	m_iDOF_THRESHOLD(12),
	m_iDENUNCIATION_EXPIRATION_TIME(30),
	m_iDOF_EXPIRATION_TIME(50),
	m_iEACH_GOLD_VALUE_PERCENT(100),
	m_iEACH_GOLD_PER_TURN_VALUE_PERCENT(75),

	m_iEXPANSION_BICKER_TIMEOUT(10),
	m_iEXPANSION_PROMISE_TURNS_EFFECTIVE(50),
	m_iEXPANSION_PROMISE_BROKEN_PER_TURN_DECAY(3),
	m_iBROKEN_EXPANSION_PROMISE_PER_OPINION_WEIGHT(10),
	m_iOPINION_WEIGHT_EXPANSION_PROMISE_BROKE_MAX(30),
	m_iEXPANSION_PROMISE_IGNORED_PER_TURN_DECAY(3),
	m_iIGNORED_EXPANSION_PROMISE_PER_OPINION_WEIGHT(10),
	m_iOPINION_WEIGHT_EXPANSION_PROMISE_IGNORED_MAX(15),

	m_iBORDER_PROMISE_TURNS_EFFECTIVE(50),
	m_iBORDER_PROMISE_BROKEN_PER_TURN_DECAY(3),
	m_iBROKEN_BORDER_PROMISE_PER_OPINION_WEIGHT(10),
	m_iOPINION_WEIGHT_BORDER_PROMISE_BROKE_MAX(30),
	m_iBORDER_PROMISE_IGNORED_PER_TURN_DECAY(3),
	m_iIGNORED_BORDER_PROMISE_PER_OPINION_WEIGHT(10),
	m_iOPINION_WEIGHT_BORDER_PROMISE_IGNORED_MAX(15),
	m_iDECLARED_WAR_ON_FRIEND_PER_TURN_DECAY(100),
	m_iDECLARED_WAR_ON_FRIEND_PER_OPINION_WEIGHT(1),

	m_iDEAL_VALUE_PER_TURN_DECAY(3),
	m_iDEAL_VALUE_PER_OPINION_WEIGHT(10),
	m_iCOMMON_FOE_VALUE_PER_TURN_DECAY(25),
	m_iCOMMON_FOE_VALUE_PER_OPINION_WEIGHT(50),
	m_iWANT_RESEARCH_AGREEMENT_RAND(8),
	m_iDEMAND_RAND(100),
	m_iCAN_WORK_WATER_FROM_GAME_START(1),
	m_iNAVAL_PLOT_BLOCKADE_RANGE(2),
	m_iEVENT_MESSAGE_TIME(10),
	m_iSTART_YEAR(-4000),
	m_iWEEKS_PER_MONTHS(4),
	m_iHIDDEN_START_TURN_OFFSET(0),
	m_iRECON_VISIBILITY_RANGE(6),
	m_iPLOT_VISIBILITY_RANGE(1),
	m_iUNIT_VISIBILITY_RANGE(1),
	m_iAIR_UNIT_REBASE_RANGE_MULTIPLIER(200),
	m_iMOUNTAIN_SEE_FROM_CHANGE(2),
	m_iMOUNTAIN_SEE_THROUGH_CHANGE(2),
	m_iHILLS_SEE_FROM_CHANGE(1),
	m_iHILLS_SEE_THROUGH_CHANGE(1),
	m_iSEAWATER_SEE_FROM_CHANGE(1),
	m_iSEAWATER_SEE_THROUGH_CHANGE(1),
	m_iMAX_YIELD_STACK(5),
	m_iMOVE_DENOMINATOR(60),
	m_iSTARTING_DISTANCE_PERCENT(12),
	m_iMIN_CIV_STARTING_DISTANCE(10),
	m_iMIN_CITY_RANGE(2),
	m_iOWNERSHIP_SCORE_DURATION_THRESHOLD(20),
	m_iNUM_POLICY_BRANCHES_ALLOWED(2),
	m_iVICTORY_POINTS_NEEDED_TO_WIN(20),
	m_iNUM_VICTORY_POINT_AWARDS(5),
	m_iNUM_OR_TECH_PREREQS(3),
	m_iNUM_AND_TECH_PREREQS(4),
	m_iNUM_UNIT_AND_TECH_PREREQS(3),
	m_iNUM_BUILDING_AND_TECH_PREREQS(3),
	m_iNUM_BUILDING_RESOURCE_PREREQS(5),
	m_iBASE_RESEARCH_RATE(1),
	m_iMAX_WORLD_WONDERS_PER_CITY(-1),
	m_iMAX_TEAM_WONDERS_PER_CITY(-1),
	m_iMAX_NATIONAL_WONDERS_PER_CITY(-1),
	m_iMAX_NATIONAL_WONDERS_PER_CITY_FOR_OCC(-1),
	m_iMAX_BUILDINGS_PER_CITY(-1),
	m_iINITIAL_CITY_POPULATION(1),
	m_iCITY_CAPTURE_POPULATION_PERCENT(50),
	m_iBASE_CITY_GROWTH_THRESHOLD(15),
	m_iFOOD_CONSUMPTION_PER_POPULATION(2),
	m_iHAPPINESS_PER_CITY_WITH_STATE_RELIGION(0),
	m_iHAPPINESS_PER_NATURAL_WONDER(1),
	m_iHAPPINESS_PER_EXTRA_LUXURY(0),
	m_iUNHAPPINESS_PER_POPULATION(1),
	m_fUNHAPPINESS_PER_OCCUPIED_POPULATION(1.25f),
	m_iUNHAPPINESS_PER_CITY(2),
	m_iUNHAPPINESS_PER_CAPTURED_CITY(3),
	m_iUNHAPPY_GROWTH_PENALTY(-75),
	m_iVERY_UNHAPPY_GROWTH_PENALTY(-100),
	m_iVERY_UNHAPPY_CANT_TRAIN_SETTLERS(1),
	m_iVERY_UNHAPPY_THRESHOLD(-10),
	m_iSUPER_UNHAPPY_THRESHOLD(-20),
	m_iREVOLT_COUNTER_MIN(5),
	m_iREVOLT_COUNTER_POSSIBLE(5),
	m_iREVOLT_NUM_BASE(100),
	m_iREVOLT_NUM_CITY_COUNT(20),
	m_iVERY_UNHAPPY_COMBAT_PENALTY(-33),
	m_iSTRATEGIC_RESOURCE_EXHAUSTED_PENALTY(-50),
	m_iVERY_UNHAPPY_PRODUCTION_PENALTY(-50),
	m_iWLTKD_GROWTH_MULTIPLIER(25),
	m_iINDUSTRIAL_ROUTE_PRODUCTION_MOD(50),
	m_iRESOURCE_DEMAND_COUNTDOWN_BASE(15),
	m_iRESOURCE_DEMAND_COUNTDOWN_CAPITAL_ADD(25),
	m_iRESOURCE_DEMAND_COUNTDOWN_RAND(10),
	m_iNEW_HURRY_MODIFIER(50),
	m_iGREAT_GENERAL_RANGE(2),
	m_iGREAT_GENERAL_STRENGTH_MOD(25),
	m_iBONUS_PER_ADJACENT_FRIEND(15),
	m_iPOLICY_ATTACK_BONUS_MOD(20),
	m_iCONSCRIPT_MIN_CITY_POPULATION(5),
	m_iCONSCRIPT_POPULATION_PER_COST(60),
	m_iMIN_TIMER_UNIT_DOUBLE_MOVES(32),
	m_iCOMBAT_DAMAGE(20),
	m_iNONCOMBAT_UNIT_RANGED_DAMAGE(4),
	m_iNAVAL_COMBAT_DEFENDER_STRENGTH_MULTIPLIER(100),
	m_iLAKE_PLOT_RAND(160),
	m_iPLOTS_PER_RIVER_EDGE(12),
	m_iRIVER_SOURCE_MIN_RIVER_RANGE(4),
	m_iRIVER_SOURCE_MIN_SEAWATER_RANGE(2),
	m_iLAKE_MAX_AREA_SIZE(9),
	m_iINITIAL_GOLD_PER_UNIT_TIMES_100(50),
	m_iINITIAL_FREE_OUTSIDE_UNITS(3),
	m_iINITIAL_OUTSIDE_UNIT_GOLD_PERCENT(0),
	m_iUNIT_MAINTENANCE_GAME_MULTIPLIER(5),
	m_iUNIT_MAINTENANCE_GAME_EXPONENT_DIVISOR(6),
	m_iFREE_UNIT_HAPPINESS(0),
	m_iTRADE_ROUTE_BASE_GOLD(1),
	m_iTRADE_ROUTE_CAPITAL_POP_GOLD_MULTIPLIER(0),
	m_iTRADE_ROUTE_CITY_POP_GOLD_MULTIPLIER(125),
	m_iDEFICIT_UNIT_DISBANDING_THRESHOLD(-5),
	m_iGOLDEN_AGE_BASE_THRESHOLD_HAPPINESS(500),
	m_fGOLDEN_AGE_THRESHOLD_CITY_MULTIPLIER(0.02f),
	m_iGOLDEN_AGE_EACH_GA_ADDITIONAL_HAPPINESS(500),
	m_iGOLDEN_AGE_VISIBLE_THRESHOLD_DIVISOR(5),
	m_iBASE_GOLDEN_AGE_UNITS(1),
	m_iGOLDEN_AGE_UNITS_MULTIPLIER(1),
	m_iGOLDEN_AGE_LENGTH(10),
	m_iGOLDEN_AGE_GREAT_PEOPLE_MODIFIER(100),
	m_iMIN_UNIT_GOLDEN_AGE_TURNS(3),
	m_iGOLDEN_AGE_CULTURE_MODIFIER(50),
	m_iHILLS_EXTRA_MOVEMENT(1),
	m_iRIVER_EXTRA_MOVEMENT(10),
	m_iFEATURE_GROWTH_MODIFIER(25),
	m_iROUTE_FEATURE_GROWTH_MODIFIER(-50),
	m_iEXTRA_YIELD(1),
	m_iFORTIFY_MODIFIER_PER_TURN(25),
	m_iMAX_FORTIFY_TURNS(2),
	m_iNUKE_FALLOUT_PROB(50),
	m_iNUKE_UNIT_DAMAGE_BASE(3),
	m_iNUKE_UNIT_DAMAGE_RAND_1(4),
	m_iNUKE_UNIT_DAMAGE_RAND_2(4),
	m_iNUKE_NON_COMBAT_DEATH_THRESHOLD(6),
	m_iNUKE_LEVEL1_POPULATION_DEATH_BASE(30),
	m_iNUKE_LEVEL1_POPULATION_DEATH_RAND_1(20),
	m_iNUKE_LEVEL1_POPULATION_DEATH_RAND_2(20),
	m_iNUKE_LEVEL2_POPULATION_DEATH_BASE(60),
	m_iNUKE_LEVEL2_POPULATION_DEATH_RAND_1(10),
	m_iNUKE_LEVEL2_POPULATION_DEATH_RAND_2(10),
	m_iNUKE_LEVEL2_ELIM_POPULATION_THRESHOLD(5),
	m_iNUKE_CITY_HIT_POINT_DAMAGE(50),
	m_iNUKE_BLAST_RADIUS(2),
	m_iTECH_COST_EXTRA_TEAM_MEMBER_MODIFIER(50),
	m_iTECH_COST_TOTAL_KNOWN_TEAM_MODIFIER(30),
	m_iTECH_COST_KNOWN_PREREQ_MODIFIER(20),
	m_iPEACE_TREATY_LENGTH(10),
	m_iCOOP_WAR_LOCKED_LENGTH(15),
	m_iBASE_FEATURE_PRODUCTION_PERCENT(67),
	m_iFEATURE_PRODUCTION_PERCENT_MULTIPLIER(0),
	m_iDIFFERENT_TEAM_FEATURE_PRODUCTION_PERCENT(67),
	m_iDEFAULT_WAR_VALUE_FOR_UNIT(100),
	m_iUNIT_PRODUCTION_PERCENT(100),
	m_iMAX_UNIT_SUPPLY_PRODMOD(70),
	m_iBUILDING_PRODUCTION_PERCENT(100),
	m_iPROJECT_PRODUCTION_PERCENT(100),
	m_iMAXED_UNIT_GOLD_PERCENT(100),
	m_iMAXED_BUILDING_GOLD_PERCENT(100),
	m_iMAXED_PROJECT_GOLD_PERCENT(300),
	m_iMAX_CITY_DEFENSE_DAMAGE(100),
	m_iCIRCUMNAVIGATE_FREE_MOVES(0),
	m_iBASE_CAPTURE_GOLD(20),
	m_iCAPTURE_GOLD_PER_POPULATION(10),
	m_iCAPTURE_GOLD_RAND1(20),
	m_iCAPTURE_GOLD_RAND2(20),
	m_iCAPTURE_GOLD_MAX_TURNS(50),
	m_iBARBARIAN_CITY_ATTACK_MODIFIER(-25),
	m_iBUILDING_PRODUCTION_DECAY_TIME(50),
	m_iBUILDING_PRODUCTION_DECAY_PERCENT(99),
	m_iUNIT_PRODUCTION_DECAY_TIME(10),
	m_iUNIT_PRODUCTION_DECAY_PERCENT(98),
	m_iBASE_UNIT_UPGRADE_COST(10),
	m_iUNIT_UPGRADE_COST_PER_PRODUCTION(2),
	m_iUNIT_UPGRADE_COST_VISIBLE_DIVISOR(5),
	m_iUNIT_UPGRADE_COST_DISCOUNT_MAX(-75),
	m_iWAR_SUCCESS_UNIT_CAPTURING(1),
	m_iWAR_SUCCESS_CITY_CAPTURING(10),
	m_iDIPLO_VOTE_SECRETARY_GENERAL_INTERVAL(4),
	m_iTEAM_VOTE_MIN_CANDIDATES(2),
	m_iRESEARCH_AGREEMENT_TIMER(20),
	m_iRESEARCH_AGREEMENT_BOOST_DIVISOR(3),
	m_iSCORE_POPULATION_FACTOR(5000),
	m_iSCORE_LAND_FACTOR(2000),
	m_iSCORE_WONDER_FACTOR(1000),
	m_iSCORE_TECH_FACTOR(2000),
	m_iSCORE_FREE_PERCENT(0),
	m_iSCORE_VICTORY_PERCENT(0),
	m_iSCORE_HANDICAP_PERCENT_OFFSET(-60),
	m_iSCORE_HANDICAP_PERCENT_PER(20),
	m_iMINIMAP_RENDER_SIZE(512),
	m_iMAX_INTERCEPTION_PROBABILITY(100),
	m_iMAX_EVASION_PROBABILITY(90),
	m_iPLAYER_ALWAYS_RAZES_CITIES(0),
	m_iMIN_WATER_SIZE_FOR_OCEAN(10),
	m_iCITY_SCREEN_CLICK_WILL_EXIT(0),
	m_iWATER_POTENTIAL_CITY_WORK_FOR_AREA(0),
	m_iLAND_UNITS_CAN_ATTACK_WATER_CITIES(0),
	m_iCITY_MAX_NUM_BUILDINGS(1),
	m_iCITY_MIN_SIZE_FOR_SETTLERS(2),
	m_iRANGED_ATTACKS_USE_MOVES(0),
	m_iADVANCED_START_ALLOW_UNITS_OUTSIDE_CITIES(0),
	m_iADVANCED_START_MAX_UNITS_PER_CITY(2),
	m_iADVANCED_START_CITY_COST(67),
	m_iADVANCED_START_CITY_COST_INCREASE(0),
	m_iADVANCED_START_POPULATION_COST(150),
	m_iADVANCED_START_POPULATION_COST_INCREASE(0),
	m_iADVANCED_START_VISIBILITY_COST(2),
	m_iADVANCED_START_VISIBILITY_COST_INCREASE(3),
	m_iADVANCED_START_CITY_PLACEMENT_MAX_RANGE(6),
	m_iNEW_CITY_BUILDING_VALUE_MODIFIER(-60),
	m_iPATH_DAMAGE_WEIGHT(0),
	m_iPUPPET_SCIENCE_MODIFIER(-25),
	m_iPUPPET_CULTURE_MODIFIER(-25),
	m_iPUPPET_GOLD_MODIFIER(0),
	m_iPUPPET_FAITH_MODIFIER(0),
	m_iBASE_POLICY_COST(25),
	m_iPOLICY_COST_INCREASE_TO_BE_EXPONENTED(6),
	m_iPOLICY_COST_VISIBLE_DIVISOR(5),
	m_iSWITCH_POLICY_BRANCHES_ANARCHY_TURNS(1),
	m_iPOLICY_COST_DISCOUNT_MAX(-75),
	m_iGOLD_PURCHASE_GOLD_PER_PRODUCTION(4),
	m_iGOLD_PURCHASE_VISIBLE_DIVISOR(10),
	m_iPROJECT_PURCHASING_DISABLED(1),
	m_iINFLUENCE_MOUNTAIN_COST(3),
	m_iINFLUENCE_HILL_COST(2),
	m_iINFLUENCE_RIVER_COST(1),
	m_iUSE_FIRST_RING_INFLUENCE_TERRAIN_COST(0),
	m_iNUM_RESOURCE_QUANTITY_TYPES(4),
	m_iSPECIALISTS_DIVERT_POPULATION_ENABLED(0),
	m_iSCIENCE_PER_POPULATION(1),
	m_iRESEARCH_AGREEMENT_MOD(0),
	m_iBARBARIAN_CAMP_FIRST_TURN_PERCENT_OF_TARGET_TO_ADD(33),
	m_iBARBARIAN_CAMP_ODDS_OF_NEW_CAMP_SPAWNING(2),
	m_iBARBARIAN_CAMP_MINIMUM_DISTANCE_CAPITAL(4),
	m_iBARBARIAN_CAMP_MINIMUM_DISTANCE_ANOTHER_CAMP(7),
	m_iBARBARIAN_CAMP_COASTAL_SPAWN_ROLL(6),
	m_iBARBARIAN_EXTRA_RAGING_UNIT_SPAWN_CHANCE(10),
	m_iBARBARIAN_NAVAL_UNIT_START_TURN_SPAWN(30),
	m_iMAX_BARBARIANS_FROM_CAMP_NEARBY(2),
	m_iMAX_BARBARIANS_FROM_CAMP_NEARBY_RANGE(4),
	m_iGOLD_FROM_BARBARIAN_CONVERSION(25),
	m_iBARBARIAN_CITY_GOLD_RANSOM(200),
	m_iBARBARIAN_UNIT_GOLD_RANSOM(100),
	m_iEMBARKED_UNIT_MOVEMENT(2),
	m_iEMBARKED_VISIBILITY_RANGE(0),
	m_iDEFAULT_MAX_NUM_BUILDERS(-1),
	m_iBARBARIAN_TECH_PERCENT(75),
	m_iCITY_RESOURCE_WLTKD_TURNS(20),
	m_iMAX_SPECIALISTS_FROM_BUILDING(4),
	m_iGREAT_PERSON_THRESHOLD_BASE(100),
	m_iGREAT_PERSON_THRESHOLD_INCREASE(100),
	m_iCULTURE_BOMB_COOLDOWN(10),
	m_iCULTURE_BOMB_MINOR_FRIENDSHIP_CHANGE(-50),
	m_iUNIT_AUTO_EXPLORE_DISABLED(0),
	m_iUNIT_WORKER_AUTOMATION_DISABLED(0),
	m_iUNIT_DELETE_DISABLED(0),
	m_iMIN_START_AREA_TILES(4),
	m_iMIN_DISTANCE_OTHER_AREA_PERCENT(75),
	m_iMINOR_CIV_FOOD_REQUIREMENT(2),
	m_iMAJOR_CIV_FOOD_REQUIREMENT(3),
	m_iMIN_START_FOUND_VALUE_AS_PERCENT_OF_BEST(50),
	m_iSTART_AREA_FOOD_MULTIPLIER(6),
	m_iSTART_AREA_HAPPINESS_MULTIPLIER(12),
	m_iSTART_AREA_PRODUCTION_MULTIPLIER(8),
	m_iSTART_AREA_GOLD_MULTIPLIER(2),
	m_iSTART_AREA_SCIENCE_MULTIPLIER(1),
	m_iSTART_AREA_FAITH_MULTIPLIER(1),
	m_iSTART_AREA_RESOURCE_MULTIPLIER(1),
	m_iSTART_AREA_STRATEGIC_MULTIPLIER(1),
	m_iSTART_AREA_BUILD_ON_COAST_PERCENT(20),
	m_iSETTLER_FOOD_MULTIPLIER(15),
	m_iSETTLER_HAPPINESS_MULTIPLIER(6),
	m_iSETTLER_PRODUCTION_MULTIPLIER(3),
	m_iSETTLER_GOLD_MULTIPLIER(2),
	m_iSETTLER_SCIENCE_MULTIPLIER(1),
	m_iSETTLER_FAITH_MULTIPLIER(1),
	m_iSETTLER_RESOURCE_MULTIPLIER(1),
	m_iSETTLER_STRATEGIC_MULTIPLIER(1),
	m_iSETTLER_BUILD_ON_COAST_PERCENT(10),
	m_iCITY_RING_1_MULTIPLIER(12),
	m_iCITY_RING_2_MULTIPLIER(8),
	m_iCITY_RING_3_MULTIPLIER(6),
	m_iCITY_RING_4_MULTIPLIER(1),
	m_iCITY_RING_5_MULTIPLIER(1),
	m_iSETTLER_EVALUATION_DISTANCE(40),
	m_iSETTLER_DISTANCE_DROPOFF_MODIFIER(85),
	m_iBUILD_ON_RESOURCE_PERCENT(-50),
	m_iBUILD_ON_RIVER_PERCENT(15),
	m_iCHOKEPOINT_STRATEGIC_VALUE(5),
	m_iHILL_STRATEGIC_VALUE(3),
	m_iALREADY_OWNED_STRATEGIC_VALUE(-1000),
	m_iMINOR_CIV_CONTACT_GOLD_FIRST(30),
	m_iMINOR_CIV_CONTACT_GOLD_OTHER(15),
	m_iMINOR_CIV_GROWTH_PERCENT(150),
	m_iMINOR_CIV_PRODUCTION_PERCENT(150),
	m_iMINOR_CIV_GOLD_PERCENT(200),
	m_iMINOR_CIV_TECH_PERCENT(40),
	m_iMINOR_POLICY_RESOURCE_MULTIPLIER(200),
	m_iMINOR_POLICY_RESOURCE_HAPPINESS_MULTIPLIER(150),
	m_iMINOR_GOLD_GIFT_LARGE(1000),
	m_iMINOR_GOLD_GIFT_MEDIUM(500),
	m_iMINOR_GOLD_GIFT_SMALL(250),
	m_iMINOR_CIV_TILE_IMPROVEMENT_GIFT_COST(200),
	m_iMINOR_CIV_BUYOUT_COST(500),
	m_iMINOR_CIV_BUYOUT_TURNS(5),
	m_iMINOR_FRIENDSHIP_FROM_TRADE_MISSION(30),
	m_iPLOT_UNIT_LIMIT(1),
	m_iZONE_OF_CONTROL_ENABLED(1),
	m_iFIRE_SUPPORT_DISABLED(1),
	m_iMAX_HIT_POINTS(10),
	m_iMAX_CITY_HIT_POINTS(200),
	m_iCITY_HIT_POINTS_HEALED_PER_TURN(1),
	m_iFLAT_LAND_EXTRA_DEFENSE(-33),
	m_iHILLS_EXTRA_DEFENSE(25),
	m_iRIVER_ATTACK_MODIFIER(-20),
	m_iAMPHIB_ATTACK_MODIFIER(-50),
	m_iENEMY_HEAL_RATE(10),
	m_iNEUTRAL_HEAL_RATE(10),
	m_iFRIENDLY_HEAL_RATE(15),
	m_iINSTA_HEAL_RATE(50),
	m_iCITY_HEAL_RATE(15),
	m_iATTACK_SAME_STRENGTH_MIN_DAMAGE(400),
	m_iRANGE_ATTACK_RANGED_DEFENDER_MOD(125),
	m_iATTACK_SAME_STRENGTH_POSSIBLE_EXTRA_DAMAGE(400),
	m_iRANGE_ATTACK_SAME_STRENGTH_MIN_DAMAGE(250),
	m_iRANGE_ATTACK_SAME_STRENGTH_POSSIBLE_EXTRA_DAMAGE(300),
	m_iAIR_STRIKE_SAME_STRENGTH_MIN_DEFENSE_DAMAGE(200),
	m_iAIR_STRIKE_SAME_STRENGTH_POSSIBLE_EXTRA_DEFENSE_DAMAGE(200),
	m_iINTERCEPTION_SAME_STRENGTH_MIN_DAMAGE(400),
	m_iINTERCEPTION_SAME_STRENGTH_POSSIBLE_EXTRA_DAMAGE(300),
	m_iAIR_SWEEP_INTERCEPTION_DAMAGE_MOD(75),
	m_iWOUNDED_DAMAGE_MULTIPLIER(50),
	m_iTRAIT_WOUNDED_DAMAGE_MOD(-50),
	m_iCITY_STRENGTH_DEFAULT(400),
	m_iCITY_STRENGTH_POPULATION_CHANGE(25),
	m_iCITY_STRENGTH_UNIT_DIVISOR(300),
	m_iCITY_STRENGTH_HILL_CHANGE(3),
	m_iCITY_ATTACKING_DAMAGE_MOD(50),
	m_iATTACKING_CITY_MELEE_DAMAGE_MOD(100),
	m_iCITY_ATTACK_RANGE(2),
	m_iCAN_CITY_USE_INDIRECT_FIRE(1),
	m_iCITY_RANGED_ATTACK_STRENGTH_MULTIPLIER(40),
	m_iMIN_CITY_STRIKE_DAMAGE(1),
	m_iCITY_CAPTURE_DAMAGE_PERCENT(50),
	m_iEXPERIENCE_PER_LEVEL(10),
	m_iEXPERIENCE_ATTACKING_UNIT_MELEE(5),
	m_iEXPERIENCE_DEFENDING_UNIT_MELEE(4),
	m_iEXPERIENCE_ATTACKING_UNIT_AIR(4),
	m_iEXPERIENCE_DEFENDING_UNIT_AIR(2),
	m_iEXPERIENCE_ATTACKING_UNIT_RANGED(2),
	m_iEXPERIENCE_DEFENDING_UNIT_RANGED(2),
	m_iEXPERIENCE_ATTACKING_AIR_SWEEP(5),
	m_iEXPERIENCE_DEFENDING_AIR_SWEEP_AIR(5),
	m_iEXPERIENCE_DEFENDING_AIR_SWEEP_GROUND(2),
	m_iEXPERIENCE_ATTACKING_CITY_MELEE(5),
	m_iEXPERIENCE_ATTACKING_CITY_RANGED(3),
	m_iEXPERIENCE_ATTACKING_CITY_AIR(4),
	m_iBARBARIAN_MAX_XP_VALUE(30),
	m_iCOMBAT_EXPERIENCE_IN_BORDERS_PERCENT(100),
	m_iGREAT_GENERALS_THRESHOLD_INCREASE(50),
	m_iGREAT_GENERALS_THRESHOLD_INCREASE_TEAM(50),
	m_iGREAT_GENERALS_THRESHOLD(200),
	m_iUNIT_DEATH_XP_GREAT_GENERAL_LOSS(50),
	m_iMIN_EXPERIENCE_PER_COMBAT(1),
	m_iMAX_EXPERIENCE_PER_COMBAT(10),
	m_iCRAMPED_RANGE_FROM_CITY(5),
	m_iCRAMPED_USABLE_PLOT_PERCENT(25),
	m_iPROXIMITY_NEIGHBORS_CLOSEST_CITY_REQUIREMENT(7),
	m_iPROXIMITY_CLOSE_CLOSEST_CITY_POSSIBILITY(11),
	m_iPROXIMITY_CLOSE_DISTANCE_MAP_MULTIPLIER(25),
	m_iPROXIMITY_CLOSE_DISTANCE_MAX(20),
	m_iPROXIMITY_CLOSE_DISTANCE_MIN(10),
	m_iPROXIMITY_FAR_DISTANCE_MAP_MULTIPLIER(45),
	m_iPROXIMITY_FAR_DISTANCE_MAX(50),
	m_iPROXIMITY_FAR_DISTANCE_MIN(20),
	m_iPLOT_BASE_COST(50),
	m_iPLOT_ADDITIONAL_COST_PER_PLOT(5),
	m_iPLOT_COST_APPEARANCE_DIVISOR(5),
	m_iCULTURE_COST_FIRST_PLOT(20),
	m_iCULTURE_COST_LATER_PLOT_MULTIPLIER(10),
	m_iCULTURE_COST_VISIBLE_DIVISOR(5),
	m_iCULTURE_PLOT_COST_MOD_MINIMUM(-85),
	m_iMINOR_CIV_PLOT_CULTURE_COST_MULTIPLIER(150),
	m_iMAXIMUM_BUY_PLOT_DISTANCE(3),
	m_iMAXIMUM_ACQUIRE_PLOT_DISTANCE(5),
	m_iPLOT_INFLUENCE_BASE_MULTIPLIER(100),
	m_iPLOT_INFLUENCE_DISTANCE_MULTIPLIER(100),
	m_iPLOT_INFLUENCE_DISTANCE_DIVISOR(3),
	m_iPLOT_INFLUENCE_RING_COST(100),
	m_iPLOT_INFLUENCE_WATER_COST(25),
	m_iPLOT_INFLUENCE_IMPROVEMENT_COST(-5),
	m_iPLOT_INFLUENCE_ROUTE_COST(0),
	m_iPLOT_INFLUENCE_RESOURCE_COST(-105),
	m_iPLOT_INFLUENCE_NW_COST(-105),
	m_iPLOT_BUY_RESOURCE_COST(-100),
	m_iPLOT_BUY_YIELD_COST(10),
	m_iPLOT_INFLUENCE_YIELD_POINT_COST(-1),
	m_iPLOT_INFLUENCE_NO_ADJACENT_OWNED_COST(1000),
	m_iUNITED_NATIONS_COUNTDOWN_TURNS(10),
	m_iOWN_UNITED_NATIONS_VOTE_BONUS(1),
	m_iDIPLO_VICTORY_ALGORITHM_THRESHOLD(28),
	m_iDIPLO_VICTORY_BEYOND_ALGORITHM_MULTIPLIER(35),
	m_iDIPLO_VICTORY_DEFAULT_VOTE_PERCENT(67),
	m_iSCORE_CITY_MULTIPLIER(10),
	m_iSCORE_POPULATION_MULTIPLIER(3),
	m_iSCORE_LAND_MULTIPLIER(1),
	m_iSCORE_WONDER_MULTIPLIER(40),
	m_iSCORE_TECH_MULTIPLIER(4),
	m_iSCORE_FUTURE_TECH_MULTIPLIER(10),
	m_iVICTORY_POINTS_PER_ERA(1),
	m_iMIN_GAME_TURNS_ELAPSED_TO_TEST_VICTORY(10),
	m_iZERO_SUM_COMPETITION_WONDERS_VICTORY_POINTS(5),
	m_iZERO_SUM_COMPETITION_POLICIES_VICTORY_POINTS(5),
	m_iZERO_SUM_COMPETITION_GREAT_PEOPLE_VICTORY_POINTS(5),
	m_iMAX_CITY_DIST_HIGHWATER_MARK(3),
	m_iHEAVY_RESOURCE_THRESHOLD(3),
	m_iPROGRESS_POPUP_TURN_FREQUENCY(25),
	m_iSETTLER_PRODUCTION_SPEED(0),
	m_iBUY_PLOTS_DISABLED(0),
	m_iCITY_STRENGTH_TECH_MULTIPLIER(2),
	m_iWARLORD_EXTRA_EXPERIENCE_PER_UNIT_PERCENT(0),
	m_iBUILDING_SALE_DIVISOR(10),
	m_iDISBAND_UNIT_REFUND_PERCENT(10),
	m_iMINOR_CIV_ROUTE_QUEST_WEIGHT(0),
	m_iWITHDRAW_MOD_ENEMY_MOVES(0),
	m_iWITHDRAW_MOD_BLOCKED_TILE(0),
	m_iAI_OPERATIONAL_MAX_RECRUIT_TURNS_DEFAULT(5),
	m_iAI_OPERATIONAL_MAX_RECRUIT_TURNS_ENEMY_TERRITORY(10),

// -- floats --

	m_fAI_PRODUCTION_WEIGHT_MOD_PER_TURN_LEFT(0.015f),
	m_fAI_PRODUCTION_WEIGHT_BASE_MOD(0.15f),
	m_fAI_RESEARCH_WEIGHT_MOD_PER_TURN_LEFT(0.015f),
	m_fAI_RESEARCH_WEIGHT_BASE_MOD(0.15f),
	m_fHURRY_GOLD_PRODUCTION_EXPONENT(0.95f),
	m_fCITY_ZOOM_LEVEL_1(500.0f),
	m_fCITY_ZOOM_LEVEL_2(700.0f),
	m_fCITY_ZOOM_LEVEL_3(800.0f),
	m_fCITY_ZOOM_OFFSET(20.0f),
	m_fCULTURE_COST_LATER_PLOT_EXPONENT(1.1f),
	m_fPOST_COMBAT_TEXT_DELAY(1.0f),
	m_fAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_NEXT_WONDER(0.2f),
	m_fAI_DANGER_MAJOR_APPROACH_WAR(1.0f),
	m_fAI_DANGER_MAJOR_APPROACH_HOSTILE(0.2f),
	m_fAI_DANGER_MAJOR_APPROACH_DECEPTIVE(0.1f),
	m_fAI_DANGER_MAJOR_APPROACH_GUARDED(0.5f),
	m_fAI_DANGER_MAJOR_APPROACH_AFRAID(0.9f),
	m_fAI_DANGER_MAJOR_APPROACH_FRIENDLY(0.0f),
	m_fAI_DANGER_MAJOR_APPROACH_NEUTRAL(0.1f),
	m_fAI_DANGER_MINOR_APPROACH_NEUTRAL(0.1f),
	m_fAI_DANGER_MINOR_APPROACH_FRIENDLY(0.0f),
	m_fAI_DANGER_MINOR_APPROACH_BULLY(0.9f),
	m_fAI_DANGER_MINOR_APPROACH_CONQUEST(1.0f),
	m_fFLAVOR_STANDARD_LOG10_TILES_PER_PLAYER(2.1f),
	m_fDIPLO_VICTORY_TEAM_MULTIPLIER(1.1f),
	m_fAI_TACTICAL_FLAVOR_DAMPENING_FOR_MOVE_PRIORITIZATION(0.3f),
	m_fAI_STRATEGY_DEFEND_MY_LANDS_UNITS_PER_CITY(1.0f),
	m_fAI_STRATEGY_NAVAL_UNITS_PER_CITY(0.67f),
	m_fGOLD_GIFT_FRIENDSHIP_EXPONENT(1.01f),
	m_fGOLD_GIFT_FRIENDSHIP_DIVISOR(6.3f),
	m_fHURRY_GOLD_TECH_EXPONENT(1.10f),
	m_fHURRY_GOLD_CULTURE_EXPONENT(1.10f),
	m_fCITY_GROWTH_MULTIPLIER(6.0f),
	m_fCITY_GROWTH_EXPONENT(1.8f),
	m_fPOLICY_COST_EXPONENT(1.70f),
	m_fUNIT_UPGRADE_COST_MULTIPLIER_PER_ERA(0.0f),
	m_fUNIT_UPGRADE_COST_EXPONENT(1.0f),
	m_fCITY_STRENGTH_TECH_BASE(5.0f),
	m_fCITY_STRENGTH_TECH_EXPONENT(1.8f),
	m_fESPIONAGE_COUP_NOBODY_BONUS(1.0f),
	m_fESPIONAGE_COUP_MULTIPLY_CONSTANT(1.0f),
	m_fESPIONAGE_COUP_SPY_LEVEL_DELTA_ZERO(1.0f),
	m_fESPIONAGE_COUP_SPY_LEVEL_DELTA_ONE(1.0f),
	m_fESPIONAGE_COUP_SPY_LEVEL_DELTA_TWO(1.0f),
	m_iPILLAGE_HEAL_AMOUNT(25),

// -- post defines --

	m_iLAND_TERRAIN(0),
	m_iDEEP_WATER_TERRAIN(6),
	m_iSHALLOW_WATER_TERRAIN(5),
	m_iRUINS_IMPROVEMENT(0),
	m_iNUKE_FEATURE(6),
	m_iCAPITAL_BUILDINGCLASS(28),
	m_iDEFAULT_SPECIALIST(0),
	m_iSPACE_RACE_TRIGGER_PROJECT(1),
	m_iSPACESHIP_CAPSULE(2),
	m_iSPACESHIP_BOOSTER(5),
	m_iSPACESHIP_STASIS(3),
	m_iSPACESHIP_ENGINE(4),
	m_iMANHATTAN_PROJECT(0),
	m_iINITIAL_CITY_ROUTE_TYPE(0),
	m_iSTANDARD_HANDICAP(1),
	m_iMULTIPLAYER_HANDICAP(3),
	m_iSTANDARD_HANDICAP_QUICK(1),
	m_iSTANDARD_GAMESPEED(2),
	m_iSTANDARD_TURNTIMER(3),
	m_iSTANDARD_CLIMATE(0),
	m_iSTANDARD_WORLD_SIZE(3),
	m_iSTANDARD_SEALEVEL(1),
	m_iSTANDARD_ERA(0),
	m_iLAST_EMBARK_ART_ERA(4),
	m_iLAST_UNIT_ART_ERA(4),
	m_iLAST_BRIDGE_ART_ERA(5),
	m_iSTANDARD_CALENDAR(0),
	m_iBARBARIAN_HANDICAP(1),
	m_iBARBARIAN_CIVILIZATION(19),
	m_iBARBARIAN_LEADER(19),
	m_iMINOR_CIV_HANDICAP(3),
	m_iMINOR_CIVILIZATION(18),
	m_iPROMOTION_EMBARKATION(76),
	m_iPROMOTION_DEFENSIVE_EMBARKATION(77),
	m_iPROMOTION_ALLWATER_EMBARKATION(146),
	m_iPROMOTION_OCEAN_IMPASSABLE_UNTIL_ASTRONOMY(115),
	m_iPROMOTION_OCEAN_IMPASSABLE(116),
	m_iCOMBAT_CAPTURE_HEALTH(50),
	m_iCOMBAT_CAPTURE_MIN_CHANCE(10),
	m_iCOMBAT_CAPTURE_MAX_CHANCE(80),
	m_iCOMBAT_CAPTURE_RATIO_MULTIPLIER(40),
	m_iAI_HANDICAP(1),
	m_iBARBARIAN_CAMP_IMPROVEMENT(1),
	m_iWALLS_BUILDINGCLASS(-1),
	m_iPROMOTION_ONLY_DEFENSIVE(-1),
	m_iPROMOTION_UNWELCOME_EVANGELIST(-1),
	m_iRELIGION_MIN_FAITH_FIRST_PANTHEON(0),
	m_iRELIGION_MIN_FAITH_FIRST_PROPHET(0),
	m_iRELIGION_MIN_FAITH_FIRST_GREAT_PERSON(0),
	m_iRELIGION_GAME_FAITH_DELTA_NEXT_PANTHEON(0),
	m_iRELIGION_FAITH_DELTA_NEXT_PROPHET(0),
	m_iRELIGION_FAITH_DELTA_NEXT_GREAT_PERSON(0),
	m_iRELIGION_BASE_CHANCE_PROPHET_SPAWN(0),
	m_iRELIGION_ATHEISM_PRESSURE_PER_POP(0),
	m_iRELIGION_INITIAL_FOUNDING_CITY_PRESSURE(0),
	m_iRELIGION_PER_TURN_FOUNDING_CITY_PRESSURE(0),
	m_iRELIGION_MISSIONARY_PRESSURE_MULTIPLIER(0),
	m_iRELIGION_ADJACENT_CITY_DISTANCE(0),
	m_iRELIGION_DIPLO_HIT_INITIAL_CONVERT_FRIENDLY_CITY(0),
	m_iRELIGION_DIPLO_HIT_RELIGIOUS_FLIP_FRIENDLY_CITY(0),
	m_iRELIGION_DIPLO_HIT_CONVERT_HOLY_CITY(0),
	m_iRELIGION_DIPLO_HIT_THRESHOLD(0),
	m_iESPIONAGE_GATHERING_INTEL_COST_PERCENT(0),
	m_iESPIONAGE_GATHERING_INTEL_RATE_BY_SPY_RANK_PERCENT(0),
	m_iESPIONAGE_GATHERING_INTEL_RATE_BASE_PERCENT(0),
	m_iESPIONAGE_TURNS_BETWEEN_CITY_STATE_ELECTIONS(0),
	m_iESPIONAGE_INFLUENCE_GAINED_FOR_RIGGED_ELECTION(0),
	m_iESPIONAGE_INFLUENCE_LOST_FOR_RIGGED_ELECTION(0),
	m_iESPIONAGE_SURVEILLANCE_SIGHT_RANGE(0),
	m_iESPIONAGE_COUP_OTHER_PLAYERS_INFLUENCE_DROP(10),

	m_pEconomicAIStrategies(NULL),
	m_pCitySpecializations(NULL),
	m_pTacticalMoves(NULL),
	m_pMilitaryAIStrategies(NULL),
	m_pAIGrandStrategies(NULL),
	m_pPolicies(NULL),
	m_pTechs(NULL),
	m_pBuildings(NULL),
	m_pEmphases(NULL),
	m_pTraits(NULL),
	m_pReligions(NULL),
	m_pBeliefs(NULL),
	m_pGameDatabase(NULL)
{
}

CvGlobals::~CvGlobals()
{
}

//
// allocate
//
void CvGlobals::init()
{
	//
	// These vars are used to initialize the globals.
	//
	int aiPlotDirectionX[NUM_DIRECTION_TYPES] =
	{
		0,	// DIRECTION_NORTHEAST
		1,	// DIRECTION_EAST
		1,	// DIRECTION_SOUTHEAST
		0,	// DIRECTION_SOUTHWEST
		-1,	// DIRECTION_WEST
		-1,	// DIRECTION_NORTHWEST
	};

	int aiPlotDirectionY[NUM_DIRECTION_TYPES] =
	{
		1,	// DIRECTION_NORTHEAST
		0,	// DIRECTION_EAST
		-1,	// DIRECTION_SOUTHEAST
		-1,	// DIRECTION_SOUTHWEST
		0,	// DIRECTION_WEST
		1,	// DIRECTION_NORTHWEST
	};

	// these are now in hex-space coords
	int aiCityPlotX[NUM_CITY_PLOTS] =
	{
		//	0
		0,
		//	1	2	3	4	5	6
		0,  1,  1,  0, -1, -1,
		//	7	8	9	10	11	12	13	14	15	16	17	18
		0,  1,  2,  2,  2,  1,  0,  -1, -2, -2, -2, -1,
		//	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36
		0,  1,  2,  3,  3,  3,  3,  2,  1,  0,  -1, -2, -3, -3, -3, -3, -2, -1,
		//	37	38	39	40	41	42	43	44	45	46	47	48	49	50	51	52	53	54	55	56	57	58	59	60
		//	0,  1,  2,  3,  4,  4,  4,  4,  4,  3,  2,  1,  0,  -1,  -2, -3, -4, -4, -4, -4, -4, -3, -2, -1,
	};

	int aiCityPlotY[NUM_CITY_PLOTS] =
	{
		//	0
		0,
		//	1	2	3	4	5	6
		1,  0, -1, -1,  0,  1,
		//	7	8	9	10	11	12	13	14	15	16	17	18
		2,  1,  0, -1,	-2, -2, -2, -1,  0,  1,  2,  2,
		//	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36
		3,  2,  1,  0,  -1, -2, -3, -3, -3, -3, -2, -1,  0,  1,  2,  3,  3,  3,
		//	37	38	39	40	41	42	43	44	45	46	47	48	49	50	51	52	53	54	55	56	57	58	59	60
		//	4,  3,  2,  1,  0, -1, -2, -3, -4, -4, -4, -4, -4, -3, -2, -1,  0,  1,  2,  3,  4,  4,  4,  4,
	};

	int aiCityPlotPriority[NUM_CITY_PLOTS] =
	{
		0,
		1,  1,  1,  1,  1,  1,
		2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
		3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
		//4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
	};

	int aaiXYCityPlot[CITY_PLOTS_DIAMETER][CITY_PLOTS_DIAMETER] =
	{
		// this is the 4 ring layout
		/*
		//	 -4  -3  -2  -1   0   1   2   3  4  -- in the Y direction
		{-1, -1, -1, -1, 53, 54, 55, 56, 57,}, // -4 hex-space x
		{-1, -1, -1, 52, 31, 32, 33, 34, 58,}, // -3 hex-space x
		{-1, -1, 51, 30, 15, 16, 17, 35, 59,}, // -2 hex-space x
		{-1, 50, 29, 14,  5,  6, 18, 36, 60,}, // -1 hex-space x
		{49, 28, 13,  4,  0,  1,  7, 19, 37,}, //  0 hex-space x
		{48, 27, 12,  3,  2,  8, 20, 38, -1,}, //  1 hex-space x
		{47, 26, 11, 10,  9, 21, 39, -1, -1,}, //  2 hex-space x
		{46, 25, 24, 23, 22, 40, -1, -1, -1,}, //  3 hex-space x
		{45, 44, 43, 42, 41, -1, -1, -1, -1,}, //  4 hex-space x
		*/
		// this is the 3 ring layout
		//	 -3  -2  -1   0   1   2   3    -- in the Y direction
		{-1, -1, -1, 31, 32, 33, 34,}, // -3 hex-space x
		{-1, -1, 30, 15, 16, 17, 35,}, // -2 hex-space x
		{-1, 29, 14,  5,  6, 18, 36,}, // -1 hex-space x
		{28, 13,  4,  0,  1,  7, 19,}, //  0 hex-space x
		{27, 12,  3,  2,  8, 20, -1,}, //  1 hex-space x
		{26, 11, 10,  9, 21, -1, -1,}, //  2 hex-space x
		{25, 24, 23, 22, -1, -1, -1,}, //  3 hex-space x
		/*
		// this is the 2 ring layout
		//	-2   -1   0   1   2      -- in the Y direction
		{-1, -1, 16, 17, 18,}, // -2 hex-space x
		{-1, 15,  5,  6,  7,}, // -1 hex-space x
		{14,  4,  0,  1,  8,}, //  0 hex-space x
		{13,  3,  2,  9, -1,}, //  1 hex-space x
		{12, 11, 10, -1, -1,}, //  2 hex-space x
		*/
	};

	DirectionTypes aeTurnRightDirection[NUM_DIRECTION_TYPES] =
	{
		DIRECTION_EAST,			// DIRECTION_NORTHEAST or DIRECTION_NORTH (deprecated)
		DIRECTION_SOUTHEAST,	// DIRECTION_EAST
		DIRECTION_SOUTHWEST,	// DIRECTION_SOUTHEAST
		DIRECTION_WEST,			// DIRECTION_SOUTHWEST or DIRECTION_SOUTH (deprecated)
		DIRECTION_NORTHWEST,	// DIRECTION_WEST
		DIRECTION_NORTHEAST,	// DIRECTION_NORTHWEST
	};

	DirectionTypes aeTurnLeftDirection[NUM_DIRECTION_TYPES] =
	{
		DIRECTION_NORTHWEST,	// DIRECTION_NORTHEAST or DIRECTION_NORTH (deprecated)
		DIRECTION_NORTHEAST,	// DIRECTION_EAST
		DIRECTION_EAST,			// DIRECTION_SOUTHEAST
		DIRECTION_SOUTHEAST,	// DIRECTION_SOUTHWEST or DIRECTION_SOUTH (deprecated)
		DIRECTION_SOUTHWEST,	// DIRECTION_WEST
		DIRECTION_WEST,			// DIRECTION_NORTHWEST
	};

	CvAssertMsg(gDLL != NULL, "Civ app needs to set gDLL");
	m_asyncRand = FNEW(CvRandom, c_eCiv5GameplayDLL, 0);

	gDLL->InitGlobals();	// some globals need to be allocated outside the dll

	m_game = FNEW(CvGame, c_eCiv5GameplayDLL, 0);
	m_map = FNEW(CvMap, c_eCiv5GameplayDLL, 0);

	m_pEconomicAIStrategies = FNEW(CvEconomicAIStrategyXMLEntries, c_eCiv5GameplayDLL, 0);
	m_pCitySpecializations = FNEW(CvCitySpecializationXMLEntries, c_eCiv5GameplayDLL, 0);
	m_pTacticalMoves = FNEW(CvTacticalMoveXMLEntries, c_eCiv5GameplayDLL, 0);
	m_pMilitaryAIStrategies = FNEW(CvMilitaryAIStrategyXMLEntries, c_eCiv5GameplayDLL, 0);
	m_pAIGrandStrategies = FNEW(CvAIGrandStrategyXMLEntries, c_eCiv5GameplayDLL, 0);
	m_pAICityStrategies = FNEW(CvAICityStrategies, c_eCiv5GameplayDLL, 0);
	m_pPolicies = FNEW(CvPolicyXMLEntries, c_eCiv5GameplayDLL, 0);
	m_pTechs = FNEW(CvTechXMLEntries, c_eCiv5GameplayDLL, 0);
	m_pBuildings = FNEW(CvBuildingXMLEntries, c_eCiv5GameplayDLL, 0);
	m_pUnits = FNEW(CvUnitXMLEntries, c_eCiv5GameplayDLL, 0);
	m_pProjects = FNEW(CvProjectXMLEntries, c_eCiv5GameplayDLL, 0);
	m_pPromotions = FNEW(CvPromotionXMLEntries, c_eCiv5GameplayDLL, 0);
	m_pImprovements = FNEW(CvImprovementXMLEntries, c_eCiv5GameplayDLL, 0);
	m_pEmphases = FNEW(CvEmphasisXMLEntries, c_eCiv5GameplayDLL, 0);
	m_pTraits = FNEW(CvTraitXMLEntries, c_eCiv5GameplayDLL, 0);
	m_pReligions = FNEW(CvReligionXMLEntries, c_eCiv5GameplayDLL, 0);
	m_pBeliefs = FNEW(CvBeliefXMLEntries, c_eCiv5GameplayDLL, 0);
	m_pNotifications = FNEW(CvNotificationXMLEntries, c_eCiv5GameplayDLL, 0);

	auto_ptr<ICvDLLDatabaseUtility1> pkLoader(getDatabaseLoadUtility());

	Database::Connection* pDB = GetGameDatabase();
	pDB->Execute(m_kGlobalDefinesLookup, "SELECT Value from Defines where Name = ? LIMIT 1");

	pkLoader->PerformDatabasePostProcessing();
	pkLoader->CacheGameDatabaseData();

	CvPlayerAI::initStatics();
	CvTeam::initStatics();

	memcpy(m_aiPlotDirectionX, aiPlotDirectionX, sizeof(m_aiPlotDirectionX));
	memcpy(m_aiPlotDirectionY, aiPlotDirectionY, sizeof(m_aiPlotDirectionY));
	memcpy(m_aiCityPlotX, aiCityPlotX, sizeof(m_aiCityPlotX));
	memcpy(m_aiCityPlotY, aiCityPlotY, sizeof(m_aiCityPlotY));
	memcpy(m_aiCityPlotPriority, aiCityPlotPriority, sizeof(m_aiCityPlotPriority));
	memcpy(m_aeTurnLeftDirection, aeTurnLeftDirection, sizeof(m_aeTurnLeftDirection));
	memcpy(m_aeTurnRightDirection, aeTurnRightDirection, sizeof(m_aeTurnRightDirection));
	memcpy(m_aaiXYCityPlot, aaiXYCityPlot, sizeof(m_aaiXYCityPlot));

	setPathFinder(FNEW(CvTwoLayerPathFinder, c_eCiv5GameplayDLL, 0));
	setInterfacePathFinder(FNEW(CvTwoLayerPathFinder, c_eCiv5GameplayDLL, 0));
	setIgnoreUnitsPathFinder(FNEW(CvIgnoreUnitsPathFinder, c_eCiv5GameplayDLL, 0));
	setStepFinder(FNEW(CvStepPathFinder, c_eCiv5GameplayDLL, 0));
	setRouteFinder(FNEW(CvAStar, c_eCiv5GameplayDLL, 0));
	SetWaterRouteFinder(FNEW(CvAStar, c_eCiv5GameplayDLL, 0));
	setAreaFinder(FNEW(CvAStar, c_eCiv5GameplayDLL, 0));
	setInfluenceFinder(FNEW(CvAStar, c_eCiv5GameplayDLL, 0));
	SetBuildRouteFinder(FNEW(CvAStar, c_eCiv5GameplayDLL, 0));
	SetTacticalAnalysisMapFinder(FNEW(CvTwoLayerPathFinder, c_eCiv5GameplayDLL, 0));
}

//
// free
//
void CvGlobals::uninit()
{
	CvPlayerAI::freeStatics();
	CvTeam::freeStatics();

	SAFE_DELETE(m_pEconomicAIStrategies);
	SAFE_DELETE(m_pCitySpecializations);
	SAFE_DELETE(m_pTacticalMoves);
	SAFE_DELETE(m_pMilitaryAIStrategies);
	SAFE_DELETE(m_pAIGrandStrategies);
	SAFE_DELETE(m_pPolicies);
	SAFE_DELETE(m_pBuildings);
	SAFE_DELETE(m_pUnits);
	SAFE_DELETE(m_pProjects);
	SAFE_DELETE(m_pPromotions);
	SAFE_DELETE(m_pEmphases);
	SAFE_DELETE(m_pTraits);
	SAFE_DELETE(m_pReligions);
	SAFE_DELETE(m_pBeliefs);
	SAFE_DELETE(m_pNotifications);

	SAFE_DELETE(m_pImprovements); // player uses the improvement count in deallocating.
	SAFE_DELETE(m_pTechs);        // improvements uses tech to deallocate. arrghh!

	SAFE_DELETE(m_map);
	SAFE_DELETE(m_game);

	SAFE_DELETE(m_asyncRand);

	m_kGlobalDefinesLookup.Release();

	if(gDLL)
		gDLL->UninitGlobals();	// free globals allocated outside the dll

	SAFE_DELETE(m_pathFinder);
	SAFE_DELETE(m_interfacePathFinder);
	SAFE_DELETE(m_ignoreUnitsPathFinder);
	SAFE_DELETE(m_stepFinder);
	SAFE_DELETE(m_routeFinder);
	SAFE_DELETE(m_waterRouteFinder);
	SAFE_DELETE(m_areaFinder);
	SAFE_DELETE(m_influenceFinder);
	SAFE_DELETE(m_buildRouteFinder);
	SAFE_DELETE(m_tacticalAnalysisMapFinder);

	// already deleted outside of the dll, set to null for safety
	m_pathFinder=NULL;
	m_interfacePathFinder=NULL;
	m_ignoreUnitsPathFinder=NULL;
	m_stepFinder=NULL;
	m_routeFinder=NULL;
	m_waterRouteFinder=NULL;
	m_areaFinder=NULL;
	m_influenceFinder=NULL;
	m_buildRouteFinder = NULL;
	m_tacticalAnalysisMapFinder = NULL;

}

//------------------------------------------------------------------------------
CvCity* CvGlobals::UnwrapCityPointer(ICvCity1* pCity)
{
	return (NULL != pCity)? static_cast<CvDllCity*>(pCity)->GetInstance() : NULL;
}
//------------------------------------------------------------------------------
auto_ptr<ICvCity1> CvGlobals::WrapCityPointer(CvCity* pCity)
{
	return auto_ptr<ICvCity1>((NULL != pCity)? new CvDllCity(pCity) : NULL);
}
//------------------------------------------------------------------------------
CvDeal* CvGlobals::UnwrapDealPointer(ICvDeal1* pDeal)
{
	return (NULL != pDeal)? static_cast<CvDllDeal*>(pDeal)->GetInstance() : NULL;
}
//------------------------------------------------------------------------------
auto_ptr<ICvDeal1> CvGlobals::WrapDealPointer(CvDeal* pDeal)
{
	return auto_ptr<ICvDeal1>((NULL != pDeal)? new CvDllDeal(pDeal) : NULL);
}
//------------------------------------------------------------------------------
CvPlot* CvGlobals::UnwrapPlotPointer(ICvPlot1* pPlot)
{
	return (NULL != pPlot)? static_cast<CvDllPlot*>(pPlot)->GetInstance() : NULL;
}
//------------------------------------------------------------------------------
auto_ptr<ICvPlot1> CvGlobals::WrapPlotPointer(CvPlot* pPlot)
{
	return auto_ptr<ICvPlot1>((NULL != pPlot)? new CvDllPlot(pPlot) : NULL);
}
//------------------------------------------------------------------------------
CvRandom* CvGlobals::UnwrapRandomPointer(ICvRandom1* pRandom)
{
	return (NULL != pRandom)? static_cast<CvDllRandom*>(pRandom)->GetInstance() : NULL;
}
//------------------------------------------------------------------------------
auto_ptr<ICvRandom1> CvGlobals::WrapRandomPointer(CvRandom* pRandom)
{
	return auto_ptr<ICvRandom1>((NULL != pRandom)? new CvDllRandom(pRandom) : NULL);
}
//------------------------------------------------------------------------------
auto_ptr<ICvUnit1> CvGlobals::WrapUnitPointer(CvUnit* pUnit)
{
	return auto_ptr<ICvUnit1>((NULL != pUnit)? new CvDllUnit(pUnit) : NULL);
}
//------------------------------------------------------------------------------
CvUnit* CvGlobals::UnwrapUnitPointer(ICvUnit1* pUnit)
{
	return (NULL != pUnit)? static_cast<CvDllUnit*>(pUnit)->GetInstance() : NULL;
}
//------------------------------------------------------------------------------
CvGlobals& CvGlobals::getInstance()
{
	return gGlobals;
}

CvRandom& CvGlobals::getASyncRand()
{
	return *m_asyncRand;
}

CvTwoLayerPathFinder& CvGlobals::getPathFinder()
{
	return *m_pathFinder;
}

CvTwoLayerPathFinder& CvGlobals::getInterfacePathFinder()
{
	return *m_interfacePathFinder;
}

CvIgnoreUnitsPathFinder& CvGlobals::getIgnoreUnitsPathFinder()
{
	return *m_ignoreUnitsPathFinder;
}

CvStepPathFinder& CvGlobals::getStepFinder()
{
	return *m_stepFinder;
}

CvAStar& CvGlobals::getRouteFinder()
{
	return *m_routeFinder;
}

CvAStar& CvGlobals::GetWaterRouteFinder()
{
	return *m_waterRouteFinder;
}

CvAStar& CvGlobals::getAreaFinder()
{
	return *m_areaFinder;
}

CvAStar& CvGlobals::getInfluenceFinder()
{
	return *m_influenceFinder;
}

CvAStar& CvGlobals::GetBuildRouteFinder()
{
	return *m_buildRouteFinder;
}

CvTwoLayerPathFinder& CvGlobals::GetTacticalAnalysisMapFinder()
{
	return *m_tacticalAnalysisMapFinder;
}

ICvDLLDatabaseUtility1* CvGlobals::getDatabaseLoadUtility()
{
	if(m_pkDatabaseLoadUtility == NULL)
		m_pkDatabaseLoadUtility = new CvDllDatabaseUtility(DB);

	//By using query interface, we implicitly increment the reference count and avoid
	//a new allocation.
	return m_pkDatabaseLoadUtility->QueryInterface<ICvDLLDatabaseUtility1>();
}

std::vector<CvInterfaceModeInfo*>& CvGlobals::getInterfaceModeInfo()
{
	return m_paInterfaceModeInfo;
}

CvInterfaceModeInfo* CvGlobals::getInterfaceModeInfo(InterfaceModeTypes e)
{
	CvAssert(e > -1);
	CvAssert(e < NUM_INTERFACEMODE_TYPES);
	if(e > -1 && e < (int)m_paInterfaceModeInfo.size())
		return m_paInterfaceModeInfo[e];
	else
		return NULL;
}

bool CvGlobals::getLogging()
{
	return m_bLogging;
}

void CvGlobals::setLogging(bool bLoggingEnabled)
{
	m_bLogging = bLoggingEnabled;
}

int CvGlobals::getRandLogging()
{
	return m_iRandLogging;
}

void CvGlobals::setRandLogging(int iRandLoggingFlags)
{
	m_iRandLogging = iRandLoggingFlags;
}

bool CvGlobals::getAILogging()
{
	return m_bAILogging;
}

void CvGlobals::setAILogging(bool bEnable)
{
	m_bAILogging = bEnable;
}

bool CvGlobals::getAIPerfLogging()
{
	return m_bAIPerfLogging;
}

void CvGlobals::setAIPerfLogging(bool bEnable)
{
	m_bAIPerfLogging = bEnable;
}

bool CvGlobals::GetBuilderAILogging()
{
	return m_bBuilderAILogging;
}

void CvGlobals::SetBuilderAILogging(bool bEnable)
{
	m_bBuilderAILogging = bEnable;
}

bool CvGlobals::getPlayerAndCityAILogSplit()
{
	return m_bPlayerAndCityAILogSplit;
}

void CvGlobals::setPlayerAndCityAILogSplit(bool bEnable)
{
	m_bPlayerAndCityAILogSplit = bEnable;
}

bool CvGlobals::GetTutorialLogging()
{
	return m_bTutorialLogging;
}

void CvGlobals::SetTutorialLogging(bool bEnable)
{
	m_bTutorialLogging = bEnable;
}

bool CvGlobals::GetTutorialDebugging()
{
	return m_bTutorialDebugging;
}

void CvGlobals::SetTutorialDebugging(bool bEnable)
{
	m_bTutorialDebugging = bEnable;
}

bool CvGlobals::GetAllowRClickMovementWhileScrolling()
{
	return m_bAllowRClickMovementWhileCameraScrolling;
}

void CvGlobals::SetAllowRClickMovementWhileScrolling(bool bAllow)
{
	m_bAllowRClickMovementWhileCameraScrolling = bAllow;
}

bool CvGlobals::GetPostTurnAutosaves()
{
	return m_bPostTurnAutosaves;
}

void CvGlobals::SetPostTurnAutosaves(bool bEnable)
{
	m_bPostTurnAutosaves = bEnable;
}


int* CvGlobals::getCityPlotPriority()
{
	return m_aiCityPlotPriority;
}

int CvGlobals::getXYCityPlot(int i, int j)
{
	CvAssertMsg(i < CITY_PLOTS_DIAMETER, "Index out of bounds");
	CvAssertMsg(i > -1, "Index out of bounds");
	if(i < 0 || i >= CITY_PLOTS_DIAMETER) return -1;

	CvAssertMsg(j < CITY_PLOTS_DIAMETER, "Index out of bounds");
	CvAssertMsg(j > -1, "Index out of bounds");
	if(j < 0 || j >= CITY_PLOTS_DIAMETER) return -1;

	return m_aaiXYCityPlot[i][j];
}

DirectionTypes* CvGlobals::getTurnLeftDirection()
{
	return m_aeTurnLeftDirection;
}

DirectionTypes CvGlobals::getTurnLeftDirection(int i)
{
	CvAssertMsg(i < NUM_DIRECTION_TYPES, "Index out of bounds");
	CvAssertMsg(i > -1, "Index out of bounds");

	if(i < 0 || i >= NUM_DIRECTION_TYPES) return NO_DIRECTION;

	return m_aeTurnLeftDirection[i];
}

DirectionTypes* CvGlobals::getTurnRightDirection()
{
	return m_aeTurnRightDirection;
}

DirectionTypes CvGlobals::getTurnRightDirection(int i)
{
	CvAssertMsg(i < NUM_DIRECTION_TYPES, "Index out of bounds");
	CvAssertMsg(i > -1, "Index out of bounds");

	if(i < 0 || i >= NUM_DIRECTION_TYPES) return NO_DIRECTION;

	return m_aeTurnRightDirection[i];
}

int CvGlobals::getNumWorldInfos()
{
	return GetGameDatabase()->Count("Worlds");
}

int CvGlobals::getNumClimateInfos()
{
	return GetGameDatabase()->Count("Climates");
}

int CvGlobals::getNumSeaLevelInfos()
{
	return GetGameDatabase()->Count("SeaLevels");
}

int CvGlobals::GetNumColorInfos()
{
	return (int)m_paColorInfo.size();
}

std::vector<CvColorInfo*>& CvGlobals::GetColorInfo()
{
	return m_paColorInfo;
}

CvColorInfo* CvGlobals::GetColorInfo(ColorTypes e)
{
	CvAssert(e > -1);
	CvAssert(e < GetNumColorInfos());
	if(e > -1 && e < (int)m_paColorInfo.size())
		return m_paColorInfo[e];
	else
		return NULL;
}


int CvGlobals::GetNumPlayerColorInfos()
{
	return (int)m_paPlayerColorInfo.size();
}

std::vector<CvPlayerColorInfo*>& CvGlobals::GetPlayerColorInfo()
{
	return m_paPlayerColorInfo;
}

CvPlayerColorInfo* CvGlobals::GetPlayerColorInfo(PlayerColorTypes e)
{
	CvAssert(e > -1);
	CvAssert(e < GetNumPlayerColorInfos());
	if(e > -1 && e < (int)m_paPlayerColorInfo.size())
		return m_paPlayerColorInfo[e];
	else
		return NULL;
}

int CvGlobals::getNumEntityEventInfos()
{
	return (int)m_paEntityEventInfo.size();
}

std::vector<CvEntityEventInfo*>& CvGlobals::getEntityEventInfo()
{
	return m_paEntityEventInfo;
}

CvEntityEventInfo* CvGlobals::getEntityEventInfo(EntityEventTypes e)
{
	CvAssert(e > -1);
	CvAssert(e < GC.getNumEntityEventInfos());
	if(e > -1 && e < (int)m_paEntityEventInfo.size())
		return m_paEntityEventInfo[e];
	else
		return NULL;
}

int CvGlobals::getNumMultiUnitFormationInfos()
{
	return (int)m_paMultiUnitFormationInfo.size();
}

std::vector<CvMultiUnitFormationInfo*>& CvGlobals::getMultiUnitFormationInfo()
{
	return m_paMultiUnitFormationInfo;
}

CvMultiUnitFormationInfo* CvGlobals::getMultiUnitFormationInfo(int i)
{
	CvAssert(i > -1);
	CvAssert(i < GC.getNumMultiUnitFormationInfos());
	if(i > -1 && i < (int)m_paMultiUnitFormationInfo.size())
		return m_paMultiUnitFormationInfo[i];
	else
		return NULL;
}

int CvGlobals::getNumTerrainInfos()
{
	return (int)m_paTerrainInfo.size();
}

std::vector<CvTerrainInfo*>& CvGlobals::getTerrainInfo()
{
	return m_paTerrainInfo;
}

CvTerrainInfo* CvGlobals::getTerrainInfo(TerrainTypes eTerrainNum)
{
	CvAssert(eTerrainNum > -1);
	CvAssert(eTerrainNum < GC.getNumTerrainInfos());
	if(eTerrainNum > -1 && eTerrainNum < (int)m_paTerrainInfo.size())
		return m_paTerrainInfo[eTerrainNum];
	else
		return NULL;
}

int CvGlobals::getNumResourceClassInfos()
{
	return (int)m_paResourceClassInfo.size();
}

std::vector<CvResourceClassInfo*>& CvGlobals::getResourceClassInfo()
{
	return m_paResourceClassInfo;
}

CvResourceClassInfo* CvGlobals::getResourceClassInfo(ResourceClassTypes eResourceNum)
{
	CvAssert(eResourceNum > -1);
	CvAssert(eResourceNum < GC.getNumResourceClassInfos());
	if(eResourceNum > -1 && eResourceNum < (int)m_paResourceClassInfo.size())
		return m_paResourceClassInfo[eResourceNum];
	else
		return NULL;
}


int CvGlobals::getNumResourceInfos()
{
	return (int)m_paResourceInfo.size();
}

std::vector<CvResourceInfo*>& CvGlobals::getResourceInfo()
{
	return m_paResourceInfo;
}

CvResourceInfo* CvGlobals::getResourceInfo(ResourceTypes eResourceNum)
{
	CvAssert(eResourceNum > -1);
	CvAssert(eResourceNum < GC.getNumResourceInfos());
	if(eResourceNum > -1 && eResourceNum < (int)m_paResourceInfo.size())
		return m_paResourceInfo[eResourceNum];
	else
		return NULL;
}

int CvGlobals::getNumFeatureInfos()
{
	return (int)m_paFeatureInfo.size();
}

std::vector<CvFeatureInfo*>& CvGlobals::getFeatureInfo()
{
	return m_paFeatureInfo;
}

CvFeatureInfo* CvGlobals::getFeatureInfo(FeatureTypes eFeatureNum)
{
	CvAssert(eFeatureNum > -1);
	CvAssert(eFeatureNum < GC.getNumFeatureInfos());
	if(eFeatureNum > -1 && eFeatureNum < (int)m_paFeatureInfo.size())
		return m_paFeatureInfo[eFeatureNum];
	else
		return NULL;
}

int& CvGlobals::getNumPlayableCivilizationInfos()
{
	return m_iNumPlayableCivilizationInfos;
}

int& CvGlobals::getNumAIPlayableCivilizationInfos()
{
	return m_iNumAIPlayableCivilizationInfos;
}

int CvGlobals::getNumCivilizationInfos()
{
	return (int)m_paCivilizationInfo.size();
}

std::vector<CvCivilizationInfo*>& CvGlobals::getCivilizationInfo()
{
	return m_paCivilizationInfo;
}

CvCivilizationInfo* CvGlobals::getCivilizationInfo(CivilizationTypes eCivilizationNum)
{
	CvAssert(eCivilizationNum > -1);
	CvAssert(eCivilizationNum < GC.getNumCivilizationInfos());
	if(eCivilizationNum > -1 && eCivilizationNum < (int)m_paCivilizationInfo.size())
		return m_paCivilizationInfo[eCivilizationNum];
	else
		return NULL;
}

CivilizationTypes CvGlobals::getCivilizationInfoIndex(const char* pszType)
{
	CvAssert(pszType != NULL);
	if(pszType != NULL)
	{
		int iIndex = 0;
		for(std::vector<CvCivilizationInfo*>::iterator itr = m_paCivilizationInfo.begin(); itr != m_paCivilizationInfo.end(); ++itr, ++iIndex)
		{
			const char* szType = (*itr)->GetType();
			if(szType && strcmp(szType, pszType) == 0)
				return (CivilizationTypes)iIndex;
		}
	}
	return NO_CIVILIZATION;
}

int CvGlobals::getNumMinorCivInfos()
{
	return (int)m_paMinorCivInfo.size();
}

int CvGlobals::GetNumPlayableMinorCivs() const
{
	int iFound = 0;
	int iCurrentMinorIndex = 0;

	for(; iCurrentMinorIndex < (int)m_paMinorCivInfo.size(); iCurrentMinorIndex++)
	{
		if(m_paMinorCivInfo[iCurrentMinorIndex] != NULL)
		{
			iFound++;
		}
	}

	return iFound;
}

std::vector<CvMinorCivInfo*>& CvGlobals::getMinorCivInfo()
{
	return m_paMinorCivInfo;
}

CvMinorCivInfo* CvGlobals::getMinorCivInfo(MinorCivTypes eMinorCivNum)
{
	CvAssert(eMinorCivNum > -1);
	CvAssert(eMinorCivNum < GC.getNumMinorCivInfos());
	if(eMinorCivNum > -1 && eMinorCivNum < (int)m_paMinorCivInfo.size())
		return m_paMinorCivInfo[eMinorCivNum];
	else
		return NULL;
}

int CvGlobals::getNumLeaderHeadInfos()
{
	return (int)m_paLeaderHeadInfo.size();
}

std::vector<CvLeaderHeadInfo*>& CvGlobals::getLeaderHeadInfo()
{
	return m_paLeaderHeadInfo;
}

CvLeaderHeadInfo* CvGlobals::getLeaderHeadInfo(LeaderHeadTypes eLeaderHeadNum)
{
	CvAssert(eLeaderHeadNum > -1);
	CvAssert(eLeaderHeadNum < GC.getNumLeaderHeadInfos());
	if(eLeaderHeadNum > -1 && eLeaderHeadNum < (int)m_paLeaderHeadInfo.size())
		return m_paLeaderHeadInfo[eLeaderHeadNum];
	else
		return NULL;
}

int CvGlobals::getNumUnitInfos()
{
	return m_pUnits->GetNumUnits();
}

std::vector<CvUnitEntry*>& CvGlobals::getUnitInfo()
{
	return m_pUnits->GetUnitEntries();
}

CvUnitEntry* CvGlobals::getUnitInfo(UnitTypes eUnitNum)
{
	CvAssert(eUnitNum > -1);
	CvAssert(eUnitNum < GC.getNumUnitInfos());
	if(eUnitNum > -1 && eUnitNum < GC.getNumUnitInfos())
		return m_pUnits->GetUnitEntries()[eUnitNum];
	else
		return NULL;
}

CvUnitXMLEntries* CvGlobals::GetGameUnits() const
{
	return m_pUnits;
}

int CvGlobals::getNumSpecialUnitInfos()
{
	return (int)m_paSpecialUnitInfo.size();
}

std::vector<CvSpecialUnitInfo*>& CvGlobals::getSpecialUnitInfo()
{
	return m_paSpecialUnitInfo;
}

CvSpecialUnitInfo* CvGlobals::getSpecialUnitInfo(SpecialUnitTypes eSpecialUnitNum)
{
	CvAssert(eSpecialUnitNum > -1);
	CvAssert(eSpecialUnitNum < GC.getNumSpecialUnitInfos());
	if(eSpecialUnitNum > -1 && eSpecialUnitNum < (int)m_paSpecialUnitInfo.size())
		return m_paSpecialUnitInfo[eSpecialUnitNum];
	else
		return NULL;
}

int CvGlobals::getNumVoteSourceInfos()
{
	return (int)m_paVoteSourceInfo.size();
}

std::vector<CvVoteSourceInfo*>& CvGlobals::getVoteSourceInfo()
{
	return m_paVoteSourceInfo;
}

CvVoteSourceInfo* CvGlobals::getVoteSourceInfo(VoteSourceTypes e)
{
	CvAssert(e > -1);
	CvAssert(e < GC.getNumVoteSourceInfos());
	if(e > -1 && e < (int)m_paVoteSourceInfo.size())
		return m_paVoteSourceInfo[e];
	else
		return NULL;
}

int CvGlobals::getNumUnitCombatClassInfos()
{
	return (int)m_paUnitCombatClassInfo.size();
}

std::vector<CvBaseInfo*>& CvGlobals::getUnitCombatClassInfo()
{
	return m_paUnitCombatClassInfo;
}

CvBaseInfo* CvGlobals::getUnitCombatClassInfo(UnitCombatTypes e)
{
	CvAssert(e > -1);
	CvAssert(e < GC.getNumUnitCombatClassInfos());
	if(e > -1 && e < (int)m_paUnitCombatClassInfo.size())
		return m_paUnitCombatClassInfo[e];
	else
		return NULL;
}

std::vector<CvBaseInfo*>& CvGlobals::getUnitAIInfo()
{
	return m_paUnitAIInfos;
}

CvBaseInfo* CvGlobals::getUnitAIInfo(UnitAITypes eUnitAINum)
{
	CvAssert(eUnitAINum >= 0);
	CvAssert(eUnitAINum < NUM_UNITAI_TYPES);
	if(eUnitAINum > -1 && eUnitAINum < (int)m_paUnitAIInfos.size())
		return m_paUnitAIInfos[eUnitAINum];
	else
		return NULL;
}

int CvGlobals::getNumGameOptionInfos()
{
	return (int)m_paGameOptionInfos.size();
}

std::vector<CvGameOptionInfo*>& CvGlobals::getGameOptionInfo()
{
	return m_paGameOptionInfos;
}

CvGameOptionInfo* CvGlobals::getGameOptionInfo(GameOptionTypes eGameOptionNum)
{
	CvAssert(eGameOptionNum >= 0);
	CvAssert(eGameOptionNum < GC.getNumGameOptionInfos());
	if(eGameOptionNum > -1 && eGameOptionNum < (int)m_paGameOptionInfos.size())
		return m_paGameOptionInfos[eGameOptionNum];
	else
		return NULL;
}

int CvGlobals::getNumMPOptionInfos()
{
	return (int)m_paMPOptionInfos.size();
}

std::vector<CvMPOptionInfo*>& CvGlobals::getMPOptionInfo()
{
	return m_paMPOptionInfos;
}

CvMPOptionInfo* CvGlobals::getMPOptionInfo(MultiplayerOptionTypes eMPOptionNum)
{
	CvAssert(eMPOptionNum >= 0);
	CvAssert(eMPOptionNum < GC.getNumMPOptionInfos());
	if(eMPOptionNum > -1 && eMPOptionNum < (int)m_paMPOptionInfos.size())
		return m_paMPOptionInfos[eMPOptionNum];
	else
		return NULL;
}

std::vector<CvPlayerOptionInfo*>& CvGlobals::getPlayerOptionInfo()
{
	return m_paPlayerOptionInfos;
}

CvPlayerOptionInfo* CvGlobals::getPlayerOptionInfo(PlayerOptionTypes ePlayerOptionNum)
{
	CvAssert(ePlayerOptionNum >= 0);
	if(ePlayerOptionNum > -1 && ePlayerOptionNum < (int)m_paPlayerOptionInfos.size())
		return m_paPlayerOptionInfos[ePlayerOptionNum];
	else
		return NULL;
}

std::vector<CvYieldInfo*>& CvGlobals::getYieldInfo()
{
	return m_paYieldInfo;
}

CvYieldInfo* CvGlobals::getYieldInfo(YieldTypes eYieldNum)
{
	CvAssert(eYieldNum > -1);
	CvAssert(eYieldNum < NUM_YIELD_TYPES);
	if(eYieldNum > -1 && eYieldNum < (int)m_paYieldInfo.size())
		return m_paYieldInfo[eYieldNum];
	else
		return NULL;
}

int CvGlobals::getNumRouteInfos()
{
	return (int)m_paRouteInfo.size();
}

std::vector<CvRouteInfo*>& CvGlobals::getRouteInfo()
{
	return m_paRouteInfo;
}

CvRouteInfo* CvGlobals::getRouteInfo(RouteTypes eRouteNum)
{
	CvAssert(eRouteNum > -1);
	CvAssert(eRouteNum < GC.getNumRouteInfos());
	if(eRouteNum > -1 && eRouteNum < (int)m_paRouteInfo.size())
		return m_paRouteInfo[eRouteNum];
	else
		return NULL;
}

int CvGlobals::getNumImprovementInfos()
{
	return m_pImprovements->GetNumImprovements();
}

std::vector<CvImprovementEntry*>& CvGlobals::getImprovementInfo()
{
	return m_pImprovements->GetImprovementEntries();
}

CvImprovementEntry* CvGlobals::getImprovementInfo(ImprovementTypes eImprovementNum)
{
	CvAssert(eImprovementNum > -1);
	CvAssert(eImprovementNum < GC.getNumImprovementInfos());
	if(eImprovementNum > -1 && eImprovementNum < GC.getNumImprovementInfos())
		return m_pImprovements->GetImprovementEntries()[eImprovementNum];
	else
		return NULL;
}

CvImprovementXMLEntries* CvGlobals::GetGameImprovements() const
{
	return m_pImprovements;
}

int CvGlobals::getNumBuildInfos()
{
	return (int)m_paBuildInfo.size();
}

std::vector<CvBuildInfo*>& CvGlobals::getBuildInfo()
{
	return m_paBuildInfo;
}

CvBuildInfo* CvGlobals::getBuildInfo(BuildTypes eBuildNum)
{
	CvAssert(eBuildNum > -1);
	CvAssert(eBuildNum < GC.getNumBuildInfos());
	if(eBuildNum > -1 && eBuildNum < (int)m_paBuildInfo.size())
		return m_paBuildInfo[eBuildNum];
	else
		return NULL;
}

int CvGlobals::getNumHandicapInfos()
{
	return (int)m_paHandicapInfo.size();
}

std::vector<CvHandicapInfo*>& CvGlobals::getHandicapInfo()
{
	return m_paHandicapInfo;
}

CvHandicapInfo* CvGlobals::getHandicapInfo(HandicapTypes eHandicapNum)
{
	CvAssert(eHandicapNum > -1);
	CvAssert(eHandicapNum < GC.getNumHandicapInfos());
	if(eHandicapNum > -1 && eHandicapNum < (int)m_paHandicapInfo.size())
		return m_paHandicapInfo[eHandicapNum];
	else
		return NULL;
}

int CvGlobals::getNumGameSpeedInfos()
{
	return (int)m_paGameSpeedInfo.size();
}

std::vector<CvGameSpeedInfo*>& CvGlobals::getGameSpeedInfo()
{
	return m_paGameSpeedInfo;
}

CvGameSpeedInfo* CvGlobals::getGameSpeedInfo(GameSpeedTypes eGameSpeedNum)
{
	CvAssert(eGameSpeedNum > -1);
	CvAssert(eGameSpeedNum < GC.getNumGameSpeedInfos());
	if(eGameSpeedNum > -1 && eGameSpeedNum < (int)m_paGameSpeedInfo.size())
		return m_paGameSpeedInfo[eGameSpeedNum];
	else
		return NULL;
}

int CvGlobals::getNumProcessInfos()
{
	return (int)m_paProcessInfo.size();
}

std::vector<CvProcessInfo*>& CvGlobals::getProcessInfo()
{
	return m_paProcessInfo;
}

CvProcessInfo* CvGlobals::getProcessInfo(ProcessTypes e)
{
	CvAssert(e > -1);
	CvAssert(e < GC.getNumProcessInfos());
	if(e > -1 && e < (int)m_paProcessInfo.size())
		return m_paProcessInfo[e];
	else
		return NULL;
}

int CvGlobals::getNumVoteInfos()
{
	return (int)m_paVoteInfo.size();
}

std::vector<CvVoteInfo*>& CvGlobals::getVoteInfo()
{
	return m_paVoteInfo;
}

CvVoteInfo* CvGlobals::getVoteInfo(VoteTypes e)
{
	CvAssert(e > -1);
	CvAssert(e < GC.getNumVoteInfos());
	if(e > -1 && e < (int)m_paVoteInfo.size())
		return m_paVoteInfo[e];
	else
		return NULL;
}

int CvGlobals::getNumProjectInfos()
{
	return m_pProjects->GetNumProjects();
}

std::vector<CvProjectEntry*>& CvGlobals::getProjectInfo()
{
	return m_pProjects->GetProjectEntries();
}

CvProjectEntry* CvGlobals::getProjectInfo(ProjectTypes e)
{
	CvAssert(e > -1);
	CvAssert(e < GC.getNumProjectInfos());
	if(e > -1 && e < GC.getNumProjectInfos())
		return m_pProjects->GetProjectEntries()[e];
	else
		return NULL;
}

CvProjectXMLEntries* CvGlobals::GetGameProjects() const
{
	return m_pProjects;
}

int CvGlobals::getNumBuildingClassInfos()
{
	return (int)m_paBuildingClassInfo.size();
}

std::vector<CvBuildingClassInfo*>& CvGlobals::getBuildingClassInfo()
{
	return m_paBuildingClassInfo;
}

CvBuildingClassInfo* CvGlobals::getBuildingClassInfo(BuildingClassTypes eBuildingClassNum)
{
	CvAssert(eBuildingClassNum > -1);
	CvAssert(eBuildingClassNum < GC.getNumBuildingClassInfos());
	if(eBuildingClassNum > -1 && eBuildingClassNum < (int)m_paBuildingClassInfo.size())
		return m_paBuildingClassInfo[eBuildingClassNum];
	else
		return NULL;
}

int CvGlobals::getNumBuildingInfos()
{
	return m_pBuildings->GetNumBuildings();
}

std::vector<CvBuildingEntry*>& CvGlobals::getBuildingInfo()
{
	return m_pBuildings->GetBuildingEntries();
}

CvBuildingEntry* CvGlobals::getBuildingInfo(BuildingTypes eBuildingNum)
{
	CvAssert(eBuildingNum > -1);
	CvAssert(eBuildingNum < GC.getNumBuildingInfos());
	if(eBuildingNum > -1 && eBuildingNum < GC.getNumBuildingInfos())
		return m_pBuildings->GetBuildingEntries()[eBuildingNum];
	else
		return NULL;
}

CvBuildingXMLEntries* CvGlobals::GetGameBuildings() const
{
	return m_pBuildings;
}

int CvGlobals::getNumUnitClassInfos()
{
	return (int)m_paUnitClassInfo.size();
}

std::vector<CvUnitClassInfo*>& CvGlobals::getUnitClassInfo()
{
	return m_paUnitClassInfo;
}

CvUnitClassInfo* CvGlobals::getUnitClassInfo(UnitClassTypes eUnitClassNum)
{
	CvAssert(eUnitClassNum > -1);
	CvAssert(eUnitClassNum < GC.getNumUnitClassInfos());
	if(eUnitClassNum > -1 && eUnitClassNum < (int)m_paUnitClassInfo.size())
		return m_paUnitClassInfo[eUnitClassNum];
	else
		return NULL;
}

int CvGlobals::getNumActionInfos()
{
	return (int)m_paActionInfo.size();
}

std::vector<CvActionInfo*>& CvGlobals::getActionInfo()
{
	return m_paActionInfo;
}

CvActionInfo* CvGlobals::getActionInfo(int i)
{
	CvAssertMsg(i < getNumActionInfos(), "Index out of bounds");
	CvAssertMsg(i > -1, "Index out of bounds");
	if(i > -1 && i < (int)m_paActionInfo.size())
		return m_paActionInfo[i];
	else
		return NULL;
}

std::vector<CvMissionInfo*>& CvGlobals::getMissionInfo()
{
	return m_paMissionInfo;
}

CvMissionInfo* CvGlobals::getMissionInfo(MissionTypes eMissionNum)
{
	CvAssert(eMissionNum > -1);
	CvAssert(static_cast<unsigned int>(eMissionNum) < CvTypes::getNUM_MISSION_TYPES());
	if(eMissionNum > -1 && eMissionNum < (int)m_paMissionInfo.size())
		return m_paMissionInfo[eMissionNum];
	else
		return NULL;
}

std::vector<CvControlInfo*>& CvGlobals::getControlInfo()
{
	return m_paControlInfo;
}

CvControlInfo* CvGlobals::getControlInfo(ControlTypes eControlNum)
{
	CvAssert(eControlNum > -1);
	CvAssert(eControlNum < NUM_CONTROL_TYPES);
	if(eControlNum > -1 && eControlNum < (int)m_paControlInfo.size())
		return m_paControlInfo[eControlNum];
	else
		return NULL;
}

std::vector<CvCommandInfo*>& CvGlobals::getCommandInfo()
{
	return m_paCommandInfo;
}

CvCommandInfo* CvGlobals::getCommandInfo(CommandTypes eCommandNum)
{
	CvAssert(eCommandNum > -1);
	CvAssert(eCommandNum < NUM_COMMAND_TYPES);
	if(eCommandNum > -1 && eCommandNum < (int)m_paCommandInfo.size())
		return m_paCommandInfo[eCommandNum];
	else
		return NULL;
}

int CvGlobals::getNumAutomateInfos()
{
	return (int)m_paAutomateInfo.size();
}

std::vector<CvAutomateInfo*>& CvGlobals::getAutomateInfo()
{
	return m_paAutomateInfo;
}

CvAutomateInfo* CvGlobals::getAutomateInfo(int iAutomateNum)
{
	CvAssertMsg(iAutomateNum < getNumAutomateInfos(), "Index out of bounds");
	CvAssertMsg(iAutomateNum > -1, "Index out of bounds");
	if(iAutomateNum > -1 && iAutomateNum < (int)m_paAutomateInfo.size())
		return m_paAutomateInfo[iAutomateNum];
	else
		return NULL;
}

int CvGlobals::getNumPromotionInfos()
{
	return (int)m_pPromotions->GetPromotionEntries().size();
}

std::vector<CvPromotionEntry*>& CvGlobals::getPromotionInfo()
{
	return m_pPromotions->GetPromotionEntries();
}

CvPromotionEntry* CvGlobals::getPromotionInfo(PromotionTypes ePromotionNum)
{
	CvAssert(ePromotionNum > -1);
	CvAssert(ePromotionNum < GC.getNumPromotionInfos());
	if(ePromotionNum > -1 && ePromotionNum < GC.getNumPromotionInfos())
		return m_pPromotions->GetPromotionEntries()[ePromotionNum];
	else
		return NULL;
}

CvPromotionXMLEntries* CvGlobals::GetGamePromotions() const
{
	return m_pPromotions;
}

int CvGlobals::getNumSpecialistInfos()
{
	return (int)m_paSpecialistInfo.size();
}

std::vector<CvSpecialistInfo*>& CvGlobals::getSpecialistInfo()
{
	return m_paSpecialistInfo;
}

CvSpecialistInfo* CvGlobals::getSpecialistInfo(SpecialistTypes eSpecialistNum)
{
	CvAssert(eSpecialistNum > -1);
	CvAssert(eSpecialistNum < GC.getNumSpecialistInfos());
	if(eSpecialistNum > -1 && eSpecialistNum < (int)m_paSpecialistInfo.size())
		return m_paSpecialistInfo[eSpecialistNum];
	else
		return NULL;
}

int CvGlobals::getNumEconomicAIStrategyInfos()
{
	return (int)m_pEconomicAIStrategies->GetEconomicAIStrategyEntries().size();
}

std::vector<CvEconomicAIStrategyXMLEntry*>& CvGlobals::getEconomicAIStrategyInfo()
{
	return m_pEconomicAIStrategies->GetEconomicAIStrategyEntries();
}

CvEconomicAIStrategyXMLEntry* CvGlobals::getEconomicAIStrategyInfo(EconomicAIStrategyTypes eAIStrategyNum)
{
	FAssert(eAIStrategyNum > -1);
	FAssert(eAIStrategyNum < GC.getNumEconomicAIStrategyInfos());
	if(eAIStrategyNum > -1 && eAIStrategyNum < GC.getNumEconomicAIStrategyInfos())
		return m_pEconomicAIStrategies->GetEconomicAIStrategyEntries()[eAIStrategyNum];
	else
		return NULL;
}

CvEconomicAIStrategyXMLEntries* CvGlobals::GetGameEconomicAIStrategies() const
{
	return m_pEconomicAIStrategies;
}

int CvGlobals::getNumCitySpecializationInfos()
{
	return (int)m_pCitySpecializations->GetCitySpecializationEntries().size();
}

std::vector<CvCitySpecializationXMLEntry*>& CvGlobals::getCitySpecializationInfo()
{
	return m_pCitySpecializations->GetCitySpecializationEntries();
}

CvCitySpecializationXMLEntry* CvGlobals::getCitySpecializationInfo(CitySpecializationTypes eCitySpecialization)
{
	CvAssert(eCitySpecialization > -1);
	CvAssert(eCitySpecialization < GC.getNumCitySpecializationInfos());
	if(eCitySpecialization > -1 && eCitySpecialization < GC.getNumCitySpecializationInfos())
		return m_pCitySpecializations->GetCitySpecializationEntries()[eCitySpecialization];
	else
		return NULL;
}

CvCitySpecializationXMLEntries* CvGlobals::GetGameCitySpecializations() const
{
	return m_pCitySpecializations;
}

int CvGlobals::getNumTacticalMoveInfos()
{
	return (int)m_pTacticalMoves->GetTacticalMoveEntries().size();
}

std::vector<CvTacticalMoveXMLEntry*>& CvGlobals::getTacticalMoveInfo()
{
	return m_pTacticalMoves->GetTacticalMoveEntries();
}

CvTacticalMoveXMLEntry* CvGlobals::getTacticalMoveInfo(TacticalAIMoveTypes eTacticalMove)
{
	FAssert(eTacticalMove > -1);
	FAssert(eTacticalMove < GC.getNumTacticalMoveInfos());
	if(eTacticalMove > -1 && eTacticalMove < GC.getNumTacticalMoveInfos())
		return m_pTacticalMoves->GetTacticalMoveEntries()[eTacticalMove];
	else
		return NULL;
}

CvTacticalMoveXMLEntries* CvGlobals::GetGameTacticalMoves() const
{
	return m_pTacticalMoves;
}

int CvGlobals::getNumMilitaryAIStrategyInfos()
{
	return (int)m_pMilitaryAIStrategies->GetMilitaryAIStrategyEntries().size();
}

std::vector<CvMilitaryAIStrategyXMLEntry*>& CvGlobals::getMilitaryAIStrategyInfo()
{
	return m_pMilitaryAIStrategies->GetMilitaryAIStrategyEntries();
}

CvMilitaryAIStrategyXMLEntry* CvGlobals::getMilitaryAIStrategyInfo(MilitaryAIStrategyTypes eAIStrategyNum)
{
	FAssert(eAIStrategyNum < GC.getNumMilitaryAIStrategyInfos());
	return m_pMilitaryAIStrategies->GetMilitaryAIStrategyEntries()[eAIStrategyNum];
}

CvMilitaryAIStrategyXMLEntries* CvGlobals::GetGameMilitaryAIStrategies() const
{
	return m_pMilitaryAIStrategies;
}

int CvGlobals::getNumAIGrandStrategyInfos()
{
	return (int)m_pAIGrandStrategies->GetAIGrandStrategyEntries().size();
}

std::vector<CvAIGrandStrategyXMLEntry*>& CvGlobals::getAIGrandStrategyInfo()
{
	return m_pAIGrandStrategies->GetAIGrandStrategyEntries();
}

CvAIGrandStrategyXMLEntry* CvGlobals::getAIGrandStrategyInfo(AIGrandStrategyTypes eAIGrandStrategyNum)
{
	CvAssert(eAIGrandStrategyNum > -1);
	CvAssert(eAIGrandStrategyNum < GC.getNumAIGrandStrategyInfos());
	return m_pAIGrandStrategies->GetAIGrandStrategyEntries()[eAIGrandStrategyNum];
}

CvAIGrandStrategyXMLEntries* CvGlobals::GetGameAIGrandStrategies() const
{
	return m_pAIGrandStrategies;
}

int CvGlobals::getNumAICityStrategyInfos()
{
	return (int)m_pAICityStrategies->GetAICityStrategyEntries().size();
}

std::vector<CvAICityStrategyEntry*>& CvGlobals::getAICityStrategyInfo()
{
	return m_pAICityStrategies->GetAICityStrategyEntries();
}

CvAICityStrategyEntry* CvGlobals::getAICityStrategyInfo(AICityStrategyTypes eAICityStrategyNum)
{
	CvAssert(eAICityStrategyNum > -1);
	CvAssert(eAICityStrategyNum < GC.getNumAICityStrategyInfos());
	return m_pAICityStrategies->GetAICityStrategyEntries()[eAICityStrategyNum];
}

CvAICityStrategies* CvGlobals::GetGameAICityStrategies() const
{
	return m_pAICityStrategies;
}

int CvGlobals::getNumPolicyInfos()
{
	return (int)m_pPolicies->GetPolicyEntries().size();
}

std::vector<CvPolicyEntry*>& CvGlobals::getPolicyInfo()
{
	return m_pPolicies->GetPolicyEntries();
}

CvPolicyEntry* CvGlobals::getPolicyInfo(PolicyTypes ePolicyNum)
{
	CvAssert(ePolicyNum > -1);
	CvAssert(ePolicyNum < GC.getNumPolicyInfos());
	return m_pPolicies->GetPolicyEntries()[ePolicyNum];
}

CvPolicyXMLEntries* CvGlobals::GetGamePolicies() const
{
	return m_pPolicies;
}

int CvGlobals::getNumPolicyBranchInfos()
{
	return (int)m_pPolicies->GetPolicyBranchEntries().size();
}

std::vector<CvPolicyBranchEntry*>& CvGlobals::getPolicyBranchInfo()
{
	return m_pPolicies->GetPolicyBranchEntries();
}

CvPolicyBranchEntry* CvGlobals::getPolicyBranchInfo(PolicyBranchTypes ePolicyBranchNum)
{
	CvAssert(ePolicyBranchNum > -1);
	CvAssert(ePolicyBranchNum < GC.getNumPolicyBranchInfos());
	return m_pPolicies->GetPolicyBranchEntries()[ePolicyBranchNum];
}

int CvGlobals::getNumEmphasisInfos()
{
	return (int)m_pEmphases->GetEmphasisEntries().size();
}

std::vector<CvEmphasisEntry*>& CvGlobals::getEmphasisInfo()
{
	return m_pEmphases->GetEmphasisEntries();
}

CvEmphasisEntry* CvGlobals::getEmphasisInfo(EmphasizeTypes eEmphasisNum)
{
	CvAssert(eEmphasisNum > -1);
	CvAssert(eEmphasisNum < GC.getNumEmphasisInfos());
	return m_pEmphases->GetEmphasisEntries()[eEmphasisNum];
}

CvEmphasisXMLEntries* CvGlobals::GetGameEmphases() const
{
	return m_pEmphases;
}

int CvGlobals::getNumTraitInfos()
{
	return (int)m_pTraits->GetTraitEntries().size();
}

std::vector<CvTraitEntry*>& CvGlobals::getTraitInfo()
{
	return m_pTraits->GetTraitEntries();
}

CvTraitEntry* CvGlobals::getTraitInfo(TraitTypes eTraitNum)
{
	CvAssert(eTraitNum > -1);
	CvAssert(eTraitNum < GC.getNumTraitInfos());
	return m_pTraits->GetTraitEntries()[eTraitNum];
}

CvTraitXMLEntries* CvGlobals::GetGameTraits() const
{
	return m_pTraits;
}

int CvGlobals::getNumReligionInfos()
{
	return (int)m_pReligions->GetReligionEntries().size();
}

std::vector<CvReligionEntry*>& CvGlobals::getReligionInfo()
{
	return m_pReligions->GetReligionEntries();
}

CvReligionEntry* CvGlobals::getReligionInfo(ReligionTypes eReligionNum)
{
	CvAssert(eReligionNum > -1);
	CvAssert(eReligionNum < GC.getNumReligionInfos());
	return m_pReligions->GetReligionEntries()[eReligionNum];
}

CvReligionXMLEntries* CvGlobals::GetGameReligions() const
{
	return m_pReligions;
}

int CvGlobals::getNumBeliefInfos()
{
	return (int)m_pBeliefs->GetBeliefEntries().size();
}

std::vector<CvBeliefEntry*>& CvGlobals::getBeliefInfo()
{
	return m_pBeliefs->GetBeliefEntries();
}

CvBeliefEntry* CvGlobals::getBeliefInfo(BeliefTypes eBeliefNum)
{
	CvAssert(eBeliefNum > -1);
	CvAssert(eBeliefNum < GC.getNumBeliefInfos());
	return m_pBeliefs->GetBeliefEntries()[eBeliefNum];
}

CvBeliefXMLEntries* CvGlobals::GetGameBeliefs() const
{
	return m_pBeliefs;
}

int CvGlobals::getNumTechInfos()
{
	return (int)m_pTechs->GetTechEntries().size();
}

std::vector<CvTechEntry*>& CvGlobals::getTechInfo()
{
	return m_pTechs->GetTechEntries();
}

CvTechEntry* CvGlobals::getTechInfo(TechTypes eTechNum)
{
	CvAssert(eTechNum > -1);
	CvAssert(eTechNum < GC.getNumTechInfos());
	return m_pTechs->GetTechEntries()[eTechNum];
}

CvTechXMLEntries* CvGlobals::GetGameTechs() const
{
	return m_pTechs;
}

int CvGlobals::getNumEraInfos()
{
	return (int)m_aEraInfo.size();
}

std::vector<CvEraInfo*>& CvGlobals::getEraInfo()
{
	return m_aEraInfo;
}

CvEraInfo* CvGlobals::getEraInfo(EraTypes eEraNum)
{
	CvAssert(eEraNum > -1);
	CvAssert(eEraNum < GC.getNumEraInfos());
	return m_aEraInfo[eEraNum];
}

int CvGlobals::getNumHurryInfos()
{
	return (int)m_paHurryInfo.size();
}

std::vector<CvHurryInfo*>& CvGlobals::getHurryInfo()
{
	return m_paHurryInfo;
}

CvHurryInfo* CvGlobals::getHurryInfo(HurryTypes eHurryNum)
{
	CvAssert(eHurryNum > -1);
	CvAssert(eHurryNum < GC.getNumHurryInfos());
	return m_paHurryInfo[eHurryNum];
}

int CvGlobals::getNumVictoryInfos()
{
	return (int)m_paVictoryInfo.size();
}

std::vector<CvVictoryInfo*>& CvGlobals::getVictoryInfo()
{
	return m_paVictoryInfo;
}

CvVictoryInfo* CvGlobals::getVictoryInfo(VictoryTypes eVictoryNum)
{
	CvAssert(eVictoryNum > -1);
	CvAssert(eVictoryNum < GC.getNumVictoryInfos());
	return m_paVictoryInfo[eVictoryNum];
}

int CvGlobals::getNumSmallAwardInfos()
{
	return (int)m_paSmallAwardInfo.size();
}

std::vector<CvSmallAwardInfo*>& CvGlobals::getSmallAwardInfo()	// For Moose - XML Load Util, CvInfos
{
	return m_paSmallAwardInfo;
}

CvSmallAwardInfo* CvGlobals::getSmallAwardInfo(SmallAwardTypes eSmallAwardNum)
{
	CvAssert(eSmallAwardNum > -1);
	CvAssert(eSmallAwardNum < GC.getNumSmallAwardInfos());
	return m_paSmallAwardInfo[eSmallAwardNum];
}

//////////////////////////////////////////////////////////////////////////
int CvGlobals::getNumUnitDomainInfos()
{
	return (int)m_paUnitDomainInfo.size();
}

std::vector<CvDomainInfo*>& CvGlobals::getUnitDomainInfo()
{
	return m_paUnitDomainInfo;
}

CvDomainInfo* CvGlobals::getUnitDomainInfo(DomainTypes eDomainNum)
{
	CvAssert(eDomainNum > -1);
	CvAssert(eDomainNum < GC.getNumUnitDomainInfos());
	return m_paUnitDomainInfo[eDomainNum];
}

//////////////////////////////////////////////////////////////////////////
void CvGlobals::LogMessage(const char* szMessage)
{
	if(getLogging())
	{
		FILogFile* pLog = LOGFILEMGR.GetLog("GameCore.log", 0);
		if(pLog)
			pLog->Msg(szMessage);
	}
}

CvNotificationXMLEntries* CvGlobals::GetNotificationEntries()
{
	return m_pNotifications;
}

CvString*& CvGlobals::getFootstepAudioTags()
{
	return m_paszFootstepAudioTags;
}

CvString& CvGlobals::getFootstepAudioTags(int i)
{
//	CvAssertMsg(i < getNumFootstepAudioTags(), "Index out of bounds")
	CvAssertMsg(i > -1, "Index out of bounds");
	return m_paszFootstepAudioTags[i];
}

const char** CvGlobals::GetHexDebugLayerNames()
{
	static const char* hexDebugLayerNames[] =
	{
		"StartSiteEvaluationLayer",
		"SettlerSiteEvaluationLayer",
		"VisibilityLayer",
		"RevealedLayer",
		"DangerLayer",
		"TacticalAnalysisLayer",
		NULL
	};
	return hexDebugLayerNames;
}

float CvGlobals::GetHexDebugLayerScale(const char* szLayerName)
{
	std::string strLayerName = szLayerName;
	float fScale = 1.0f;

	if(strLayerName == "SettlerSiteEvaluationLayer")
	{
		fScale = 1.5f;
	}

	return fScale;
}

bool CvGlobals::GetHexDebugLayerString(CvPlot* pkPlot, const char* szLayerName, PlayerTypes ePlayer, char* szBuffer, unsigned int uiBufferLength)
{
	std::string strLayerName = szLayerName;
	if(strLayerName == "StartSiteEvaluationLayer")
	{
		if(!pkPlot->isWater())
		{
			const int iValue = GC.getGame().GetStartSiteEvaluator()->PlotFoundValue(pkPlot, NULL);
			sprintf_s(szBuffer, uiBufferLength, "%d", iValue);
		}
	}
	else if(strLayerName == "SettlerSiteEvaluationLayer")
	{
		if(!pkPlot->isWater() && ePlayer != NO_PLAYER)
		{
			CvPlayerAI& kPlayer = GET_PLAYER(ePlayer);
			const int iValue = GC.getGame().GetSettlerSiteEvaluator()->PlotFoundValue(pkPlot, &kPlayer);
			sprintf_s(szBuffer, uiBufferLength, "%d", iValue);
		}
	}
	else if(strLayerName == "VisibilityLayer")
	{
		if(ePlayer != NO_PLAYER)
		{
			CvPlayerAI& kPlayer = GET_PLAYER(ePlayer);
			const TeamTypes eTeam = kPlayer.getTeam();

			if(pkPlot->isVisible(eTeam))
			{
				sprintf_s(szBuffer, uiBufferLength, "Vis %d", kPlayer.GetID());
			}
		}
	}
	else if(strLayerName == "RevealedLayer")
	{
		if(ePlayer != NO_PLAYER)
		{
			CvPlayerAI& kPlayer = GET_PLAYER(ePlayer);
			const TeamTypes eTeam = kPlayer.getTeam();
			if(pkPlot->isRevealed(eTeam))
			{
				sprintf_s(szBuffer, uiBufferLength, "Rev %d", kPlayer.GetID());

			}
		}
	}
	else if(strLayerName == "DangerLayer")
	{
		if(ePlayer != NO_PLAYER)
		{
			CvPlayerAI& kPlayer = GET_PLAYER(ePlayer);
			const int iValue = kPlayer.GetPlotDanger(*pkPlot);

			sprintf_s(szBuffer, uiBufferLength, "%d", iValue);
		}
	}
	else if(strLayerName == "TacticalAnalysisLayer")
	{
		std::string strOut;

		int iIndex = GC.getMap().plotNum(pkPlot->getX(), pkPlot->getY());
		CvTacticalAnalysisMap* pTactMap = GC.getGame().GetTacticalAnalysisMap();
		CvTacticalAnalysisCell* pCell = pTactMap->GetCell(iIndex);

		if(pCell->IsImpassableTerrain())
		{
			strOut += "X Terrain";
		}
		else
		{
			if(pCell->IsImpassableTerritory())
			{
				strOut += "X Territory";
			}
			else
			{
				if(pCell->IsRevealed())
				{
					strOut += "R ";
				}
				if(pCell->IsVisible())
				{
					strOut += "V ";
				}
				if(pCell->IsEnemyCanMovePast())
				{
					strOut += "A+ ";
				}
				else if(pCell->IsNotVisibleToEnemy())
				{
					strOut += "N ";
				}
				else if(pCell->IsSubjectToAttack())
				{
					strOut += "A ";
				}
				if(pCell->IsFriendlyTurnEndTile())
				{
					strOut += "E ";
				}
				if(pCell->IsWithinRangeOfTarget())
				{
					strOut += "T ";
				}
				if(pCell->IsHelpsProvidesFlankBonus())
				{
					strOut += "F ";
				}
				if(pCell->GetDefenseModifier() > 0)
				{
					strOut += "D ";
				}
				if(pCell->GetDominanceZone() != -1)
				{
					char szTmp[16] = {0};
					sprintf_s(szTmp, "%d ", pCell->GetDominanceZone());

					strOut += szTmp;
				}
				if(pCell->GetDeploymentScore() > 0)
				{
					char szTmp[16] = {0};
					if(pCell->IsSafeForDeployment())
					{
						sprintf_s(szTmp, "[S%d] ", pCell->GetDeploymentScore());
					}
					else
					{
						sprintf_s(szTmp, "[%d] ", pCell->GetDeploymentScore());
					}

					strOut += szTmp;
				}
			}
		}

		sprintf_s(szBuffer, uiBufferLength, "%s", strOut.c_str());
	}

	return true;
}


void CvGlobals::cacheGlobals()
{
	// -- ints --

	m_iAI_ATTEMPT_RUSH_OVER_X_TURNS_TO_BUILD = getDefineINT("AI_ATTEMPT_RUSH_OVER_X_TURNS_TO_BUILD");
	m_iINITIAL_AI_CITY_PRODUCTION = getDefineINT("INITIAL_AI_CITY_PRODUCTION");
	m_iAI_CAN_DISBAND_UNITS = getDefineINT("AI_CAN_DISBAND_UNITS");
	m_iAI_SHOULDNT_MANAGE_PLOT_ASSIGNMENT = getDefineINT("AI_SHOULDNT_MANAGE_PLOT_ASSIGNMENT");
	m_iPOLICY_WEIGHT_PROPAGATION_PERCENT = getDefineINT("POLICY_WEIGHT_PROPAGATION_PERCENT");
	m_iPOLICY_WEIGHT_PROPAGATION_LEVELS = getDefineINT("POLICY_WEIGHT_PROPAGATION_LEVELS");
	m_iPOLICY_WEIGHT_PERCENT_DROP_NEW_BRANCH = getDefineINT("POLICY_WEIGHT_PERCENT_DROP_NEW_BRANCH");
	m_iTECH_WEIGHT_PROPAGATION_PERCENT = getDefineINT("TECH_WEIGHT_PROPAGATION_PERCENT");
	m_iTECH_WEIGHT_PROPAGATION_LEVELS = getDefineINT("TECH_WEIGHT_PROPAGATION_LEVELS");
	m_iTECH_PRIORITY_UNIQUE_ITEM = getDefineINT("TECH_PRIORITY_UNIQUE_ITEM");
	m_iTECH_PRIORITY_MAYA_CALENDAR_BONUS = getDefineINT("TECH_PRIORITY_MAYA_CALENDAR_BONUS");
	m_iAI_VALUE_OF_YIELD_GOLD = getDefineINT("AI_VALUE_OF_YIELD_GOLD");
	m_iAI_VALUE_OF_YIELD_PRODUCTION = getDefineINT("AI_VALUE_OF_YIELD_PRODUCTION");
	m_iAI_VALUE_OF_YIELD_SCIENCE = getDefineINT("AI_VALUE_OF_YIELD_SCIENCE");
	m_iDEFAULT_FLAVOR_VALUE = getDefineINT("DEFAULT_FLAVOR_VALUE");
	m_iPERSONALITY_FLAVOR_MAX_VALUE = getDefineINT("PERSONALITY_FLAVOR_MAX_VALUE");
	m_iPERSONALITY_FLAVOR_MIN_VALUE = getDefineINT("PERSONALITY_FLAVOR_MIN_VALUE");
	m_iFLAVOR_MIN_VALUE = getDefineINT("FLAVOR_MIN_VALUE");
	m_iFLAVOR_MAX_VALUE = getDefineINT("FLAVOR_MAX_VALUE");
	m_iFLAVOR_RANDOMIZATION_RANGE = getDefineINT("FLAVOR_RANDOMIZATION_RANGE");
	m_iFLAVOR_EXPANDGROW_COEFFICIENT = getDefineINT("FLAVOR_EXPANDGROW_COEFFICIENT");
	m_iAI_GRAND_STRATEGY_NUM_TURNS_STRATEGY_MUST_BE_ACTIVE = getDefineINT("AI_GRAND_STRATEGY_NUM_TURNS_STRATEGY_MUST_BE_ACTIVE");
	m_iAI_GS_RAND_ROLL = getDefineINT("AI_GS_RAND_ROLL");
	m_iAI_GRAND_STRATEGY_CURRENT_STRATEGY_WEIGHT = getDefineINT("AI_GRAND_STRATEGY_CURRENT_STRATEGY_WEIGHT");
	m_iAI_GRAND_STRATEGY_GUESS_NO_CLUE_WEIGHT = getDefineINT("AI_GRAND_STRATEGY_GUESS_NO_CLUE_WEIGHT");
	m_iAI_GRAND_STRATEGY_GUESS_POSITIVE_THRESHOLD = getDefineINT("AI_GRAND_STRATEGY_GUESS_POSITIVE_THRESHOLD");
	m_iAI_GRAND_STRATEGY_GUESS_LIKELY_THRESHOLD = getDefineINT("AI_GRAND_STRATEGY_GUESS_LIKELY_THRESHOLD");
	m_iAI_GRAND_STRATEGY_OTHER_PLAYERS_GS_MULTIPLIER = getDefineINT("AI_GRAND_STRATEGY_OTHER_PLAYERS_GS_MULTIPLIER");
	m_iAI_GS_CONQUEST_NOBODY_MET_FIRST_TURN = getDefineINT("AI_GS_CONQUEST_NOBODY_MET_FIRST_TURN");
	m_iAI_GRAND_STRATEGY_CONQUEST_NOBODY_MET_WEIGHT = getDefineINT("AI_GRAND_STRATEGY_CONQUEST_NOBODY_MET_WEIGHT");
	m_iAI_GRAND_STRATEGY_CONQUEST_AT_WAR_WEIGHT = getDefineINT("AI_GRAND_STRATEGY_CONQUEST_AT_WAR_WEIGHT");
	m_iAI_GS_CONQUEST_MILITARY_STRENGTH_FIRST_TURN = getDefineINT("AI_GS_CONQUEST_MILITARY_STRENGTH_FIRST_TURN");
	m_iAI_GRAND_STRATEGY_CONQUEST_POWER_RATIO_MULTIPLIER = getDefineINT("AI_GRAND_STRATEGY_CONQUEST_POWER_RATIO_MULTIPLIER");
	m_iAI_GRAND_STRATEGY_CONQUEST_CRAMPED_WEIGHT = getDefineINT("AI_GRAND_STRATEGY_CONQUEST_CRAMPED_WEIGHT");
	m_iAI_GRAND_STRATEGY_CONQUEST_WEIGHT_PER_MINOR_ATTACKED = getDefineINT("AI_GRAND_STRATEGY_CONQUEST_WEIGHT_PER_MINOR_ATTACKED");
	m_iAI_GRAND_STRATEGY_CONQUEST_WEIGHT_PER_MINOR_CONQUERED = getDefineINT("AI_GRAND_STRATEGY_CONQUEST_WEIGHT_PER_MINOR_CONQUERED");
	m_iAI_GRAND_STRATEGY_CONQUEST_WEIGHT_PER_MAJOR_ATTACKED = getDefineINT("AI_GRAND_STRATEGY_CONQUEST_WEIGHT_PER_MAJOR_ATTACKED");
	m_iAI_GRAND_STRATEGY_CONQUEST_WEIGHT_PER_MAJOR_CONQUERED = getDefineINT("AI_GRAND_STRATEGY_CONQUEST_WEIGHT_PER_MAJOR_CONQUERED");
	m_iAI_GS_CULTURE_RATIO_MULTIPLIER = getDefineINT("AI_GS_CULTURE_RATIO_MULTIPLIER");
	m_iAI_GS_CULTURE_RATIO_EARLY_TURN_THRESHOLD = getDefineINT("AI_GS_CULTURE_RATIO_EARLY_TURN_THRESHOLD");
	m_iAI_GS_CULTURE_RATIO_EARLY_DIVISOR = getDefineINT("AI_GS_CULTURE_RATIO_EARLY_DIVISOR");
	m_iAI_GS_CULTURE_MAX_CITIES = getDefineINT("AI_GS_CULTURE_MAX_CITIES");
	m_iAI_GS_CULTURE_MAX_CITIES_MODIFIER = getDefineINT("AI_GS_CULTURE_MAX_CITIES_MODIFIER");
	m_iAI_GS_CULTURE_POLICY_BRANCH_MOD = getDefineINT("AI_GS_CULTURE_POLICY_BRANCH_MOD");
	m_iAI_GRAND_STRATEGY_UN_EACH_MINOR_ATTACKED_WEIGHT = getDefineINT("AI_GRAND_STRATEGY_UN_EACH_MINOR_ATTACKED_WEIGHT");
	m_iAI_GS_UN_SECURED_VOTE_MOD = getDefineINT("AI_GS_UN_SECURED_VOTE_MOD");
	m_iAI_GS_SS_HAS_APOLLO_PROGRAM = getDefineINT("AI_GS_SS_HAS_APOLLO_PROGRAM");
	m_iAI_GS_SS_TECH_PROGRESS_MOD = getDefineINT("AI_GS_SS_TECH_PROGRESS_MOD");
	m_iAI_STRATEGY_EARLY_EXPLORATION_STARTING_WEIGHT = getDefineINT("AI_STRATEGY_EARLY_EXPLORATION_STARTING_WEIGHT");
	m_iAI_STRATEGY_EARLY_EXPLORATION_EXPLORERS_WEIGHT_DIVISOR = getDefineINT("AI_STRATEGY_EARLY_EXPLORATION_EXPLORERS_WEIGHT_DIVISOR");
	m_iAI_STRATEGY_EARLY_EXPLORATION_WEIGHT_PER_FLAVOR = getDefineINT("AI_STRATEGY_EARLY_EXPLORATION_WEIGHT_PER_FLAVOR");
	m_iAI_STRATEGY_EARLY_EXPANSION_NUM_UNOWNED_TILES_REQUIRED = getDefineINT("AI_STRATEGY_EARLY_EXPANSION_NUM_UNOWNED_TILES_REQUIRED");
	m_iAI_STRATEGY_EARLY_EXPANSION_NUM_CITIES_LIMIT = getDefineINT("AI_STRATEGY_EARLY_EXPANSION_NUM_CITIES_LIMIT");
	m_fAI_STRATEGY_NEED_IMPROVEMENT_CITY_RATIO = getDefineFLOAT("AI_STRATEGY_NEED_IMPROVEMENT_CITY_RATIO");
	m_iAI_STRATEGY_ISLAND_START_COAST_REVEAL_PERCENT = getDefineINT("AI_STRATEGY_ISLAND_START_COAST_REVEAL_PERCENT");
	m_iAI_STRATEGY_AREA_IS_FULL_PERCENT = getDefineINT("AI_STRATEGY_AREA_IS_FULL_PERCENT");
	m_iAI_STRATEGY_MINIMUM_SETTLE_FERTILITY = getDefineINT("AI_STRATEGY_MINIMUM_SETTLE_FERTILITY");
	m_iAI_BUY_PLOT_TEST_PROBES = getDefineINT("AI_BUY_PLOT_TEST_PROBES");
	m_iAI_PLOT_VALUE_STRATEGIC_RESOURCE = getDefineINT("AI_PLOT_VALUE_STRATEGIC_RESOURCE");
	m_iAI_PLOT_VALUE_LUXURY_RESOURCE = getDefineINT("AI_PLOT_VALUE_LUXURY_RESOURCE");
	m_iAI_PLOT_VALUE_SPECIALIZATION_MULTIPLIER = getDefineINT("AI_PLOT_VALUE_SPECIALIZATION_MULTIPLIER");
	m_iAI_PLOT_VALUE_YIELD_MULTIPLIER = getDefineINT("AI_PLOT_VALUE_YIELD_MULTIPLIER");
	m_iAI_PLOT_VALUE_DEFICIENT_YIELD_MULTIPLIER = getDefineINT("AI_PLOT_VALUE_DEFICIENT_YIELD_MULTIPLIER");
	m_iAI_PLOT_VALUE_FIERCE_DISPUTE = getDefineINT("AI_PLOT_VALUE_FIERCE_DISPUTE");
	m_iAI_PLOT_VALUE_STRONG_DISPUTE = getDefineINT("AI_PLOT_VALUE_STRONG_DISPUTE");
	m_iAI_PLOT_VALUE_WEAK_DISPUTE = getDefineINT("AI_PLOT_VALUE_WEAK_DISPUTE");
	m_iAI_GOLD_PRIORITY_MINIMUM_PLOT_BUY_VALUE = getDefineINT("AI_GOLD_PRIORITY_MINIMUM_PLOT_BUY_VALUE");
	m_iAI_GOLD_BALANCE_TO_HALVE_PLOT_BUY_MINIMUM = getDefineINT("AI_GOLD_BALANCE_TO_HALVE_PLOT_BUY_MINIMUM");
	m_iAI_GOLD_PRIORITY_UPGRADE_BASE = getDefineINT("AI_GOLD_PRIORITY_UPGRADE_BASE");
	m_iAI_GOLD_PRIORITY_UPGRADE_PER_FLAVOR_POINT = getDefineINT("AI_GOLD_PRIORITY_UPGRADE_PER_FLAVOR_POINT");
	m_iAI_GOLD_PRIORITY_DIPLOMACY_BASE = getDefineINT("AI_GOLD_PRIORITY_DIPLOMACY_BASE");
	m_iAI_GOLD_PRIORITY_DIPLOMACY_PER_FLAVOR_POINT = getDefineINT("AI_GOLD_PRIORITY_DIPLOMACY_PER_FLAVOR_POINT");
	m_iAI_GOLD_PRIORITY_UNIT = getDefineINT("AI_GOLD_PRIORITY_UNIT");
	m_iAI_GOLD_PRIORITY_DEFENSIVE_BUILDING = getDefineINT("AI_GOLD_PRIORITY_DEFENSIVE_BUILDING");
	m_iBUILDER_TASKING_PLOT_EVAL_MULTIPLIER_FOOD = getDefineINT("BUILDER_TASKING_PLOT_EVAL_MULTIPLIER_FOOD");
	m_iBUILDER_TASKING_PLOT_EVAL_MULTIPLIER_PRODUCTION = getDefineINT("BUILDER_TASKING_PLOT_EVAL_MULTIPLIER_PRODUCTION");
	m_iBUILDER_TASKING_PLOT_EVAL_MULTIPLIER_GOLD = getDefineINT("BUILDER_TASKING_PLOT_EVAL_MULTIPLIER_GOLD");
	m_iBUILDER_TASKING_PLOT_EVAL_MULTIPLIER_SCIENCE = getDefineINT("BUILDER_TASKING_PLOT_EVAL_MULTIPLIER_SCIENCE");
	m_iBUILDER_TASKING_PLOT_EVAL_MULTIPLIER_CULTURE = getDefineINT("BUILDER_TASKING_PLOT_EVAL_MULTIPLIER_CULTURE");
	m_iBUILDER_TASKING_PLOT_EVAL_MULTIPLIER_LUXURY_RESOURCE = getDefineINT("BUILDER_TASKING_PLOT_EVAL_MULTIPLIER_LUXURY_RESOURCE");
	m_iBUILDER_TASKING_IMPROVE_RESOURCE_TENDENCY = getDefineINT("BUILDER_TASKING_IMPROVE_RESOURCE_TENDENCY");
	m_iBUILDER_TASKING_BUILD_ROUTE_TENDENCY = getDefineINT("BUILDER_TASKING_BUILD_ROUTE_TENDENCY");
	m_iBUILDER_TASKING_DIRECTIVES_TO_EVALUATE = getDefineINT("BUILDER_TASKING_DIRECTIVES_TO_EVALUATE");
	m_iBUILDER_TASKING_BASELINE_BUILD_IMPROVEMENTS = getDefineINT("BUILDER_TASKING_BASELINE_BUILD_IMPROVEMENTS");
	m_iBUILDER_TASKING_BASELINE_BUILD_RESOURCE_IMPROVEMENTS = getDefineINT("BUILDER_TASKING_BASELINE_BUILD_RESOURCE_IMPROVEMENTS");
	m_iBUILDER_TASKING_BASELINE_BUILD_ROUTES = getDefineINT("BUILDER_TASKING_BASELINE_BUILD_ROUTES");
	m_iBUILDER_TASKING_BASELINE_REPAIR = getDefineINT("BUILDER_TASKING_BASELINE_REPAIR");
	m_iBUILDER_TASKING_BASELINE_SCRUB_FALLOUT = getDefineINT("BUILDER_TASKING_BASELINE_SCRUB_FALLOUT");
	m_iBUILDER_TASKING_BASELINE_ADDS_CULTURE = getDefineINT("BUILDER_TASKING_BASELINE_ADDS_CULTURE");
	m_iAI_MILITARY_THREAT_WEIGHT_MINOR = getDefineINT("AI_MILITARY_THREAT_WEIGHT_MINOR");
	m_iAI_MILITARY_THREAT_WEIGHT_MAJOR = getDefineINT("AI_MILITARY_THREAT_WEIGHT_MAJOR");
	m_iAI_MILITARY_THREAT_WEIGHT_SEVERE = getDefineINT("AI_MILITARY_THREAT_WEIGHT_SEVERE");
	m_iAI_MILITARY_THREAT_WEIGHT_CRITICAL = getDefineINT("AI_MILITARY_THREAT_WEIGHT_CRITICAL");
	m_iAI_STRATEGY_DEFEND_MY_LANDS_BASE_UNITS = getDefineINT("AI_STRATEGY_DEFEND_MY_LANDS_BASE_UNITS");
	m_iAI_STRATEGY_MILITARY_RESERVE_PERCENTAGE = getDefineINT("AI_STRATEGY_MILITARY_RESERVE_PERCENTAGE");
	m_iAI_MILITARY_CITY_THREAT_WEIGHT_CAPITAL = getDefineINT("AI_MILITARY_CITY_THREAT_WEIGHT_CAPITAL");
	m_iAI_MILITARY_BARBARIANS_FOR_MINOR_THREAT = getDefineINT("AI_MILITARY_BARBARIANS_FOR_MINOR_THREAT");
	m_iAI_MILITARY_IGNORE_BAD_ODDS = getDefineINT("AI_MILITARY_IGNORE_BAD_ODDS");
	m_iAI_CITY_SPECIALIZATION_EARLIEST_TURN = getDefineINT("AI_CITY_SPECIALIZATION_EARLIEST_TURN");
	m_iAI_CITY_SPECIALIZATION_REEVALUATION_INTERVAL = getDefineINT("AI_CITY_SPECIALIZATION_REEVALUATION_INTERVAL");
	m_iAI_CITY_SPECIALIZATION_GENERAL_ECONOMIC_WEIGHT = getDefineINT("AI_CITY_SPECIALIZATION_GENERAL_ECONOMIC_WEIGHT");
	m_iAI_CITY_SPECIALIZATION_FOOD_WEIGHT_FLAVOR_EXPANSION = getDefineINT("AI_CITY_SPECIALIZATION_FOOD_WEIGHT_FLAVOR_EXPANSION");
	m_iAI_CITY_SPECIALIZATION_FOOD_WEIGHT_PERCENT_CONTINENT_UNOWNED = getDefineINT("AI_CITY_SPECIALIZATION_FOOD_WEIGHT_PERCENT_CONTINENT_UNOWNED");
	m_iAI_CITY_SPECIALIZATION_FOOD_WEIGHT_NUM_CITIES = getDefineINT("AI_CITY_SPECIALIZATION_FOOD_WEIGHT_NUM_CITIES");
	m_iAI_CITY_SPECIALIZATION_FOOD_WEIGHT_NUM_SETTLERS = getDefineINT("AI_CITY_SPECIALIZATION_FOOD_WEIGHT_NUM_SETTLERS");
	m_iAI_CITY_SPECIALIZATION_FOOD_WEIGHT_EARLY_EXPANSION = getDefineINT("AI_CITY_SPECIALIZATION_FOOD_WEIGHT_EARLY_EXPANSION");
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_OPERATIONAL_UNITS_REQUESTED = getDefineINT("AI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_OPERATIONAL_UNITS_REQUESTED");
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_CIVS_AT_WAR_WITH = getDefineINT("AI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_CIVS_AT_WAR_WITH");
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_WAR_MOBILIZATION = getDefineINT("AI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_WAR_MOBILIZATION");
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_EMPIRE_DEFENSE = getDefineINT("AI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_EMPIRE_DEFENSE");
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_EMPIRE_DEFENSE_CRITICAL = getDefineINT("AI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_EMPIRE_DEFENSE_CRITICAL");
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_CAPITAL_THREAT = getDefineINT("AI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_CAPITAL_THREAT");
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_NEED_NAVAL_UNITS = getDefineINT("AI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_NEED_NAVAL_UNITS");
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_NEED_NAVAL_UNITS_CRITICAL = getDefineINT("AI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_NEED_NAVAL_UNITS_CRITICAL");
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_FLAVOR_WONDER = getDefineINT("AI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_FLAVOR_WONDER");
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_FLAVOR_SPACESHIP = getDefineINT("AI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_FLAVOR_SPACESHIP");
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_TRAINING_PER_OFFENSE = getDefineINT("AI_CITY_SPECIALIZATION_PRODUCTION_TRAINING_PER_OFFENSE");
	m_iAI_CITY_SPECIALIZATION_PRODUCTION_TRAINING_PER_PERSONALITY = getDefineINT("AI_CITY_SPECIALIZATION_PRODUCTION_TRAINING_PER_PERSONALITY");
	m_iAI_CITY_SPECIALIZATION_GOLD_WEIGHT_FLAVOR_GOLD = getDefineINT("AI_CITY_SPECIALIZATION_GOLD_WEIGHT_FLAVOR_GOLD");
	m_iAI_CITY_SPECIALIZATION_GOLD_WEIGHT_LAND_DISPUTE = getDefineINT("AI_CITY_SPECIALIZATION_GOLD_WEIGHT_LAND_DISPUTE");
	m_iAI_CITY_SPECIALIZATION_SCIENCE_WEIGHT_FLAVOR_SCIENCE = getDefineINT("AI_CITY_SPECIALIZATION_SCIENCE_WEIGHT_FLAVOR_SCIENCE");
	m_iAI_CITY_SPECIALIZATION_SCIENCE_WEIGHT_FLAVOR_SPACESHIP = getDefineINT("AI_CITY_SPECIALIZATION_SCIENCE_WEIGHT_FLAVOR_SPACESHIP");
	m_iAI_CITY_SPECIALIZATION_YIELD_WEIGHT_FIRST_RING = getDefineINT("AI_CITY_SPECIALIZATION_YIELD_WEIGHT_FIRST_RING");
	m_iAI_CITY_SPECIALIZATION_YIELD_WEIGHT_SECOND_RING = getDefineINT("AI_CITY_SPECIALIZATION_YIELD_WEIGHT_SECOND_RING");
	m_iAI_CITY_SPECIALIZATION_YIELD_WEIGHT_THIRD_RING = getDefineINT("AI_CITY_SPECIALIZATION_YIELD_WEIGHT_THIRD_RING");
	m_iAI_CITY_SPECIALIZATION_YIELD_NUM_TILES_CONSIDERED = getDefineINT("AI_CITY_SPECIALIZATION_YIELD_NUM_TILES_CONSIDERED");
	m_iAI_CITYSTRATEGY_SMALL_CITY_POP_THRESHOLD = getDefineINT("AI_CITYSTRATEGY_SMALL_CITY_POP_THRESHOLD");
	m_iAI_CITYSTRATEGY_MEDIUM_CITY_POP_THRESHOLD = getDefineINT("AI_CITYSTRATEGY_MEDIUM_CITY_POP_THRESHOLD");
	m_iAI_CITYSTRATEGY_LARGE_CITY_POP_THRESHOLD = getDefineINT("AI_CITYSTRATEGY_LARGE_CITY_POP_THRESHOLD");
	m_iAI_CITYSTRATEGY_NEED_TILE_IMPROVERS_CITY_THRESHOLD = getDefineINT("AI_CITYSTRATEGY_NEED_TILE_IMPROVERS_CITY_THRESHOLD");
	m_iAI_CITYSTRATEGY_NEED_TILE_IMPROVERS_WORKER_MOD = getDefineINT("AI_CITYSTRATEGY_NEED_TILE_IMPROVERS_WORKER_MOD");
	m_iAI_CITYSTRATEGY_NEED_TILE_IMPROVERS_DESPERATE_TURN = getDefineINT("AI_CITYSTRATEGY_NEED_TILE_IMPROVERS_DESPERATE_TURN");
	m_iAI_CITYSTRATEGY_WANT_TILE_IMPROVERS_MINIMUM_SIZE = getDefineINT("AI_CITYSTRATEGY_WANT_TILE_IMPROVERS_MINIMUM_SIZE");
	m_fAI_CITYSTRATEGY_YIELD_DEFICIENT_FOOD = getDefineFLOAT("AI_CITYSTRATEGY_YIELD_DEFICIENT_FOOD");
	m_fAI_CITYSTRATEGY_YIELD_DEFICIENT_PRODUCTION = getDefineFLOAT("AI_CITYSTRATEGY_YIELD_DEFICIENT_PRODUCTION");
	m_fAI_CITYSTRATEGY_YIELD_DEFICIENT_GOLD = getDefineFLOAT("AI_CITYSTRATEGY_YIELD_DEFICIENT_GOLD");
	m_fAI_CITYSTRATEGY_YIELD_DEFICIENT_SCIENCE = getDefineFLOAT("AI_CITYSTRATEGY_YIELD_DEFICIENT_SCIENCE");
	m_iAI_CITYSTRATEGY_OPERATION_UNIT_BASE_WEIGHT = getDefineINT("AI_CITYSTRATEGY_OPERATION_UNIT_BASE_WEIGHT");
	m_iAI_CITYSTRATEGY_OPERATION_UNIT_FLAVOR_MULTIPLIER = getDefineINT("AI_CITYSTRATEGY_OPERATION_UNIT_FLAVOR_MULTIPLIER");
	m_iAI_CITYSTRATEGY_ARMY_UNIT_BASE_WEIGHT = getDefineINT("AI_CITYSTRATEGY_ARMY_UNIT_BASE_WEIGHT");
	m_iAI_CITIZEN_VALUE_FOOD = getDefineINT("AI_CITIZEN_VALUE_FOOD");
	m_iAI_CITIZEN_VALUE_PRODUCTION = getDefineINT("AI_CITIZEN_VALUE_PRODUCTION");
	m_iAI_CITIZEN_VALUE_GOLD = getDefineINT("AI_CITIZEN_VALUE_GOLD");
	m_iAI_CITIZEN_VALUE_SCIENCE = getDefineINT("AI_CITIZEN_VALUE_SCIENCE");
	m_iAI_CITIZEN_VALUE_CULTURE = getDefineINT("AI_CITIZEN_VALUE_CULTURE");
	m_iAI_CITIZEN_VALUE_FAITH = getDefineINT("AI_CITIZEN_VALUE_FAITH");
	m_iAI_CITIZEN_FOOD_MOD_SIZE_CUTOFF = getDefineINT("AI_CITIZEN_FOOD_MOD_SIZE_CUTOFF");
	m_iAI_CITIZEN_FOOD_MOD_SIZE_EXPONENT = getDefineINT("AI_CITIZEN_FOOD_MOD_SIZE_EXPONENT");
	m_iAI_CITIZEN_MOD_FOOD_DEFICIT = getDefineINT("AI_CITIZEN_MOD_FOOD_DEFICIT");
	m_iAI_CITIZEN_MOD_PRODUCTION_DEFICIT = getDefineINT("AI_CITIZEN_MOD_PRODUCTION_DEFICIT");
	m_iAI_OPERATIONAL_BARBARIAN_CAMP_DEPLOY_RANGE = getDefineINT("AI_OPERATIONAL_BARBARIAN_CAMP_DEPLOY_RANGE");
	m_iAI_OPERATIONAL_CITY_ATTACK_DEPLOY_RANGE = getDefineINT("AI_OPERATIONAL_CITY_ATTACK_DEPLOY_RANGE");
	m_iAI_OPERATIONAL_PILLAGE_ENEMY_DEPLOY_RANGE = getDefineINT("AI_OPERATIONAL_PILLAGE_ENEMY_DEPLOY_RANGE");
	m_iAI_OPERATIONAL_NAVAL_BOMBARDMENT_DEPLOY_RANGE = getDefineINT("AI_OPERATIONAL_NAVAL_BOMBARDMENT_DEPLOY_RANGE");
	m_iAI_OPERATIONAL_PERCENT_DANGER_FOR_FORWARD_MUSTER = getDefineINT("AI_OPERATIONAL_PERCENT_DANGER_FOR_FORWARD_MUSTER");
	m_iAI_OPERATIONAL_PERCENT_HEALTH_FOR_OPERATION = getDefineINT("AI_OPERATIONAL_PERCENT_HEALTH_FOR_OPERATION");
	m_iAI_TACTICAL_MAP_UNIT_STRENGTH_MULTIPLIER = getDefineINT("AI_TACTICAL_MAP_UNIT_STRENGTH_MULTIPLIER");
	m_iAI_TACTICAL_MAP_DOMINANCE_PERCENTAGE = getDefineINT("AI_TACTICAL_MAP_DOMINANCE_PERCENTAGE");
	m_iAI_TACTICAL_MAP_TEMP_ZONE_RADIUS = getDefineINT("AI_TACTICAL_MAP_TEMP_ZONE_RADIUS");
	m_iAI_TACTICAL_MAP_TEMP_ZONE_TURNS = getDefineINT("AI_TACTICAL_MAP_TEMP_ZONE_TURNS");
	m_iAI_TACTICAL_MAP_BOMBARDMENT_ZONE_TURNS = getDefineINT("AI_TACTICAL_MAP_BOMBARDMENT_ZONE_TURNS");
	m_iAI_TACTICAL_RECRUIT_RANGE = getDefineINT("AI_TACTICAL_RECRUIT_RANGE");
	m_iAI_TACTICAL_REPOSITION_RANGE = getDefineINT("AI_TACTICAL_REPOSITION_RANGE");
	m_iAI_TACTICAL_OVERKILL_PERCENT = getDefineINT("AI_TACTICAL_OVERKILL_PERCENT");
	m_iAI_TACTICAL_BARBARIAN_RELEASE_VARIATION = getDefineINT("AI_TACTICAL_BARBARIAN_RELEASE_VARIATION");
	m_iAI_TACTICAL_MOVE_PRIORITY_RANDOMNESS = getDefineINT("AI_TACTICAL_MOVE_PRIORITY_RANDOMNESS");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_CAPTURE_CITY = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_CAPTURE_CITY");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_DAMAGE_CITY = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_DAMAGE_CITY");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_DESTROY_HIGH_UNIT = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_DESTROY_HIGH_UNIT");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_DESTROY_MEDIUM_UNIT = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_DESTROY_MEDIUM_UNIT");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_DESTROY_LOW_UNIT = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_DESTROY_LOW_UNIT");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_TO_SAFETY = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_TO_SAFETY");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_ATTRIT_HIGH_UNIT = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_ATTRIT_HIGH_UNIT");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_ATTRIT_MEDIUM_UNIT = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_ATTRIT_MEDIUM_UNIT");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_ATTRIT_LOW_UNIT = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_ATTRIT_LOW_UNIT");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_DESPERATE_ATTACK = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_DESPERATE_ATTACK");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_PILLAGE = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_PILLAGE");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_BLOCKADE_RESOURCE = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_BLOCKADE_RESOURCE");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_CIVILIAN_ATTACK = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_CIVILIAN_ATTACK");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_PASSIVE_MOVE = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_PASSIVE_MOVE");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_AGGRESSIVE_MOVE = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_AGGRESSIVE_MOVE");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_CAMP_DEFENSE = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_CAMP_DEFENSE");
	m_iAI_TACTICAL_BARBARIAN_PRIORITY_ESCORT_CIVILIAN = getDefineINT("AI_TACTICAL_BARBARIAN_PRIORITY_ESCORT_CIVILIAN");
	m_iAI_HOMELAND_MOVE_PRIORITY_RANDOMNESS = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_RANDOMNESS");
	m_iAI_HOMELAND_MAX_UPGRADE_MOVE_TURNS = getDefineINT("AI_HOMELAND_MAX_UPGRADE_MOVE_TURNS");
	m_iAI_HOMELAND_MAX_DEFENSIVE_MOVE_TURNS = getDefineINT("AI_HOMELAND_MAX_DEFENSIVE_MOVE_TURNS");
	m_iAI_HOMELAND_ESTIMATE_TURNS_DISTANCE = getDefineINT("AI_HOMELAND_ESTIMATE_TURNS_DISTANCE");
	m_iAI_HOMELAND_MOVE_PRIORITY_SETTLE = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_SETTLE");
	m_iAI_HOMELAND_MOVE_PRIORITY_HEAL = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_HEAL");
	m_iAI_HOMELAND_MOVE_PRIORITY_TO_SAFETY = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_TO_SAFETY");
	m_iAI_HOMELAND_MOVE_PRIORITY_WORKER = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_WORKER");
	m_iAI_HOMELAND_MOVE_PRIORITY_WORKER_SEA = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_WORKER_SEA");
	m_iAI_HOMELAND_MOVE_PRIORITY_EXPLORE = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_EXPLORE");
	m_iAI_HOMELAND_MOVE_PRIORITY_EXPLORE_SEA = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_EXPLORE_SEA");
	m_iAI_HOMELAND_MOVE_PRIORITY_SENTRY = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_SENTRY");
	m_iAI_HOMELAND_MOVE_PRIORITY_MOBILE_RESERVE = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_MOBILE_RESERVE");
	m_iAI_HOMELAND_MOVE_PRIORITY_GARRISON = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_GARRISON");
	m_iAI_HOMELAND_MOVE_PRIORITY_PATROL = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_PATROL");
	m_iAI_HOMELAND_MOVE_PRIORITY_UPGRADE = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_UPGRADE");
	m_iAI_HOMELAND_MOVE_PRIORITY_ANCIENT_RUINS = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_ANCIENT_RUINS");
	m_iAI_HOMELAND_MOVE_PRIORITY_GARRISON_CITY_STATE = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_GARRISON_CITY_STATE");
	m_iAI_HOMELAND_MOVE_PRIORITY_ARTIST_GOLDEN_AGE = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_ARTIST_GOLDEN_AGE");
	m_iAI_HOMELAND_MOVE_PRIORITY_SCIENTIST_FREE_TECH = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_SCIENTIST_FREE_TECH");
	m_iAI_HOMELAND_MOVE_PRIORITY_ENGINEER_HURRY = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_ENGINEER_HURRY");
	m_iAI_HOMELAND_MOVE_PRIORITY_GENERAL_GARRISON = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_GENERAL_GARRISON");
	m_iAI_HOMELAND_MOVE_PRIORITY_ADMIRAL_GARRISON = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_ADMIRAL_GARRISON");
	m_iAI_HOMELAND_MOVE_PRIORITY_PROPHET_RELIGION = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_PROPHET_RELIGION");
	m_iAI_HOMELAND_MOVE_PRIORITY_MISSIONARY = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_MISSIONARY");
	m_iAI_HOMELAND_MOVE_PRIORITY_INQUISITOR = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_INQUISITOR");
	m_iAI_HOMELAND_MOVE_PRIORITY_AIRCRAFT_TO_THE_FRONT = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_AIRCRAFT_TO_THE_FRONT");
	m_iAI_HOMELAND_MOVE_PRIORITY_SPACESHIP_PART = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_SPACESHIP_PART");
	m_iAI_HOMELAND_MOVE_PRIORITY_TREASURE = getDefineINT("AI_HOMELAND_MOVE_PRIORITY_TREASURE");
	m_iAI_HOMELAND_GREAT_PERSON_TURNS_TO_WAIT = getDefineINT("AI_HOMELAND_GREAT_PERSON_TURNS_TO_WAIT");
	m_iAI_DIPLO_PLOT_RANGE_FROM_CITY_HOME_FRONT = getDefineINT("AI_DIPLO_PLOT_RANGE_FROM_CITY_HOME_FRONT");
	m_iAI_DIPLO_LAND_DISPUTE_WEIGHT_WEAK = getDefineINT("AI_DIPLO_LAND_DISPUTE_WEIGHT_WEAK");
	m_iAI_DIPLO_LAND_DISPUTE_WEIGHT_STRONG = getDefineINT("AI_DIPLO_LAND_DISPUTE_WEIGHT_STRONG");
	m_iAI_DIPLO_LAND_DISPUTE_WEIGHT_FIERCE = getDefineINT("AI_DIPLO_LAND_DISPUTE_WEIGHT_FIERCE");
	m_iMINOR_BULLY_GOLD = getDefineINT("MINOR_BULLY_GOLD");
	m_iMINOR_FRIENDSHIP_RATE_MOD_MAXIMUM = getDefineINT("MINOR_FRIENDSHIP_RATE_MOD_MAXIMUM");
	m_iMINOR_FRIENDSHIP_RATE_MOD_SHARED_RELIGION = getDefineINT("MINOR_FRIENDSHIP_RATE_MOD_SHARED_RELIGION");
	m_iMINOR_FRIENDSHIP_DROP_PER_TURN = getDefineINT("MINOR_FRIENDSHIP_DROP_PER_TURN");
	m_iMINOR_FRIENDSHIP_DROP_PER_TURN_HOSTILE = getDefineINT("MINOR_FRIENDSHIP_DROP_PER_TURN_HOSTILE");
	m_iMINOR_FRIENDSHIP_DROP_PER_TURN_AGGRESSOR = getDefineINT("MINOR_FRIENDSHIP_DROP_PER_TURN_AGGRESSOR");
	m_iMINOR_FRIENDSHIP_DROP_DISHONOR_PLEDGE_TO_PROTECT = getDefineINT("MINOR_FRIENDSHIP_DROP_DISHONOR_PLEDGE_TO_PROTECT");
	m_iMINOR_FRIENDSHIP_DROP_BULLY_GOLD_SUCCESS = getDefineINT("MINOR_FRIENDSHIP_DROP_BULLY_GOLD_SUCCESS");
	m_iMINOR_FRIENDSHIP_DROP_BULLY_GOLD_FAILURE = getDefineINT("MINOR_FRIENDSHIP_DROP_BULLY_GOLD_FAILURE");
	m_iMINOR_FRIENDSHIP_DROP_BULLY_WORKER_SUCCESS = getDefineINT("MINOR_FRIENDSHIP_DROP_BULLY_WORKER_SUCCESS");
	m_iMINOR_FRIENDSHIP_DROP_BULLY_WORKER_FAILURE = getDefineINT("MINOR_FRIENDSHIP_DROP_BULLY_WORKER_FAILURE");
	m_iMINOR_FRIENDSHIP_NEGATIVE_INCREASE_PER_TURN = getDefineINT("MINOR_FRIENDSHIP_NEGATIVE_INCREASE_PER_TURN");
	m_iMINOR_FRIENDSHIP_AT_WAR = getDefineINT("MINOR_FRIENDSHIP_AT_WAR");
	m_iMINOR_CIV_AGGRESSOR_THRESHOLD = getDefineINT("MINOR_CIV_AGGRESSOR_THRESHOLD");
	m_iMINOR_CIV_WARMONGER_THRESHOLD = getDefineINT("MINOR_CIV_WARMONGER_THRESHOLD");
	m_iPERMANENT_WAR_AGGRESSOR_CHANCE = getDefineINT("PERMANENT_WAR_AGGRESSOR_CHANCE");
	m_iPERMANENT_WAR_OTHER_WARMONGER_CHANCE_DISTANT = getDefineINT("PERMANENT_WAR_OTHER_WARMONGER_CHANCE_DISTANT");
	m_iPERMANENT_WAR_OTHER_WARMONGER_CHANCE_FAR = getDefineINT("PERMANENT_WAR_OTHER_WARMONGER_CHANCE_FAR");
	m_iPERMANENT_WAR_OTHER_WARMONGER_CHANCE_CLOSE = getDefineINT("PERMANENT_WAR_OTHER_WARMONGER_CHANCE_CLOSE");
	m_iPERMANENT_WAR_OTHER_WARMONGER_CHANCE_NEIGHBORS = getDefineINT("PERMANENT_WAR_OTHER_WARMONGER_CHANCE_NEIGHBORS");
	m_iPERMANENT_WAR_OTHER_CHANCE_DISTANT = getDefineINT("PERMANENT_WAR_OTHER_CHANCE_DISTANT");
	m_iPERMANENT_WAR_OTHER_CHANCE_FAR = getDefineINT("PERMANENT_WAR_OTHER_CHANCE_FAR");
	m_iPERMANENT_WAR_OTHER_CHANCE_CLOSE = getDefineINT("PERMANENT_WAR_OTHER_CHANCE_CLOSE");
	m_iPERMANENT_WAR_OTHER_CHANCE_NEIGHBORS = getDefineINT("PERMANENT_WAR_OTHER_CHANCE_NEIGHBORS");
	m_iPERMANENT_WAR_OTHER_AT_WAR = getDefineINT("PERMANENT_WAR_OTHER_AT_WAR");
	m_iFRIENDSHIP_THRESHOLD_NEUTRAL = getDefineINT("FRIENDSHIP_THRESHOLD_NEUTRAL");
	m_iFRIENDSHIP_THRESHOLD_FRIENDS = getDefineINT("FRIENDSHIP_THRESHOLD_FRIENDS");
	m_iFRIENDSHIP_THRESHOLD_ALLIES = getDefineINT("FRIENDSHIP_THRESHOLD_ALLIES");
	m_iFRIENDSHIP_THRESHOLD_MAX = getDefineINT("FRIENDSHIP_THRESHOLD_MAX");
	m_iFRIENDSHIP_THRESHOLD_CAN_BULLY = getDefineINT("FRIENDSHIP_THRESHOLD_CAN_BULLY");
	m_iFRIENDSHIP_THRESHOLD_CAN_PLEDGE_TO_PROTECT = getDefineINT("FRIENDSHIP_THRESHOLD_CAN_PLEDGE_TO_PROTECT");
	m_iMINOR_FRIENDSHIP_CLOSE_AMOUNT = getDefineINT("MINOR_FRIENDSHIP_CLOSE_AMOUNT");
	m_iMINOR_CIV_SCIENCE_BONUS_MULTIPLIER = getDefineINT("MINOR_CIV_SCIENCE_BONUS_MULTIPLIER");
	m_iFRIENDS_CULTURE_BONUS_AMOUNT_ANCIENT = getDefineINT("FRIENDS_CULTURE_BONUS_AMOUNT_ANCIENT");
	m_iFRIENDS_CULTURE_BONUS_AMOUNT_MEDIEVAL = getDefineINT("FRIENDS_CULTURE_BONUS_AMOUNT_MEDIEVAL");
	m_iFRIENDS_CULTURE_BONUS_AMOUNT_INDUSTRIAL = getDefineINT("FRIENDS_CULTURE_BONUS_AMOUNT_INDUSTRIAL");
	m_iALLIES_CULTURE_BONUS_AMOUNT_ANCIENT = getDefineINT("ALLIES_CULTURE_BONUS_AMOUNT_ANCIENT");
	m_iALLIES_CULTURE_BONUS_AMOUNT_MEDIEVAL = getDefineINT("ALLIES_CULTURE_BONUS_AMOUNT_MEDIEVAL");
	m_iALLIES_CULTURE_BONUS_AMOUNT_INDUSTRIAL = getDefineINT("ALLIES_CULTURE_BONUS_AMOUNT_INDUSTRIAL");
	m_iFRIENDS_CAPITAL_FOOD_BONUS_AMOUNT_PRE_RENAISSANCE = getDefineINT("FRIENDS_CAPITAL_FOOD_BONUS_AMOUNT_PRE_RENAISSANCE");
	m_iFRIENDS_CAPITAL_FOOD_BONUS_AMOUNT_POST_RENAISSANCE = getDefineINT("FRIENDS_CAPITAL_FOOD_BONUS_AMOUNT_POST_RENAISSANCE");
	m_iFRIENDS_OTHER_CITIES_FOOD_BONUS_AMOUNT_PRE_RENAISSANCE = getDefineINT("FRIENDS_OTHER_CITIES_FOOD_BONUS_AMOUNT_PRE_RENAISSANCE");
	m_iFRIENDS_OTHER_CITIES_FOOD_BONUS_AMOUNT_POST_RENAISSANCE = getDefineINT("FRIENDS_OTHER_CITIES_FOOD_BONUS_AMOUNT_POST_RENAISSANCE");
	m_iALLIES_CAPITAL_FOOD_BONUS_AMOUNT = getDefineINT("ALLIES_CAPITAL_FOOD_BONUS_AMOUNT");
	m_iALLIES_OTHER_CITIES_FOOD_BONUS_AMOUNT = getDefineINT("ALLIES_OTHER_CITIES_FOOD_BONUS_AMOUNT");
	m_iFRIENDS_BASE_TURNS_UNIT_SPAWN = getDefineINT("FRIENDS_BASE_TURNS_UNIT_SPAWN");
	m_iFRIENDS_RAND_TURNS_UNIT_SPAWN = getDefineINT("FRIENDS_RAND_TURNS_UNIT_SPAWN");
	m_iALLIES_EXTRA_TURNS_UNIT_SPAWN = getDefineINT("ALLIES_EXTRA_TURNS_UNIT_SPAWN");
	m_iUNIT_SPAWN_BIAS_MULTIPLIER = getDefineINT("UNIT_SPAWN_BIAS_MULTIPLIER");
	m_iUNIT_SPAWN_NUM_CHOICES = getDefineINT("UNIT_SPAWN_NUM_CHOICES");
	m_iFRIENDS_HAPPINESS_FLAT_BONUS_AMOUNT_ANCIENT = getDefineINT("FRIENDS_HAPPINESS_FLAT_BONUS_AMOUNT_ANCIENT");
	m_iFRIENDS_HAPPINESS_FLAT_BONUS_AMOUNT_MEDIEVAL = getDefineINT("FRIENDS_HAPPINESS_FLAT_BONUS_AMOUNT_MEDIEVAL");
	m_iFRIENDS_HAPPINESS_FLAT_BONUS_AMOUNT_INDUSTRIAL = getDefineINT("FRIENDS_HAPPINESS_FLAT_BONUS_AMOUNT_INDUSTRIAL");
	m_iALLIES_HAPPINESS_FLAT_BONUS_AMOUNT_ANCIENT = getDefineINT("ALLIES_HAPPINESS_FLAT_BONUS_AMOUNT_ANCIENT");
	m_iALLIES_HAPPINESS_FLAT_BONUS_AMOUNT_MEDIEVAL = getDefineINT("ALLIES_HAPPINESS_FLAT_BONUS_AMOUNT_MEDIEVAL");
	m_iALLIES_HAPPINESS_FLAT_BONUS_AMOUNT_INDUSTRIAL = getDefineINT("ALLIES_HAPPINESS_FLAT_BONUS_AMOUNT_INDUSTRIAL");
	m_iFRIENDS_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_ANCIENT = getDefineINT("FRIENDS_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_ANCIENT");
	m_iFRIENDS_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_MEDIEVAL = getDefineINT("FRIENDS_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_MEDIEVAL");
	m_iFRIENDS_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_INDUSTRIAL = getDefineINT("FRIENDS_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_INDUSTRIAL");
	m_iALLIES_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_ANCIENT = getDefineINT("ALLIES_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_ANCIENT");
	m_iALLIES_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_MEDIEVAL = getDefineINT("ALLIES_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_MEDIEVAL");
	m_iALLIES_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_INDUSTRIAL = getDefineINT("ALLIES_HAPPINESS_PER_LUXURY_BONUS_AMOUNT_INDUSTRIAL");
	m_iFRIENDS_FAITH_FLAT_BONUS_AMOUNT_INDUSTRIAL = getDefineINT("FRIENDS_FAITH_FLAT_BONUS_AMOUNT_INDUSTRIAL");
	m_iFRIENDS_FAITH_FLAT_BONUS_AMOUNT_RENAISSANCE = getDefineINT("FRIENDS_FAITH_FLAT_BONUS_AMOUNT_RENAISSANCE");
	m_iFRIENDS_FAITH_FLAT_BONUS_AMOUNT_MEDIEVAL = getDefineINT("FRIENDS_FAITH_FLAT_BONUS_AMOUNT_MEDIEVAL");
	m_iFRIENDS_FAITH_FLAT_BONUS_AMOUNT_CLASSICAL = getDefineINT("FRIENDS_FAITH_FLAT_BONUS_AMOUNT_CLASSICAL");
	m_iFRIENDS_FAITH_FLAT_BONUS_AMOUNT_ANCIENT = getDefineINT("FRIENDS_FAITH_FLAT_BONUS_AMOUNT_ANCIENT");
	m_iALLIES_FAITH_FLAT_BONUS_AMOUNT_INDUSTRIAL = getDefineINT("ALLIES_FAITH_FLAT_BONUS_AMOUNT_INDUSTRIAL");
	m_iALLIES_FAITH_FLAT_BONUS_AMOUNT_RENAISSANCE = getDefineINT("ALLIES_FAITH_FLAT_BONUS_AMOUNT_RENAISSANCE");
	m_iALLIES_FAITH_FLAT_BONUS_AMOUNT_MEDIEVAL = getDefineINT("ALLIES_FAITH_FLAT_BONUS_AMOUNT_MEDIEVAL");
	m_iALLIES_FAITH_FLAT_BONUS_AMOUNT_CLASSICAL = getDefineINT("ALLIES_FAITH_FLAT_BONUS_AMOUNT_CLASSICAL");
	m_iALLIES_FAITH_FLAT_BONUS_AMOUNT_ANCIENT = getDefineINT("ALLIES_FAITH_FLAT_BONUS_AMOUNT_ANCIENT");
	m_iMINOR_TURNS_GREAT_PEOPLE_SPAWN_BASE = getDefineINT("MINOR_TURNS_GREAT_PEOPLE_SPAWN_BASE");
	m_iMINOR_TURNS_GREAT_PEOPLE_SPAWN_RAND = getDefineINT("MINOR_TURNS_GREAT_PEOPLE_SPAWN_RAND");
	m_iMINOR_TURNS_GREAT_PEOPLE_SPAWN_BIAS_MULTIPLY = getDefineINT("MINOR_TURNS_GREAT_PEOPLE_SPAWN_BIAS_MULTIPLY");
	m_iMINOR_ADDITIONAL_ALLIES_GP_CHANGE = getDefineINT("MINOR_ADDITIONAL_ALLIES_GP_CHANGE");
	m_iMAX_MINOR_ADDITIONAL_ALLIES_GP_CHANGE = getDefineINT("MAX_MINOR_ADDITIONAL_ALLIES_GP_CHANGE");
	m_iMAX_DISTANCE_MINORS_BARB_QUEST = getDefineINT("MAX_DISTANCE_MINORS_BARB_QUEST");
	m_iTXT_KEY_MINOR_GIFT_UNITS_REMINDER = getDefineINT("TXT_KEY_MINOR_GIFT_UNITS_REMINDER");
	m_iWAR_QUEST_COMPLETE_FRIENDSHIP = getDefineINT("WAR_QUEST_COMPLETE_FRIENDSHIP");
	m_iWAR_QUEST_UNITS_TO_KILL_DIVISOR = getDefineINT("WAR_QUEST_UNITS_TO_KILL_DIVISOR");
	m_iWAR_QUEST_MIN_UNITS_TO_KILL = getDefineINT("WAR_QUEST_MIN_UNITS_TO_KILL");
	m_iMINOR_QUEST_FRIENDSHIP_ROUTE = getDefineINT("MINOR_QUEST_FRIENDSHIP_ROUTE");
	m_iMINOR_QUEST_FRIENDSHIP_KILL_CAMP = getDefineINT("MINOR_QUEST_FRIENDSHIP_KILL_CAMP");
	m_iMINOR_QUEST_FRIENDSHIP_CONNECT_RESOURCE = getDefineINT("MINOR_QUEST_FRIENDSHIP_CONNECT_RESOURCE");
	m_iMINOR_QUEST_FRIENDSHIP_CONSTRUCT_WONDER = getDefineINT("MINOR_QUEST_FRIENDSHIP_CONSTRUCT_WONDER");
	m_iMINOR_QUEST_FRIENDSHIP_GREAT_PERSON = getDefineINT("MINOR_QUEST_FRIENDSHIP_GREAT_PERSON");
	m_iMINOR_QUEST_FRIENDSHIP_KILL_CITY_STATE = getDefineINT("MINOR_QUEST_FRIENDSHIP_KILL_CITY_STATE");
	m_iMINOR_QUEST_FRIENDSHIP_FIND_PLAYER = getDefineINT("MINOR_QUEST_FRIENDSHIP_FIND_PLAYER");
	m_iMINOR_QUEST_FRIENDSHIP_FIND_NATURAL_WONDER = getDefineINT("MINOR_QUEST_FRIENDSHIP_FIND_NATURAL_WONDER");
	m_iMINOR_QUEST_FRIENDSHIP_GIVE_GOLD = getDefineINT("MINOR_QUEST_FRIENDSHIP_GIVE_GOLD");
	m_iMINOR_QUEST_FRIENDSHIP_PLEDGE_TO_PROTECT = getDefineINT("MINOR_QUEST_FRIENDSHIP_PLEDGE_TO_PROTECT");
	m_iMINOR_QUEST_FRIENDSHIP_CONTEST_CULTURE = getDefineINT("MINOR_QUEST_FRIENDSHIP_CONTEST_CULTURE");
	m_iMINOR_QUEST_FRIENDSHIP_CONTEST_FAITH = getDefineINT("MINOR_QUEST_FRIENDSHIP_CONTEST_FAITH");
	m_iMINOR_QUEST_FRIENDSHIP_CONTEST_TECHS = getDefineINT("MINOR_QUEST_FRIENDSHIP_CONTEST_TECHS");
	m_iMINOR_QUEST_FRIENDSHIP_INVEST = getDefineINT("MINOR_QUEST_FRIENDSHIP_INVEST");
	m_iMINOR_QUEST_FRIENDSHIP_BULLY_CITY_STATE = getDefineINT("MINOR_QUEST_FRIENDSHIP_BULLY_CITY_STATE");
	m_iMINOR_QUEST_FRIENDSHIP_DENOUNCE_MAJOR = getDefineINT("MINOR_QUEST_FRIENDSHIP_DENOUNCE_MAJOR");
	m_iMINOR_QUEST_FRIENDSHIP_SPREAD_RELIGION = getDefineINT("MINOR_QUEST_FRIENDSHIP_SPREAD_RELIGION");
	m_iMINOR_QUEST_STANDARD_CONTEST_LENGTH = getDefineINT("MINOR_QUEST_STANDARD_CONTEST_LENGTH");
	m_iMINOR_CIV_GOLD_GIFT_GAME_MULTIPLIER = getDefineINT("MINOR_CIV_GOLD_GIFT_GAME_MULTIPLIER");
	m_iMINOR_CIV_GOLD_GIFT_GAME_DIVISOR = getDefineINT("MINOR_CIV_GOLD_GIFT_GAME_DIVISOR");
	m_iMINOR_CIV_GOLD_GIFT_VISIBLE_DIVISOR = getDefineINT("MINOR_CIV_GOLD_GIFT_VISIBLE_DIVISOR");
	m_iMINOR_CIV_GOLD_GIFT_MINIMUM_FRIENDSHIP_REWARD = getDefineINT("MINOR_CIV_GOLD_GIFT_MINIMUM_FRIENDSHIP_REWARD");
	m_iMINOR_CIV_BEST_RELATIONS_HAPPINESS_BONUS = getDefineINT("MINOR_CIV_BEST_RELATIONS_HAPPINESS_BONUS");
	m_iMINOR_CIV_RESOURCE_SEARCH_RADIUS = getDefineINT("MINOR_CIV_RESOURCE_SEARCH_RADIUS");
	m_iFRIENDSHIP_PER_UNIT_INTRUDING = getDefineINT("FRIENDSHIP_PER_UNIT_INTRUDING");
	m_iFRIENDSHIP_PER_BARB_KILLED = getDefineINT("FRIENDSHIP_PER_BARB_KILLED");
	m_iFRIENDSHIP_PER_UNIT_GIFTED = getDefineINT("FRIENDSHIP_PER_UNIT_GIFTED");
	m_iMAX_INFLUENCE_FROM_MINOR_GIFTS = getDefineINT("MAX_INFLUENCE_FROM_MINOR_GIFTS");
	m_iMINOR_LIBERATION_FRIENDSHIP = getDefineINT("MINOR_LIBERATION_FRIENDSHIP");
	m_iRETURN_CIVILIAN_FRIENDSHIP = getDefineINT("RETURN_CIVILIAN_FRIENDSHIP");
	m_iMINOR_CIV_MAX_GLOBAL_QUESTS_FOR_PLAYER = getDefineINT("MINOR_CIV_MAX_GLOBAL_QUESTS_FOR_PLAYER");
	m_iMINOR_CIV_MAX_PERSONAL_QUESTS_FOR_PLAYER = getDefineINT("MINOR_CIV_MAX_PERSONAL_QUESTS_FOR_PLAYER");
	m_iMINOR_CIV_GLOBAL_QUEST_FIRST_POSSIBLE_TURN = getDefineINT("MINOR_CIV_GLOBAL_QUEST_FIRST_POSSIBLE_TURN");
	m_iMINOR_CIV_GLOBAL_QUEST_FIRST_POSSIBLE_TURN_RAND = getDefineINT("MINOR_CIV_GLOBAL_QUEST_FIRST_POSSIBLE_TURN_RAND");
	m_iMINOR_CIV_GLOBAL_QUEST_MIN_TURNS_BETWEEN = getDefineINT("MINOR_CIV_GLOBAL_QUEST_MIN_TURNS_BETWEEN");
	m_iMINOR_CIV_GLOBAL_QUEST_RAND_TURNS_BETWEEN = getDefineINT("MINOR_CIV_GLOBAL_QUEST_RAND_TURNS_BETWEEN");
	m_iMINOR_CIV_GLOBAL_QUEST_RAND_TURNS_BETWEEN_HOSTILE_MULTIPLIER = getDefineINT("MINOR_CIV_GLOBAL_QUEST_RAND_TURNS_BETWEEN_HOSTILE_MULTIPLIER");
	m_iMINOR_CIV_PERSONAL_QUEST_FIRST_POSSIBLE_TURN = getDefineINT("MINOR_CIV_PERSONAL_QUEST_FIRST_POSSIBLE_TURN");
	m_iMINOR_CIV_PERSONAL_QUEST_FIRST_POSSIBLE_TURN_RAND = getDefineINT("MINOR_CIV_PERSONAL_QUEST_FIRST_POSSIBLE_TURN_RAND");
	m_iMINOR_CIV_PERSONAL_QUEST_MIN_TURNS_BETWEEN = getDefineINT("MINOR_CIV_PERSONAL_QUEST_MIN_TURNS_BETWEEN");
	m_iMINOR_CIV_PERSONAL_QUEST_RAND_TURNS_BETWEEN = getDefineINT("MINOR_CIV_PERSONAL_QUEST_RAND_TURNS_BETWEEN");
	m_iMINOR_CIV_PERSONAL_QUEST_RAND_TURNS_BETWEEN_HOSTILE_MULTIPLIER = getDefineINT("MINOR_CIV_PERSONAL_QUEST_RAND_TURNS_BETWEEN_HOSTILE_MULTIPLIER");
	m_iMINOR_CIV_QUEST_KILL_CAMP_RANGE = getDefineINT("MINOR_CIV_QUEST_KILL_CAMP_RANGE");
	m_iMINOR_CIV_QUEST_WONDER_COMPLETION_THRESHOLD = getDefineINT("MINOR_CIV_QUEST_WONDER_COMPLETION_THRESHOLD");
	m_iMINOR_CIV_THREATENED_BY_BARBS_NOTIF_THRESHOLD = getDefineINT("MINOR_CIV_THREATENED_BY_BARBS_NOTIF_THRESHOLD");
	m_iMINOR_CIV_MERCANTILE_RESOURCES_QUANTITY = getDefineINT("MINOR_CIV_MERCANTILE_RESOURCES_QUANTITY");
	m_iMINOR_CIV_MERCANTILE_RESOURCES_KEEP_ON_CAPTURE_DISABLED = getDefineINT("MINOR_CIV_MERCANTILE_RESOURCES_KEEP_ON_CAPTURE_DISABLED");
	m_iQUEST_DISABLED_ROUTE = getDefineINT("QUEST_DISABLED_ROUTE");
	m_iQUEST_DISABLED_KILL_CAMP = getDefineINT("QUEST_DISABLED_KILL_CAMP");
	m_iQUEST_DISABLED_CONNECT_RESOURCE = getDefineINT("QUEST_DISABLED_CONNECT_RESOURCE");
	m_iQUEST_DISABLED_CONSTRUCT_WONDER = getDefineINT("QUEST_DISABLED_CONSTRUCT_WONDER");
	m_iQUEST_DISABLED_GREAT_PERSON = getDefineINT("QUEST_DISABLED_GREAT_PERSON");
	m_iQUEST_DISABLED_KILL_CITY_STATE = getDefineINT("QUEST_DISABLED_KILL_CITY_STATE");
	m_iQUEST_DISABLED_FIND_PLAYER = getDefineINT("QUEST_DISABLED_FIND_PLAYER");
	m_iQUEST_DISABLED_NATURAL_WONDER = getDefineINT("QUEST_DISABLED_NATURAL_WONDER");
	m_iQUEST_DISABLED_GIVE_GOLD = getDefineINT("QUEST_DISABLED_GIVE_GOLD");
	m_iQUEST_DISABLED_PLEDGE_TO_PROTECT = getDefineINT("QUEST_DISABLED_PLEDGE_TO_PROTECT");
	m_iQUEST_DISABLED_CONTEST_CULTURE = getDefineINT("QUEST_DISABLED_CONTEST_CULTURE");
	m_iQUEST_DISABLED_CONTEST_FAITH = getDefineINT("QUEST_DISABLED_CONTEST_FAITH");
	m_iQUEST_DISABLED_CONTEST_TECHS = getDefineINT("QUEST_DISABLED_CONTEST_TECHS");
	m_iQUEST_DISABLED_INVEST = getDefineINT("QUEST_DISABLED_INVEST");
	m_iQUEST_DISABLED_BULLY_CITY_STATE = getDefineINT("QUEST_DISABLED_BULLY_CITY_STATE");
	m_iQUEST_DISABLED_DENOUNCE_MAJOR = getDefineINT("QUEST_DISABLED_DENOUNCE_MAJOR");
	m_iQUEST_DISABLED_SPREAD_RELIGION = getDefineINT("QUEST_DISABLED_SPREAD_RELIGION");
	m_iMINOR_CIV_QUEST_WEIGHT_DEFAULT = getDefineINT("MINOR_CIV_QUEST_WEIGHT_DEFAULT");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_FRIENDLY_ROUTE = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_FRIENDLY_ROUTE");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_HOSTILE_ROUTE = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_HOSTILE_ROUTE");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MARITIME_ROUTE = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MARITIME_ROUTE");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MERCANTILE_ROUTE = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MERCANTILE_ROUTE");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MILITARISTIC_KILL_CAMP = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MILITARISTIC_KILL_CAMP");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MARITIME_CONNECT_RESOURCE = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MARITIME_CONNECT_RESOURCE");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MERCANTILE_CONNECT_RESOURCE = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MERCANTILE_CONNECT_RESOURCE");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_CULTURED_CONSTRUCT_WONDER = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_CULTURED_CONSTRUCT_WONDER");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_CULTURED_GREAT_PERSON = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_CULTURED_GREAT_PERSON");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MILITARISTIC_KILL_CITY_STATE = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MILITARISTIC_KILL_CITY_STATE");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_HOSTILE_KILL_CITY_STATE = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_HOSTILE_KILL_CITY_STATE");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_NEUTRAL_KILL_CITY_STATE = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_NEUTRAL_KILL_CITY_STATE");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MARITIME_FIND_PLAYER = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MARITIME_FIND_PLAYER");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MERCANTILE_FIND_PLAYER = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MERCANTILE_FIND_PLAYER");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MILITARISTIC_FIND_NATURAL_WONDER = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MILITARISTIC_FIND_NATURAL_WONDER");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_HOSTILE_FIND_NATURAL_WONDER = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_HOSTILE_FIND_NATURAL_WONDER");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MILITARISTIC_GIVE_GOLD = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MILITARISTIC_GIVE_GOLD");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MERCANTILE_GIVE_GOLD = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MERCANTILE_GIVE_GOLD");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_OTHER_GIVE_GOLD = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_OTHER_GIVE_GOLD");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MILITARISTIC_PLEDGE_TO_PROTECT = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_MILITARISTIC_PLEDGE_TO_PROTECT");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_CULTURED_PLEDGE_TO_PROTECT = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_CULTURED_PLEDGE_TO_PROTECT");
	m_iMINOR_CIV_QUEST_WEIGHT_MULTIPLIER_OTHER_PLEDGE_TO_PROTECT = getDefineINT("MINOR_CIV_QUEST_WEIGHT_MULTIPLIER_OTHER_PLEDGE_TO_PROTECT");
	m_iRELIGION_BELIEF_SCORE_CITY_MULTIPLIER = getDefineINT("RELIGION_BELIEF_SCORE_CITY_MULTIPLIER");
	m_iRELIGION_BELIEF_SCORE_WORKED_PLOT_MULTIPLIER = getDefineINT("RELIGION_BELIEF_SCORE_WORKED_PLOT_MULTIPLIER");
	m_iRELIGION_BELIEF_SCORE_OWNED_PLOT_MULTIPLIER = getDefineINT("RELIGION_BELIEF_SCORE_OWNED_PLOT_MULTIPLIER");
	m_iRELIGION_BELIEF_SCORE_UNOWNED_PLOT_MULTIPLIER = getDefineINT("RELIGION_BELIEF_SCORE_UNOWNED_PLOT_MULTIPLIER");
	m_iRELIGION_MISSIONARY_RANGE_IN_TURNS = getDefineINT("RELIGION_MISSIONARY_RANGE_IN_TURNS");
	m_iRELIGION_MAX_MISSIONARIES = getDefineINT("RELIGION_MAX_MISSIONARIES");
	m_fNORMAL_ANNEX = getDefineFLOAT("NORMAL_ANNEX");
	m_fAGGRESSIVE_ANNEX = getDefineFLOAT("AGGRESSIVE_ANNEX");
	m_iMC_GIFT_WEIGHT_THRESHOLD = getDefineINT("MC_GIFT_WEIGHT_THRESHOLD");
	m_iMC_ALWAYS_GIFT_DIPLO_THRESHOLD = getDefineINT("MC_ALWAYS_GIFT_DIPLO_THRESHOLD");
	m_iMC_SOMETIMES_GIFT_RAND_MULTIPLIER = getDefineINT("MC_SOMETIMES_GIFT_RAND_MULTIPLIER");
	m_iMC_SMALL_GIFT_WEIGHT_PASS_OTHER_PLAYER = getDefineINT("MC_SMALL_GIFT_WEIGHT_PASS_OTHER_PLAYER");
	m_iMC_GIFT_WEIGHT_PASS_OTHER_PLAYER = getDefineINT("MC_GIFT_WEIGHT_PASS_OTHER_PLAYER");
	m_iMC_GIFT_WEIGHT_MARITIME_GROWTH = getDefineINT("MC_GIFT_WEIGHT_MARITIME_GROWTH");
	m_iMC_GIFT_WEIGHT_DIPLO_VICTORY = getDefineINT("MC_GIFT_WEIGHT_DIPLO_VICTORY");
	m_iMC_GIFT_WEIGHT_CULTURE_VICTORY = getDefineINT("MC_GIFT_WEIGHT_CULTURE_VICTORY");
	m_iMC_GIFT_WEIGHT_CONQUEST_VICTORY = getDefineINT("MC_GIFT_WEIGHT_CONQUEST_VICTORY");
	m_iMC_GIFT_WEIGHT_MILITARISTIC = getDefineINT("MC_GIFT_WEIGHT_MILITARISTIC");
	m_iMC_GIFT_WEIGHT_RESOURCE_WE_NEED = getDefineINT("MC_GIFT_WEIGHT_RESOURCE_WE_NEED");
	m_iMC_GIFT_WEIGHT_NEUTRAL_VICTORY_ROLL = getDefineINT("MC_GIFT_WEIGHT_NEUTRAL_VICTORY_ROLL");
	m_iMC_GIFT_WEIGHT_PROTECTIVE = getDefineINT("MC_GIFT_WEIGHT_PROTECTIVE");
	m_iMC_GIFT_WEIGHT_HOSTILE = getDefineINT("MC_GIFT_WEIGHT_HOSTILE");
	m_iMC_GIFT_WEIGHT_NEIGHBORS = getDefineINT("MC_GIFT_WEIGHT_NEIGHBORS");
	m_iMC_GIFT_WEIGHT_CLOSE = getDefineINT("MC_GIFT_WEIGHT_CLOSE");
	m_iMC_GIFT_WEIGHT_FAR = getDefineINT("MC_GIFT_WEIGHT_FAR");
	m_iMC_GIFT_WEIGHT_ALMOST_NOT_ALLIES = getDefineINT("MC_GIFT_WEIGHT_ALMOST_NOT_ALLIES");
	m_iMC_GIFT_WEIGHT_ALMOST_NOT_FRIENDS = getDefineINT("MC_GIFT_WEIGHT_ALMOST_NOT_FRIENDS");
	m_iOPINION_WEIGHT_LAND_FIERCE = getDefineINT("OPINION_WEIGHT_LAND_FIERCE");
	m_iOPINION_WEIGHT_LAND_STRONG = getDefineINT("OPINION_WEIGHT_LAND_STRONG");
	m_iOPINION_WEIGHT_LAND_WEAK = getDefineINT("OPINION_WEIGHT_LAND_WEAK");
	m_iOPINION_WEIGHT_LAND_NONE = getDefineINT("OPINION_WEIGHT_LAND_NONE");
	m_iOPINION_WEIGHT_VICTORY_FIERCE = getDefineINT("OPINION_WEIGHT_VICTORY_FIERCE");
	m_iOPINION_WEIGHT_VICTORY_STRONG = getDefineINT("OPINION_WEIGHT_VICTORY_STRONG");
	m_iOPINION_WEIGHT_VICTORY_WEAK = getDefineINT("OPINION_WEIGHT_VICTORY_WEAK");
	m_iOPINION_WEIGHT_VICTORY_NONE = getDefineINT("OPINION_WEIGHT_VICTORY_NONE");
	m_iOPINION_WEIGHT_WONDER_FIERCE = getDefineINT("OPINION_WEIGHT_WONDER_FIERCE");
	m_iOPINION_WEIGHT_WONDER_STRONG = getDefineINT("OPINION_WEIGHT_WONDER_STRONG");
	m_iOPINION_WEIGHT_WONDER_WEAK = getDefineINT("OPINION_WEIGHT_WONDER_WEAK");
	m_iOPINION_WEIGHT_WONDER_NONE = getDefineINT("OPINION_WEIGHT_WONDER_NONE");
	m_iOPINION_WEIGHT_MINOR_CIV_FIERCE = getDefineINT("OPINION_WEIGHT_MINOR_CIV_FIERCE");
	m_iOPINION_WEIGHT_MINOR_CIV_STRONG = getDefineINT("OPINION_WEIGHT_MINOR_CIV_STRONG");
	m_iOPINION_WEIGHT_MINOR_CIV_WEAK = getDefineINT("OPINION_WEIGHT_MINOR_CIV_WEAK");
	m_iOPINION_WEIGHT_MINOR_CIV_NONE = getDefineINT("OPINION_WEIGHT_MINOR_CIV_NONE");
	m_iOPINION_WEIGHT_WARMONGER_CRITICAL = getDefineINT("OPINION_WEIGHT_WARMONGER_CRITICAL");
	m_iOPINION_WEIGHT_WARMONGER_SEVERE = getDefineINT("OPINION_WEIGHT_WARMONGER_SEVERE");
	m_iOPINION_WEIGHT_WARMONGER_MAJOR = getDefineINT("OPINION_WEIGHT_WARMONGER_MAJOR");
	m_iOPINION_WEIGHT_WARMONGER_MINOR = getDefineINT("OPINION_WEIGHT_WARMONGER_MINOR");
	m_iOPINION_WEIGHT_WARMONGER_NONE = getDefineINT("OPINION_WEIGHT_WARMONGER_NONE");
	m_iOPINION_WEIGHT_ASKED_NO_SETTLE = getDefineINT("OPINION_WEIGHT_ASKED_NO_SETTLE");
	m_iOPINION_WEIGHT_ASKED_STOP_SPYING = getDefineINT("OPINION_WEIGHT_ASKED_STOP_SPYING");
	m_iOPINION_WEIGHT_MADE_DEMAND_OF_US = getDefineINT("OPINION_WEIGHT_MADE_DEMAND_OF_US");
	m_iOPINION_WEIGHT_RETURNED_CIVILIAN = getDefineINT("OPINION_WEIGHT_RETURNED_CIVILIAN");
	m_iOPINION_WEIGHT_RESURRECTED = getDefineINT("OPINION_WEIGHT_RESURRECTED");
	m_iOPINION_WEIGHT_LIBERATED_ONE_CITY = getDefineINT("OPINION_WEIGHT_LIBERATED_ONE_CITY");
	m_iOPINION_WEIGHT_LIBERATED_TWO_CITIES = getDefineINT("OPINION_WEIGHT_LIBERATED_TWO_CITIES");
	m_iOPINION_WEIGHT_LIBERATED_THREE_CITIES = getDefineINT("OPINION_WEIGHT_LIBERATED_THREE_CITIES");
	m_iOPINION_WEIGHT_EMBASSY = getDefineINT("OPINION_WEIGHT_EMBASSY");
	m_iOPINION_WEIGHT_CULTURE_BOMBED = getDefineINT("OPINION_WEIGHT_CULTURE_BOMBED");
	m_iOPINION_WEIGHT_PER_NEGATIVE_CONVERSION = getDefineINT("OPINION_WEIGHT_PER_NEGATIVE_CONVERSION");
	m_iOPINION_WEIGHT_ADOPTING_HIS_RELIGION = getDefineINT("OPINION_WEIGHT_ADOPTING_HIS_RELIGION");
	m_iOPINION_WEIGHT_ADOPTING_MY_RELIGION = getDefineINT("OPINION_WEIGHT_ADOPTING_MY_RELIGION");
	m_iOPINION_WEIGHT_SAME_LATE_POLICIES = getDefineINT("OPINION_WEIGHT_SAME_LATE_POLICIES");
	m_iOPINION_WEIGHT_DIFFERENT_LATE_POLICIES = getDefineINT("OPINION_WEIGHT_DIFFERENT_LATE_POLICIES");
	m_iOPINION_WEIGHT_BROKEN_MILITARY_PROMISE = getDefineINT("OPINION_WEIGHT_BROKEN_MILITARY_PROMISE");
	m_iOPINION_WEIGHT_BROKEN_MILITARY_PROMISE_WORLD = getDefineINT("OPINION_WEIGHT_BROKEN_MILITARY_PROMISE_WORLD");
	m_iOPINION_WEIGHT_IGNORED_MILITARY_PROMISE = getDefineINT("OPINION_WEIGHT_IGNORED_MILITARY_PROMISE");
	m_iOPINION_WEIGHT_BROKEN_EXPANSION_PROMISE = getDefineINT("OPINION_WEIGHT_BROKEN_EXPANSION_PROMISE");
	m_iOPINION_WEIGHT_IGNORED_EXPANSION_PROMISE = getDefineINT("OPINION_WEIGHT_IGNORED_EXPANSION_PROMISE");
	m_iOPINION_WEIGHT_BROKEN_BORDER_PROMISE = getDefineINT("OPINION_WEIGHT_BROKEN_BORDER_PROMISE");
	m_iOPINION_WEIGHT_IGNORED_BORDER_PROMISE = getDefineINT("OPINION_WEIGHT_IGNORED_BORDER_PROMISE");
	m_iOPINION_WEIGHT_BROKEN_CITY_STATE_PROMISE = getDefineINT("OPINION_WEIGHT_BROKEN_CITY_STATE_PROMISE");
	m_iOPINION_WEIGHT_BROKEN_CITY_STATE_PROMISE_WORLD = getDefineINT("OPINION_WEIGHT_BROKEN_CITY_STATE_PROMISE_WORLD");
	m_iOPINION_WEIGHT_IGNORED_CITY_STATE_PROMISE = getDefineINT("OPINION_WEIGHT_IGNORED_CITY_STATE_PROMISE");
	m_iOPINION_WEIGHT_BROKEN_SPY_PROMISE = getDefineINT("OPINION_WEIGHT_BROKEN_SPY_PROMISE");
	m_iOPINION_WEIGHT_IGNORED_SPY_PROMISE = getDefineINT("OPINION_WEIGHT_IGNORED_SPY_PROMISE");
	m_iOPINION_WEIGHT_FORGAVE_FOR_SPYING = getDefineINT("OPINION_WEIGHT_FORGAVE_FOR_SPYING");
	m_iOPINION_WEIGHT_BROKEN_NO_CONVERT_PROMISE = getDefineINT("OPINION_WEIGHT_BROKEN_NO_CONVERT_PROMISE");
	m_iOPINION_WEIGHT_IGNORED_NO_CONVERT_PROMISE = getDefineINT("OPINION_WEIGHT_IGNORED_NO_CONVERT_PROMISE");
	m_iOPINION_WEIGHT_BROKEN_COOP_WAR_PROMISE = getDefineINT("OPINION_WEIGHT_BROKEN_COOP_WAR_PROMISE");
	m_iOPINION_WEIGHT_KILLED_PROTECTED_MINOR_NUM_TURNS_UNTIL_FORGIVEN = getDefineINT("OPINION_WEIGHT_KILLED_PROTECTED_MINOR_NUM_TURNS_UNTIL_FORGIVEN");
	m_iOPINION_WEIGHT_KILLED_PROTECTED_MINOR = getDefineINT("OPINION_WEIGHT_KILLED_PROTECTED_MINOR");
	m_iOPINION_WEIGHT_KILLED_MANY_PROTECTED_MINORS = getDefineINT("OPINION_WEIGHT_KILLED_MANY_PROTECTED_MINORS");
	m_iOPINION_WEIGHT_ATTACKED_PROTECTED_MINOR_NUM_TURNS_UNTIL_FORGIVEN = getDefineINT("OPINION_WEIGHT_ATTACKED_PROTECTED_MINOR_NUM_TURNS_UNTIL_FORGIVEN");
	m_iOPINION_WEIGHT_ATTACKED_PROTECTED_MINOR_RECENTLY_NUM_TURNS = getDefineINT("OPINION_WEIGHT_ATTACKED_PROTECTED_MINOR_RECENTLY_NUM_TURNS");
	m_iOPINION_WEIGHT_ATTACKED_PROTECTED_MINOR_RECENTLY = getDefineINT("OPINION_WEIGHT_ATTACKED_PROTECTED_MINOR_RECENTLY");
	m_iOPINION_WEIGHT_ATTACKED_PROTECTED_MINOR_WHILE_AGO = getDefineINT("OPINION_WEIGHT_ATTACKED_PROTECTED_MINOR_WHILE_AGO");
	m_iOPINION_WEIGHT_ATTACKED_MANY_PROTECTED_MINORS = getDefineINT("OPINION_WEIGHT_ATTACKED_MANY_PROTECTED_MINORS");
	m_iOPINION_WEIGHT_BULLIED_PROTECTED_MINOR_NUM_TURNS_UNTIL_FORGIVEN = getDefineINT("OPINION_WEIGHT_BULLIED_PROTECTED_MINOR_NUM_TURNS_UNTIL_FORGIVEN");
	m_iOPINION_WEIGHT_BULLIED_PROTECTED_MINOR_RECENTLY_NUM_TURNS = getDefineINT("OPINION_WEIGHT_BULLIED_PROTECTED_MINOR_RECENTLY_NUM_TURNS");
	m_iOPINION_WEIGHT_BULLIED_PROTECTED_MINOR_RECENTLY = getDefineINT("OPINION_WEIGHT_BULLIED_PROTECTED_MINOR_RECENTLY");
	m_iOPINION_WEIGHT_BULLIED_PROTECTED_MINOR_WHILE_AGO = getDefineINT("OPINION_WEIGHT_BULLIED_PROTECTED_MINOR_WHILE_AGO");
	m_iOPINION_WEIGHT_BULLIED_MANY_PROTECTED_MINORS = getDefineINT("OPINION_WEIGHT_BULLIED_MANY_PROTECTED_MINORS");
	m_iOPINION_WEIGHT_SIDED_WITH_THEIR_MINOR_NUM_TURNS_UNTIL_FORGIVEN = getDefineINT("OPINION_WEIGHT_SIDED_WITH_THEIR_MINOR_NUM_TURNS_UNTIL_FORGIVEN");
	m_iOPINION_WEIGHT_SIDED_WITH_THEIR_MINOR = getDefineINT("OPINION_WEIGHT_SIDED_WITH_THEIR_MINOR");
	m_iOPINION_WEIGHT_DOF = getDefineINT("OPINION_WEIGHT_DOF");
	m_iOPINION_WEIGHT_DOF_WITH_FRIEND = getDefineINT("OPINION_WEIGHT_DOF_WITH_FRIEND");
	m_iOPINION_WEIGHT_DOF_WITH_ENEMY = getDefineINT("OPINION_WEIGHT_DOF_WITH_ENEMY");
	m_iOPINION_WEIGHT_DENOUNCED_BY_FRIEND_EACH = getDefineINT("OPINION_WEIGHT_DENOUNCED_BY_FRIEND_EACH");
	m_iOPINION_WEIGHT_DENOUNCED_BY_FRIEND_DONT_LIKE = getDefineINT("OPINION_WEIGHT_DENOUNCED_BY_FRIEND_DONT_LIKE");
	m_iOPINION_WEIGHT_DENOUNCED_FRIEND_EACH = getDefineINT("OPINION_WEIGHT_DENOUNCED_FRIEND_EACH");
	m_iOPINION_WEIGHT_DENOUNCED_ME_FRIENDS = getDefineINT("OPINION_WEIGHT_DENOUNCED_ME_FRIENDS");
	m_iOPINION_WEIGHT_WAR_FRIEND_EACH = getDefineINT("OPINION_WEIGHT_WAR_FRIEND_EACH");
	m_iOPINION_WEIGHT_WAR_ME_FRIENDS = getDefineINT("OPINION_WEIGHT_WAR_ME_FRIENDS");
	m_iOPINION_WEIGHT_REFUSED_REQUEST_EACH = getDefineINT("OPINION_WEIGHT_REFUSED_REQUEST_EACH");
	m_iOPINION_WEIGHT_DENOUNCED_ME = getDefineINT("OPINION_WEIGHT_DENOUNCED_ME");
	m_iOPINION_WEIGHT_DENOUNCED_THEM = getDefineINT("OPINION_WEIGHT_DENOUNCED_THEM");
	m_iOPINION_WEIGHT_DENOUNCED_FRIEND = getDefineINT("OPINION_WEIGHT_DENOUNCED_FRIEND");
	m_iOPINION_WEIGHT_DENOUNCED_ENEMY = getDefineINT("OPINION_WEIGHT_DENOUNCED_ENEMY");
	m_iOPINION_WEIGHT_RECKLESS_EXPANDER = getDefineINT("OPINION_WEIGHT_RECKLESS_EXPANDER");
	m_iOPINION_WEIGHT_TRADE_MAX = getDefineINT("OPINION_WEIGHT_TRADE_MAX");
	m_iOPINION_WEIGHT_COMMON_FOE_MAX = getDefineINT("OPINION_WEIGHT_COMMON_FOE_MAX");
	m_iOPINION_WEIGHT_ASSIST_MAX = getDefineINT("OPINION_WEIGHT_ASSIST_MAX");
	m_iOPINION_WEIGHT_LIBERATED_CAPITAL = getDefineINT("OPINION_WEIGHT_LIBERATED_CAPITAL");
	m_iOPINION_WEIGHT_LIBERATED_CITY = getDefineINT("OPINION_WEIGHT_LIBERATED_CITY");
	m_iOPINION_WEIGHT_GAVE_ASSISTANCE = getDefineINT("OPINION_WEIGHT_GAVE_ASSISTANCE");
	m_iOPINION_WEIGHT_PAID_TRIBUTE = getDefineINT("OPINION_WEIGHT_PAID_TRIBUTE");
	m_iOPINION_WEIGHT_NUKED_MAX = getDefineINT("OPINION_WEIGHT_NUKED_MAX");
	m_iOPINION_WEIGHT_ROBBED_BY = getDefineINT("OPINION_WEIGHT_ROBBED_BY");
	m_iOPINION_WEIGHT_INTRIGUE_SHARED_BY = getDefineINT("OPINION_WEIGHT_INTRIGUE_SHARED_BY");
	m_iOPINION_WEIGHT_CAPTURED_CAPITAL = getDefineINT("OPINION_WEIGHT_CAPTURED_CAPITAL");
	m_iOPINION_THRESHOLD_UNFORGIVABLE = getDefineINT("OPINION_THRESHOLD_UNFORGIVABLE");
	m_iOPINION_THRESHOLD_ENEMY = getDefineINT("OPINION_THRESHOLD_ENEMY");
	m_iOPINION_THRESHOLD_COMPETITOR = getDefineINT("OPINION_THRESHOLD_COMPETITOR");
	m_iOPINION_THRESHOLD_FAVORABLE = getDefineINT("OPINION_THRESHOLD_FAVORABLE");
	m_iOPINION_THRESHOLD_FRIEND = getDefineINT("OPINION_THRESHOLD_FRIEND");
	m_iOPINION_THRESHOLD_ALLY = getDefineINT("OPINION_THRESHOLD_ALLY");
	m_iAPPROACH_NEUTRAL_DEFAULT = getDefineINT("APPROACH_NEUTRAL_DEFAULT");
	m_iAPPROACH_BIAS_FOR_CURRENT = getDefineINT("APPROACH_BIAS_FOR_CURRENT");
	m_iAPPROACH_WAR_CURRENTLY_DECEPTIVE = getDefineINT("APPROACH_WAR_CURRENTLY_DECEPTIVE");
	m_iAPPROACH_HOSTILE_CURRENTLY_HOSTILE = getDefineINT("APPROACH_HOSTILE_CURRENTLY_HOSTILE");
	m_iAPPROACH_WAR_CURRENTLY_WAR = getDefineINT("APPROACH_WAR_CURRENTLY_WAR");
	m_iAPPROACH_RANDOM_PERCENT = getDefineINT("APPROACH_RANDOM_PERCENT");
	m_iAPPROACH_WAR_CONQUEST_GRAND_STRATEGY = getDefineINT("APPROACH_WAR_CONQUEST_GRAND_STRATEGY");
	m_iAPPROACH_OPINION_UNFORGIVABLE_WAR = getDefineINT("APPROACH_OPINION_UNFORGIVABLE_WAR");
	m_iAPPROACH_OPINION_UNFORGIVABLE_HOSTILE = getDefineINT("APPROACH_OPINION_UNFORGIVABLE_HOSTILE");
	m_iAPPROACH_OPINION_UNFORGIVABLE_DECEPTIVE = getDefineINT("APPROACH_OPINION_UNFORGIVABLE_DECEPTIVE");
	m_iAPPROACH_OPINION_UNFORGIVABLE_GUARDED = getDefineINT("APPROACH_OPINION_UNFORGIVABLE_GUARDED");
	m_iAPPROACH_OPINION_ENEMY_WAR = getDefineINT("APPROACH_OPINION_ENEMY_WAR");
	m_iAPPROACH_OPINION_ENEMY_HOSTILE = getDefineINT("APPROACH_OPINION_ENEMY_HOSTILE");
	m_iAPPROACH_OPINION_ENEMY_DECEPTIVE = getDefineINT("APPROACH_OPINION_ENEMY_DECEPTIVE");
	m_iAPPROACH_OPINION_ENEMY_GUARDED = getDefineINT("APPROACH_OPINION_ENEMY_GUARDED");
	m_iAPPROACH_OPINION_COMPETITOR_WAR = getDefineINT("APPROACH_OPINION_COMPETITOR_WAR");
	m_iAPPROACH_OPINION_COMPETITOR_HOSTILE = getDefineINT("APPROACH_OPINION_COMPETITOR_HOSTILE");
	m_iAPPROACH_OPINION_COMPETITOR_DECEPTIVE = getDefineINT("APPROACH_OPINION_COMPETITOR_DECEPTIVE");
	m_iAPPROACH_OPINION_COMPETITOR_GUARDED = getDefineINT("APPROACH_OPINION_COMPETITOR_GUARDED");
	m_iAPPROACH_OPINION_NEUTRAL_DECEPTIVE = getDefineINT("APPROACH_OPINION_NEUTRAL_DECEPTIVE");
	m_iAPPROACH_OPINION_NEUTRAL_FRIENDLY = getDefineINT("APPROACH_OPINION_NEUTRAL_FRIENDLY");
	m_iAPPROACH_OPINION_FAVORABLE_HOSTILE = getDefineINT("APPROACH_OPINION_FAVORABLE_HOSTILE");
	m_iAPPROACH_OPINION_FAVORABLE_DECEPTIVE = getDefineINT("APPROACH_OPINION_FAVORABLE_DECEPTIVE");
	m_iAPPROACH_OPINION_FAVORABLE_FRIENDLY = getDefineINT("APPROACH_OPINION_FAVORABLE_FRIENDLY");
	m_iAPPROACH_OPINION_FRIEND_HOSTILE = getDefineINT("APPROACH_OPINION_FRIEND_HOSTILE");
	m_iAPPROACH_OPINION_FRIEND_FRIENDLY = getDefineINT("APPROACH_OPINION_FRIEND_FRIENDLY");
	m_iAPPROACH_OPINION_ALLY_FRIENDLY = getDefineINT("APPROACH_OPINION_ALLY_FRIENDLY");
	m_iAPPROACH_DECEPTIVE_WORKING_WITH_PLAYER = getDefineINT("APPROACH_DECEPTIVE_WORKING_WITH_PLAYER");
	m_iAPPROACH_FRIENDLY_WORKING_WITH_PLAYER = getDefineINT("APPROACH_FRIENDLY_WORKING_WITH_PLAYER");
	m_iAPPROACH_HOSTILE_WORKING_WITH_PLAYER = getDefineINT("APPROACH_HOSTILE_WORKING_WITH_PLAYER");
	m_iAPPROACH_GUARDED_WORKING_WITH_PLAYER = getDefineINT("APPROACH_GUARDED_WORKING_WITH_PLAYER");
	m_iAPPROACH_DECEPTIVE_WORKING_AGAINST_PLAYER = getDefineINT("APPROACH_DECEPTIVE_WORKING_AGAINST_PLAYER");
	m_iAPPROACH_HOSTILE_WORKING_AGAINST_PLAYER = getDefineINT("APPROACH_HOSTILE_WORKING_AGAINST_PLAYER");
	m_iAPPROACH_WAR_WORKING_AGAINST_PLAYER = getDefineINT("APPROACH_WAR_WORKING_AGAINST_PLAYER");
	m_iAPPROACH_WAR_DENOUNCED = getDefineINT("APPROACH_WAR_DENOUNCED");
	m_iAPPROACH_HOSTILE_DENOUNCED = getDefineINT("APPROACH_HOSTILE_DENOUNCED");
	m_iAPPROACH_GUARDED_DENOUNCED = getDefineINT("APPROACH_GUARDED_DENOUNCED");
	m_iAPPROACH_FRIENDLY_DENOUNCED = getDefineINT("APPROACH_FRIENDLY_DENOUNCED");
	m_iAPPROACH_DECEPTIVE_DENOUNCED = getDefineINT("APPROACH_DECEPTIVE_DENOUNCED");
	m_iAPPROACH_ATTACKED_PROTECTED_MINOR_WAR = getDefineINT("APPROACH_ATTACKED_PROTECTED_MINOR_WAR");
	m_iAPPROACH_ATTACKED_PROTECTED_MINOR_HOSTILE = getDefineINT("APPROACH_ATTACKED_PROTECTED_MINOR_HOSTILE");
	m_iAPPROACH_ATTACKED_PROTECTED_MINOR_GUARDED = getDefineINT("APPROACH_ATTACKED_PROTECTED_MINOR_GUARDED");
	m_iAPPROACH_ATTACKED_PROTECTED_MINOR_PAST_WAR = getDefineINT("APPROACH_ATTACKED_PROTECTED_MINOR_PAST_WAR");
	m_iAPPROACH_ATTACKED_PROTECTED_MINOR_PAST_HOSTILE = getDefineINT("APPROACH_ATTACKED_PROTECTED_MINOR_PAST_HOSTILE");
	m_iAPPROACH_ATTACKED_PROTECTED_MINOR_PAST_GUARDED = getDefineINT("APPROACH_ATTACKED_PROTECTED_MINOR_PAST_GUARDED");
	m_iAPPROACH_DECEPTIVE_MILITARY_THREAT_CRITICAL = getDefineINT("APPROACH_DECEPTIVE_MILITARY_THREAT_CRITICAL");
	m_iAPPROACH_GUARDED_MILITARY_THREAT_CRITICAL = getDefineINT("APPROACH_GUARDED_MILITARY_THREAT_CRITICAL");
	m_iAPPROACH_AFRAID_MILITARY_THREAT_CRITICAL = getDefineINT("APPROACH_AFRAID_MILITARY_THREAT_CRITICAL");
	m_iAPPROACH_DECEPTIVE_DEMAND = getDefineINT("APPROACH_DECEPTIVE_DEMAND");
	m_iAPPROACH_FRIENDLY_DEMAND = getDefineINT("APPROACH_FRIENDLY_DEMAND");
	m_iAPPROACH_WAR_BROKEN_MILITARY_PROMISE = getDefineINT("APPROACH_WAR_BROKEN_MILITARY_PROMISE");
	m_iAPPROACH_DECEPTIVE_BROKEN_MILITARY_PROMISE = getDefineINT("APPROACH_DECEPTIVE_BROKEN_MILITARY_PROMISE");
	m_iAPPROACH_FRIENDLY_BROKEN_MILITARY_PROMISE = getDefineINT("APPROACH_FRIENDLY_BROKEN_MILITARY_PROMISE");
	m_iAPPROACH_WAR_BROKEN_MILITARY_PROMISE_WORLD = getDefineINT("APPROACH_WAR_BROKEN_MILITARY_PROMISE_WORLD");
	m_iAPPROACH_DECEPTIVE_BROKEN_MILITARY_PROMISE_WORLD = getDefineINT("APPROACH_DECEPTIVE_BROKEN_MILITARY_PROMISE_WORLD");
	m_iAPPROACH_FRIENDLY_BROKEN_MILITARY_PROMISE_WORLD = getDefineINT("APPROACH_FRIENDLY_BROKEN_MILITARY_PROMISE_WORLD");
	m_iAPPROACH_DECEPTIVE_IGNORED_MILITARY_PROMISE = getDefineINT("APPROACH_DECEPTIVE_IGNORED_MILITARY_PROMISE");
	m_iAPPROACH_FRIENDLY_IGNORED_MILITARY_PROMISE = getDefineINT("APPROACH_FRIENDLY_IGNORED_MILITARY_PROMISE");
	m_iAPPROACH_WAR_BROKEN_EXPANSION_PROMISE = getDefineINT("APPROACH_WAR_BROKEN_EXPANSION_PROMISE");
	m_iAPPROACH_DECEPTIVE_BROKEN_EXPANSION_PROMISE = getDefineINT("APPROACH_DECEPTIVE_BROKEN_EXPANSION_PROMISE");
	m_iAPPROACH_FRIENDLY_BROKEN_EXPANSION_PROMISE = getDefineINT("APPROACH_FRIENDLY_BROKEN_EXPANSION_PROMISE");
	m_iAPPROACH_WAR_IGNORED_EXPANSION_PROMISE = getDefineINT("APPROACH_WAR_IGNORED_EXPANSION_PROMISE");
	m_iAPPROACH_DECEPTIVE_IGNORED_EXPANSION_PROMISE = getDefineINT("APPROACH_DECEPTIVE_IGNORED_EXPANSION_PROMISE");
	m_iAPPROACH_FRIENDLY_IGNORED_EXPANSION_PROMISE = getDefineINT("APPROACH_FRIENDLY_IGNORED_EXPANSION_PROMISE");
	m_iAPPROACH_WAR_BROKEN_BORDER_PROMISE = getDefineINT("APPROACH_WAR_BROKEN_BORDER_PROMISE");
	m_iAPPROACH_DECEPTIVE_BROKEN_BORDER_PROMISE = getDefineINT("APPROACH_DECEPTIVE_BROKEN_BORDER_PROMISE");
	m_iAPPROACH_FRIENDLY_BROKEN_BORDER_PROMISE = getDefineINT("APPROACH_FRIENDLY_BROKEN_BORDER_PROMISE");
	m_iAPPROACH_WAR_IGNORED_BORDER_PROMISE = getDefineINT("APPROACH_WAR_IGNORED_BORDER_PROMISE");
	m_iAPPROACH_DECEPTIVE_IGNORED_BORDER_PROMISE = getDefineINT("APPROACH_DECEPTIVE_IGNORED_BORDER_PROMISE");
	m_iAPPROACH_FRIENDLY_IGNORED_BORDER_PROMISE = getDefineINT("APPROACH_FRIENDLY_IGNORED_BORDER_PROMISE");
	m_iAPPROACH_WAR_BROKEN_CITY_STATE_PROMISE = getDefineINT("APPROACH_WAR_BROKEN_CITY_STATE_PROMISE");
	m_iAPPROACH_DECEPTIVE_BROKEN_CITY_STATE_PROMISE = getDefineINT("APPROACH_DECEPTIVE_BROKEN_CITY_STATE_PROMISE");
	m_iAPPROACH_FRIENDLY_BROKEN_CITY_STATE_PROMISE = getDefineINT("APPROACH_FRIENDLY_BROKEN_CITY_STATE_PROMISE");
	m_iAPPROACH_WAR_BROKEN_CITY_STATE_PROMISE_WORLD = getDefineINT("APPROACH_WAR_BROKEN_CITY_STATE_PROMISE_WORLD");
	m_iAPPROACH_DECEPTIVE_BROKEN_CITY_STATE_PROMISE_WORLD = getDefineINT("APPROACH_DECEPTIVE_BROKEN_CITY_STATE_PROMISE_WORLD");
	m_iAPPROACH_FRIENDLY_BROKEN_CITY_STATE_PROMISE_WORLD = getDefineINT("APPROACH_FRIENDLY_BROKEN_CITY_STATE_PROMISE_WORLD");
	m_iAPPROACH_WAR_IGNORED_CITY_STATE_PROMISE = getDefineINT("APPROACH_WAR_IGNORED_CITY_STATE_PROMISE");
	m_iAPPROACH_DECEPTIVE_IGNORED_CITY_STATE_PROMISE = getDefineINT("APPROACH_DECEPTIVE_IGNORED_CITY_STATE_PROMISE");
	m_iAPPROACH_FRIENDLY_IGNORED_CITY_STATE_PROMISE = getDefineINT("APPROACH_FRIENDLY_IGNORED_CITY_STATE_PROMISE");
	m_iAPPROACH_FRIENDLY_MILITARY_THREAT_CRITICAL = getDefineINT("APPROACH_FRIENDLY_MILITARY_THREAT_CRITICAL");
	m_iAPPROACH_DECEPTIVE_MILITARY_THREAT_SEVERE = getDefineINT("APPROACH_DECEPTIVE_MILITARY_THREAT_SEVERE");
	m_iAPPROACH_GUARDED_MILITARY_THREAT_SEVERE = getDefineINT("APPROACH_GUARDED_MILITARY_THREAT_SEVERE");
	m_iAPPROACH_AFRAID_MILITARY_THREAT_SEVERE = getDefineINT("APPROACH_AFRAID_MILITARY_THREAT_SEVERE");
	m_iAPPROACH_FRIENDLY_MILITARY_THREAT_SEVERE = getDefineINT("APPROACH_FRIENDLY_MILITARY_THREAT_SEVERE");
	m_iAPPROACH_DECEPTIVE_MILITARY_THREAT_MAJOR = getDefineINT("APPROACH_DECEPTIVE_MILITARY_THREAT_MAJOR");
	m_iAPPROACH_GUARDED_MILITARY_THREAT_MAJOR = getDefineINT("APPROACH_GUARDED_MILITARY_THREAT_MAJOR");
	m_iAPPROACH_AFRAID_MILITARY_THREAT_MAJOR = getDefineINT("APPROACH_AFRAID_MILITARY_THREAT_MAJOR");
	m_iAPPROACH_FRIENDLY_MILITARY_THREAT_MAJOR = getDefineINT("APPROACH_FRIENDLY_MILITARY_THREAT_MAJOR");
	m_iAPPROACH_DECEPTIVE_MILITARY_THREAT_MINOR = getDefineINT("APPROACH_DECEPTIVE_MILITARY_THREAT_MINOR");
	m_iAPPROACH_GUARDED_MILITARY_THREAT_MINOR = getDefineINT("APPROACH_GUARDED_MILITARY_THREAT_MINOR");
	m_iAPPROACH_AFRAID_MILITARY_THREAT_MINOR = getDefineINT("APPROACH_AFRAID_MILITARY_THREAT_MINOR");
	m_iAPPROACH_FRIENDLY_MILITARY_THREAT_MINOR = getDefineINT("APPROACH_FRIENDLY_MILITARY_THREAT_MINOR");
	m_iAPPROACH_HOSTILE_MILITARY_THREAT_NONE = getDefineINT("APPROACH_HOSTILE_MILITARY_THREAT_NONE");
	m_iAPPROACH_WAR_AT_WAR_WITH_PLAYER_WARS_NEUTRAL = getDefineINT("APPROACH_WAR_AT_WAR_WITH_PLAYER_WARS_NEUTRAL");
	m_iAPPROACH_WAR_AT_WAR_WITH_PLAYER_WARS_WINNING = getDefineINT("APPROACH_WAR_AT_WAR_WITH_PLAYER_WARS_WINNING");
	m_iAPPROACH_WAR_AT_WAR_WITH_PLAYER_WARS_LOSING = getDefineINT("APPROACH_WAR_AT_WAR_WITH_PLAYER_WARS_LOSING");
	m_iAPPROACH_HOSTILE_AT_WAR_WITH_PLAYER = getDefineINT("APPROACH_HOSTILE_AT_WAR_WITH_PLAYER");
	m_iAPPROACH_DECEPTIVE_AT_WAR_WITH_PLAYER = getDefineINT("APPROACH_DECEPTIVE_AT_WAR_WITH_PLAYER");
	m_iAPPROACH_GUARDED_AT_WAR_WITH_PLAYER = getDefineINT("APPROACH_GUARDED_AT_WAR_WITH_PLAYER");
	m_iAPPROACH_FRIENDLY_AT_WAR_WITH_PLAYER = getDefineINT("APPROACH_FRIENDLY_AT_WAR_WITH_PLAYER");
	m_iAPPROACH_WAR_PLANNING_WAR_WITH_ANOTHER_PLAYER = getDefineINT("APPROACH_WAR_PLANNING_WAR_WITH_ANOTHER_PLAYER");
	m_iAPPROACH_HOSTILE_PLANNING_WAR_WITH_ANOTHER_PLAYER = getDefineINT("APPROACH_HOSTILE_PLANNING_WAR_WITH_ANOTHER_PLAYER");
	m_iAPPROACH_DECEPTIVE_PLANNING_WAR_WITH_ANOTHER_PLAYER = getDefineINT("APPROACH_DECEPTIVE_PLANNING_WAR_WITH_ANOTHER_PLAYER");
	m_iAPPROACH_GUARDED_PLANNING_WAR_WITH_ANOTHER_PLAYER = getDefineINT("APPROACH_GUARDED_PLANNING_WAR_WITH_ANOTHER_PLAYER");
	m_iAPPROACH_FRIENDLY_PLANNING_WAR_WITH_ANOTHER_PLAYER = getDefineINT("APPROACH_FRIENDLY_PLANNING_WAR_WITH_ANOTHER_PLAYER");
	m_iAPPROACH_WAR_HOSTILE_WITH_ANOTHER_PLAYER = getDefineINT("APPROACH_WAR_HOSTILE_WITH_ANOTHER_PLAYER");
	m_iAPPROACH_HOSTILE_HOSTILE_WITH_ANOTHER_PLAYER = getDefineINT("APPROACH_HOSTILE_HOSTILE_WITH_ANOTHER_PLAYER");
	m_iAPPROACH_DECEPTIVE_HOSTILE_WITH_ANOTHER_PLAYER = getDefineINT("APPROACH_DECEPTIVE_HOSTILE_WITH_ANOTHER_PLAYER");
	m_iAPPROACH_FRIENDLY_HOSTILE_WITH_ANOTHER_PLAYER = getDefineINT("APPROACH_FRIENDLY_HOSTILE_WITH_ANOTHER_PLAYER");
	m_iAPPROACH_WAR_AFRAID_WITH_ANOTHER_PLAYER = getDefineINT("APPROACH_WAR_AFRAID_WITH_ANOTHER_PLAYER");
	m_iAPPROACH_HOSTILE_AFRAID_WITH_ANOTHER_PLAYER = getDefineINT("APPROACH_HOSTILE_AFRAID_WITH_ANOTHER_PLAYER");
	m_iAPPROACH_DECEPTIVE_AFRAID_WITH_ANOTHER_PLAYER = getDefineINT("APPROACH_DECEPTIVE_AFRAID_WITH_ANOTHER_PLAYER");
	m_iAPPROACH_FRIENDLY_AFRAID_WITH_ANOTHER_PLAYER = getDefineINT("APPROACH_FRIENDLY_AFRAID_WITH_ANOTHER_PLAYER");
	m_iAPPROACH_WAR_PROJECTION_DESTRUCTION_PERCENT = getDefineINT("APPROACH_WAR_PROJECTION_DESTRUCTION_PERCENT");
	m_iAPPROACH_WAR_PROJECTION_DEFEAT_PERCENT = getDefineINT("APPROACH_WAR_PROJECTION_DEFEAT_PERCENT");
	m_iAPPROACH_WAR_PROJECTION_STALEMATE_PERCENT = getDefineINT("APPROACH_WAR_PROJECTION_STALEMATE_PERCENT");
	m_iAPPROACH_WAR_PROJECTION_UNKNOWN_PERCENT = getDefineINT("APPROACH_WAR_PROJECTION_UNKNOWN_PERCENT");
	m_iAPPROACH_WAR_PROJECTION_GOOD_PERCENT = getDefineINT("APPROACH_WAR_PROJECTION_GOOD_PERCENT");
	m_iAPPROACH_WAR_PROJECTION_VERY_GOOD_PERCENT = getDefineINT("APPROACH_WAR_PROJECTION_VERY_GOOD_PERCENT");
	m_iAPPROACH_GUARDED_PROJECTION_DESTRUCTION_PERCENT = getDefineINT("APPROACH_GUARDED_PROJECTION_DESTRUCTION_PERCENT");
	m_iAPPROACH_GUARDED_PROJECTION_DEFEAT_PERCENT = getDefineINT("APPROACH_GUARDED_PROJECTION_DEFEAT_PERCENT");
	m_iAPPROACH_GUARDED_PROJECTION_STALEMATE_PERCENT = getDefineINT("APPROACH_GUARDED_PROJECTION_STALEMATE_PERCENT");
	m_iAPPROACH_GUARDED_PROJECTION_UNKNOWN_PERCENT = getDefineINT("APPROACH_GUARDED_PROJECTION_UNKNOWN_PERCENT");
	m_iAPPROACH_GUARDED_PROJECTION_GOOD_PERCENT = getDefineINT("APPROACH_GUARDED_PROJECTION_GOOD_PERCENT");
	m_iAPPROACH_GUARDED_PROJECTION_VERY_GOOD_PERCENT = getDefineINT("APPROACH_GUARDED_PROJECTION_VERY_GOOD_PERCENT");
	m_iTURNS_SINCE_PEACE_WEIGHT_DAMPENER = getDefineINT("TURNS_SINCE_PEACE_WEIGHT_DAMPENER");
	m_iAPPROACH_WAR_HAS_MADE_PEACE_BEFORE_PERCENT = getDefineINT("APPROACH_WAR_HAS_MADE_PEACE_BEFORE_PERCENT");
	m_iAPPROACH_WAR_RECKLESS_EXPANDER = getDefineINT("APPROACH_WAR_RECKLESS_EXPANDER");
	m_iAPPROACH_WAR_PROXIMITY_NEIGHBORS = getDefineINT("APPROACH_WAR_PROXIMITY_NEIGHBORS");
	m_iAPPROACH_WAR_PROXIMITY_CLOSE = getDefineINT("APPROACH_WAR_PROXIMITY_CLOSE");
	m_iAPPROACH_WAR_PROXIMITY_FAR = getDefineINT("APPROACH_WAR_PROXIMITY_FAR");
	m_iAPPROACH_WAR_PROXIMITY_DISTANT = getDefineINT("APPROACH_WAR_PROXIMITY_DISTANT");
	m_iMINOR_APPROACH_IGNORE_DEFAULT = getDefineINT("MINOR_APPROACH_IGNORE_DEFAULT");
	m_iMINOR_APPROACH_BIAS_FOR_CURRENT = getDefineINT("MINOR_APPROACH_BIAS_FOR_CURRENT");
	m_iMINOR_APPROACH_IGNORE_CURRENTLY_WAR = getDefineINT("MINOR_APPROACH_IGNORE_CURRENTLY_WAR");
	m_iMINOR_APPROACH_WAR_CONQUEST_GRAND_STRATEGY = getDefineINT("MINOR_APPROACH_WAR_CONQUEST_GRAND_STRATEGY");
	m_iMINOR_APPROACH_PROTECTIVE_CONQUEST_GRAND_STRATEGY = getDefineINT("MINOR_APPROACH_PROTECTIVE_CONQUEST_GRAND_STRATEGY");
	m_iMINOR_APPROACH_FRIENDLY_CONQUEST_GRAND_STRATEGY = getDefineINT("MINOR_APPROACH_FRIENDLY_CONQUEST_GRAND_STRATEGY");
	m_iMINOR_APPROACH_WAR_CONQUEST_GRAND_STRATEGY_NEIGHBORS = getDefineINT("MINOR_APPROACH_WAR_CONQUEST_GRAND_STRATEGY_NEIGHBORS");
	m_iMINOR_APPROACH_WAR_DIPLO_GRAND_STRATEGY = getDefineINT("MINOR_APPROACH_WAR_DIPLO_GRAND_STRATEGY");
	m_iMINOR_APPROACH_IGNORE_DIPLO_GRAND_STRATEGY = getDefineINT("MINOR_APPROACH_IGNORE_DIPLO_GRAND_STRATEGY");
	m_iMINOR_APPROACH_PROTECTIVE_DIPLO_GRAND_STRATEGY_NEIGHBORS = getDefineINT("MINOR_APPROACH_PROTECTIVE_DIPLO_GRAND_STRATEGY_NEIGHBORS");
	m_iMINOR_APPROACH_WAR_CULTURE_GRAND_STRATEGY = getDefineINT("MINOR_APPROACH_WAR_CULTURE_GRAND_STRATEGY");
	m_iMINOR_APPROACH_IGNORE_CULTURE_GRAND_STRATEGY = getDefineINT("MINOR_APPROACH_IGNORE_CULTURE_GRAND_STRATEGY");
	m_iMINOR_APPROACH_PROTECTIVE_CULTURE_GRAND_STRATEGY_CST = getDefineINT("MINOR_APPROACH_PROTECTIVE_CULTURE_GRAND_STRATEGY_CST");
	m_iMINOR_APPROACH_WAR_CURRENTLY_PROTECTIVE = getDefineINT("MINOR_APPROACH_WAR_CURRENTLY_PROTECTIVE");
	m_iMINOR_APPROACH_PROTECTIVE_CURRENTLY_PROTECTIVE = getDefineINT("MINOR_APPROACH_PROTECTIVE_CURRENTLY_PROTECTIVE");
	m_iMINOR_APPROACH_PROTECTIVE_CURRENTLY_WAR = getDefineINT("MINOR_APPROACH_PROTECTIVE_CURRENTLY_WAR");
	m_iMINOR_APPROACH_FRIENDLY_CURRENTLY_WAR = getDefineINT("MINOR_APPROACH_FRIENDLY_CURRENTLY_WAR");
	m_iMINOR_APPROACH_FRIENDLY_RESOURCES = getDefineINT("MINOR_APPROACH_FRIENDLY_RESOURCES");
	m_iMINOR_APPROACH_PROTECTIVE_RESOURCES = getDefineINT("MINOR_APPROACH_PROTECTIVE_RESOURCES");
	m_iMINOR_APPROACH_WAR_FRIENDS = getDefineINT("MINOR_APPROACH_WAR_FRIENDS");
	m_iMINOR_APPROACH_FRIENDLY_FRIENDS = getDefineINT("MINOR_APPROACH_FRIENDLY_FRIENDS");
	m_iMINOR_APPROACH_PROTECTIVE_FRIENDS = getDefineINT("MINOR_APPROACH_PROTECTIVE_FRIENDS");
	m_iMINOR_APPROACH_IGNORE_PROXIMITY_NEIGHBORS = getDefineINT("MINOR_APPROACH_IGNORE_PROXIMITY_NEIGHBORS");
	m_iMINOR_APPROACH_FRIENDLY_PROXIMITY_NEIGHBORS = getDefineINT("MINOR_APPROACH_FRIENDLY_PROXIMITY_NEIGHBORS");
	m_iMINOR_APPROACH_PROTECTIVE_PROXIMITY_NEIGHBORS = getDefineINT("MINOR_APPROACH_PROTECTIVE_PROXIMITY_NEIGHBORS");
	m_iMINOR_APPROACH_CONQUEST_PROXIMITY_NEIGHBORS = getDefineINT("MINOR_APPROACH_CONQUEST_PROXIMITY_NEIGHBORS");
	m_iMINOR_APPROACH_IGNORE_PROXIMITY_CLOSE = getDefineINT("MINOR_APPROACH_IGNORE_PROXIMITY_CLOSE");
	m_iMINOR_APPROACH_PROTECTIVE_PROXIMITY_CLOSE = getDefineINT("MINOR_APPROACH_PROTECTIVE_PROXIMITY_CLOSE");
	m_iMINOR_APPROACH_CONQUEST_PROXIMITY_CLOSE = getDefineINT("MINOR_APPROACH_CONQUEST_PROXIMITY_CLOSE");
	m_iMINOR_APPROACH_FRIENDLY_PROXIMITY_FAR = getDefineINT("MINOR_APPROACH_FRIENDLY_PROXIMITY_FAR");
	m_iMINOR_APPROACH_CONQUEST_PROXIMITY_FAR = getDefineINT("MINOR_APPROACH_CONQUEST_PROXIMITY_FAR");
	m_iMINOR_APPROACH_FRIENDLY_PROXIMITY_DISTANT = getDefineINT("MINOR_APPROACH_FRIENDLY_PROXIMITY_DISTANT");
	m_iMINOR_APPROACH_CONQUEST_PROXIMITY_DISTANT = getDefineINT("MINOR_APPROACH_CONQUEST_PROXIMITY_DISTANT");
	m_iMINOR_APPROACH_FRIENDLY_PERSONALITY_FRIENDLY = getDefineINT("MINOR_APPROACH_FRIENDLY_PERSONALITY_FRIENDLY");
	m_iMINOR_APPROACH_PROTECTIVE_PERSONALITY_PROTECTIVE = getDefineINT("MINOR_APPROACH_PROTECTIVE_PERSONALITY_PROTECTIVE");
	m_iMINOR_APPROACH_FRIENDLY_PERSONALITY_NEUTRAL = getDefineINT("MINOR_APPROACH_FRIENDLY_PERSONALITY_NEUTRAL");
	m_iMINOR_APPROACH_PROTECTIVE_PERSONALITY_NEUTRAL = getDefineINT("MINOR_APPROACH_PROTECTIVE_PERSONALITY_NEUTRAL");
	m_iMINOR_APPROACH_FRIENDLY_PERSONALITY_HOSTILE = getDefineINT("MINOR_APPROACH_FRIENDLY_PERSONALITY_HOSTILE");
	m_iMINOR_APPROACH_PROTECTIVE_PERSONALITY_HOSTILE = getDefineINT("MINOR_APPROACH_PROTECTIVE_PERSONALITY_HOSTILE");
	m_iMINOR_APPROACH_CONQUEST_PERSONALITY_HOSTILE = getDefineINT("MINOR_APPROACH_CONQUEST_PERSONALITY_HOSTILE");
	m_iMINOR_APPROACH_FRIENDLY_PERSONALITY_IRRATIONAL = getDefineINT("MINOR_APPROACH_FRIENDLY_PERSONALITY_IRRATIONAL");
	m_iMINOR_APPROACH_PROTECTIVE_PERSONALITY_IRRATIONAL = getDefineINT("MINOR_APPROACH_PROTECTIVE_PERSONALITY_IRRATIONAL");
	m_iMINOR_APPROACH_WAR_PLANNING_WAR_WITH_ANOTHER_PLAYER = getDefineINT("MINOR_APPROACH_WAR_PLANNING_WAR_WITH_ANOTHER_PLAYER");
	m_iMINOR_APPROACH_PROTECTIVE_WITH_ANOTHER_PLAYER = getDefineINT("MINOR_APPROACH_PROTECTIVE_WITH_ANOTHER_PLAYER");
	m_iMINOR_APPROACH_WAR_TARGET_IMPOSSIBLE = getDefineINT("MINOR_APPROACH_WAR_TARGET_IMPOSSIBLE");
	m_iMINOR_APPROACH_WAR_TARGET_BAD = getDefineINT("MINOR_APPROACH_WAR_TARGET_BAD");
	m_iMINOR_APPROACH_WAR_TARGET_AVERAGE = getDefineINT("MINOR_APPROACH_WAR_TARGET_AVERAGE");
	m_iMINOR_APPROACH_WAR_TARGET_FAVORABLE = getDefineINT("MINOR_APPROACH_WAR_TARGET_FAVORABLE");
	m_iMINOR_APPROACH_WAR_TARGET_SOFT = getDefineINT("MINOR_APPROACH_WAR_TARGET_SOFT");
	m_iCOOPERATION_DESIRE_THRESHOLD_EAGER = getDefineINT("COOPERATION_DESIRE_THRESHOLD_EAGER");
	m_iCOOPERATION_DESIRE_THRESHOLD_STRONG = getDefineINT("COOPERATION_DESIRE_THRESHOLD_STRONG");
	m_iCOOPERATION_DESIRE_THRESHOLD_DECENT = getDefineINT("COOPERATION_DESIRE_THRESHOLD_DECENT");
	m_iCOOPERATION_DESIRE_THRESHOLD_WEAK = getDefineINT("COOPERATION_DESIRE_THRESHOLD_WEAK");
	m_iCOOPERATION_DESIRE_WAR_STATE_CALM = getDefineINT("COOPERATION_DESIRE_WAR_STATE_CALM");
	m_iCOOPERATION_DESIRE_WAR_STATE_NEARLY_WON = getDefineINT("COOPERATION_DESIRE_WAR_STATE_NEARLY_WON");
	m_iCOOPERATION_DESIRE_WAR_STATE_OFFENSIVE = getDefineINT("COOPERATION_DESIRE_WAR_STATE_OFFENSIVE");
	m_iCOOPERATION_DESIRE_WAR_STATE_STALEMATE = getDefineINT("COOPERATION_DESIRE_WAR_STATE_STALEMATE");
	m_iCOOPERATION_DESIRE_WAR_STATE_DEFENSIVE = getDefineINT("COOPERATION_DESIRE_WAR_STATE_DEFENSIVE");
	m_iCOOPERATION_DESIRE_WAR_STATE_NEARLY_DEFEATED = getDefineINT("COOPERATION_DESIRE_WAR_STATE_NEARLY_DEFEATED");
	m_iCOOPERATION_DESIRE_MILITARY_STRENGTH_IMMENSE = getDefineINT("COOPERATION_DESIRE_MILITARY_STRENGTH_IMMENSE");
	m_iCOOPERATION_DESIRE_MILITARY_STRENGTH_POWERFUL = getDefineINT("COOPERATION_DESIRE_MILITARY_STRENGTH_POWERFUL");
	m_iCOOPERATION_DESIRE_MILITARY_STRENGTH_STRONG = getDefineINT("COOPERATION_DESIRE_MILITARY_STRENGTH_STRONG");
	m_iCOOPERATION_DESIRE_MILITARY_STRENGTH_AVERAGE = getDefineINT("COOPERATION_DESIRE_MILITARY_STRENGTH_AVERAGE");
	m_iCOOPERATION_DESIRE_MILITARY_STRENGTH_POOR = getDefineINT("COOPERATION_DESIRE_MILITARY_STRENGTH_POOR");
	m_iCOOPERATION_DESIRE_MILITARY_STRENGTH_WEAK = getDefineINT("COOPERATION_DESIRE_MILITARY_STRENGTH_WEAK");
	m_iCOOPERATION_DESIRE_MILITARY_STRENGTH_PATHETIC = getDefineINT("COOPERATION_DESIRE_MILITARY_STRENGTH_PATHETIC");
	m_iCOOPERATION_DESIRE_OPINION_ALLY = getDefineINT("COOPERATION_DESIRE_OPINION_ALLY");
	m_iCOOPERATION_DESIRE_OPINION_FRIEND = getDefineINT("COOPERATION_DESIRE_OPINION_FRIEND");
	m_iCOOPERATION_DESIRE_OPINION_NEUTRAL = getDefineINT("COOPERATION_DESIRE_OPINION_NEUTRAL");
	m_iCOOPERATION_DESIRE_OPINION_COMPETITOR = getDefineINT("COOPERATION_DESIRE_OPINION_COMPETITOR");
	m_iCOOPERATION_DESIRE_OPINION_ENEMY = getDefineINT("COOPERATION_DESIRE_OPINION_ENEMY");
	m_iCOOPERATION_DESIRE_GAME_THREAT_CRITICAL = getDefineINT("COOPERATION_DESIRE_GAME_THREAT_CRITICAL");
	m_iCOOPERATION_DESIRE_GAME_THREAT_SEVERE = getDefineINT("COOPERATION_DESIRE_GAME_THREAT_SEVERE");
	m_iCOOPERATION_DESIRE_GAME_THREAT_MAJOR = getDefineINT("COOPERATION_DESIRE_GAME_THREAT_MAJOR");
	m_iCOOPERATION_DESIRE_GAME_THREAT_MINOR = getDefineINT("COOPERATION_DESIRE_GAME_THREAT_MINOR");
	m_iCOOPERATION_DESIRE_GAME_THREAT_NONE = getDefineINT("COOPERATION_DESIRE_GAME_THREAT_NONE");
	m_iCOOPERATION_DESIRE_THEM_US_SAME_COMPETITOR = getDefineINT("COOPERATION_DESIRE_THEM_US_SAME_COMPETITOR");
	m_iCOOPERATION_DESIRE_THEM_US_COMPETITOR_ENEMY = getDefineINT("COOPERATION_DESIRE_THEM_US_COMPETITOR_ENEMY");
	m_iCOOPERATION_DESIRE_THEM_US_ENEMY_COMPETITOR = getDefineINT("COOPERATION_DESIRE_THEM_US_ENEMY_COMPETITOR");
	m_iCOOPERATION_DESIRE_THEM_US_SAME_ENEMY = getDefineINT("COOPERATION_DESIRE_THEM_US_SAME_ENEMY");
	m_iEVALUATE_WAR_PLAYER_THRESHOLD = getDefineINT("EVALUATE_WAR_PLAYER_THRESHOLD");
	m_iEVALUATE_WAR_WILLING_TO_DECLARE_THRESHOLD = getDefineINT("EVALUATE_WAR_WILLING_TO_DECLARE_THRESHOLD");
	m_iEVALUATE_WAR_CONQUEST_GRAND_STRATEGY = getDefineINT("EVALUATE_WAR_CONQUEST_GRAND_STRATEGY");
	m_iEVALUATE_WAR_NOT_PREPARED = getDefineINT("EVALUATE_WAR_NOT_PREPARED");
	m_iEVALUATE_WAR_ALREADY_FIGHTING = getDefineINT("EVALUATE_WAR_ALREADY_FIGHTING");
	m_iEVALUATE_WAR_GAME_THREAT_CRITICAL = getDefineINT("EVALUATE_WAR_GAME_THREAT_CRITICAL");
	m_iEVALUATE_WAR_GAME_THREAT_SEVERE = getDefineINT("EVALUATE_WAR_GAME_THREAT_SEVERE");
	m_iEVALUATE_WAR_GAME_THREAT_MAJOR = getDefineINT("EVALUATE_WAR_GAME_THREAT_MAJOR");
	m_iEVALUATE_WAR_GAME_THREAT_MINOR = getDefineINT("EVALUATE_WAR_GAME_THREAT_MINOR");
	m_iEVALUATE_WAR_GAME_THREAT_NONE = getDefineINT("EVALUATE_WAR_GAME_THREAT_NONE");
	m_iEVALUATE_WAR_SOFT_TARGET = getDefineINT("EVALUATE_WAR_SOFT_TARGET");
	m_iEVALUATE_WAR_FAVORABLE_TARGET = getDefineINT("EVALUATE_WAR_FAVORABLE_TARGET");
	m_iEVALUATE_WAR_AVERAGE_TARGET = getDefineINT("EVALUATE_WAR_AVERAGE_TARGET");
	m_iEVALUATE_WAR_BAD_TARGET = getDefineINT("EVALUATE_WAR_BAD_TARGET");
	m_iEVALUATE_WAR_IMPOSSIBLE_TARGET = getDefineINT("EVALUATE_WAR_IMPOSSIBLE_TARGET");
	m_iREQUEST_PEACE_TURN_THRESHOLD = getDefineINT("REQUEST_PEACE_TURN_THRESHOLD");
	m_iPEACE_WILLINGNESS_OFFER_PROJECTION_DESTRUCTION = getDefineINT("PEACE_WILLINGNESS_OFFER_PROJECTION_DESTRUCTION");
	m_iPEACE_WILLINGNESS_OFFER_PROJECTION_DEFEAT = getDefineINT("PEACE_WILLINGNESS_OFFER_PROJECTION_DEFEAT");
	m_iPEACE_WILLINGNESS_OFFER_PROJECTION_STALEMATE = getDefineINT("PEACE_WILLINGNESS_OFFER_PROJECTION_STALEMATE");
	m_iPEACE_WILLINGNESS_OFFER_PROJECTION_UNKNOWN = getDefineINT("PEACE_WILLINGNESS_OFFER_PROJECTION_UNKNOWN");
	m_iPEACE_WILLINGNESS_OFFER_PROJECTION_GOOD = getDefineINT("PEACE_WILLINGNESS_OFFER_PROJECTION_GOOD");
	m_iPEACE_WILLINGNESS_OFFER_PROJECTION_VERY_GOOD = getDefineINT("PEACE_WILLINGNESS_OFFER_PROJECTION_VERY_GOOD");
	m_iPEACE_WILLINGNESS_OFFER_WAR_DAMAGE_NONE = getDefineINT("PEACE_WILLINGNESS_OFFER_WAR_DAMAGE_NONE");
	m_iPEACE_WILLINGNESS_OFFER_WAR_DAMAGE_MINOR = getDefineINT("PEACE_WILLINGNESS_OFFER_WAR_DAMAGE_MINOR");
	m_iPEACE_WILLINGNESS_OFFER_WAR_DAMAGE_MAJOR = getDefineINT("PEACE_WILLINGNESS_OFFER_WAR_DAMAGE_MAJOR");
	m_iPEACE_WILLINGNESS_OFFER_WAR_DAMAGE_SERIOUS = getDefineINT("PEACE_WILLINGNESS_OFFER_WAR_DAMAGE_SERIOUS");
	m_iPEACE_WILLINGNESS_OFFER_WAR_DAMAGE_CRIPPLED = getDefineINT("PEACE_WILLINGNESS_OFFER_WAR_DAMAGE_CRIPPLED");
	m_iPEACE_WILLINGNESS_OFFER_THRESHOLD_UN_SURRENDER = getDefineINT("PEACE_WILLINGNESS_OFFER_THRESHOLD_UN_SURRENDER");
	m_iPEACE_WILLINGNESS_OFFER_THRESHOLD_CAPITULATION = getDefineINT("PEACE_WILLINGNESS_OFFER_THRESHOLD_CAPITULATION");
	m_iPEACE_WILLINGNESS_OFFER_THRESHOLD_CESSION = getDefineINT("PEACE_WILLINGNESS_OFFER_THRESHOLD_CESSION");
	m_iPEACE_WILLINGNESS_OFFER_THRESHOLD_SURRENDER = getDefineINT("PEACE_WILLINGNESS_OFFER_THRESHOLD_SURRENDER");
	m_iPEACE_WILLINGNESS_OFFER_THRESHOLD_SUBMISSION = getDefineINT("PEACE_WILLINGNESS_OFFER_THRESHOLD_SUBMISSION");
	m_iPEACE_WILLINGNESS_OFFER_THRESHOLD_BACKDOWN = getDefineINT("PEACE_WILLINGNESS_OFFER_THRESHOLD_BACKDOWN");
	m_iPEACE_WILLINGNESS_OFFER_THRESHOLD_SETTLEMENT = getDefineINT("PEACE_WILLINGNESS_OFFER_THRESHOLD_SETTLEMENT");
	m_iPEACE_WILLINGNESS_OFFER_THRESHOLD_ARMISTICE = getDefineINT("PEACE_WILLINGNESS_OFFER_THRESHOLD_ARMISTICE");
	m_iPEACE_WILLINGNESS_ACCEPT_PROJECTION_DESTRUCTION = getDefineINT("PEACE_WILLINGNESS_ACCEPT_PROJECTION_DESTRUCTION");
	m_iPEACE_WILLINGNESS_ACCEPT_PROJECTION_DEFEAT = getDefineINT("PEACE_WILLINGNESS_ACCEPT_PROJECTION_DEFEAT");
	m_iPEACE_WILLINGNESS_ACCEPT_PROJECTION_STALEMATE = getDefineINT("PEACE_WILLINGNESS_ACCEPT_PROJECTION_STALEMATE");
	m_iPEACE_WILLINGNESS_ACCEPT_PROJECTION_UNKNOWN = getDefineINT("PEACE_WILLINGNESS_ACCEPT_PROJECTION_UNKNOWN");
	m_iPEACE_WILLINGNESS_ACCEPT_PROJECTION_GOOD = getDefineINT("PEACE_WILLINGNESS_ACCEPT_PROJECTION_GOOD");
	m_iPEACE_WILLINGNESS_ACCEPT_PROJECTION_VERY_GOOD = getDefineINT("PEACE_WILLINGNESS_ACCEPT_PROJECTION_VERY_GOOD");
	m_iPEACE_WILLINGNESS_ACCEPT_TARGET_IMPOSSIBLE = getDefineINT("PEACE_WILLINGNESS_ACCEPT_TARGET_IMPOSSIBLE");
	m_iPEACE_WILLINGNESS_ACCEPT_TARGET_BAD = getDefineINT("PEACE_WILLINGNESS_ACCEPT_TARGET_BAD");
	m_iPEACE_WILLINGNESS_ACCEPT_TARGET_AVERAGE = getDefineINT("PEACE_WILLINGNESS_ACCEPT_TARGET_AVERAGE");
	m_iPEACE_WILLINGNESS_ACCEPT_TARGET_FAVORABLE = getDefineINT("PEACE_WILLINGNESS_ACCEPT_TARGET_FAVORABLE");
	m_iPEACE_WILLINGNESS_ACCEPT_TARGET_SOFT = getDefineINT("PEACE_WILLINGNESS_ACCEPT_TARGET_SOFT");
	m_iPEACE_WILLINGNESS_ACCEPT_THRESHOLD_UN_SURRENDER = getDefineINT("PEACE_WILLINGNESS_ACCEPT_THRESHOLD_UN_SURRENDER");
	m_iPEACE_WILLINGNESS_ACCEPT_THRESHOLD_CAPITULATION = getDefineINT("PEACE_WILLINGNESS_ACCEPT_THRESHOLD_CAPITULATION");
	m_iPEACE_WILLINGNESS_ACCEPT_THRESHOLD_CESSION = getDefineINT("PEACE_WILLINGNESS_ACCEPT_THRESHOLD_CESSION");
	m_iPEACE_WILLINGNESS_ACCEPT_THRESHOLD_SURRENDER = getDefineINT("PEACE_WILLINGNESS_ACCEPT_THRESHOLD_SURRENDER");
	m_iPEACE_WILLINGNESS_ACCEPT_THRESHOLD_SUBMISSION = getDefineINT("PEACE_WILLINGNESS_ACCEPT_THRESHOLD_SUBMISSION");
	m_iPEACE_WILLINGNESS_ACCEPT_THRESHOLD_BACKDOWN = getDefineINT("PEACE_WILLINGNESS_ACCEPT_THRESHOLD_BACKDOWN");
	m_iPEACE_WILLINGNESS_ACCEPT_THRESHOLD_SETTLEMENT = getDefineINT("PEACE_WILLINGNESS_ACCEPT_THRESHOLD_SETTLEMENT");
	m_iPEACE_WILLINGNESS_ACCEPT_THRESHOLD_ARMISTICE = getDefineINT("PEACE_WILLINGNESS_ACCEPT_THRESHOLD_ARMISTICE");
	m_iARMISTICE_GPT_DIVISOR = getDefineINT("ARMISTICE_GPT_DIVISOR");
	m_iARMISTICE_MIN_GOLD = getDefineINT("ARMISTICE_MIN_GOLD");
	m_iWAR_GOAL_THRESHOLD_CONQUEST = getDefineINT("WAR_GOAL_THRESHOLD_CONQUEST");
	m_iWAR_GOAL_THRESHOLD_DAMAGE = getDefineINT("WAR_GOAL_THRESHOLD_DAMAGE");
	m_iWAR_GOAL_THRESHOLD_PEACE = getDefineINT("WAR_GOAL_THRESHOLD_PEACE");
	m_iWAR_GOAL_STATE_CALM = getDefineINT("WAR_GOAL_STATE_CALM");
	m_iWAR_GOAL_STATE_NEARLY_WON = getDefineINT("WAR_GOAL_STATE_NEARLY_WON");
	m_iWAR_GOAL_STATE_OFFENSIVE = getDefineINT("WAR_GOAL_STATE_OFFENSIVE");
	m_iWAR_GOAL_STATE_STALEMATE = getDefineINT("WAR_GOAL_STATE_STALEMATE");
	m_iWAR_GOAL_STATE_DEFENSIVE = getDefineINT("WAR_GOAL_STATE_DEFENSIVE");
	m_iWAR_GOAL_STATE_NEARLY_DEFEATED = getDefineINT("WAR_GOAL_STATE_NEARLY_DEFEATED");
	m_iWAR_GOAL_ANOTHER_PLAYER_STATE_CALM = getDefineINT("WAR_GOAL_ANOTHER_PLAYER_STATE_CALM");
	m_iWAR_GOAL_ANOTHER_PLAYER_STATE_NEARLY_WON = getDefineINT("WAR_GOAL_ANOTHER_PLAYER_STATE_NEARLY_WON");
	m_iWAR_GOAL_ANOTHER_PLAYER_STATE_OFFENSIVE = getDefineINT("WAR_GOAL_ANOTHER_PLAYER_STATE_OFFENSIVE");
	m_iWAR_GOAL_ANOTHER_PLAYER_STATE_STALEMATE = getDefineINT("WAR_GOAL_ANOTHER_PLAYER_STATE_STALEMATE");
	m_iWAR_GOAL_ANOTHER_PLAYER_STATE_DEFENSIVE = getDefineINT("WAR_GOAL_ANOTHER_PLAYER_STATE_DEFENSIVE");
	m_iWAR_GOAL_ANOTHER_PLAYER_STATE_NEARLY_DEFEATED = getDefineINT("WAR_GOAL_ANOTHER_PLAYER_STATE_NEARLY_DEFEATED");
	m_iWAR_GOAL_DAMAGE_CRIPPLED = getDefineINT("WAR_GOAL_DAMAGE_CRIPPLED");
	m_iWAR_GOAL_DAMAGE_SERIOUS = getDefineINT("WAR_GOAL_DAMAGE_SERIOUS");
	m_iWAR_GOAL_DAMAGE_MAJOR = getDefineINT("WAR_GOAL_DAMAGE_MAJOR");
	m_iWAR_GOAL_DAMAGE_MINOR = getDefineINT("WAR_GOAL_DAMAGE_MINOR");
	m_iWAR_GOAL_DAMAGE_NONE = getDefineINT("WAR_GOAL_DAMAGE_NONE");
	m_iWAR_GOAL_GAME_THREAT_CRITICAL = getDefineINT("WAR_GOAL_GAME_THREAT_CRITICAL");
	m_iWAR_GOAL_GAME_THREAT_SEVERE = getDefineINT("WAR_GOAL_GAME_THREAT_SEVERE");
	m_iWAR_GOAL_GAME_THREAT_MAJOR = getDefineINT("WAR_GOAL_GAME_THREAT_MAJOR");
	m_iWAR_GOAL_GAME_THREAT_MINOR = getDefineINT("WAR_GOAL_GAME_THREAT_MINOR");
	m_iWAR_GOAL_GAME_THREAT_NONE = getDefineINT("WAR_GOAL_GAME_THREAT_NONE");
	m_iWAR_GOAL_TARGET_SOFT = getDefineINT("WAR_GOAL_TARGET_SOFT");
	m_iWAR_GOAL_TARGET_FAVORABLE = getDefineINT("WAR_GOAL_TARGET_FAVORABLE");
	m_iWAR_GOAL_TARGET_AVERAGE = getDefineINT("WAR_GOAL_TARGET_AVERAGE");
	m_iWAR_GOAL_TARGET_BAD = getDefineINT("WAR_GOAL_TARGET_BAD");
	m_iWAR_GOAL_TARGET_IMPOSSIBLE = getDefineINT("WAR_GOAL_TARGET_IMPOSSIBLE");
	m_iWAR_PROJECTION_THRESHOLD_VERY_GOOD = getDefineINT("WAR_PROJECTION_THRESHOLD_VERY_GOOD");
	m_iWAR_PROJECTION_THRESHOLD_GOOD = getDefineINT("WAR_PROJECTION_THRESHOLD_GOOD");
	m_iWAR_PROJECTION_THRESHOLD_DESTRUCTION = getDefineINT("WAR_PROJECTION_THRESHOLD_DESTRUCTION");
	m_iWAR_PROJECTION_THRESHOLD_DEFEAT = getDefineINT("WAR_PROJECTION_THRESHOLD_DEFEAT");
	m_iWAR_PROJECTION_THRESHOLD_STALEMATE = getDefineINT("WAR_PROJECTION_THRESHOLD_STALEMATE");
	m_iWAR_PROJECTION_THEIR_MILITARY_STRENGTH_PATHETIC = getDefineINT("WAR_PROJECTION_THEIR_MILITARY_STRENGTH_PATHETIC");
	m_iWAR_PROJECTION_THEIR_MILITARY_STRENGTH_WEAK = getDefineINT("WAR_PROJECTION_THEIR_MILITARY_STRENGTH_WEAK");
	m_iWAR_PROJECTION_RECKLESS_EXPANDER = getDefineINT("WAR_PROJECTION_RECKLESS_EXPANDER");
	m_iWAR_PROJECTION_THEIR_MILITARY_STRENGTH_POOR = getDefineINT("WAR_PROJECTION_THEIR_MILITARY_STRENGTH_POOR");
	m_iWAR_PROJECTION_THEIR_MILITARY_STRENGTH_AVERAGE = getDefineINT("WAR_PROJECTION_THEIR_MILITARY_STRENGTH_AVERAGE");
	m_iWAR_PROJECTION_THEIR_MILITARY_STRENGTH_STRONG = getDefineINT("WAR_PROJECTION_THEIR_MILITARY_STRENGTH_STRONG");
	m_iWAR_PROJECTION_THEIR_MILITARY_STRENGTH_POWERFUL = getDefineINT("WAR_PROJECTION_THEIR_MILITARY_STRENGTH_POWERFUL");
	m_iWAR_PROJECTION_THEIR_MILITARY_STRENGTH_IMMENSE = getDefineINT("WAR_PROJECTION_THEIR_MILITARY_STRENGTH_IMMENSE");
	m_iWAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_PATHETIC = getDefineINT("WAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_PATHETIC");
	m_iWAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_WEAK = getDefineINT("WAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_WEAK");
	m_iWAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_POOR = getDefineINT("WAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_POOR");
	m_iWAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_AVERAGE = getDefineINT("WAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_AVERAGE");
	m_iWAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_STRONG = getDefineINT("WAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_STRONG");
	m_iWAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_POWERFUL = getDefineINT("WAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_POWERFUL");
	m_iWAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_IMMENSE = getDefineINT("WAR_PROJECTION_THEIR_ECONOMIC_STRENGTH_IMMENSE");
	m_iWAR_PROJECTION_WAR_DAMAGE_US_NONE = getDefineINT("WAR_PROJECTION_WAR_DAMAGE_US_NONE");
	m_iWAR_PROJECTION_WAR_DAMAGE_US_MINOR = getDefineINT("WAR_PROJECTION_WAR_DAMAGE_US_MINOR");
	m_iWAR_PROJECTION_WAR_DAMAGE_US_MAJOR = getDefineINT("WAR_PROJECTION_WAR_DAMAGE_US_MAJOR");
	m_iWAR_PROJECTION_WAR_DAMAGE_US_SERIOUS = getDefineINT("WAR_PROJECTION_WAR_DAMAGE_US_SERIOUS");
	m_iWAR_PROJECTION_WAR_DAMAGE_US_CRIPPLED = getDefineINT("WAR_PROJECTION_WAR_DAMAGE_US_CRIPPLED");
	m_iWAR_PROJECTION_WAR_DAMAGE_THEM_NONE = getDefineINT("WAR_PROJECTION_WAR_DAMAGE_THEM_NONE");
	m_iWAR_PROJECTION_WAR_DAMAGE_THEM_MINOR = getDefineINT("WAR_PROJECTION_WAR_DAMAGE_THEM_MINOR");
	m_iWAR_PROJECTION_WAR_DAMAGE_THEM_MAJOR = getDefineINT("WAR_PROJECTION_WAR_DAMAGE_THEM_MAJOR");
	m_iWAR_PROJECTION_WAR_DAMAGE_THEM_SERIOUS = getDefineINT("WAR_PROJECTION_WAR_DAMAGE_THEM_SERIOUS");
	m_iWAR_PROJECTION_WAR_DAMAGE_THEM_CRIPPLED = getDefineINT("WAR_PROJECTION_WAR_DAMAGE_THEM_CRIPPLED");
	m_iWAR_PROJECTION_WAR_DURATION_SCORE_CAP = getDefineINT("WAR_PROJECTION_WAR_DURATION_SCORE_CAP");
	m_iWAR_STATE_CALM_THRESHOLD_FOREIGN_FORCES = getDefineINT("WAR_STATE_CALM_THRESHOLD_FOREIGN_FORCES");
	m_iWAR_STATE_THRESHOLD_NEARLY_WON = getDefineINT("WAR_STATE_THRESHOLD_NEARLY_WON");
	m_iWAR_STATE_THRESHOLD_OFFENSIVE = getDefineINT("WAR_STATE_THRESHOLD_OFFENSIVE");
	m_iWAR_STATE_THRESHOLD_STALEMATE = getDefineINT("WAR_STATE_THRESHOLD_STALEMATE");
	m_iWAR_STATE_THRESHOLD_DEFENSIVE = getDefineINT("WAR_STATE_THRESHOLD_DEFENSIVE");
	m_iWAR_DAMAGE_LEVEL_THRESHOLD_CRIPPLED = getDefineINT("WAR_DAMAGE_LEVEL_THRESHOLD_CRIPPLED");
	m_iWAR_DAMAGE_LEVEL_THRESHOLD_SERIOUS = getDefineINT("WAR_DAMAGE_LEVEL_THRESHOLD_SERIOUS");
	m_iWAR_DAMAGE_LEVEL_THRESHOLD_MAJOR = getDefineINT("WAR_DAMAGE_LEVEL_THRESHOLD_MAJOR");
	m_iWAR_DAMAGE_LEVEL_THRESHOLD_MINOR = getDefineINT("WAR_DAMAGE_LEVEL_THRESHOLD_MINOR");
	m_iWAR_DAMAGE_LEVEL_CITY_WEIGHT = getDefineINT("WAR_DAMAGE_LEVEL_CITY_WEIGHT");
	m_iWAR_DAMAGE_LEVEL_INVOLVED_CITY_POP_MULTIPLIER = getDefineINT("WAR_DAMAGE_LEVEL_INVOLVED_CITY_POP_MULTIPLIER");
	m_iWAR_DAMAGE_LEVEL_UNINVOLVED_CITY_POP_MULTIPLIER = getDefineINT("WAR_DAMAGE_LEVEL_UNINVOLVED_CITY_POP_MULTIPLIER");
	m_iMILITARY_AGGRESSIVE_POSTURE_THRESHOLD_INCREDIBLE = getDefineINT("MILITARY_AGGRESSIVE_POSTURE_THRESHOLD_INCREDIBLE");
	m_iMILITARY_AGGRESSIVE_POSTURE_THRESHOLD_HIGH = getDefineINT("MILITARY_AGGRESSIVE_POSTURE_THRESHOLD_HIGH");
	m_iMILITARY_AGGRESSIVE_POSTURE_THRESHOLD_MEDIUM = getDefineINT("MILITARY_AGGRESSIVE_POSTURE_THRESHOLD_MEDIUM");
	m_iMILITARY_AGGRESSIVE_POSTURE_THRESHOLD_LOW = getDefineINT("MILITARY_AGGRESSIVE_POSTURE_THRESHOLD_LOW");
	m_iEXPANSION_CAPITAL_DISTANCE_AGGRESSIVE_POSTURE_HIGH = getDefineINT("EXPANSION_CAPITAL_DISTANCE_AGGRESSIVE_POSTURE_HIGH");
	m_iEXPANSION_CAPITAL_DISTANCE_AGGRESSIVE_POSTURE_MEDIUM = getDefineINT("EXPANSION_CAPITAL_DISTANCE_AGGRESSIVE_POSTURE_MEDIUM");
	m_iEXPANSION_CAPITAL_DISTANCE_AGGRESSIVE_POSTURE_LOW = getDefineINT("EXPANSION_CAPITAL_DISTANCE_AGGRESSIVE_POSTURE_LOW");
	m_iPLOT_BUYING_POSTURE_INCREDIBLE_THRESHOLD = getDefineINT("PLOT_BUYING_POSTURE_INCREDIBLE_THRESHOLD");
	m_iPLOT_BUYING_POSTURE_HIGH_THRESHOLD = getDefineINT("PLOT_BUYING_POSTURE_HIGH_THRESHOLD");
	m_iPLOT_BUYING_POSTURE_MEDIUM_THRESHOLD = getDefineINT("PLOT_BUYING_POSTURE_MEDIUM_THRESHOLD");
	m_iPLOT_BUYING_POSTURE_LOW_THRESHOLD = getDefineINT("PLOT_BUYING_POSTURE_LOW_THRESHOLD");
	m_iMILITARY_STRENGTH_BASE = getDefineINT("MILITARY_STRENGTH_BASE");
	m_iMILITARY_STRENGTH_RATIO_MULTIPLIER = getDefineINT("MILITARY_STRENGTH_RATIO_MULTIPLIER");
	m_iMILITARY_STRENGTH_CITY_MOD = getDefineINT("MILITARY_STRENGTH_CITY_MOD");
	m_iMILITARY_STRENGTH_IMMENSE_THRESHOLD = getDefineINT("MILITARY_STRENGTH_IMMENSE_THRESHOLD");
	m_iMILITARY_STRENGTH_POWERFUL_THRESHOLD = getDefineINT("MILITARY_STRENGTH_POWERFUL_THRESHOLD");
	m_iMILITARY_STRENGTH_STRONG_THRESHOLD = getDefineINT("MILITARY_STRENGTH_STRONG_THRESHOLD");
	m_iMILITARY_STRENGTH_AVERAGE_THRESHOLD = getDefineINT("MILITARY_STRENGTH_AVERAGE_THRESHOLD");
	m_iMILITARY_STRENGTH_POOR_THRESHOLD = getDefineINT("MILITARY_STRENGTH_POOR_THRESHOLD");
	m_iMILITARY_STRENGTH_WEAK_THRESHOLD = getDefineINT("MILITARY_STRENGTH_WEAK_THRESHOLD");
	m_iECONOMIC_STRENGTH_RATIO_MULTIPLIER = getDefineINT("ECONOMIC_STRENGTH_RATIO_MULTIPLIER");
	m_iECONOMIC_STRENGTH_IMMENSE_THRESHOLD = getDefineINT("ECONOMIC_STRENGTH_IMMENSE_THRESHOLD");
	m_iECONOMIC_STRENGTH_POWERFUL_THRESHOLD = getDefineINT("ECONOMIC_STRENGTH_POWERFUL_THRESHOLD");
	m_iECONOMIC_STRENGTH_STRONG_THRESHOLD = getDefineINT("ECONOMIC_STRENGTH_STRONG_THRESHOLD");
	m_iECONOMIC_STRENGTH_AVERAGE_THRESHOLD = getDefineINT("ECONOMIC_STRENGTH_AVERAGE_THRESHOLD");
	m_iECONOMIC_STRENGTH_POOR_THRESHOLD = getDefineINT("ECONOMIC_STRENGTH_POOR_THRESHOLD");
	m_iECONOMIC_STRENGTH_WEAK_THRESHOLD = getDefineINT("ECONOMIC_STRENGTH_WEAK_THRESHOLD");
	m_iTARGET_IMPOSSIBLE_THRESHOLD = getDefineINT("TARGET_IMPOSSIBLE_THRESHOLD");
	m_iTARGET_BAD_THRESHOLD = getDefineINT("TARGET_BAD_THRESHOLD");
	m_iTARGET_AVERAGE_THRESHOLD = getDefineINT("TARGET_AVERAGE_THRESHOLD");
	m_iTARGET_FAVORABLE_THRESHOLD = getDefineINT("TARGET_FAVORABLE_THRESHOLD");
	m_iTARGET_INCREASE_WAR_TURNS = getDefineINT("TARGET_INCREASE_WAR_TURNS");
	m_iTARGET_MILITARY_STRENGTH_IMMENSE = getDefineINT("TARGET_MILITARY_STRENGTH_IMMENSE");
	m_iTARGET_MILITARY_STRENGTH_POWERFUL = getDefineINT("TARGET_MILITARY_STRENGTH_POWERFUL");
	m_iTARGET_MILITARY_STRENGTH_STRONG = getDefineINT("TARGET_MILITARY_STRENGTH_STRONG");
	m_iTARGET_MILITARY_STRENGTH_AVERAGE = getDefineINT("TARGET_MILITARY_STRENGTH_AVERAGE");
	m_iTARGET_MILITARY_STRENGTH_POOR = getDefineINT("TARGET_MILITARY_STRENGTH_POOR");
	m_iTARGET_MILITARY_STRENGTH_WEAK = getDefineINT("TARGET_MILITARY_STRENGTH_WEAK");
	m_iTARGET_MILITARY_STRENGTH_PATHETIC = getDefineINT("TARGET_MILITARY_STRENGTH_PATHETIC");
	m_iTARGET_ALREADY_WAR_EACH_PLAYER = getDefineINT("TARGET_ALREADY_WAR_EACH_PLAYER");
	m_iTARGET_NEIGHBORS = getDefineINT("TARGET_NEIGHBORS");
	m_iTARGET_CLOSE = getDefineINT("TARGET_CLOSE");
	m_iTARGET_FAR = getDefineINT("TARGET_FAR");
	m_iTARGET_DISTANT = getDefineINT("TARGET_DISTANT");
	m_iTARGET_MINOR_BACKUP_PATHETIC = getDefineINT("TARGET_MINOR_BACKUP_PATHETIC");
	m_iTARGET_MINOR_BACKUP_WEAK = getDefineINT("TARGET_MINOR_BACKUP_WEAK");
	m_iTARGET_MINOR_BACKUP_POOR = getDefineINT("TARGET_MINOR_BACKUP_POOR");
	m_iTARGET_MINOR_BACKUP_AVERAGE = getDefineINT("TARGET_MINOR_BACKUP_AVERAGE");
	m_iTARGET_MINOR_BACKUP_STRONG = getDefineINT("TARGET_MINOR_BACKUP_STRONG");
	m_iTARGET_MINOR_BACKUP_POWERFUL = getDefineINT("TARGET_MINOR_BACKUP_POWERFUL");
	m_iTARGET_MINOR_BACKUP_IMMENSE = getDefineINT("TARGET_MINOR_BACKUP_IMMENSE");
	m_iTARGET_MINOR_BACKUP_DISTANT = getDefineINT("TARGET_MINOR_BACKUP_DISTANT");
	m_iTARGET_MINOR_BACKUP_FAR = getDefineINT("TARGET_MINOR_BACKUP_FAR");
	m_iTARGET_MINOR_BACKUP_CLOSE = getDefineINT("TARGET_MINOR_BACKUP_CLOSE");
	m_iTARGET_MINOR_BACKUP_NEIGHBORS = getDefineINT("TARGET_MINOR_BACKUP_NEIGHBORS");
	m_iGAME_THREAT_CRITICAL_THRESHOLD = getDefineINT("GAME_THREAT_CRITICAL_THRESHOLD");
	m_iGAME_THREAT_SEVERE_THRESHOLD = getDefineINT("GAME_THREAT_SEVERE_THRESHOLD");
	m_iGAME_THREAT_MAJOR_THRESHOLD = getDefineINT("GAME_THREAT_MAJOR_THRESHOLD");
	m_iGAME_THREAT_MINOR_THRESHOLD = getDefineINT("GAME_THREAT_MINOR_THRESHOLD");
	m_iGAME_THREAT_AT_WAR_STALEMATE = getDefineINT("GAME_THREAT_AT_WAR_STALEMATE");
	m_iGAME_THREAT_AT_WAR_DEFENSIVE = getDefineINT("GAME_THREAT_AT_WAR_DEFENSIVE");
	m_iGAME_THREAT_AT_WAR_NEARLY_DEFEATED = getDefineINT("GAME_THREAT_AT_WAR_NEARLY_DEFEATED");
	m_iGAME_THREAT_AT_WAR_MILITARY_STRENGTH_IMMENSE = getDefineINT("GAME_THREAT_AT_WAR_MILITARY_STRENGTH_IMMENSE");
	m_iGAME_THREAT_AT_WAR_MILITARY_STRENGTH_POWERFUL = getDefineINT("GAME_THREAT_AT_WAR_MILITARY_STRENGTH_POWERFUL");
	m_iGAME_THREAT_AT_WAR_MILITARY_STRENGTH_STRONG = getDefineINT("GAME_THREAT_AT_WAR_MILITARY_STRENGTH_STRONG");
	m_iGAME_THREAT_AT_WAR_MILITARY_STRENGTH_AVERAGE = getDefineINT("GAME_THREAT_AT_WAR_MILITARY_STRENGTH_AVERAGE");
	m_iGAME_THREAT_GUESS_AT_WAR = getDefineINT("GAME_THREAT_GUESS_AT_WAR");
	m_iGAME_THREAT_GUESS_AT_WAR_MILITARY_STRENGTH_IMMENSE = getDefineINT("GAME_THREAT_GUESS_AT_WAR_MILITARY_STRENGTH_IMMENSE");
	m_iGAME_THREAT_GUESS_AT_WAR_MILITARY_STRENGTH_POWERFUL = getDefineINT("GAME_THREAT_GUESS_AT_WAR_MILITARY_STRENGTH_POWERFUL");
	m_iGAME_THREAT_GUESS_AT_WAR_MILITARY_STRENGTH_STRONG = getDefineINT("GAME_THREAT_GUESS_AT_WAR_MILITARY_STRENGTH_STRONG");
	m_iGAME_THREAT_GUESS_AT_WAR_MILITARY_STRENGTH_AVERAGE = getDefineINT("GAME_THREAT_GUESS_AT_WAR_MILITARY_STRENGTH_AVERAGE");
	m_iMILITARY_THREAT_CRITICAL_THRESHOLD = getDefineINT("MILITARY_THREAT_CRITICAL_THRESHOLD");
	m_iMILITARY_THREAT_SEVERE_THRESHOLD = getDefineINT("MILITARY_THREAT_SEVERE_THRESHOLD");
	m_iMILITARY_THREAT_MAJOR_THRESHOLD = getDefineINT("MILITARY_THREAT_MAJOR_THRESHOLD");
	m_iMILITARY_THREAT_MINOR_THRESHOLD = getDefineINT("MILITARY_THREAT_MINOR_THRESHOLD");
	m_iMILITARY_THREAT_STRENGTH_IMMENSE = getDefineINT("MILITARY_THREAT_STRENGTH_IMMENSE");
	m_iMILITARY_THREAT_STRENGTH_POWERFUL = getDefineINT("MILITARY_THREAT_STRENGTH_POWERFUL");
	m_iMILITARY_THREAT_STRENGTH_STRONG = getDefineINT("MILITARY_THREAT_STRENGTH_STRONG");
	m_iMILITARY_THREAT_STRENGTH_AVERAGE = getDefineINT("MILITARY_THREAT_STRENGTH_AVERAGE");
	m_iMILITARY_THREAT_STRENGTH_POOR = getDefineINT("MILITARY_THREAT_STRENGTH_POOR");
	m_iMILITARY_THREAT_STRENGTH_WEAK = getDefineINT("MILITARY_THREAT_STRENGTH_WEAK");
	m_iMILITARY_THREAT_STRENGTH_PATHETIC = getDefineINT("MILITARY_THREAT_STRENGTH_PATHETIC");
	m_iMILITARY_THREAT_WAR_STATE_CALM = getDefineINT("MILITARY_THREAT_WAR_STATE_CALM");
	m_iMILITARY_THREAT_WAR_STATE_NEARLY_WON = getDefineINT("MILITARY_THREAT_WAR_STATE_NEARLY_WON");
	m_iMILITARY_THREAT_WAR_STATE_OFFENSIVE = getDefineINT("MILITARY_THREAT_WAR_STATE_OFFENSIVE");
	m_iMILITARY_THREAT_WAR_STATE_STALEMATE = getDefineINT("MILITARY_THREAT_WAR_STATE_STALEMATE");
	m_iMILITARY_THREAT_WAR_STATE_DEFENSIVE = getDefineINT("MILITARY_THREAT_WAR_STATE_DEFENSIVE");
	m_iMILITARY_THREAT_WAR_STATE_NEARLY_DEFEATED = getDefineINT("MILITARY_THREAT_WAR_STATE_NEARLY_DEFEATED");
	m_iMILITARY_THREAT_NEIGHBORS = getDefineINT("MILITARY_THREAT_NEIGHBORS");
	m_iMILITARY_THREAT_CLOSE = getDefineINT("MILITARY_THREAT_CLOSE");
	m_iMILITARY_THREAT_FAR = getDefineINT("MILITARY_THREAT_FAR");
	m_iMILITARY_THREAT_DISTANT = getDefineINT("MILITARY_THREAT_DISTANT");
	m_iMILITARY_THREAT_PER_MINOR_ATTACKED = getDefineINT("MILITARY_THREAT_PER_MINOR_ATTACKED");
	m_iMILITARY_THREAT_PER_MINOR_CONQUERED = getDefineINT("MILITARY_THREAT_PER_MINOR_CONQUERED");
	m_iMILITARY_THREAT_PER_MAJOR_ATTACKED = getDefineINT("MILITARY_THREAT_PER_MAJOR_ATTACKED");
	m_iMILITARY_THREAT_PER_MAJOR_CONQUERED = getDefineINT("MILITARY_THREAT_PER_MAJOR_CONQUERED");
	m_iMILITARY_THREAT_ALREADY_WAR_EACH_PLAYER_MULTIPLIER = getDefineINT("MILITARY_THREAT_ALREADY_WAR_EACH_PLAYER_MULTIPLIER");
	m_iWARMONGER_THREAT_CRITICAL_THRESHOLD = getDefineINT("WARMONGER_THREAT_CRITICAL_THRESHOLD");
	m_iWARMONGER_THREAT_SEVERE_THRESHOLD = getDefineINT("WARMONGER_THREAT_SEVERE_THRESHOLD");
	m_iWARMONGER_THREAT_MAJOR_THRESHOLD = getDefineINT("WARMONGER_THREAT_MAJOR_THRESHOLD");
	m_iWARMONGER_THREAT_MINOR_THRESHOLD = getDefineINT("WARMONGER_THREAT_MINOR_THRESHOLD");
	m_iWARMONGER_THREAT_MINOR_ATTACKED_WEIGHT = getDefineINT("WARMONGER_THREAT_MINOR_ATTACKED_WEIGHT");
	m_iWARMONGER_THREAT_MINOR_CONQUERED_WEIGHT = getDefineINT("WARMONGER_THREAT_MINOR_CONQUERED_WEIGHT");
	m_iWARMONGER_THREAT_MAJOR_ATTACKED_WEIGHT = getDefineINT("WARMONGER_THREAT_MAJOR_ATTACKED_WEIGHT");
	m_iWARMONGER_THREAT_MAJOR_CONQUERED_WEIGHT = getDefineINT("WARMONGER_THREAT_MAJOR_CONQUERED_WEIGHT");
	m_iWARMONGER_THREAT_PER_TURN_DECAY = getDefineINT("WARMONGER_THREAT_PER_TURN_DECAY");
	m_iWARMONGER_THREAT_PERSONALITY_MOD = getDefineINT("WARMONGER_THREAT_PERSONALITY_MOD");
	m_iWARMONGER_THREAT_CRITICAL_PERCENT_THRESHOLD = getDefineINT("WARMONGER_THREAT_CRITICAL_PERCENT_THRESHOLD");
	m_iWARMONGER_THREAT_SEVERE_PERCENT_THRESHOLD = getDefineINT("WARMONGER_THREAT_SEVERE_PERCENT_THRESHOLD");
	m_iLAND_DISPUTE_FIERCE_THRESHOLD = getDefineINT("LAND_DISPUTE_FIERCE_THRESHOLD");
	m_iLAND_DISPUTE_STRONG_THRESHOLD = getDefineINT("LAND_DISPUTE_STRONG_THRESHOLD");
	m_iLAND_DISPUTE_WEAK_THRESHOLD = getDefineINT("LAND_DISPUTE_WEAK_THRESHOLD");
	m_iVICTORY_DISPUTE_FIERCE_THRESHOLD = getDefineINT("VICTORY_DISPUTE_FIERCE_THRESHOLD");
	m_iVICTORY_DISPUTE_STRONG_THRESHOLD = getDefineINT("VICTORY_DISPUTE_STRONG_THRESHOLD");
	m_iVICTORY_DISPUTE_WEAK_THRESHOLD = getDefineINT("VICTORY_DISPUTE_WEAK_THRESHOLD");
	m_iWONDER_DISPUTE_FIERCE_THRESHOLD = getDefineINT("WONDER_DISPUTE_FIERCE_THRESHOLD");
	m_iWONDER_DISPUTE_STRONG_THRESHOLD = getDefineINT("WONDER_DISPUTE_STRONG_THRESHOLD");
	m_iWONDER_DISPUTE_WEAK_THRESHOLD = getDefineINT("WONDER_DISPUTE_WEAK_THRESHOLD");
	m_iMINOR_CIV_DISPUTE_FIERCE_THRESHOLD = getDefineINT("MINOR_CIV_DISPUTE_FIERCE_THRESHOLD");
	m_iMINOR_CIV_DISPUTE_STRONG_THRESHOLD = getDefineINT("MINOR_CIV_DISPUTE_STRONG_THRESHOLD");
	m_iMINOR_CIV_DISPUTE_WEAK_THRESHOLD = getDefineINT("MINOR_CIV_DISPUTE_WEAK_THRESHOLD");
	m_iMINOR_CIV_DISPUTE_ALLIES_WEIGHT = getDefineINT("MINOR_CIV_DISPUTE_ALLIES_WEIGHT");
	m_iMINOR_CIV_DISPUTE_FRIENDS_WEIGHT = getDefineINT("MINOR_CIV_DISPUTE_FRIENDS_WEIGHT");
	m_iLAND_DISPUTE_EXP_AGGRESSIVE_POSTURE_NONE = getDefineINT("LAND_DISPUTE_EXP_AGGRESSIVE_POSTURE_NONE");
	m_iLAND_DISPUTE_EXP_AGGRESSIVE_POSTURE_LOW = getDefineINT("LAND_DISPUTE_EXP_AGGRESSIVE_POSTURE_LOW");
	m_iLAND_DISPUTE_EXP_AGGRESSIVE_POSTURE_MEDIUM = getDefineINT("LAND_DISPUTE_EXP_AGGRESSIVE_POSTURE_MEDIUM");
	m_iLAND_DISPUTE_EXP_AGGRESSIVE_POSTURE_HIGH = getDefineINT("LAND_DISPUTE_EXP_AGGRESSIVE_POSTURE_HIGH");
	m_iLAND_DISPUTE_EXP_AGGRESSIVE_POSTURE_INCREDIBLE = getDefineINT("LAND_DISPUTE_EXP_AGGRESSIVE_POSTURE_INCREDIBLE");
	m_iLAND_DISPUTE_PLOT_BUY_AGGRESSIVE_POSTURE_NONE = getDefineINT("LAND_DISPUTE_PLOT_BUY_AGGRESSIVE_POSTURE_NONE");
	m_iLAND_DISPUTE_PLOT_BUY_AGGRESSIVE_POSTURE_LOW = getDefineINT("LAND_DISPUTE_PLOT_BUY_AGGRESSIVE_POSTURE_LOW");
	m_iLAND_DISPUTE_PLOT_BUY_AGGRESSIVE_POSTURE_MEDIUM = getDefineINT("LAND_DISPUTE_PLOT_BUY_AGGRESSIVE_POSTURE_MEDIUM");
	m_iLAND_DISPUTE_PLOT_BUY_AGGRESSIVE_POSTURE_HIGH = getDefineINT("LAND_DISPUTE_PLOT_BUY_AGGRESSIVE_POSTURE_HIGH");
	m_iLAND_DISPUTE_PLOT_BUY_AGGRESSIVE_POSTURE_INCREDIBLE = getDefineINT("LAND_DISPUTE_PLOT_BUY_AGGRESSIVE_POSTURE_INCREDIBLE");
	m_iLAND_DISPUTE_DISTANT = getDefineINT("LAND_DISPUTE_DISTANT");
	m_iLAND_DISPUTE_FAR = getDefineINT("LAND_DISPUTE_FAR");
	m_iLAND_DISPUTE_CLOSE = getDefineINT("LAND_DISPUTE_CLOSE");
	m_iLAND_DISPUTE_NEIGHBORS = getDefineINT("LAND_DISPUTE_NEIGHBORS");
	m_iLAND_DISPUTE_CRAMPED_MULTIPLIER = getDefineINT("LAND_DISPUTE_CRAMPED_MULTIPLIER");
	m_iLAND_DISPUTE_NO_EXPANSION_STRATEGY = getDefineINT("LAND_DISPUTE_NO_EXPANSION_STRATEGY");
	m_iVICTORY_DISPUTE_GRAND_STRATEGY_MATCH_POSITIVE = getDefineINT("VICTORY_DISPUTE_GRAND_STRATEGY_MATCH_POSITIVE");
	m_iVICTORY_DISPUTE_GRAND_STRATEGY_MATCH_LIKELY = getDefineINT("VICTORY_DISPUTE_GRAND_STRATEGY_MATCH_LIKELY");
	m_iVICTORY_DISPUTE_GRAND_STRATEGY_MATCH_UNSURE = getDefineINT("VICTORY_DISPUTE_GRAND_STRATEGY_MATCH_UNSURE");
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_10 = getDefineINT("LAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_10");
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_9 = getDefineINT("LAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_9");
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_8 = getDefineINT("LAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_8");
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_7 = getDefineINT("LAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_7");
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_6 = getDefineINT("LAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_6");
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_5 = getDefineINT("LAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_5");
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_4 = getDefineINT("LAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_4");
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_3 = getDefineINT("LAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_3");
	m_iLAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_2 = getDefineINT("LAND_DISPUTE_CITY_RATIO_EXPANSION_GUESS_2");
	m_iVICTORY_DISPUTE_OTHER_PLAYER_FIERCE_THRESHOLD = getDefineINT("VICTORY_DISPUTE_OTHER_PLAYER_FIERCE_THRESHOLD");
	m_iVICTORY_DISPUTE_OTHER_PLAYER_STRONG_THRESHOLD = getDefineINT("VICTORY_DISPUTE_OTHER_PLAYER_STRONG_THRESHOLD");
	m_iVICTORY_DISPUTE_OTHER_PLAYER_WEAK_THRESHOLD = getDefineINT("VICTORY_DISPUTE_OTHER_PLAYER_WEAK_THRESHOLD");
	m_iVICTORY_DISPUTE_OTHER_PLAYER_GRAND_STRATEGY_MATCH_POSITIVE = getDefineINT("VICTORY_DISPUTE_OTHER_PLAYER_GRAND_STRATEGY_MATCH_POSITIVE");
	m_iVICTORY_DISPUTE_OTHER_PLAYER_GRAND_STRATEGY_MATCH_LIKELY = getDefineINT("VICTORY_DISPUTE_OTHER_PLAYER_GRAND_STRATEGY_MATCH_LIKELY");
	m_iVICTORY_DISPUTE_OTHER_PLAYER_GRAND_STRATEGY_MATCH_UNSURE = getDefineINT("VICTORY_DISPUTE_OTHER_PLAYER_GRAND_STRATEGY_MATCH_UNSURE");
	m_iIC_MEMORY_TURN_EXPIRATION = getDefineINT("IC_MEMORY_TURN_EXPIRATION");
	m_iSTOP_SPYING_MEMORY_TURN_EXPIRATION = getDefineINT("STOP_SPYING_MEMORY_TURN_EXPIRATION");
	m_iCOOP_WAR_SOON_COUNTER = getDefineINT("COOP_WAR_SOON_COUNTER");
	m_iCOOP_WAR_LOCKED_TURNS = getDefineINT("COOP_WAR_LOCKED_TURNS");
	m_iCOOP_WAR_LOCKED_TURNS_WAR_WEIGHT = getDefineINT("COOP_WAR_LOCKED_TURNS_WAR_WEIGHT");
	m_iDEMAND_TURN_LIMIT_MIN = getDefineINT("DEMAND_TURN_LIMIT_MIN");
	m_iDEMAND_TURN_LIMIT_RAND = getDefineINT("DEMAND_TURN_LIMIT_RAND");
	m_iDONT_SETTLE_RAND = getDefineINT("DONT_SETTLE_RAND");
	m_iDONT_SETTLE_FLAVOR_BASE = getDefineINT("DONT_SETTLE_FLAVOR_BASE");
	m_iDONT_SETTLE_FLAVOR_MULTIPLIER = getDefineINT("DONT_SETTLE_FLAVOR_MULTIPLIER");
	m_iDONT_SETTLE_FRIENDLY = getDefineINT("DONT_SETTLE_FRIENDLY");
	m_iDONT_SETTLE_STRENGTH_PATHETIC = getDefineINT("DONT_SETTLE_STRENGTH_PATHETIC");
	m_iDONT_SETTLE_STRENGTH_WEAK = getDefineINT("DONT_SETTLE_STRENGTH_WEAK");
	m_iDONT_SETTLE_STRENGTH_POOR = getDefineINT("DONT_SETTLE_STRENGTH_POOR");
	m_iDONT_SETTLE_STRENGTH_AVERAGE = getDefineINT("DONT_SETTLE_STRENGTH_AVERAGE");
	m_iDONT_SETTLE_STRENGTH_STRONG = getDefineINT("DONT_SETTLE_STRENGTH_STRONG");
	m_iDONT_SETTLE_STRENGTH_POWERFUL = getDefineINT("DONT_SETTLE_STRENGTH_POWERFUL");
	m_iDONT_SETTLE_STRENGTH_IMMENSE = getDefineINT("DONT_SETTLE_STRENGTH_IMMENSE");
	m_iDONT_SETTLE_MOD_MILITARY_POSTURE_NONE = getDefineINT("DONT_SETTLE_MOD_MILITARY_POSTURE_NONE");
	m_iDONT_SETTLE_MOD_MILITARY_POSTURE_LOW = getDefineINT("DONT_SETTLE_MOD_MILITARY_POSTURE_LOW");
	m_iDONT_SETTLE_MOD_MILITARY_POSTURE_MEDIUM = getDefineINT("DONT_SETTLE_MOD_MILITARY_POSTURE_MEDIUM");
	m_iDONT_SETTLE_MOD_MILITARY_POSTURE_HIGH = getDefineINT("DONT_SETTLE_MOD_MILITARY_POSTURE_HIGH");
	m_iDONT_SETTLE_MOD_MILITARY_POSTURE_INCREDIBLE = getDefineINT("DONT_SETTLE_MOD_MILITARY_POSTURE_INCREDIBLE");
	m_iDOF_TURN_BUFFER = getDefineINT("DOF_TURN_BUFFER");
	m_iDOF_THRESHOLD = getDefineINT("DOF_THRESHOLD");
	m_iDENUNCIATION_EXPIRATION_TIME = getDefineINT("DENUNCIATION_EXPIRATION_TIME");
	m_iDOF_EXPIRATION_TIME = getDefineINT("DOF_EXPIRATION_TIME");
	m_iEACH_GOLD_VALUE_PERCENT = getDefineINT("EACH_GOLD_VALUE_PERCENT");
	m_iEACH_GOLD_PER_TURN_VALUE_PERCENT = getDefineINT("EACH_GOLD_PER_TURN_VALUE_PERCENT");

	m_iEXPANSION_BICKER_TIMEOUT = getDefineINT("EXPANSION_BICKER_TIMEOUT");
	m_iEXPANSION_PROMISE_TURNS_EFFECTIVE = getDefineINT("EXPANSION_PROMISE_TURNS_EFFECTIVE");
	m_iEXPANSION_PROMISE_BROKEN_PER_TURN_DECAY = getDefineINT("EXPANSION_PROMISE_BROKEN_PER_TURN_DECAY");
	m_iBROKEN_EXPANSION_PROMISE_PER_OPINION_WEIGHT = getDefineINT("BROKEN_EXPANSION_PROMISE_PER_OPINION_WEIGHT");
	m_iOPINION_WEIGHT_EXPANSION_PROMISE_BROKE_MAX = getDefineINT("OPINION_WEIGHT_EXPANSION_PROMISE_BROKE_MAX");
	m_iEXPANSION_PROMISE_IGNORED_PER_TURN_DECAY = getDefineINT("EXPANSION_PROMISE_IGNORED_PER_TURN_DECAY");
	m_iIGNORED_EXPANSION_PROMISE_PER_OPINION_WEIGHT = getDefineINT("IGNORED_EXPANSION_PROMISE_PER_OPINION_WEIGHT");
	m_iOPINION_WEIGHT_EXPANSION_PROMISE_IGNORED_MAX = getDefineINT("OPINION_WEIGHT_EXPANSION_PROMISE_IGNORED_MAX");

	m_iBORDER_PROMISE_TURNS_EFFECTIVE = getDefineINT("BORDER_PROMISE_TURNS_EFFECTIVE");
	m_iBORDER_PROMISE_BROKEN_PER_TURN_DECAY = getDefineINT("BORDER_PROMISE_BROKEN_PER_TURN_DECAY");
	m_iBROKEN_BORDER_PROMISE_PER_OPINION_WEIGHT = getDefineINT("BROKEN_BORDER_PROMISE_PER_OPINION_WEIGHT");
	m_iOPINION_WEIGHT_BORDER_PROMISE_BROKE_MAX = getDefineINT("OPINION_WEIGHT_BORDER_PROMISE_BROKE_MAX");
	m_iBORDER_PROMISE_IGNORED_PER_TURN_DECAY = getDefineINT("BORDER_PROMISE_IGNORED_PER_TURN_DECAY");
	m_iIGNORED_BORDER_PROMISE_PER_OPINION_WEIGHT = getDefineINT("IGNORED_BORDER_PROMISE_PER_OPINION_WEIGHT");
	m_iOPINION_WEIGHT_BORDER_PROMISE_IGNORED_MAX = getDefineINT("OPINION_WEIGHT_BORDER_PROMISE_IGNORED_MAX");
	m_iDECLARED_WAR_ON_FRIEND_PER_TURN_DECAY = getDefineINT("DECLARED_WAR_ON_FRIEND_PER_TURN_DECAY");
	m_iDECLARED_WAR_ON_FRIEND_PER_OPINION_WEIGHT = getDefineINT("DECLARED_WAR_ON_FRIEND_PER_OPINION_WEIGHT");

	m_iDEAL_VALUE_PER_TURN_DECAY = getDefineINT("DEAL_VALUE_PER_TURN_DECAY");
	m_iDEAL_VALUE_PER_OPINION_WEIGHT = getDefineINT("DEAL_VALUE_PER_OPINION_WEIGHT");
	m_iCOMMON_FOE_VALUE_PER_TURN_DECAY = getDefineINT("COMMON_FOE_VALUE_PER_TURN_DECAY");
	m_iCOMMON_FOE_VALUE_PER_OPINION_WEIGHT = getDefineINT("COMMON_FOE_VALUE_PER_OPINION_WEIGHT");
	m_iWANT_RESEARCH_AGREEMENT_RAND = getDefineINT("WANT_RESEARCH_AGREEMENT_RAND");
	m_iDEMAND_RAND = getDefineINT("DEMAND_RAND");
	m_iCAN_WORK_WATER_FROM_GAME_START = getDefineINT("CAN_WORK_WATER_FROM_GAME_START");
	m_iNAVAL_PLOT_BLOCKADE_RANGE = getDefineINT("NAVAL_PLOT_BLOCKADE_RANGE");
	m_iEVENT_MESSAGE_TIME = getDefineINT("EVENT_MESSAGE_TIME");
	m_iSTART_YEAR = getDefineINT("START_YEAR");
	m_iWEEKS_PER_MONTHS = getDefineINT("WEEKS_PER_MONTHS");
	m_iHIDDEN_START_TURN_OFFSET = getDefineINT("HIDDEN_START_TURN_OFFSET");
	m_iRECON_VISIBILITY_RANGE = getDefineINT("RECON_VISIBILITY_RANGE");
	m_iPLOT_VISIBILITY_RANGE = getDefineINT("PLOT_VISIBILITY_RANGE");
	m_iUNIT_VISIBILITY_RANGE = getDefineINT("UNIT_VISIBILITY_RANGE");
	m_iAIR_UNIT_REBASE_RANGE_MULTIPLIER = getDefineINT("AIR_UNIT_REBASE_RANGE_MULTIPLIER");
	m_iMOUNTAIN_SEE_FROM_CHANGE = getDefineINT("MOUNTAIN_SEE_FROM_CHANGE");
	m_iMOUNTAIN_SEE_THROUGH_CHANGE = getDefineINT("MOUNTAIN_SEE_THROUGH_CHANGE");
	m_iHILLS_SEE_FROM_CHANGE = getDefineINT("HILLS_SEE_FROM_CHANGE");
	m_iHILLS_SEE_THROUGH_CHANGE = getDefineINT("HILLS_SEE_THROUGH_CHANGE");
	m_iSEAWATER_SEE_FROM_CHANGE = getDefineINT("SEAWATER_SEE_FROM_CHANGE");
	m_iSEAWATER_SEE_THROUGH_CHANGE = getDefineINT("SEAWATER_SEE_THROUGH_CHANGE");
	m_iMAX_YIELD_STACK = getDefineINT("MAX_YIELD_STACK");
	m_iMOVE_DENOMINATOR = getDefineINT("MOVE_DENOMINATOR");
	m_iSTARTING_DISTANCE_PERCENT = getDefineINT("STARTING_DISTANCE_PERCENT");
	m_iMIN_CIV_STARTING_DISTANCE = getDefineINT("MIN_CIV_STARTING_DISTANCE");
	m_iMIN_CITY_RANGE = getDefineINT("MIN_CITY_RANGE");
	m_iOWNERSHIP_SCORE_DURATION_THRESHOLD = getDefineINT("OWNERSHIP_SCORE_DURATION_THRESHOLD");
	m_iNUM_POLICY_BRANCHES_ALLOWED = getDefineINT("NUM_POLICY_BRANCHES_ALLOWED");
	m_iVICTORY_POINTS_NEEDED_TO_WIN = getDefineINT("VICTORY_POINTS_NEEDED_TO_WIN");
	m_iNUM_VICTORY_POINT_AWARDS = getDefineINT("NUM_VICTORY_POINT_AWARDS");
	m_iNUM_OR_TECH_PREREQS = getDefineINT("NUM_OR_TECH_PREREQS");
	m_iNUM_AND_TECH_PREREQS = getDefineINT("NUM_AND_TECH_PREREQS");
	m_iNUM_UNIT_AND_TECH_PREREQS = getDefineINT("NUM_UNIT_AND_TECH_PREREQS");
	m_iNUM_BUILDING_AND_TECH_PREREQS = getDefineINT("NUM_BUILDING_AND_TECH_PREREQS");
	m_iNUM_BUILDING_RESOURCE_PREREQS = getDefineINT("NUM_BUILDING_RESOURCE_PREREQS");
	m_iBASE_RESEARCH_RATE = getDefineINT("BASE_RESEARCH_RATE");
	m_iMAX_WORLD_WONDERS_PER_CITY = getDefineINT("MAX_WORLD_WONDERS_PER_CITY");
	m_iMAX_TEAM_WONDERS_PER_CITY = getDefineINT("MAX_TEAM_WONDERS_PER_CITY");
	m_iMAX_NATIONAL_WONDERS_PER_CITY = getDefineINT("MAX_NATIONAL_WONDERS_PER_CITY");
	m_iMAX_NATIONAL_WONDERS_PER_CITY_FOR_OCC = getDefineINT("MAX_NATIONAL_WONDERS_PER_CITY_FOR_OCC");
	m_iMAX_BUILDINGS_PER_CITY = getDefineINT("MAX_BUILDINGS_PER_CITY");
	m_iINITIAL_CITY_POPULATION = getDefineINT("INITIAL_CITY_POPULATION");
	m_iCITY_CAPTURE_POPULATION_PERCENT = getDefineINT("CITY_CAPTURE_POPULATION_PERCENT");
	m_iBASE_CITY_GROWTH_THRESHOLD = getDefineINT("BASE_CITY_GROWTH_THRESHOLD");
	m_iFOOD_CONSUMPTION_PER_POPULATION = getDefineINT("FOOD_CONSUMPTION_PER_POPULATION");
	m_iHAPPINESS_PER_CITY_WITH_STATE_RELIGION = getDefineINT("HAPPINESS_PER_CITY_WITH_STATE_RELIGION");
	m_iHAPPINESS_PER_NATURAL_WONDER = getDefineINT("HAPPINESS_PER_NATURAL_WONDER");
	m_iHAPPINESS_PER_EXTRA_LUXURY = getDefineINT("HAPPINESS_PER_EXTRA_LUXURY");
	m_iUNHAPPINESS_PER_POPULATION = getDefineINT("UNHAPPINESS_PER_POPULATION");
	m_fUNHAPPINESS_PER_OCCUPIED_POPULATION = getDefineFLOAT("UNHAPPINESS_PER_OCCUPIED_POPULATION");
	m_iUNHAPPINESS_PER_CITY = getDefineINT("UNHAPPINESS_PER_CITY");
	m_iUNHAPPINESS_PER_CAPTURED_CITY = getDefineINT("UNHAPPINESS_PER_CAPTURED_CITY");
	m_iUNHAPPY_GROWTH_PENALTY = getDefineINT("UNHAPPY_GROWTH_PENALTY");
	m_iVERY_UNHAPPY_GROWTH_PENALTY = getDefineINT("VERY_UNHAPPY_GROWTH_PENALTY");
	m_iVERY_UNHAPPY_CANT_TRAIN_SETTLERS = getDefineINT("VERY_UNHAPPY_CANT_TRAIN_SETTLERS");
	m_iVERY_UNHAPPY_THRESHOLD = getDefineINT("VERY_UNHAPPY_THRESHOLD");
	m_iSUPER_UNHAPPY_THRESHOLD = getDefineINT("SUPER_UNHAPPY_THRESHOLD");
	m_iREVOLT_COUNTER_MIN = getDefineINT("REVOLT_COUNTER_MIN");
	m_iREVOLT_COUNTER_POSSIBLE = getDefineINT("REVOLT_COUNTER_POSSIBLE");
	m_iREVOLT_NUM_BASE = getDefineINT("REVOLT_NUM_BASE");
	m_iREVOLT_NUM_CITY_COUNT = getDefineINT("REVOLT_NUM_CITY_COUNT");
	m_iVERY_UNHAPPY_COMBAT_PENALTY = getDefineINT("VERY_UNHAPPY_COMBAT_PENALTY");
	m_iSTRATEGIC_RESOURCE_EXHAUSTED_PENALTY = getDefineINT("STRATEGIC_RESOURCE_EXHAUSTED_PENALTY");
	m_iVERY_UNHAPPY_PRODUCTION_PENALTY = getDefineINT("VERY_UNHAPPY_PRODUCTION_PENALTY");
	m_iWLTKD_GROWTH_MULTIPLIER = getDefineINT("WLTKD_GROWTH_MULTIPLIER");
	m_iINDUSTRIAL_ROUTE_PRODUCTION_MOD = getDefineINT("INDUSTRIAL_ROUTE_PRODUCTION_MOD");
	m_iRESOURCE_DEMAND_COUNTDOWN_BASE = getDefineINT("RESOURCE_DEMAND_COUNTDOWN_BASE");
	m_iRESOURCE_DEMAND_COUNTDOWN_CAPITAL_ADD = getDefineINT("RESOURCE_DEMAND_COUNTDOWN_CAPITAL_ADD");
	m_iRESOURCE_DEMAND_COUNTDOWN_RAND = getDefineINT("RESOURCE_DEMAND_COUNTDOWN_RAND");
	m_iNEW_HURRY_MODIFIER = getDefineINT("NEW_HURRY_MODIFIER");
	m_iGREAT_GENERAL_RANGE = getDefineINT("GREAT_GENERAL_RANGE");
	m_iGREAT_GENERAL_STRENGTH_MOD = getDefineINT("GREAT_GENERAL_STRENGTH_MOD");
	m_iBONUS_PER_ADJACENT_FRIEND = getDefineINT("BONUS_PER_ADJACENT_FRIEND");
	m_iPOLICY_ATTACK_BONUS_MOD = getDefineINT("POLICY_ATTACK_BONUS_MOD");
	m_iCONSCRIPT_MIN_CITY_POPULATION = getDefineINT("CONSCRIPT_MIN_CITY_POPULATION");
	m_iCONSCRIPT_POPULATION_PER_COST = getDefineINT("CONSCRIPT_POPULATION_PER_COST");
	m_iMIN_TIMER_UNIT_DOUBLE_MOVES = getDefineINT("MIN_TIMER_UNIT_DOUBLE_MOVES");
	m_iCOMBAT_DAMAGE = getDefineINT("COMBAT_DAMAGE");
	m_iNONCOMBAT_UNIT_RANGED_DAMAGE = getDefineINT("NONCOMBAT_UNIT_RANGED_DAMAGE");
	m_iNAVAL_COMBAT_DEFENDER_STRENGTH_MULTIPLIER = getDefineINT("NAVAL_COMBAT_DEFENDER_STRENGTH_MULTIPLIER");
	m_iLAKE_PLOT_RAND = getDefineINT("LAKE_PLOT_RAND");
	m_iPLOTS_PER_RIVER_EDGE = getDefineINT("PLOTS_PER_RIVER_EDGE");
	m_iRIVER_SOURCE_MIN_RIVER_RANGE = getDefineINT("RIVER_SOURCE_MIN_RIVER_RANGE");
	m_iRIVER_SOURCE_MIN_SEAWATER_RANGE = getDefineINT("RIVER_SOURCE_MIN_SEAWATER_RANGE");
	m_iLAKE_MAX_AREA_SIZE = getDefineINT("LAKE_MAX_AREA_SIZE");
	m_iINITIAL_GOLD_PER_UNIT_TIMES_100 = getDefineINT("INITIAL_GOLD_PER_UNIT_TIMES_100");
	m_iINITIAL_FREE_OUTSIDE_UNITS = getDefineINT("INITIAL_FREE_OUTSIDE_UNITS");
	m_iINITIAL_OUTSIDE_UNIT_GOLD_PERCENT = getDefineINT("INITIAL_OUTSIDE_UNIT_GOLD_PERCENT");
	m_iUNIT_MAINTENANCE_GAME_MULTIPLIER = getDefineINT("UNIT_MAINTENANCE_GAME_MULTIPLIER");
	m_iUNIT_MAINTENANCE_GAME_EXPONENT_DIVISOR = getDefineINT("UNIT_MAINTENANCE_GAME_EXPONENT_DIVISOR");
	m_iFREE_UNIT_HAPPINESS = getDefineINT("FREE_UNIT_HAPPINESS");
	m_iTRADE_ROUTE_BASE_GOLD = getDefineINT("TRADE_ROUTE_BASE_GOLD");
	m_iTRADE_ROUTE_CAPITAL_POP_GOLD_MULTIPLIER = getDefineINT("TRADE_ROUTE_CAPITAL_POP_GOLD_MULTIPLIER");
	m_iTRADE_ROUTE_CITY_POP_GOLD_MULTIPLIER = getDefineINT("TRADE_ROUTE_CITY_POP_GOLD_MULTIPLIER");
	m_iDEFICIT_UNIT_DISBANDING_THRESHOLD = getDefineINT("DEFICIT_UNIT_DISBANDING_THRESHOLD");
	m_iGOLDEN_AGE_BASE_THRESHOLD_HAPPINESS = getDefineINT("GOLDEN_AGE_BASE_THRESHOLD_HAPPINESS");
	m_fGOLDEN_AGE_THRESHOLD_CITY_MULTIPLIER = getDefineFLOAT("GOLDEN_AGE_THRESHOLD_CITY_MULTIPLIER");
	m_iGOLDEN_AGE_EACH_GA_ADDITIONAL_HAPPINESS = getDefineINT("GOLDEN_AGE_EACH_GA_ADDITIONAL_HAPPINESS");
	m_iGOLDEN_AGE_VISIBLE_THRESHOLD_DIVISOR = getDefineINT("GOLDEN_AGE_VISIBLE_THRESHOLD_DIVISOR");
	m_iBASE_GOLDEN_AGE_UNITS = getDefineINT("BASE_GOLDEN_AGE_UNITS");
	m_iGOLDEN_AGE_UNITS_MULTIPLIER = getDefineINT("GOLDEN_AGE_UNITS_MULTIPLIER");
	m_iGOLDEN_AGE_LENGTH = getDefineINT("GOLDEN_AGE_LENGTH");
	m_iGOLDEN_AGE_GREAT_PEOPLE_MODIFIER = getDefineINT("GOLDEN_AGE_GREAT_PEOPLE_MODIFIER");
	m_iMIN_UNIT_GOLDEN_AGE_TURNS = getDefineINT("MIN_UNIT_GOLDEN_AGE_TURNS");
	m_iGOLDEN_AGE_CULTURE_MODIFIER = getDefineINT("GOLDEN_AGE_CULTURE_MODIFIER");
	m_iHILLS_EXTRA_MOVEMENT = getDefineINT("HILLS_EXTRA_MOVEMENT");
	m_iRIVER_EXTRA_MOVEMENT = getDefineINT("RIVER_EXTRA_MOVEMENT");
	m_iFEATURE_GROWTH_MODIFIER = getDefineINT("FEATURE_GROWTH_MODIFIER");
	m_iROUTE_FEATURE_GROWTH_MODIFIER = getDefineINT("ROUTE_FEATURE_GROWTH_MODIFIER");
	m_iEXTRA_YIELD = getDefineINT("EXTRA_YIELD");
	m_iFORTIFY_MODIFIER_PER_TURN = getDefineINT("FORTIFY_MODIFIER_PER_TURN");
	m_iMAX_FORTIFY_TURNS = getDefineINT("MAX_FORTIFY_TURNS");
	m_iNUKE_FALLOUT_PROB = getDefineINT("NUKE_FALLOUT_PROB");
	m_iNUKE_UNIT_DAMAGE_BASE = getDefineINT("NUKE_UNIT_DAMAGE_BASE");
	m_iNUKE_UNIT_DAMAGE_RAND_1 = getDefineINT("NUKE_UNIT_DAMAGE_RAND_1");
	m_iNUKE_UNIT_DAMAGE_RAND_2 = getDefineINT("NUKE_UNIT_DAMAGE_RAND_2");
	m_iNUKE_NON_COMBAT_DEATH_THRESHOLD = getDefineINT("NUKE_NON_COMBAT_DEATH_THRESHOLD");
	m_iNUKE_LEVEL1_POPULATION_DEATH_BASE = getDefineINT("NUKE_LEVEL1_POPULATION_DEATH_BASE");
	m_iNUKE_LEVEL1_POPULATION_DEATH_RAND_1 = getDefineINT("NUKE_LEVEL1_POPULATION_DEATH_RAND_1");
	m_iNUKE_LEVEL1_POPULATION_DEATH_RAND_2 = getDefineINT("NUKE_LEVEL1_POPULATION_DEATH_RAND_2");
	m_iNUKE_LEVEL2_POPULATION_DEATH_BASE = getDefineINT("NUKE_LEVEL2_POPULATION_DEATH_BASE");
	m_iNUKE_LEVEL2_POPULATION_DEATH_RAND_1 = getDefineINT("NUKE_LEVEL2_POPULATION_DEATH_RAND_1");
	m_iNUKE_LEVEL2_POPULATION_DEATH_RAND_2 = getDefineINT("NUKE_LEVEL2_POPULATION_DEATH_RAND_2");
	m_iNUKE_LEVEL2_ELIM_POPULATION_THRESHOLD = getDefineINT("NUKE_LEVEL2_ELIM_POPULATION_THRESHOLD");
	m_iNUKE_CITY_HIT_POINT_DAMAGE = getDefineINT("NUKE_CITY_HIT_POINT_DAMAGE");
	m_iNUKE_BLAST_RADIUS = getDefineINT("NUKE_BLAST_RADIUS");
	m_iTECH_COST_EXTRA_TEAM_MEMBER_MODIFIER = getDefineINT("TECH_COST_EXTRA_TEAM_MEMBER_MODIFIER");
	m_iTECH_COST_TOTAL_KNOWN_TEAM_MODIFIER = getDefineINT("TECH_COST_TOTAL_KNOWN_TEAM_MODIFIER");
	m_iTECH_COST_KNOWN_PREREQ_MODIFIER = getDefineINT("TECH_COST_KNOWN_PREREQ_MODIFIER");
	m_iPEACE_TREATY_LENGTH = getDefineINT("PEACE_TREATY_LENGTH");
	m_iCOOP_WAR_LOCKED_LENGTH = getDefineINT("COOP_WAR_LOCKED_LENGTH");
	m_iBASE_FEATURE_PRODUCTION_PERCENT = getDefineINT("BASE_FEATURE_PRODUCTION_PERCENT");
	m_iFEATURE_PRODUCTION_PERCENT_MULTIPLIER = getDefineINT("FEATURE_PRODUCTION_PERCENT_MULTIPLIER");
	m_iDIFFERENT_TEAM_FEATURE_PRODUCTION_PERCENT = getDefineINT("DIFFERENT_TEAM_FEATURE_PRODUCTION_PERCENT");
	m_iDEFAULT_WAR_VALUE_FOR_UNIT = getDefineINT("DEFAULT_WAR_VALUE_FOR_UNIT");
	m_iUNIT_PRODUCTION_PERCENT = getDefineINT("UNIT_PRODUCTION_PERCENT");
	m_iMAX_UNIT_SUPPLY_PRODMOD = getDefineINT("MAX_UNIT_SUPPLY_PRODMOD");
	m_iBUILDING_PRODUCTION_PERCENT = getDefineINT("BUILDING_PRODUCTION_PERCENT");
	m_iPROJECT_PRODUCTION_PERCENT = getDefineINT("PROJECT_PRODUCTION_PERCENT");
	m_iMAXED_UNIT_GOLD_PERCENT = getDefineINT("MAXED_UNIT_GOLD_PERCENT");
	m_iMAXED_BUILDING_GOLD_PERCENT = getDefineINT("MAXED_BUILDING_GOLD_PERCENT");
	m_iMAXED_PROJECT_GOLD_PERCENT = getDefineINT("MAXED_PROJECT_GOLD_PERCENT");
	m_iMAX_CITY_DEFENSE_DAMAGE = getDefineINT("MAX_CITY_DEFENSE_DAMAGE");
	m_iCIRCUMNAVIGATE_FREE_MOVES = getDefineINT("CIRCUMNAVIGATE_FREE_MOVES");
	m_iBASE_CAPTURE_GOLD = getDefineINT("BASE_CAPTURE_GOLD");
	m_iCAPTURE_GOLD_PER_POPULATION = getDefineINT("CAPTURE_GOLD_PER_POPULATION");
	m_iCAPTURE_GOLD_RAND1 = getDefineINT("CAPTURE_GOLD_RAND1");
	m_iCAPTURE_GOLD_RAND2 = getDefineINT("CAPTURE_GOLD_RAND2");
	m_iCAPTURE_GOLD_MAX_TURNS = getDefineINT("CAPTURE_GOLD_MAX_TURNS");
	m_iBARBARIAN_CITY_ATTACK_MODIFIER = getDefineINT("BARBARIAN_CITY_ATTACK_MODIFIER");
	m_iBUILDING_PRODUCTION_DECAY_TIME = getDefineINT("BUILDING_PRODUCTION_DECAY_TIME");
	m_iBUILDING_PRODUCTION_DECAY_PERCENT = getDefineINT("BUILDING_PRODUCTION_DECAY_PERCENT");
	m_iUNIT_PRODUCTION_DECAY_TIME = getDefineINT("UNIT_PRODUCTION_DECAY_TIME");
	m_iUNIT_PRODUCTION_DECAY_PERCENT = getDefineINT("UNIT_PRODUCTION_DECAY_PERCENT");
	m_iBASE_UNIT_UPGRADE_COST = getDefineINT("BASE_UNIT_UPGRADE_COST");
	m_iUNIT_UPGRADE_COST_PER_PRODUCTION = getDefineINT("UNIT_UPGRADE_COST_PER_PRODUCTION");
	m_iUNIT_UPGRADE_COST_VISIBLE_DIVISOR = getDefineINT("UNIT_UPGRADE_COST_VISIBLE_DIVISOR");
	m_iUNIT_UPGRADE_COST_DISCOUNT_MAX = getDefineINT("UNIT_UPGRADE_COST_DISCOUNT_MAX");
	m_iWAR_SUCCESS_UNIT_CAPTURING = getDefineINT("WAR_SUCCESS_UNIT_CAPTURING");
	m_iWAR_SUCCESS_CITY_CAPTURING = getDefineINT("WAR_SUCCESS_CITY_CAPTURING");
	m_iDIPLO_VOTE_SECRETARY_GENERAL_INTERVAL = getDefineINT("DIPLO_VOTE_SECRETARY_GENERAL_INTERVAL");
	m_iTEAM_VOTE_MIN_CANDIDATES = getDefineINT("TEAM_VOTE_MIN_CANDIDATES");
	m_iRESEARCH_AGREEMENT_TIMER = getDefineINT("RESEARCH_AGREEMENT_TIMER");
	m_iRESEARCH_AGREEMENT_BOOST_DIVISOR = getDefineINT("RESEARCH_AGREEMENT_BOOST_DIVISOR");
	m_iSCORE_POPULATION_FACTOR = getDefineINT("SCORE_POPULATION_FACTOR");
	m_iSCORE_LAND_FACTOR = getDefineINT("SCORE_LAND_FACTOR");
	m_iSCORE_WONDER_FACTOR = getDefineINT("SCORE_WONDER_FACTOR");
	m_iSCORE_TECH_FACTOR = getDefineINT("SCORE_TECH_FACTOR");
	m_iSCORE_FREE_PERCENT = getDefineINT("SCORE_FREE_PERCENT");
	m_iSCORE_VICTORY_PERCENT = getDefineINT("SCORE_VICTORY_PERCENT");
	m_iSCORE_HANDICAP_PERCENT_OFFSET = getDefineINT("SCORE_HANDICAP_PERCENT_OFFSET");
	m_iSCORE_HANDICAP_PERCENT_PER = getDefineINT("SCORE_HANDICAP_PERCENT_PER");
	m_iMINIMAP_RENDER_SIZE = getDefineINT("MINIMAP_RENDER_SIZE");
	m_iMAX_INTERCEPTION_PROBABILITY = getDefineINT("MAX_INTERCEPTION_PROBABILITY");
	m_iMAX_EVASION_PROBABILITY = getDefineINT("MAX_EVASION_PROBABILITY");
	m_iPLAYER_ALWAYS_RAZES_CITIES = getDefineINT("PLAYER_ALWAYS_RAZES_CITIES");
	m_iMIN_WATER_SIZE_FOR_OCEAN = getDefineINT("MIN_WATER_SIZE_FOR_OCEAN");
	m_iCITY_SCREEN_CLICK_WILL_EXIT = getDefineINT("CITY_SCREEN_CLICK_WILL_EXIT");
	m_iWATER_POTENTIAL_CITY_WORK_FOR_AREA = getDefineINT("WATER_POTENTIAL_CITY_WORK_FOR_AREA");
	m_iLAND_UNITS_CAN_ATTACK_WATER_CITIES = getDefineINT("LAND_UNITS_CAN_ATTACK_WATER_CITIES");
	m_iCITY_MAX_NUM_BUILDINGS = getDefineINT("CITY_MAX_NUM_BUILDINGS");
	m_iCITY_MIN_SIZE_FOR_SETTLERS = getDefineINT("CITY_MIN_SIZE_FOR_SETTLERS");
	m_iRANGED_ATTACKS_USE_MOVES = getDefineINT("RANGED_ATTACKS_USE_MOVES");
	m_iADVANCED_START_ALLOW_UNITS_OUTSIDE_CITIES = getDefineINT("ADVANCED_START_ALLOW_UNITS_OUTSIDE_CITIES");
	m_iADVANCED_START_MAX_UNITS_PER_CITY = getDefineINT("ADVANCED_START_MAX_UNITS_PER_CITY");
	m_iADVANCED_START_CITY_COST = getDefineINT("ADVANCED_START_CITY_COST");
	m_iADVANCED_START_CITY_COST_INCREASE = getDefineINT("ADVANCED_START_CITY_COST_INCREASE");
	m_iADVANCED_START_POPULATION_COST = getDefineINT("ADVANCED_START_POPULATION_COST");
	m_iADVANCED_START_POPULATION_COST_INCREASE = getDefineINT("ADVANCED_START_POPULATION_COST_INCREASE");
	m_iADVANCED_START_VISIBILITY_COST = getDefineINT("ADVANCED_START_VISIBILITY_COST");
	m_iADVANCED_START_VISIBILITY_COST_INCREASE = getDefineINT("ADVANCED_START_VISIBILITY_COST_INCREASE");
	m_iADVANCED_START_CITY_PLACEMENT_MAX_RANGE = getDefineINT("ADVANCED_START_CITY_PLACEMENT_MAX_RANGE");
	m_iNEW_CITY_BUILDING_VALUE_MODIFIER = getDefineINT("NEW_CITY_BUILDING_VALUE_MODIFIER");
	m_iPATH_DAMAGE_WEIGHT = getDefineINT("PATH_DAMAGE_WEIGHT");
	m_iPUPPET_SCIENCE_MODIFIER = getDefineINT("PUPPET_SCIENCE_MODIFIER");
	m_iPUPPET_CULTURE_MODIFIER = getDefineINT("PUPPET_CULTURE_MODIFIER");
	m_iPUPPET_GOLD_MODIFIER = getDefineINT("PUPPET_GOLD_MODIFIER");
	m_iPUPPET_FAITH_MODIFIER = getDefineINT("PUPPET_FAITH_MODIFIER");
	m_iBASE_POLICY_COST = getDefineINT("BASE_POLICY_COST");
	m_iPOLICY_COST_INCREASE_TO_BE_EXPONENTED = getDefineINT("POLICY_COST_INCREASE_TO_BE_EXPONENTED");
	m_iPOLICY_COST_VISIBLE_DIVISOR = getDefineINT("POLICY_COST_VISIBLE_DIVISOR");
	m_iSWITCH_POLICY_BRANCHES_ANARCHY_TURNS = getDefineINT("SWITCH_POLICY_BRANCHES_ANARCHY_TURNS");
	m_iPOLICY_COST_DISCOUNT_MAX = getDefineINT("POLICY_COST_DISCOUNT_MAX");
	m_iGOLD_PURCHASE_GOLD_PER_PRODUCTION = getDefineINT("GOLD_PURCHASE_GOLD_PER_PRODUCTION");
	m_iGOLD_PURCHASE_VISIBLE_DIVISOR = getDefineINT("GOLD_PURCHASE_VISIBLE_DIVISOR");
	m_iPROJECT_PURCHASING_DISABLED = getDefineINT("PROJECT_PURCHASING_DISABLED");
	m_iINFLUENCE_MOUNTAIN_COST = getDefineINT("INFLUENCE_MOUNTAIN_COST");
	m_iINFLUENCE_HILL_COST = getDefineINT("INFLUENCE_HILL_COST");
	m_iINFLUENCE_RIVER_COST = getDefineINT("INFLUENCE_RIVER_COST");
	m_iUSE_FIRST_RING_INFLUENCE_TERRAIN_COST = getDefineINT("USE_FIRST_RING_INFLUENCE_TERRAIN_COST");
	m_iNUM_RESOURCE_QUANTITY_TYPES = getDefineINT("NUM_RESOURCE_QUANTITY_TYPES");
	m_iSPECIALISTS_DIVERT_POPULATION_ENABLED = getDefineINT("SPECIALISTS_DIVERT_POPULATION_ENABLED");
	m_iSCIENCE_PER_POPULATION = getDefineINT("SCIENCE_PER_POPULATION");
	m_iRESEARCH_AGREEMENT_MOD = getDefineINT("RESEARCH_AGREEMENT_MOD");
	m_iBARBARIAN_CAMP_FIRST_TURN_PERCENT_OF_TARGET_TO_ADD = getDefineINT("BARBARIAN_CAMP_FIRST_TURN_PERCENT_OF_TARGET_TO_ADD");
	m_iBARBARIAN_CAMP_ODDS_OF_NEW_CAMP_SPAWNING = getDefineINT("BARBARIAN_CAMP_ODDS_OF_NEW_CAMP_SPAWNING");
	m_iBARBARIAN_CAMP_MINIMUM_DISTANCE_CAPITAL = getDefineINT("BARBARIAN_CAMP_MINIMUM_DISTANCE_CAPITAL");
	m_iBARBARIAN_CAMP_MINIMUM_DISTANCE_ANOTHER_CAMP = getDefineINT("BARBARIAN_CAMP_MINIMUM_DISTANCE_ANOTHER_CAMP");
	m_iBARBARIAN_CAMP_COASTAL_SPAWN_ROLL = getDefineINT("BARBARIAN_CAMP_COASTAL_SPAWN_ROLL");
	m_iBARBARIAN_EXTRA_RAGING_UNIT_SPAWN_CHANCE = getDefineINT("BARBARIAN_EXTRA_RAGING_UNIT_SPAWN_CHANCE");
	m_iBARBARIAN_NAVAL_UNIT_START_TURN_SPAWN = getDefineINT("BARBARIAN_NAVAL_UNIT_START_TURN_SPAWN");
	m_iMAX_BARBARIANS_FROM_CAMP_NEARBY = getDefineINT("MAX_BARBARIANS_FROM_CAMP_NEARBY");
	m_iMAX_BARBARIANS_FROM_CAMP_NEARBY_RANGE = getDefineINT("MAX_BARBARIANS_FROM_CAMP_NEARBY_RANGE");
	m_iGOLD_FROM_BARBARIAN_CONVERSION = getDefineINT("GOLD_FROM_BARBARIAN_CONVERSION");
	m_iBARBARIAN_CITY_GOLD_RANSOM = getDefineINT("BARBARIAN_CITY_GOLD_RANSOM");
	m_iBARBARIAN_UNIT_GOLD_RANSOM = getDefineINT("BARBARIAN_UNIT_GOLD_RANSOM");
	m_iEMBARKED_UNIT_MOVEMENT = getDefineINT("EMBARKED_UNIT_MOVEMENT");
	m_iEMBARKED_VISIBILITY_RANGE = getDefineINT("EMBARKED_VISIBILITY_RANGE");
	m_iDEFAULT_MAX_NUM_BUILDERS = getDefineINT("DEFAULT_MAX_NUM_BUILDERS");
	m_iBARBARIAN_TECH_PERCENT = getDefineINT("BARBARIAN_TECH_PERCENT");
	m_iCITY_RESOURCE_WLTKD_TURNS = getDefineINT("CITY_RESOURCE_WLTKD_TURNS");
	m_iMAX_SPECIALISTS_FROM_BUILDING = getDefineINT("MAX_SPECIALISTS_FROM_BUILDING");
	m_iGREAT_PERSON_THRESHOLD_BASE = getDefineINT("GREAT_PERSON_THRESHOLD_BASE");
	m_iGREAT_PERSON_THRESHOLD_INCREASE = getDefineINT("GREAT_PERSON_THRESHOLD_INCREASE");
	m_iCULTURE_BOMB_COOLDOWN = getDefineINT("CULTURE_BOMB_COOLDOWN");
	m_iCULTURE_BOMB_MINOR_FRIENDSHIP_CHANGE = getDefineINT("CULTURE_BOMB_MINOR_FRIENDSHIP_CHANGE");
	m_iUNIT_AUTO_EXPLORE_DISABLED = getDefineINT("UNIT_AUTO_EXPLORE_DISABLED");
	m_iUNIT_WORKER_AUTOMATION_DISABLED = getDefineINT("UNIT_WORKER_AUTOMATION_DISABLED");
	m_iUNIT_DELETE_DISABLED = getDefineINT("UNIT_DELETE_DISABLED");
	m_iMIN_START_AREA_TILES = getDefineINT("MIN_START_AREA_TILES");
	m_iMIN_DISTANCE_OTHER_AREA_PERCENT = getDefineINT("MIN_DISTANCE_OTHER_AREA_PERCENT");
	m_iMINOR_CIV_FOOD_REQUIREMENT = getDefineINT("MINOR_CIV_FOOD_REQUIREMENT");
	m_iMAJOR_CIV_FOOD_REQUIREMENT = getDefineINT("MAJOR_CIV_FOOD_REQUIREMENT");
	m_iMIN_START_FOUND_VALUE_AS_PERCENT_OF_BEST = getDefineINT("MIN_START_FOUND_VALUE_AS_PERCENT_OF_BEST");
	m_iSTART_AREA_FOOD_MULTIPLIER = getDefineINT("START_AREA_FOOD_MULTIPLIER");
	m_iSTART_AREA_HAPPINESS_MULTIPLIER = getDefineINT("START_AREA_HAPPINESS_MULTIPLIER");
	m_iSTART_AREA_PRODUCTION_MULTIPLIER = getDefineINT("START_AREA_PRODUCTION_MULTIPLIER");
	m_iSTART_AREA_GOLD_MULTIPLIER = getDefineINT("START_AREA_GOLD_MULTIPLIER");
	m_iSTART_AREA_SCIENCE_MULTIPLIER = getDefineINT("START_AREA_SCIENCE_MULTIPLIER");
	m_iSTART_AREA_FAITH_MULTIPLIER = getDefineINT("START_AREA_FAITH_MULTIPLIER");
	m_iSTART_AREA_RESOURCE_MULTIPLIER = getDefineINT("START_AREA_RESOURCE_MULTIPLIER");
	m_iSTART_AREA_STRATEGIC_MULTIPLIER = getDefineINT("START_AREA_STRATEGIC_MULTIPLIER");
	m_iSTART_AREA_BUILD_ON_COAST_PERCENT = getDefineINT("START_AREA_BUILD_ON_COAST_PERCENT");
	m_iSETTLER_FOOD_MULTIPLIER = getDefineINT("SETTLER_FOOD_MULTIPLIER");
	m_iSETTLER_HAPPINESS_MULTIPLIER = getDefineINT("SETTLER_HAPPINESS_MULTIPLIER");
	m_iSETTLER_PRODUCTION_MULTIPLIER = getDefineINT("SETTLER_PRODUCTION_MULTIPLIER");
	m_iSETTLER_GOLD_MULTIPLIER = getDefineINT("SETTLER_GOLD_MULTIPLIER");
	m_iSETTLER_SCIENCE_MULTIPLIER = getDefineINT("SETTLER_SCIENCE_MULTIPLIER");
	m_iSETTLER_FAITH_MULTIPLIER = getDefineINT("SETTLER_FAITH_MULTIPLIER");
	m_iSETTLER_RESOURCE_MULTIPLIER = getDefineINT("SETTLER_RESOURCE_MULTIPLIER");
	m_iSETTLER_STRATEGIC_MULTIPLIER = getDefineINT("SETTLER_STRATEGIC_MULTIPLIER");
	m_iSETTLER_BUILD_ON_COAST_PERCENT = getDefineINT("SETTLER_BUILD_ON_COAST_PERCENT");
	m_iCITY_RING_1_MULTIPLIER = getDefineINT("CITY_RING_1_MULTIPLIER");
	m_iCITY_RING_2_MULTIPLIER = getDefineINT("CITY_RING_2_MULTIPLIER");
	m_iCITY_RING_3_MULTIPLIER = getDefineINT("CITY_RING_3_MULTIPLIER");
	m_iCITY_RING_4_MULTIPLIER = getDefineINT("CITY_RING_4_MULTIPLIER");
	m_iCITY_RING_5_MULTIPLIER = getDefineINT("CITY_RING_5_MULTIPLIER");
	m_iSETTLER_EVALUATION_DISTANCE = getDefineINT("SETTLER_EVALUATION_DISTANCE");
	m_iSETTLER_DISTANCE_DROPOFF_MODIFIER = getDefineINT("SETTLER_DISTANCE_DROPOFF_MODIFIER");
	m_iBUILD_ON_RESOURCE_PERCENT = getDefineINT("BUILD_ON_RESOURCE_PERCENT");
	m_iBUILD_ON_RIVER_PERCENT = getDefineINT("BUILD_ON_RIVER_PERCENT");
	m_iCHOKEPOINT_STRATEGIC_VALUE = getDefineINT("CHOKEPOINT_STRATEGIC_VALUE");
	m_iHILL_STRATEGIC_VALUE = getDefineINT("HILL_STRATEGIC_VALUE");
	m_iALREADY_OWNED_STRATEGIC_VALUE = getDefineINT("ALREADY_OWNED_STRATEGIC_VALUE");
	m_iMINOR_CIV_CONTACT_GOLD_FIRST = getDefineINT("MINOR_CIV_CONTACT_GOLD_FIRST");
	m_iMINOR_CIV_CONTACT_GOLD_OTHER = getDefineINT("MINOR_CIV_CONTACT_GOLD_OTHER");
	m_iMINOR_CIV_GROWTH_PERCENT = getDefineINT("MINOR_CIV_GROWTH_PERCENT");
	m_iMINOR_CIV_PRODUCTION_PERCENT = getDefineINT("MINOR_CIV_PRODUCTION_PERCENT");
	m_iMINOR_CIV_GOLD_PERCENT = getDefineINT("MINOR_CIV_GOLD_PERCENT");
	m_iMINOR_CIV_TECH_PERCENT = getDefineINT("MINOR_CIV_TECH_PERCENT");
	m_iMINOR_POLICY_RESOURCE_MULTIPLIER = getDefineINT("MINOR_POLICY_RESOURCE_MULTIPLIER");
	m_iMINOR_POLICY_RESOURCE_HAPPINESS_MULTIPLIER = getDefineINT("MINOR_POLICY_RESOURCE_HAPPINESS_MULTIPLIER");
	m_iMINOR_GOLD_GIFT_LARGE = getDefineINT("MINOR_GOLD_GIFT_LARGE");
	m_iMINOR_GOLD_GIFT_MEDIUM = getDefineINT("MINOR_GOLD_GIFT_MEDIUM");
	m_iMINOR_GOLD_GIFT_SMALL = getDefineINT("MINOR_GOLD_GIFT_SMALL");
	m_iMINOR_CIV_TILE_IMPROVEMENT_GIFT_COST = getDefineINT("MINOR_CIV_TILE_IMPROVEMENT_GIFT_COST");
	m_iMINOR_CIV_BUYOUT_COST = getDefineINT("MINOR_CIV_BUYOUT_COST");
	m_iMINOR_CIV_BUYOUT_TURNS = getDefineINT("MINOR_CIV_BUYOUT_TURNS");
	m_iMINOR_FRIENDSHIP_FROM_TRADE_MISSION = getDefineINT("MINOR_FRIENDSHIP_FROM_TRADE_MISSION");
	m_iPLOT_UNIT_LIMIT = getDefineINT("PLOT_UNIT_LIMIT");
	m_iZONE_OF_CONTROL_ENABLED = getDefineINT("ZONE_OF_CONTROL_ENABLED");
	m_iFIRE_SUPPORT_DISABLED = getDefineINT("FIRE_SUPPORT_DISABLED");
	m_iMAX_HIT_POINTS = getDefineINT("MAX_HIT_POINTS");
	m_iMAX_CITY_HIT_POINTS = getDefineINT("MAX_CITY_HIT_POINTS");
	m_iCITY_HIT_POINTS_HEALED_PER_TURN = getDefineINT("CITY_HIT_POINTS_HEALED_PER_TURN");
	m_iFLAT_LAND_EXTRA_DEFENSE = getDefineINT("FLAT_LAND_EXTRA_DEFENSE");
	m_iHILLS_EXTRA_DEFENSE = getDefineINT("HILLS_EXTRA_DEFENSE");
	m_iRIVER_ATTACK_MODIFIER = getDefineINT("RIVER_ATTACK_MODIFIER");
	m_iAMPHIB_ATTACK_MODIFIER = getDefineINT("AMPHIB_ATTACK_MODIFIER");
	m_iENEMY_HEAL_RATE = getDefineINT("ENEMY_HEAL_RATE");
	m_iNEUTRAL_HEAL_RATE = getDefineINT("NEUTRAL_HEAL_RATE");
	m_iFRIENDLY_HEAL_RATE = getDefineINT("FRIENDLY_HEAL_RATE");
	m_iINSTA_HEAL_RATE = getDefineINT("INSTA_HEAL_RATE");
	m_iCITY_HEAL_RATE = getDefineINT("CITY_HEAL_RATE");
	m_iATTACK_SAME_STRENGTH_MIN_DAMAGE = getDefineINT("ATTACK_SAME_STRENGTH_MIN_DAMAGE");
	m_iRANGE_ATTACK_RANGED_DEFENDER_MOD = getDefineINT("RANGE_ATTACK_RANGED_DEFENDER_MOD");
	m_iATTACK_SAME_STRENGTH_POSSIBLE_EXTRA_DAMAGE = getDefineINT("ATTACK_SAME_STRENGTH_POSSIBLE_EXTRA_DAMAGE");
	m_iRANGE_ATTACK_SAME_STRENGTH_MIN_DAMAGE = getDefineINT("RANGE_ATTACK_SAME_STRENGTH_MIN_DAMAGE");
	m_iRANGE_ATTACK_SAME_STRENGTH_POSSIBLE_EXTRA_DAMAGE = getDefineINT("RANGE_ATTACK_SAME_STRENGTH_POSSIBLE_EXTRA_DAMAGE");
	m_iAIR_STRIKE_SAME_STRENGTH_MIN_DEFENSE_DAMAGE = getDefineINT("AIR_STRIKE_SAME_STRENGTH_MIN_DEFENSE_DAMAGE");
	m_iAIR_STRIKE_SAME_STRENGTH_POSSIBLE_EXTRA_DEFENSE_DAMAGE = getDefineINT("AIR_STRIKE_SAME_STRENGTH_POSSIBLE_EXTRA_DEFENSE_DAMAGE");
	m_iINTERCEPTION_SAME_STRENGTH_MIN_DAMAGE = getDefineINT("INTERCEPTION_SAME_STRENGTH_MIN_DAMAGE");
	m_iINTERCEPTION_SAME_STRENGTH_POSSIBLE_EXTRA_DAMAGE = getDefineINT("INTERCEPTION_SAME_STRENGTH_POSSIBLE_EXTRA_DAMAGE");
	m_iAIR_SWEEP_INTERCEPTION_DAMAGE_MOD = getDefineINT("AIR_SWEEP_INTERCEPTION_DAMAGE_MOD");
	m_iWOUNDED_DAMAGE_MULTIPLIER = getDefineINT("WOUNDED_DAMAGE_MULTIPLIER");
	m_iTRAIT_WOUNDED_DAMAGE_MOD = getDefineINT("TRAIT_WOUNDED_DAMAGE_MOD");
	m_iCITY_STRENGTH_DEFAULT = getDefineINT("CITY_STRENGTH_DEFAULT");
	m_iCITY_STRENGTH_POPULATION_CHANGE = getDefineINT("CITY_STRENGTH_POPULATION_CHANGE");
	m_iCITY_STRENGTH_UNIT_DIVISOR = getDefineINT("CITY_STRENGTH_UNIT_DIVISOR");
	m_iCITY_STRENGTH_HILL_CHANGE = getDefineINT("CITY_STRENGTH_HILL_CHANGE");
	m_iCITY_ATTACKING_DAMAGE_MOD = getDefineINT("CITY_ATTACKING_DAMAGE_MOD");
	m_iATTACKING_CITY_MELEE_DAMAGE_MOD = getDefineINT("ATTACKING_CITY_MELEE_DAMAGE_MOD");
	m_iCITY_ATTACK_RANGE = getDefineINT("CITY_ATTACK_RANGE");
	m_iCAN_CITY_USE_INDIRECT_FIRE = getDefineINT("CAN_CITY_USE_INDIRECT_FIRE");
	m_iCITY_RANGED_ATTACK_STRENGTH_MULTIPLIER = getDefineINT("CITY_RANGED_ATTACK_STRENGTH_MULTIPLIER");
	m_iMIN_CITY_STRIKE_DAMAGE = getDefineINT("MIN_CITY_STRIKE_DAMAGE");
	m_iCITY_CAPTURE_DAMAGE_PERCENT = getDefineINT("CITY_CAPTURE_DAMAGE_PERCENT");
	m_iEXPERIENCE_PER_LEVEL = getDefineINT("EXPERIENCE_PER_LEVEL");
	m_iEXPERIENCE_ATTACKING_UNIT_MELEE = getDefineINT("EXPERIENCE_ATTACKING_UNIT_MELEE");
	m_iEXPERIENCE_DEFENDING_UNIT_MELEE = getDefineINT("EXPERIENCE_DEFENDING_UNIT_MELEE");
	m_iEXPERIENCE_ATTACKING_UNIT_AIR = getDefineINT("EXPERIENCE_ATTACKING_UNIT_AIR");
	m_iEXPERIENCE_DEFENDING_UNIT_AIR = getDefineINT("EXPERIENCE_DEFENDING_UNIT_AIR");
	m_iEXPERIENCE_ATTACKING_UNIT_RANGED = getDefineINT("EXPERIENCE_ATTACKING_UNIT_RANGED");
	m_iEXPERIENCE_DEFENDING_UNIT_RANGED = getDefineINT("EXPERIENCE_DEFENDING_UNIT_RANGED");
	m_iEXPERIENCE_ATTACKING_AIR_SWEEP = getDefineINT("EXPERIENCE_ATTACKING_AIR_SWEEP");
	m_iEXPERIENCE_DEFENDING_AIR_SWEEP_AIR = getDefineINT("EXPERIENCE_DEFENDING_AIR_SWEEP_AIR");
	m_iEXPERIENCE_DEFENDING_AIR_SWEEP_GROUND = getDefineINT("EXPERIENCE_DEFENDING_AIR_SWEEP_GROUND");
	m_iEXPERIENCE_ATTACKING_CITY_MELEE = getDefineINT("EXPERIENCE_ATTACKING_CITY_MELEE");
	m_iEXPERIENCE_ATTACKING_CITY_RANGED = getDefineINT("EXPERIENCE_ATTACKING_CITY_RANGED");
	m_iEXPERIENCE_ATTACKING_CITY_AIR = getDefineINT("EXPERIENCE_ATTACKING_CITY_AIR");
	m_iBARBARIAN_MAX_XP_VALUE = getDefineINT("BARBARIAN_MAX_XP_VALUE");
	m_iCOMBAT_EXPERIENCE_IN_BORDERS_PERCENT = getDefineINT("COMBAT_EXPERIENCE_IN_BORDERS_PERCENT");
	m_iGREAT_GENERALS_THRESHOLD_INCREASE = getDefineINT("GREAT_GENERALS_THRESHOLD_INCREASE");
	m_iGREAT_GENERALS_THRESHOLD_INCREASE_TEAM = getDefineINT("GREAT_GENERALS_THRESHOLD_INCREASE_TEAM");
	m_iGREAT_GENERALS_THRESHOLD = getDefineINT("GREAT_GENERALS_THRESHOLD");
	m_iUNIT_DEATH_XP_GREAT_GENERAL_LOSS = getDefineINT("UNIT_DEATH_XP_GREAT_GENERAL_LOSS");
	m_iMIN_EXPERIENCE_PER_COMBAT = getDefineINT("MIN_EXPERIENCE_PER_COMBAT");
	m_iMAX_EXPERIENCE_PER_COMBAT = getDefineINT("MAX_EXPERIENCE_PER_COMBAT");
	m_iCRAMPED_RANGE_FROM_CITY = getDefineINT("CRAMPED_RANGE_FROM_CITY");
	m_iCRAMPED_USABLE_PLOT_PERCENT = getDefineINT("CRAMPED_USABLE_PLOT_PERCENT");
	m_iPROXIMITY_NEIGHBORS_CLOSEST_CITY_REQUIREMENT = getDefineINT("PROXIMITY_NEIGHBORS_CLOSEST_CITY_REQUIREMENT");
	m_iPROXIMITY_CLOSE_CLOSEST_CITY_POSSIBILITY = getDefineINT("PROXIMITY_CLOSE_CLOSEST_CITY_POSSIBILITY");
	m_iPROXIMITY_CLOSE_DISTANCE_MAP_MULTIPLIER = getDefineINT("PROXIMITY_CLOSE_DISTANCE_MAP_MULTIPLIER");
	m_iPROXIMITY_CLOSE_DISTANCE_MAX = getDefineINT("PROXIMITY_CLOSE_DISTANCE_MAX");
	m_iPROXIMITY_CLOSE_DISTANCE_MIN = getDefineINT("PROXIMITY_CLOSE_DISTANCE_MIN");
	m_iPROXIMITY_FAR_DISTANCE_MAP_MULTIPLIER = getDefineINT("PROXIMITY_FAR_DISTANCE_MAP_MULTIPLIER");
	m_iPROXIMITY_FAR_DISTANCE_MAX = getDefineINT("PROXIMITY_FAR_DISTANCE_MAX");
	m_iPROXIMITY_FAR_DISTANCE_MIN = getDefineINT("PROXIMITY_FAR_DISTANCE_MIN");
	m_iPLOT_BASE_COST = getDefineINT("PLOT_BASE_COST");
	m_iPLOT_ADDITIONAL_COST_PER_PLOT = getDefineINT("PLOT_ADDITIONAL_COST_PER_PLOT");
	m_iPLOT_COST_APPEARANCE_DIVISOR = getDefineINT("PLOT_COST_APPEARANCE_DIVISOR");
	m_iCULTURE_COST_FIRST_PLOT = getDefineINT("CULTURE_COST_FIRST_PLOT");
	m_iCULTURE_COST_LATER_PLOT_MULTIPLIER = getDefineINT("CULTURE_COST_LATER_PLOT_MULTIPLIER");
	m_iCULTURE_COST_VISIBLE_DIVISOR = getDefineINT("CULTURE_COST_VISIBLE_DIVISOR");
	m_iCULTURE_PLOT_COST_MOD_MINIMUM = getDefineINT("CULTURE_PLOT_COST_MOD_MINIMUM");
	m_iMINOR_CIV_PLOT_CULTURE_COST_MULTIPLIER = getDefineINT("MINOR_CIV_PLOT_CULTURE_COST_MULTIPLIER");
	m_iMAXIMUM_BUY_PLOT_DISTANCE = getDefineINT("MAXIMUM_BUY_PLOT_DISTANCE");
	m_iMAXIMUM_ACQUIRE_PLOT_DISTANCE = getDefineINT("MAXIMUM_ACQUIRE_PLOT_DISTANCE");
	m_iPLOT_INFLUENCE_BASE_MULTIPLIER = getDefineINT("PLOT_INFLUENCE_BASE_MULTIPLIER");
	m_iPLOT_INFLUENCE_DISTANCE_MULTIPLIER = getDefineINT("PLOT_INFLUENCE_DISTANCE_MULTIPLIER");
	m_iPLOT_INFLUENCE_DISTANCE_DIVISOR = getDefineINT("PLOT_INFLUENCE_DISTANCE_DIVISOR");
	m_iPLOT_INFLUENCE_RING_COST = getDefineINT("PLOT_INFLUENCE_RING_COST");
	m_iPLOT_INFLUENCE_WATER_COST = getDefineINT("PLOT_INFLUENCE_WATER_COST");
	m_iPLOT_INFLUENCE_IMPROVEMENT_COST = getDefineINT("PLOT_INFLUENCE_IMPROVEMENT_COST");
	m_iPLOT_INFLUENCE_ROUTE_COST = getDefineINT("PLOT_INFLUENCE_ROUTE_COST");
	m_iPLOT_INFLUENCE_RESOURCE_COST = getDefineINT("PLOT_INFLUENCE_RESOURCE_COST");
	m_iPLOT_INFLUENCE_NW_COST = getDefineINT("PLOT_INFLUENCE_NW_COST");
	m_iPLOT_BUY_RESOURCE_COST = getDefineINT("PLOT_BUY_RESOURCE_COST");
	m_iPLOT_BUY_YIELD_COST = getDefineINT("PLOT_BUY_YIELD_COST");
	m_iPLOT_INFLUENCE_YIELD_POINT_COST = getDefineINT("PLOT_INFLUENCE_YIELD_POINT_COST");
	m_iPLOT_INFLUENCE_NO_ADJACENT_OWNED_COST = getDefineINT("PLOT_INFLUENCE_NO_ADJACENT_OWNED_COST");
	m_iUNITED_NATIONS_COUNTDOWN_TURNS = getDefineINT("UNITED_NATIONS_COUNTDOWN_TURNS");
	m_iOWN_UNITED_NATIONS_VOTE_BONUS = getDefineINT("OWN_UNITED_NATIONS_VOTE_BONUS");
	m_iDIPLO_VICTORY_ALGORITHM_THRESHOLD = getDefineINT("DIPLO_VICTORY_ALGORITHM_THRESHOLD");
	m_iDIPLO_VICTORY_BEYOND_ALGORITHM_MULTIPLIER = getDefineINT("DIPLO_VICTORY_BEYOND_ALGORITHM_MULTIPLIER");
	m_iDIPLO_VICTORY_DEFAULT_VOTE_PERCENT = getDefineINT("DIPLO_VICTORY_DEFAULT_VOTE_PERCENT");
	m_iSCORE_CITY_MULTIPLIER = getDefineINT("SCORE_CITY_MULTIPLIER");
	m_iSCORE_POPULATION_MULTIPLIER = getDefineINT("SCORE_POPULATION_MULTIPLIER");
	m_iSCORE_LAND_MULTIPLIER = getDefineINT("SCORE_LAND_MULTIPLIER");
	m_iSCORE_WONDER_MULTIPLIER = getDefineINT("SCORE_WONDER_MULTIPLIER");
	m_iSCORE_TECH_MULTIPLIER = getDefineINT("SCORE_TECH_MULTIPLIER");
	m_iSCORE_FUTURE_TECH_MULTIPLIER = getDefineINT("SCORE_FUTURE_TECH_MULTIPLIER");
	m_iVICTORY_POINTS_PER_ERA = getDefineINT("VICTORY_POINTS_PER_ERA");
	m_iMIN_GAME_TURNS_ELAPSED_TO_TEST_VICTORY = getDefineINT("MIN_GAME_TURNS_ELAPSED_TO_TEST_VICTORY");
	m_iZERO_SUM_COMPETITION_WONDERS_VICTORY_POINTS = getDefineINT("ZERO_SUM_COMPETITION_WONDERS_VICTORY_POINTS");
	m_iZERO_SUM_COMPETITION_POLICIES_VICTORY_POINTS = getDefineINT("ZERO_SUM_COMPETITION_POLICIES_VICTORY_POINTS");
	m_iZERO_SUM_COMPETITION_GREAT_PEOPLE_VICTORY_POINTS = getDefineINT("ZERO_SUM_COMPETITION_GREAT_PEOPLE_VICTORY_POINTS");
	m_iMAX_CITY_DIST_HIGHWATER_MARK = getDefineINT("MAX_CITY_DIST_HIGHWATER_MARK");
	m_iHEAVY_RESOURCE_THRESHOLD = getDefineINT("HEAVY_RESOURCE_THRESHOLD");
	m_iPROGRESS_POPUP_TURN_FREQUENCY = getDefineINT("PROGRESS_POPUP_TURN_FREQUENCY");
	m_iSETTLER_PRODUCTION_SPEED = getDefineINT("SETTLER_PRODUCTION_SPEED");
	m_iBUY_PLOTS_DISABLED = getDefineINT("BUY_PLOTS_DISABLED");
	m_iCITY_STRENGTH_TECH_MULTIPLIER = getDefineINT("CITY_STRENGTH_TECH_MULTIPLIER");
	m_iWARLORD_EXTRA_EXPERIENCE_PER_UNIT_PERCENT = getDefineINT("WARLORD_EXTRA_EXPERIENCE_PER_UNIT_PERCENT");
	m_iBUILDING_SALE_DIVISOR = getDefineINT("BUILDING_SALE_DIVISOR");
	m_iDISBAND_UNIT_REFUND_PERCENT = getDefineINT("DISBAND_UNIT_REFUND_PERCENT");
	m_iMINOR_CIV_ROUTE_QUEST_WEIGHT = getDefineINT("MINOR_CIV_ROUTE_QUEST_WEIGHT");
	m_iWITHDRAW_MOD_ENEMY_MOVES = getDefineINT("WITHDRAW_MOD_ENEMY_MOVES");
	m_iWITHDRAW_MOD_BLOCKED_TILE = getDefineINT("WITHDRAW_MOD_BLOCKED_TILE");
	m_iAI_OPERATIONAL_MAX_RECRUIT_TURNS_DEFAULT = getDefineINT("AI_OPERATIONAL_MAX_RECRUIT_TURNS_DEFAULT");
	m_iAI_OPERATIONAL_MAX_RECRUIT_TURNS_ENEMY_TERRITORY = getDefineINT("AI_OPERATIONAL_MAX_RECRUIT_TURNS_ENEMY_TERRITORY");

	// -- floats --

	m_fAI_PRODUCTION_WEIGHT_MOD_PER_TURN_LEFT = getDefineFLOAT("AI_PRODUCTION_WEIGHT_MOD_PER_TURN_LEFT");
	m_fAI_PRODUCTION_WEIGHT_BASE_MOD = getDefineFLOAT("AI_PRODUCTION_WEIGHT_BASE_MOD");
	m_fAI_RESEARCH_WEIGHT_MOD_PER_TURN_LEFT = getDefineFLOAT("AI_RESEARCH_WEIGHT_MOD_PER_TURN_LEFT");
	m_fAI_RESEARCH_WEIGHT_BASE_MOD = getDefineFLOAT("AI_RESEARCH_WEIGHT_BASE_MOD");
	m_fHURRY_GOLD_PRODUCTION_EXPONENT = getDefineFLOAT("HURRY_GOLD_PRODUCTION_EXPONENT");
	m_fCITY_ZOOM_LEVEL_1 = getDefineFLOAT("CITY_ZOOM_LEVEL_1");
	m_fCITY_ZOOM_LEVEL_2 = getDefineFLOAT("CITY_ZOOM_LEVEL_2");
	m_fCITY_ZOOM_LEVEL_3 = getDefineFLOAT("CITY_ZOOM_LEVEL_3");
	m_fCITY_ZOOM_OFFSET = getDefineFLOAT("CITY_ZOOM_OFFSET");
	m_fCULTURE_COST_LATER_PLOT_EXPONENT = getDefineFLOAT("CULTURE_COST_LATER_PLOT_EXPONENT");
	m_fPOST_COMBAT_TEXT_DELAY = getDefineFLOAT("POST_COMBAT_TEXT_DELAY");
	m_fAI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_NEXT_WONDER = getDefineFLOAT("AI_CITY_SPECIALIZATION_PRODUCTION_WEIGHT_NEXT_WONDER");
	m_fAI_DANGER_MAJOR_APPROACH_WAR = getDefineFLOAT("AI_DANGER_MAJOR_APPROACH_WAR");
	m_fAI_DANGER_MAJOR_APPROACH_HOSTILE = getDefineFLOAT("AI_DANGER_MAJOR_APPROACH_HOSTILE");
	m_fAI_DANGER_MAJOR_APPROACH_DECEPTIVE = getDefineFLOAT("AI_DANGER_MAJOR_APPROACH_DECEPTIVE");
	m_fAI_DANGER_MAJOR_APPROACH_GUARDED = getDefineFLOAT("AI_DANGER_MAJOR_APPROACH_GUARDED");
	m_fAI_DANGER_MAJOR_APPROACH_AFRAID = getDefineFLOAT("AI_DANGER_MAJOR_APPROACH_AFRAID");
	m_fAI_DANGER_MAJOR_APPROACH_FRIENDLY = getDefineFLOAT("AI_DANGER_MAJOR_APPROACH_FRIENDLY");
	m_fAI_DANGER_MAJOR_APPROACH_NEUTRAL = getDefineFLOAT("AI_DANGER_MAJOR_APPROACH_NEUTRAL");
	m_fAI_DANGER_MINOR_APPROACH_NEUTRAL = getDefineFLOAT("AI_DANGER_MINOR_APPROACH_NEUTRAL");
	m_fAI_DANGER_MINOR_APPROACH_FRIENDLY = getDefineFLOAT("AI_DANGER_MINOR_APPROACH_FRIENDLY");
	m_fAI_DANGER_MINOR_APPROACH_BULLY = getDefineFLOAT("AI_DANGER_MINOR_APPROACH_BULLY");
	m_fAI_DANGER_MINOR_APPROACH_CONQUEST = getDefineFLOAT("AI_DANGER_MINOR_APPROACH_CONQUEST");
	m_fFLAVOR_STANDARD_LOG10_TILES_PER_PLAYER = getDefineFLOAT("FLAVOR_STANDARD_LOG10_TILES_PER_PLAYER");
	m_fDIPLO_VICTORY_TEAM_MULTIPLIER = getDefineFLOAT("DIPLO_VICTORY_TEAM_MULTIPLIER");
	m_fAI_TACTICAL_FLAVOR_DAMPENING_FOR_MOVE_PRIORITIZATION = getDefineFLOAT("AI_TACTICAL_FLAVOR_DAMPENING_FOR_MOVE_PRIORITIZATION");
	m_fAI_STRATEGY_DEFEND_MY_LANDS_UNITS_PER_CITY = getDefineFLOAT("AI_STRATEGY_DEFEND_MY_LANDS_UNITS_PER_CITY");
	m_fAI_STRATEGY_NAVAL_UNITS_PER_CITY = getDefineFLOAT("AI_STRATEGY_NAVAL_UNITS_PER_CITY");
	m_fGOLD_GIFT_FRIENDSHIP_EXPONENT = getDefineFLOAT("GOLD_GIFT_FRIENDSHIP_EXPONENT");
	m_fGOLD_GIFT_FRIENDSHIP_DIVISOR = getDefineFLOAT("GOLD_GIFT_FRIENDSHIP_DIVISOR");
	m_fHURRY_GOLD_TECH_EXPONENT = getDefineFLOAT("HURRY_GOLD_TECH_EXPONENT");
	m_fHURRY_GOLD_CULTURE_EXPONENT = getDefineFLOAT("HURRY_GOLD_CULTURE_EXPONENT");
	m_fCITY_GROWTH_MULTIPLIER = getDefineFLOAT("CITY_GROWTH_MULTIPLIER");
	m_fCITY_GROWTH_EXPONENT = getDefineFLOAT("CITY_GROWTH_EXPONENT");
	m_fPOLICY_COST_EXPONENT = getDefineFLOAT("POLICY_COST_EXPONENT");
	m_fUNIT_UPGRADE_COST_MULTIPLIER_PER_ERA = getDefineFLOAT("UNIT_UPGRADE_COST_MULTIPLIER_PER_ERA");
	m_fUNIT_UPGRADE_COST_EXPONENT = getDefineFLOAT("UNIT_UPGRADE_COST_EXPONENT");
	m_fCITY_STRENGTH_TECH_BASE = getDefineFLOAT("CITY_STRENGTH_TECH_BASE");
	m_fCITY_STRENGTH_TECH_EXPONENT = getDefineFLOAT("CITY_STRENGTH_TECH_EXPONENT");
	m_fESPIONAGE_COUP_NOBODY_BONUS = getDefineFLOAT("ESPIONAGE_COUP_NOBODY_BONUS");
	m_fESPIONAGE_COUP_MULTIPLY_CONSTANT = getDefineFLOAT("ESPIONAGE_COUP_MULTIPLY_CONSTANT");
	m_fESPIONAGE_COUP_SPY_LEVEL_DELTA_ZERO = getDefineFLOAT("ESPIONAGE_COUP_SPY_LEVEL_DELTA_ZERO");
	m_fESPIONAGE_COUP_SPY_LEVEL_DELTA_ONE = getDefineFLOAT("ESPIONAGE_COUP_SPY_LEVEL_DELTA_ONE");
	m_fESPIONAGE_COUP_SPY_LEVEL_DELTA_TWO = getDefineFLOAT("ESPIONAGE_COUP_SPY_LEVEL_DELTA_TWO");
	m_iPILLAGE_HEAL_AMOUNT = getDefineINT("PILLAGE_HEAL_AMOUNT");

	// -- post defines --

	m_iLAND_TERRAIN = getDefineINT("LAND_TERRAIN");
	m_iDEEP_WATER_TERRAIN = getDefineINT("DEEP_WATER_TERRAIN");
	m_iSHALLOW_WATER_TERRAIN = getDefineINT("SHALLOW_WATER_TERRAIN");
	m_iRUINS_IMPROVEMENT = getDefineINT("RUINS_IMPROVEMENT");
	m_iNUKE_FEATURE = getDefineINT("NUKE_FEATURE");
	m_iCAPITAL_BUILDINGCLASS = getDefineINT("CAPITAL_BUILDINGCLASS");
	m_iDEFAULT_SPECIALIST = getDefineINT("DEFAULT_SPECIALIST");
	m_iSPACE_RACE_TRIGGER_PROJECT = getDefineINT("SPACE_RACE_TRIGGER_PROJECT");
	m_iSPACESHIP_CAPSULE = getDefineINT("SPACESHIP_CAPSULE");
	m_iSPACESHIP_BOOSTER = getDefineINT("SPACESHIP_BOOSTER");
	m_iSPACESHIP_STASIS = getDefineINT("SPACESHIP_STASIS");
	m_iSPACESHIP_ENGINE = getDefineINT("SPACESHIP_ENGINE");
	m_iMANHATTAN_PROJECT = getDefineINT("MANHATTAN_PROJECT");
	m_iINITIAL_CITY_ROUTE_TYPE = getDefineINT("INITIAL_CITY_ROUTE_TYPE");
	m_iSTANDARD_HANDICAP = getDefineINT("STANDARD_HANDICAP");
	m_iMULTIPLAYER_HANDICAP = getDefineINT("MULTIPLAYER_HANDICAP");
	m_iSTANDARD_HANDICAP_QUICK = getDefineINT("STANDARD_HANDICAP_QUICK");
	m_iSTANDARD_GAMESPEED = getDefineINT("STANDARD_GAMESPEED");
	m_iSTANDARD_TURNTIMER = getDefineINT("STANDARD_TURNTIMER");
	m_iSTANDARD_CLIMATE = getDefineINT("STANDARD_CLIMATE");
	m_iSTANDARD_WORLD_SIZE = getDefineINT("STANDARD_WORLD_SIZE");
	m_iSTANDARD_SEALEVEL = getDefineINT("STANDARD_SEALEVEL");
	m_iSTANDARD_ERA = getDefineINT("STANDARD_ERA");
	m_iLAST_EMBARK_ART_ERA = getDefineINT("LAST_EMBARK_ART_ERA");
	m_iLAST_UNIT_ART_ERA = getDefineINT("LAST_UNIT_ART_ERA");
	m_iLAST_BRIDGE_ART_ERA = getDefineINT("LAST_BRIDGE_ART_ERA");
	m_iSTANDARD_CALENDAR = getDefineINT("STANDARD_CALENDAR");
	m_iBARBARIAN_HANDICAP = getDefineINT("BARBARIAN_HANDICAP");
	m_iBARBARIAN_CIVILIZATION = getDefineINT("BARBARIAN_CIVILIZATION");
	m_iBARBARIAN_LEADER = getDefineINT("BARBARIAN_LEADER");
	m_iMINOR_CIV_HANDICAP = getDefineINT("MINOR_CIV_HANDICAP");
	m_iMINOR_CIVILIZATION = getDefineINT("MINOR_CIVILIZATION");
	m_iPROMOTION_EMBARKATION = getDefineINT("PROMOTION_EMBARKATION");
	m_iPROMOTION_DEFENSIVE_EMBARKATION = getDefineINT("PROMOTION_DEFENSIVE_EMBARKATION");
	m_iPROMOTION_ALLWATER_EMBARKATION = getDefineINT("PROMOTION_ALLWATER_EMBARKATION");
	m_iPROMOTION_OCEAN_IMPASSABLE_UNTIL_ASTRONOMY = getDefineINT("PROMOTION_OCEAN_IMPASSABLE_UNTIL_ASTRONOMY");
	m_iPROMOTION_OCEAN_IMPASSABLE = getDefineINT("PROMOTION_OCEAN_IMPASSABLE");
	m_iAI_HANDICAP = getDefineINT("AI_HANDICAP");
	m_iBARBARIAN_CAMP_IMPROVEMENT = getDefineINT("BARBARIAN_CAMP_IMPROVEMENT");
	m_iWALLS_BUILDINGCLASS = getDefineINT("WALLS_BUILDINGCLASS");
	m_iPROMOTION_ONLY_DEFENSIVE = getDefineINT("PROMOTION_ONLY_DEFENSIVE");
	m_iPROMOTION_UNWELCOME_EVANGELIST = getDefineINT("PROMOTION_UNWELCOME_EVANGELIST");
	m_iCOMBAT_CAPTURE_HEALTH = getDefineINT("COMBAT_CAPTURE_HEALTH");
	m_iCOMBAT_CAPTURE_MIN_CHANCE = getDefineINT("COMBAT_CAPTURE_MIN_CHANCE");
	m_iCOMBAT_CAPTURE_MAX_CHANCE = getDefineINT("COMBAT_CAPTURE_MAX_CHANCE");
	m_iCOMBAT_CAPTURE_RATIO_MULTIPLIER = getDefineINT("COMBAT_CAPTURE_RATIO_MULTIPLIER");
	m_iRELIGION_MIN_FAITH_FIRST_PANTHEON = GC.getDefineINT("RELIGION_MIN_FAITH_FIRST_PANTHEON");
	m_iRELIGION_MIN_FAITH_FIRST_PROPHET = GC.getDefineINT("RELIGION_MIN_FAITH_FIRST_PROPHET");
	m_iRELIGION_MIN_FAITH_FIRST_GREAT_PERSON = GC.getDefineINT("RELIGION_MIN_FAITH_FIRST_GREAT_PERSON");
	m_iRELIGION_GAME_FAITH_DELTA_NEXT_PANTHEON = GC.getDefineINT("RELIGION_GAME_FAITH_DELTA_NEXT_PANTHEON");
	m_iRELIGION_FAITH_DELTA_NEXT_PROPHET = GC.getDefineINT("RELIGION_FAITH_DELTA_NEXT_PROPHET");
	m_iRELIGION_FAITH_DELTA_NEXT_GREAT_PERSON = GC.getDefineINT("RELIGION_FAITH_DELTA_NEXT_GREAT_PERSON");
	m_iRELIGION_BASE_CHANCE_PROPHET_SPAWN = GC.getDefineINT("RELIGION_BASE_CHANCE_PROPHET_SPAWN");
	m_iRELIGION_ATHEISM_PRESSURE_PER_POP = GC.getDefineINT("RELIGION_ATHEISM_PRESSURE_PER_POP");
	m_iRELIGION_INITIAL_FOUNDING_CITY_PRESSURE = GC.getDefineINT("RELIGION_INITIAL_FOUNDING_CITY_PRESSURE");
	m_iRELIGION_PER_TURN_FOUNDING_CITY_PRESSURE = GC.getDefineINT("RELIGION_PER_TURN_FOUNDING_CITY_PRESSURE");
	m_iRELIGION_MISSIONARY_PRESSURE_MULTIPLIER = GC.getDefineINT("RELIGION_MISSIONARY_PRESSURE_MULTIPLIER");
	m_iRELIGION_ADJACENT_CITY_DISTANCE = GC.getDefineINT("RELIGION_ADJACENT_CITY_DISTANCE");
	m_iRELIGION_DIPLO_HIT_INITIAL_CONVERT_FRIENDLY_CITY = GC.getDefineINT("RELIGION_DIPLO_HIT_INITIAL_CONVERT_FRIENDLY_CITY");
	m_iRELIGION_DIPLO_HIT_RELIGIOUS_FLIP_FRIENDLY_CITY = GC.getDefineINT("RELIGION_DIPLO_HIT_RELIGIOUS_FLIP_FRIENDLY_CITY");
	m_iRELIGION_DIPLO_HIT_CONVERT_HOLY_CITY = GC.getDefineINT("RELIGION_DIPLO_HIT_CONVERT_HOLY_CITY");
	m_iRELIGION_DIPLO_HIT_THRESHOLD = GC.getDefineINT("RELIGION_DIPLO_HIT_THRESHOLD");
	m_iESPIONAGE_GATHERING_INTEL_COST_PERCENT = GC.getDefineINT("ESPIONAGE_GATHERING_INTEL_COST_PERCENT");
	m_iESPIONAGE_GATHERING_INTEL_RATE_BY_SPY_RANK_PERCENT = GC.getDefineINT("ESPIONAGE_GATHERING_INTEL_RATE_BY_SPY_RANK_PERCENT");
	m_iESPIONAGE_GATHERING_INTEL_RATE_BASE_PERCENT = GC.getDefineINT("ESPIONAGE_GATHERING_INTEL_RATE_BASE_PERCENT");
	m_iESPIONAGE_TURNS_BETWEEN_CITY_STATE_ELECTIONS = GC.getDefineINT("ESPIONAGE_TURNS_BETWEEN_CITY_STATE_ELECTIONS");
	m_iESPIONAGE_INFLUENCE_GAINED_FOR_RIGGED_ELECTION = GC.getDefineINT("ESPIONAGE_INFLUENCE_GAINED_FOR_RIGGED_ELECTION");
	m_iESPIONAGE_INFLUENCE_LOST_FOR_RIGGED_ELECTION = GC.getDefineINT("ESPIONAGE_INFLUENCE_LOST_FOR_RIGGED_ELECTION");
	m_iESPIONAGE_SURVEILLANCE_SIGHT_RANGE = GC.getDefineINT("ESPIONAGE_SURVEILLANCE_SIGHT_RANGE");
	m_iESPIONAGE_COUP_OTHER_PLAYERS_INFLUENCE_DROP = GC.getDefineINT("ESPIONAGE_COUP_OTHER_PLAYERS_INFLUENCE_DROP");
}


int CvGlobals::getDefineINT(const char* szName, bool bReportErrors)
{
	int iReturn = 0;
	getDefineValue(szName, iReturn, bReportErrors);
	return iReturn;
}

float CvGlobals::getDefineFLOAT(const char* szName, bool bReportErrors)
{
	float fReturn = 0.0f;
	getDefineValue(szName, fReturn, bReportErrors);
	return fReturn;
}

CvString CvGlobals::getDefineSTRING(const char* szName, bool bReportErrors)
{
	CvString strReturn;
	getDefineValue(szName, strReturn, bReportErrors);
	return strReturn;
}

bool CvGlobals::getDefineValue(const char* szName, int& iValue, bool bReportErrors)
{
	bool bSuccess = false;
	if(m_kGlobalDefinesLookup.Bind(1, szName))
	{
		if(m_kGlobalDefinesLookup.Step())
		{
			iValue = m_kGlobalDefinesLookup.GetInt(0);
			bSuccess = true;
		}
	}

	m_kGlobalDefinesLookup.Reset();

	if(bReportErrors)
	{
		CvAssertFmt(bSuccess, "Integer Define Value not found for %s", szName);
	}

	return bSuccess;
}

bool CvGlobals::getDefineValue(const char* szName, float& fValue, bool bReportErrors)
{
	bool bSuccess = false;
	if(m_kGlobalDefinesLookup.Bind(1, szName))
	{
		if(m_kGlobalDefinesLookup.Step())
		{
			fValue = m_kGlobalDefinesLookup.GetFloat(0);
			bSuccess = true;
		}
	}

	m_kGlobalDefinesLookup.Reset();

	if(bReportErrors)
	{
		CvAssertFmt(bSuccess, "Float Define Value not found for %s", szName);
	}

	return bSuccess;
}

bool CvGlobals::getDefineValue(const char* szName, CvString& strValue, bool bReportErrors)
{
	bool bSuccess = false;
	if(m_kGlobalDefinesLookup.Bind(1, szName))
	{
		if(m_kGlobalDefinesLookup.Step())
		{
			strValue = m_kGlobalDefinesLookup.GetText(0);
			bSuccess = true;
		}
	}

	m_kGlobalDefinesLookup.Reset();

	if(bReportErrors)
	{
		CvAssertFmt(bSuccess, "String Define Value not found for %s", szName);
	}

	return bSuccess;
}

int CvGlobals::getNUM_YIELD_TYPES() const
{
	return NUM_YIELD_TYPES;
}

int CvGlobals::getNUM_CONTROL_TYPES() const
{
	return NUM_CONTROL_TYPES;
}

void CvGlobals::deleteInfoArrays()
{
	deleteInfoArray(m_paBuildingClassInfo);

	deleteInfoArray(m_paLeaderHeadInfo);
	deleteInfoArray(m_paCivilizationInfo);
	deleteInfoArray(m_paMinorCivInfo);

	deleteInfoArray(m_paVoteSourceInfo);
	deleteInfoArray(m_paHandicapInfo);
	deleteInfoArray(m_paGameSpeedInfo);
	deleteInfoArray(m_paTurnTimerInfo);
	deleteInfoArray(m_paVictoryInfo);
	deleteInfoArray(m_paSmallAwardInfo);
	deleteInfoArray(m_paHurryInfo);
	deleteInfoArray(m_paProcessInfo);
	deleteInfoArray(m_paVoteInfo);

	deleteInfoArray(m_paColorInfo);
	deleteInfoArray(m_paPlayerColorInfo);
	deleteInfoArray(m_paInterfaceModeInfo);

	deleteInfoArray(m_paRouteInfo);

	deleteInfoArray(m_aEraInfo);

	deleteInfoArray(m_paBuildInfo);
	deleteInfoArray(m_paUnitClassInfo);
	deleteInfoArray(m_paSpecialUnitInfo);
	deleteInfoArray(m_paSpecialistInfo);
	deleteInfoArray(m_paActionInfo);
	deleteInfoArray(m_paMissionInfo);
	deleteInfoArray(m_paControlInfo);
	deleteInfoArray(m_paCommandInfo);
	deleteInfoArray(m_paAutomateInfo);

	deleteInfoArray(m_paUnitCombatClassInfo);
	deleteInfoArray(m_paUnitAIInfos);
	deleteInfoArray(m_paGameOptionInfos);
	deleteInfoArray(m_paMPOptionInfos);
	deleteInfoArray(m_paPlayerOptionInfos);

	deleteInfoArray(m_paYieldInfo);
	deleteInfoArray(m_paTerrainInfo);
	deleteInfoArray(m_paFeatureInfo);
	deleteInfoArray(m_paResourceClassInfo);
	deleteInfoArray(m_paResourceInfo);
	deleteInfoArray(m_paUnitDomainInfo);

	SAFE_DELETE_ARRAY(GC.getFootstepAudioTags());

	deleteInfoArray(m_paEntityEventInfo);
}

//
// Global Infos Hash Map
//
const CvGlobals::InfosMap& CvGlobals::GetInfoTypes() const
{
	return m_infosMap;
}
//------------------------------------------------------------------------------
int CvGlobals::getInfoTypeForString(const char* szType, bool hideAssert) const
{
	if(!hideAssert)
	{
		CvAssertMsg(szType, "null info type string");
	}

	if(szType == NULL)
		return -1;


	InfosMap::const_iterator it = m_infosMap.find(szType);
	if(it!=m_infosMap.end())
	{
		return it->second;
	}

	if(!hideAssert)
	{
		//
		// *** EFB: Need to restore this logging??? ***
		//
		CvString strError;
		strError.Format("Info type %s not found.", szType);
		CvAssertMsg(strcmp(szType, "NONE")==0 || strcmp(szType, "")==0, strError.c_str());
//		gDLL->logMsg("xml.log", szError);
	}

	return -1;
}

void CvGlobals::setInfoTypeFromString(const char* szType, int idx)
{
	CvAssertMsg(szType, "null info type string");
	uint uiHash = FString::Hash(szType);
#ifdef _DEBUG
	InfosMap::const_iterator it = m_infosMap.find(szType);
	int iExisting = (it!=m_infosMap.end()) ? it->second : -1;
	CvAssertMsg(iExisting==-1 || iExisting==idx || strcmp(szType ? szType : "", "ERROR")==0, CvString::format("xml info type entry %s already exists", szType).c_str());

	InfosHashMap::const_iterator ith = m_infosHashMap.find(uiHash);
	iExisting = (ith!=m_infosHashMap.end()) ? ith->second : -1;
	CvAssertMsg(iExisting==-1 || iExisting==idx || strcmp(szType ? szType : "", "ERROR")==0, CvString::format("xml info type entry %s already exists", szType).c_str());
#endif
	m_infosMap[szType] = idx;
	m_infosHashMap[uiHash] = idx;
}

void CvGlobals::infoTypeFromStringReset()
{
	m_infosMap.clear();
	m_infosHashMap.clear();
}

//------------------------------------------------------------------------------
int CvGlobals::getInfoTypeForHash(uint uiHash, bool hideAssert) const
{

	InfosHashMap::const_iterator it = m_infosHashMap.find(uiHash);
	if(it!=m_infosHashMap.end())
	{
		return it->second;
	}

	if(!hideAssert)
	{
		CvAssertMsg(uiHash==0, "Could not find resource hash");
	}

	return -1;
}

int CvGlobals::getNumDirections() const
{
	return NUM_DIRECTION_TYPES;
}
int CvGlobals::getNumGameOptions() const
{
	return NUM_GAMEOPTION_TYPES;
}
int CvGlobals::getNumMPOptions() const
{
	return NUM_MPOPTION_TYPES;
}
int CvGlobals::getNumSpecialOptions() const
{
	return NUM_SPECIALOPTION_TYPES;
}
int CvGlobals::getNumCommandInfos() const
{
	return NUM_COMMAND_TYPES;
}
int CvGlobals::getNumControlInfos() const
{
	return NUM_CONTROL_TYPES;
}
int CvGlobals::getNumPlayerOptionInfos() const
{
	return m_paPlayerOptionInfos.size();
}


//------------------------------------------------------------------------------
void CvGlobals::SetGameDatabase(Database::Connection* pGameDatabase)
{
	if(m_pGameDatabase != pGameDatabase)
	{
		if(m_pGameDatabase)
			m_kGlobalDefinesLookup.Release();

		m_pGameDatabase = pGameDatabase;
	}
}
//------------------------------------------------------------------------------

bool CvGlobals::IsGraphicsInitialized() const
{
	return m_bGraphicsInitialized;
}
void CvGlobals::SetGraphicsInitialized(bool bVal)
{
	m_bGraphicsInitialized = bVal;
}
void CvGlobals::setPathFinder(CvTwoLayerPathFinder* pVal)
{
	m_pathFinder = pVal;
}
void CvGlobals::setInterfacePathFinder(CvTwoLayerPathFinder* pVal)
{
	m_interfacePathFinder = pVal;
}
void CvGlobals::setIgnoreUnitsPathFinder(CvIgnoreUnitsPathFinder* pVal)
{
	m_ignoreUnitsPathFinder = pVal;
}
void CvGlobals::setStepFinder(CvStepPathFinder* pVal)
{
	m_stepFinder = pVal;
}
void CvGlobals::setRouteFinder(CvAStar* pVal)
{
	m_routeFinder = pVal;
}
void CvGlobals::SetWaterRouteFinder(CvAStar* pVal)
{
	m_waterRouteFinder = pVal;
}
void CvGlobals::setAreaFinder(CvAStar* pVal)
{
	m_areaFinder = pVal;
}
void CvGlobals::setInfluenceFinder(CvAStar* pVal)
{
	m_influenceFinder = pVal;
}
void CvGlobals::SetBuildRouteFinder(CvAStar* pVal)
{
	m_buildRouteFinder = pVal;
}
void CvGlobals::SetTacticalAnalysisMapFinder(CvTwoLayerPathFinder* pVal)
{
	m_tacticalAnalysisMapFinder = pVal;
}

void CvGlobals::setOutOfSyncDebuggingEnabled(bool isEnabled)
{
	m_bOutOfSyncDebuggingEnabled = isEnabled;
	FAutoArchive::EnableCallStacks(isEnabled);
}

bool CvGlobals::getOutOfSyncDebuggingEnabled() const
{
	return m_bOutOfSyncDebuggingEnabled;
}
